/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.meta.log;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.IFrame;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.vercompare.DcTreeNode;
import kd.bos.metadata.vercompare.DcTreeNodeUtil;
import kd.bos.metadata.vercompare.IXmlCompare;
import kd.bos.metadata.vercompare.XmlCompareFactory;
import kd.bos.metadata.vercompare.XmlFormMetadata;
import kd.bos.metadata.vercompare.app.XmlAppMetadata;
import kd.bos.servicehelper.util.VersionManageUtil;
import kd.bos.session.SessionKeys;

public class MetaDataLogDiffPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener,
TabSelectListener {
    private static final Log log = LogFactory.getLog(MetaDataLogDiffPlugin.class);
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-devportal-plugin";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String TREE_VIEW = "treeviewap";
    private static final String DIFF_TREE = "diffTree";
    private static final String SHOW_DIFF = "showdiff";
    private static final String PROPERTY_NAME = "propertyname";
    private static final String ELEMENT_NAME = "elementname";
    private static final String NODE_COLOR_ADD = "#1BA854";
    private static final String NODE_COLOR_REMOVE = "#FB2323";
    private static final String NODE_COLOR_EDIT = "#FF991C";
    private static final String CURRENT = "current";
    private static final String TARGET = "target";
    private static final String TREE_N0DE_CACHE = "treeNodeCache";
    private static final String SELECT_TREE_NODES = "selectTreeNodes";
    private static final String SELECT_TREE_INDEX = "selectTreeIndex";
    private static final String ALL_TREE_NODE = "allTreeNode";
    private static final String DIFF_TREE_NODE = "diffTreeNode";
    private static final String ALL_IDS = "allIds";
    private static final String DIFF_IDS = "diffIds";
    private static final String CURRENT_TREE_IDS = "currentTreeIds";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String NEXT_SELECT = "nextselect";
    private static final String BEFORE_COMPARE = "beforecompare";
    private static final String NEXT_COMPARE = "nextcompare";
    private static final String BEFORE_CHECK = "beforecheck";
    private static final String BTN_OK = "btnok";
    private static final String TAB_AP = "tabap";
    private static final String COMPARE = "compare";
    private static final String INIT_DC_TREE = "initDcTree";
    private static final String ALL_DC_TREE = "allDcTree";
    private static final String SUCCESS = "success";
    private static final String COMBO_FIELD = "combofield";
    private static final String ADD_TREE_NODE = "addTreeNode";
    private static final String REMOVE_TREE_NODE = "removeTreeNode";
    private static final String EDIT_TREE_NODE = "editTreeNode";
    private static final String IFRAME = "iframeap";
    private static final String SEARCH_AP = "searchap";
    private static final String SEARCH_TEXT = "searchText";
    private static final String SEARCH_INDEX = "searchIndex";
    private static final String NODE_LIST = "nodeList";
    private static final String UNFOLD_VECTOR = "unfoldvector";
    private static final String UNFOLD = "unfold";
    private static final String COLLAPSE_VECTOR = "collapsevector";
    private static final String COLLAPSE = "collapse";
    private static final String IS_CHANGE = "isChange";
    private static final String CURRENT_STATUS = "currentStatus";
    private static final String IS_LAYOUT = "isLayout";
    private static final String FLEX_PANEL = "flexpanelap";
    private IXmlCompare xmlCompare;

    public void registerListener(EventObject e) {
        TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getView().getControl(SEARCH_AP);
        search.addEnterListener((SearchEnterListener)this);
        this.addClickListeners(new String[]{NEXT_SELECT, BEFORE_COMPARE, NEXT_COMPARE, BEFORE_CHECK, BTN_OK, UNFOLD_VECTOR, UNFOLD, COLLAPSE_VECTOR, COLLAPSE});
        Tab tab = (Tab)this.getView().getControl(TAB_AP);
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.loadMetadata();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object multiLang = parameter.getCustomParam("multiLang");
        String name = null;
        String number = null;
        if (this.xmlCompare instanceof XmlFormMetadata) {
            if (StringUtils.isNotBlank((Object)multiLang)) {
                name = ((XmlFormMetadata)this.xmlCompare).getForm().getBaseSerializer().getDesignFormMetaL().getName();
                number = ((XmlFormMetadata)this.xmlCompare).getForm().getBaseSerializer().getDesignFormMetaL().getNumber();
            } else {
                name = ((XmlFormMetadata)this.xmlCompare).getForm().getBaseSerializer().getFormMetadata().getName().getLocaleValue();
                number = ((XmlFormMetadata)this.xmlCompare).getForm().getBaseSerializer().getFormMetadata().getKey();
                if (Lang.zh_CN != Lang.get() && Lang.zh_TW != Lang.get()) {
                    name = number;
                }
            }
        } else if (this.xmlCompare instanceof XmlAppMetadata) {
            if (StringUtils.isNotBlank((Object)multiLang)) {
                name = ((XmlAppMetadata)this.xmlCompare).getXcAppMetadata().getBaseSerializer().getDesignAppMetaL().getName();
                number = ((XmlAppMetadata)this.xmlCompare).getXcAppMetadata().getBaseSerializer().getDesignAppMetaL().getNumber();
            } else {
                name = ((XmlAppMetadata)this.xmlCompare).getXcAppMetadata().getBaseSerializer().getAppMetadata().getName().getLocaleValue();
                number = ((XmlAppMetadata)this.xmlCompare).getXcAppMetadata().getBaseSerializer().getAppMetadata().getNumber();
                if (Lang.zh_CN != Lang.get() && Lang.zh_TW != Lang.get()) {
                    name = number;
                }
            }
        }
        this.getPageCache().put("name", name);
        this.getPageCache().put("number", number);
    }

    public void afterBindData(EventObject e) {
        TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEW);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{UNFOLD, UNFOLD_VECTOR});
        String baseDym = (String)this.getView().getFormShowParameter().getCustomParam("baseDym");
        String lastDym = (String)this.getView().getFormShowParameter().getCustomParam("lastDym");
        String isShowTree = (String)this.getView().getFormShowParameter().getCustomParam("isNotShowTree");
        if (StringUtils.isBlank((CharSequence)baseDym) || StringUtils.isBlank((CharSequence)lastDym) || Boolean.parseBoolean(isShowTree)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEX_PANEL});
            Tab tab = (Tab)this.getView().getControl(TAB_AP);
            tab.activeTab(COMPARE);
            return;
        }
        TreeNode rootNode = this.initTreeNode(true);
        this.getCurrentTreeIds(rootNode);
        this.getPageCache().put(DIFF_TREE, SerializationUtils.toJsonString((Object)rootNode));
        ArrayList<String> ids = new ArrayList<String>(10);
        ArrayList<TreeNode> addTreeNode = new ArrayList<TreeNode>(10);
        ArrayList<TreeNode> removeTreeNode = new ArrayList<TreeNode>(10);
        ArrayList<TreeNode> editTreeNode = new ArrayList<TreeNode>(10);
        ArrayList<TreeNode> selectTreeNodes = new ArrayList<TreeNode>(10);
        this.getChildList(rootNode, ids, addTreeNode, removeTreeNode, editTreeNode, selectTreeNodes);
        this.createIndex(selectTreeNodes);
        this.setNodeIsOpen(rootNode, true);
        this.getPageCache().put(DIFF_IDS, SerializationUtils.toJsonString(ids));
        this.getPageCache().put(ADD_TREE_NODE, SerializationUtils.toJsonString(addTreeNode));
        this.getPageCache().put(REMOVE_TREE_NODE, SerializationUtils.toJsonString(removeTreeNode));
        this.getPageCache().put(EDIT_TREE_NODE, SerializationUtils.toJsonString(editTreeNode));
        this.getPageCache().put(SELECT_TREE_NODES, SerializationUtils.toJsonString(selectTreeNodes));
        this.getPageCache().put(CURRENT_STATUS, "1");
        treeView.addNode(rootNode);
        treeView.focusNode(rootNode);
        treeView.checkNode(rootNode);
        this.setEntryEntity(rootNode);
    }

    private void loadMetadata() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String baseDym = (String)parameter.getCustomParam("baseDym");
        String lastDym = (String)parameter.getCustomParam("lastDym");
        String isShowTree = (String)parameter.getCustomParam("isNotShowTree");
        String formNumber = (String)parameter.getCustomParam("number");
        if (StringUtils.isNotBlank((CharSequence)formNumber)) {
            this.getPageCache().put("number", formNumber);
        }
        if (StringUtils.isBlank((CharSequence)baseDym) || StringUtils.isBlank((CharSequence)lastDym) || Boolean.parseBoolean(isShowTree)) {
            return;
        }
        String metaType = (String)parameter.getCustomParam("metaType");
        if (StringUtils.equals((CharSequence)"page", (CharSequence)metaType) || StringUtils.isBlank((CharSequence)metaType)) {
            this.getPageCache().put("metaType", "page");
            this.loadFormMetadata(lastDym, baseDym);
        } else if (StringUtils.equals((CharSequence)"app", (CharSequence)metaType)) {
            this.loadAppMetadata(lastDym, baseDym);
            this.getPageCache().put("metaType", metaType);
        }
    }

    private void loadFormMetadata(String lastDym, String baseDym) {
        try {
            this.xmlCompare = XmlCompareFactory.get((String)"XmlFormMetadata");
            List dcTreeNodes = this.xmlCompare.compareToNode(lastDym, baseDym, true);
            List dcTreeNodes1 = this.xmlCompare.compareToNode(lastDym, baseDym, false);
            XmlFormMetadata xmlFormMetadata = (XmlFormMetadata)this.xmlCompare;
            FormMetadata formMetadata = xmlFormMetadata.getForm().getBaseSerializer().getFormMetadata();
            if (!StringUtils.equals((CharSequence)formMetadata.getId(), (CharSequence)formMetadata.getEntityId())) {
                this.getPageCache().put(IS_LAYOUT, SUCCESS);
                xmlFormMetadata.setLayout(true);
            }
            this.getPageCache().put(INIT_DC_TREE, SerializationUtils.toJsonString((Object)dcTreeNodes));
            this.getPageCache().put(ALL_DC_TREE, SerializationUtils.toJsonString((Object)dcTreeNodes1));
        }
        catch (Exception e) {
            log.error((Throwable)e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5143\u6570\u636e\u6587\u4ef6\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"MetaDataLogDiffPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            this.getPageCache().put("exception", "true");
        }
    }

    private void loadAppMetadata(String lastDym, String baseDym) {
        try {
            this.xmlCompare = XmlCompareFactory.get((String)"XmlAppMetadata");
            List dcTreeNodes = this.xmlCompare.compareToNode(lastDym, baseDym, true);
            List dcTreeNodes1 = this.xmlCompare.compareToNode(lastDym, baseDym, false);
            this.getPageCache().put(INIT_DC_TREE, SerializationUtils.toJsonString((Object)dcTreeNodes));
            this.getPageCache().put(ALL_DC_TREE, SerializationUtils.toJsonString((Object)dcTreeNodes1));
        }
        catch (Exception e) {
            log.error((Throwable)e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5143\u6570\u636e\u6587\u4ef6\u5f02\u5e38\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"MetaDataLogDiffPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            this.getPageCache().put("exception", "true");
        }
    }

    private TreeNode getRootNode() {
        TreeNode rootNode = new TreeNode("", "", "");
        String name = this.getPageCache().get("name");
        if (StringUtils.isNotBlank((CharSequence)name)) {
            rootNode.setText(name);
        } else {
            rootNode.setText("");
        }
        rootNode.setIsOpened(true);
        return rootNode;
    }

    private TreeNode initTreeNode(boolean showDiff) {
        TreeNode rootNode = this.getLeftTreeNode(showDiff);
        this.getPageCache().put(TREE_N0DE_CACHE, SerializationUtils.toJsonString((Object)rootNode));
        return rootNode;
    }

    private TreeNode getLeftTreeNode(boolean showDiff) {
        String initDcTree = this.getPageCache().get(INIT_DC_TREE);
        String allDcTree = this.getPageCache().get(ALL_DC_TREE);
        ArrayList<String> ids = new ArrayList<String>(10);
        if (showDiff) {
            String diffTreeNode = this.getPageCache().get(DIFF_TREE_NODE);
            if (diffTreeNode != null) {
                return (TreeNode)SerializationUtils.fromJsonString((String)diffTreeNode, TreeNode.class);
            }
            TreeNode rootNode = this.getTreeByDiff(initDcTree, true);
            this.getPageCache().put(DIFF_TREE_NODE, SerializationUtils.toJsonString((Object)rootNode));
            return rootNode;
        }
        String allTreeNode = this.getPageCache().get(ALL_TREE_NODE);
        if (allTreeNode != null) {
            return (TreeNode)SerializationUtils.fromJsonString((String)allTreeNode, TreeNode.class);
        }
        TreeNode rootNode = this.getTreeByDiff(allDcTree, false);
        this.getChildList(rootNode, ids);
        this.getPageCache().put(ALL_TREE_NODE, SerializationUtils.toJsonString((Object)rootNode));
        this.getPageCache().put(ALL_IDS, SerializationUtils.toJsonString(ids));
        return rootNode;
    }

    private TreeNode getTreeByDiff(String initDcTree, boolean showDiff) {
        TreeNode rootNode = this.getRootNode();
        DcTreeNodeUtil.BuildTreeOption option = new DcTreeNodeUtil.BuildTreeOption();
        option.setOnlyDiff(showDiff);
        List dcTree = SerializationUtils.fromJsonStringToList((String)initDcTree, DcTreeNode.class);
        for (DcTreeNode node : dcTree) {
            TreeNode formNode = DcTreeNodeUtil.buildTreeNode((DcTreeNode)node, (DcTreeNodeUtil.BuildTreeOption)option);
            rootNode.addChild(formNode);
        }
        return rootNode;
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        String text = this.getPageCache().get(SEARCH_TEXT);
        TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEW);
        if (searchText.equals(text)) {
            String list = this.getPageCache().get(NODE_LIST);
            List nodeList = SerializationUtils.fromJsonStringToList((String)list, TreeNode.class);
            if (nodeList.size() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\uff0c\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879", (String)"MetadataMergePlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
                return;
            }
            int index = Integer.parseInt(this.getPageCache().get(SEARCH_INDEX));
            if (index >= nodeList.size()) {
                index = 0;
            }
            TreeNode treeNode = (TreeNode)nodeList.get(index);
            treeView.focusNode(treeNode);
            this.getPageCache().put(SEARCH_INDEX, String.valueOf(index + 1));
            return;
        }
        String node = this.getPageCache().get(TREE_N0DE_CACHE);
        TreeNode treeNode = (TreeNode)SerializationUtils.fromJsonString((String)node, TreeNode.class);
        ArrayList selectNodes = new ArrayList(10);
        List nodeList = treeNode.getTreeNodeListByText(selectNodes, searchText, 100);
        this.getPageCache().put(SEARCH_TEXT, searchText);
        this.getPageCache().put(NODE_LIST, SerializationUtils.toJsonString((Object)nodeList));
        if (nodeList.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\uff0c\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879", (String)"MetadataMergePlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        TreeNode selectTree = (TreeNode)nodeList.get(0);
        this.getPageCache().put(SEARCH_INDEX, String.valueOf(1));
        treeView.focusNode(selectTree);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData changeSet = e.getChangeSet()[0];
        this.getPageCache().remove(SEARCH_TEXT);
        if (SHOW_DIFF.equals(propertyName)) {
            Boolean showDiff = (Boolean)changeSet.getNewValue();
            TreeNode rootNode = this.initTreeNode(showDiff);
            String currentStatus = this.getPageCache().get(CURRENT_STATUS);
            this.setNodeIsOpen(rootNode, StringUtils.equals((CharSequence)"1", (CharSequence)currentStatus));
            this.refreshTree(rootNode, showDiff);
            this.getPageCache().put(IS_CHANGE, "1");
        } else if (COMBO_FIELD.equals(propertyName)) {
            TreeNode rootNode;
            String type = (String)changeSet.getNewValue();
            if (StringUtils.equals((CharSequence)"add", (CharSequence)type)) {
                String addIds = this.getPageCache().get(ADD_TREE_NODE);
                List addTreeNode = SerializationUtils.fromJsonStringToList((String)addIds, TreeNode.class);
                rootNode = this.buildTree(addTreeNode);
            } else if (StringUtils.equals((CharSequence)"remove", (CharSequence)type)) {
                String removeIds = this.getPageCache().get(REMOVE_TREE_NODE);
                List removeTreeNode = SerializationUtils.fromJsonStringToList((String)removeIds, TreeNode.class);
                rootNode = this.buildTree(removeTreeNode);
            } else if (StringUtils.equals((CharSequence)"edit", (CharSequence)type)) {
                String editIds = this.getPageCache().get(EDIT_TREE_NODE);
                List editTreeNode = SerializationUtils.fromJsonStringToList((String)editIds, TreeNode.class);
                rootNode = this.buildTree(editTreeNode);
            } else {
                rootNode = this.initTreeNode(true);
                this.setNodeIsOpen(rootNode, true);
            }
            this.getCurrentTreeIds(rootNode);
            this.getPageCache().put(TREE_N0DE_CACHE, SerializationUtils.toJsonString((Object)rootNode));
            this.refreshTree(rootNode, true);
        }
    }

    private void getCurrentTreeIds(TreeNode rootNode) {
        ArrayList<String> currentIds = new ArrayList<String>(10);
        this.getChild(rootNode, currentIds);
        this.getPageCache().put(CURRENT_TREE_IDS, SerializationUtils.toJsonString(currentIds));
    }

    private void refreshTree(TreeNode rootNode, Boolean showDiff) {
        TreeView treeView = (TreeView)this.getView().getControl(TREE_VIEW);
        String nodes = this.getPageCache().get(SELECT_TREE_NODES);
        List selectTreeNodes = SerializationUtils.fromJsonStringToList((String)nodes, TreeNode.class);
        if (this.getPageCache().get(IS_CHANGE) != null && !showDiff.booleanValue()) {
            this.deleteIds(selectTreeNodes);
        }
        treeView.addNode(rootNode);
        treeView.updateNode(rootNode);
        if (!selectTreeNodes.isEmpty()) {
            treeView.checkNodesWithoutChild(selectTreeNodes);
        }
        this.getPageCache().put(SELECT_TREE_NODES, SerializationUtils.toJsonString((Object)selectTreeNodes));
    }

    private void deleteIds(List<TreeNode> list) {
        String ids = this.getPageCache().get(DIFF_IDS);
        List diffIds = SerializationUtils.fromJsonStringToList((String)ids, String.class);
        list.removeIf(treeNode -> !diffIds.contains(treeNode.getId()));
    }

    private void setNodeIsOpen(TreeNode treeNode, boolean isOpen) {
        if (treeNode.getChildren() != null) {
            for (TreeNode node : treeNode.getChildren()) {
                this.setNodeIsOpen(node, isOpen);
            }
        }
        treeNode.setIsOpened(isOpen);
    }

    private void getChildList(TreeNode treeNode, List<String> ids) {
        this.getChildList(treeNode, null, ids, null, null, null, null);
    }

    private void getChildList(TreeNode treeNode, List<String> ids, List<TreeNode> addList, List<TreeNode> removeList, List<TreeNode> editList, List<TreeNode> treeNodeList) {
        this.getChildList(treeNode, null, ids, addList, removeList, editList, treeNodeList);
    }

    private void getChildList(TreeNode treeNode, List<TreeNode> treeNodes, List<String> ids, List<TreeNode> addList, List<TreeNode> removeList, List<TreeNode> editList, List<TreeNode> treeNodeList) {
        if (treeNode.getChildren() != null) {
            for (TreeNode node : treeNode.getChildren()) {
                this.getChildList(node, treeNodes, ids, addList, removeList, editList, treeNodeList);
            }
        } else {
            if (treeNodes != null) {
                treeNodes.add(treeNode);
            }
            if (ids != null) {
                ids.add(treeNode.getId());
            }
            if (addList != null && NODE_COLOR_ADD.equals(treeNode.getColor())) {
                addList.add(treeNode);
            }
            if (removeList != null && NODE_COLOR_REMOVE.equals(treeNode.getColor())) {
                removeList.add(treeNode);
            }
            if (editList != null && NODE_COLOR_EDIT.equals(treeNode.getColor())) {
                editList.add(treeNode);
            }
        }
        treeNode.setIsOpened(true);
        if (treeNodeList != null) {
            treeNodeList.add(treeNode);
        }
    }

    public void click(EventObject evt) {
        String key;
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "unfold": 
            case "unfoldvector": 
            case "collapse": 
            case "collapsevector": {
                this.unfoldOrCollapseNode(key);
                break;
            }
        }
    }

    private void unfoldOrCollapseNode(String key) {
        String node = this.getPageCache().get(TREE_N0DE_CACHE);
        TreeNode treeNode = (TreeNode)SerializationUtils.fromJsonString((String)node, TreeNode.class);
        boolean showDiff = (Boolean)this.getModel().getValue(SHOW_DIFF);
        if (UNFOLD.equals(key) || UNFOLD_VECTOR.equals(key)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{UNFOLD, UNFOLD_VECTOR});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{COLLAPSE, COLLAPSE_VECTOR});
            this.getPageCache().put(CURRENT_STATUS, "1");
            this.setNodeIsOpen(treeNode, true);
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{UNFOLD, UNFOLD_VECTOR});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{COLLAPSE, COLLAPSE_VECTOR});
            this.getPageCache().put(CURRENT_STATUS, "0");
            this.setNodeIsOpen(treeNode, false);
        }
        this.refreshTree(treeNode, showDiff);
    }

    private void handleXmlToIframe(String mergeXml, String baseXml) {
        IFrame frame = (IFrame)this.getView().getControl(IFRAME);
        String urlParams = this.getUrlParams(mergeXml, baseXml);
        urlParams = this.getKdcdUrl(urlParams);
        frame.setSrc("devtools/built-compare/gitResolve.html?" + urlParams);
    }

    private String getUrlParams(String mergeXml, String baseXml) {
        String uuid = "test";
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String filePath = null;
        String number = this.getPageCache().get("number");
        filePath = StringUtils.isNotBlank((CharSequence)number) ? "/" + this.getNumber() : (String)parameter.getCustomParam("filePath");
        String personalgitrepository = "";
        String oldCommitId = (String)parameter.getCustomParam("oldCommitId");
        String newCommitId = (String)parameter.getCustomParam("newCommitId");
        filePath = filePath + "$$" + oldCommitId + "$$" + newCommitId;
        String type = "log";
        String gitrepository = Encrypters.encode((String)VersionManageUtil.compress((String)mergeXml));
        String projectURL = Encrypters.encode((String)VersionManageUtil.compress((String)baseXml));
        String id = (String)this.getView().getFormShowParameter().getCustomParam("id");
        String bizAppId = (String)this.getView().getFormShowParameter().getCustomParam("bizappid");
        String pageId = this.getView().getPageId();
        boolean isSave = false;
        return "uuid#" + uuid + "&pageid#" + pageId + "&projecturl#" + projectURL + "&gitrepository#" + gitrepository + "&personalgitrepository#" + personalgitrepository + "&filepath#" + filePath + "&id#" + id + "&bizappid#" + bizAppId + "&type#" + type + "&issave#" + isSave;
    }

    private String getKdcdUrl(String path) {
        return SessionKeys.isAccountSession((String)RequestContext.get().getTenantId()) ? path + "&kdcdc#" + RequestContext.get().getAccountId() : path;
    }

    private String getNumber() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String name = (String)parameter.getCustomParam("number");
        if (StringUtils.isNotBlank((CharSequence)name)) {
            return name;
        }
        String type = (String)parameter.getCustomParam("metaType");
        if (StringUtils.isBlank((CharSequence)type) || StringUtils.equals((CharSequence)"page", (CharSequence)type)) {
            name = this.getPageCache().get("number") + ".dym";
            return name;
        }
        if (StringUtils.equals((CharSequence)"app", (CharSequence)type)) {
            name = this.getPageCache().get("number") + ".app";
            return name;
        }
        return "";
    }

    private TreeNode buildTree(List<TreeNode> nodes) {
        TreeNode rootNode = this.getRootNode();
        String leftTree = this.getPageCache().get(DIFF_TREE);
        TreeNode leftRoot = (TreeNode)SerializationUtils.fromJsonString((String)leftTree, TreeNode.class);
        for (TreeNode node : nodes) {
            String parentId = node.getParentid();
            String id = node.getId();
            String text = node.getText();
            TreeNode treeNode = rootNode.getTreeNode(id);
            if (null != treeNode) continue;
            TreeNode curNode = new TreeNode(parentId, id, text);
            curNode.setIsOpened(true);
            curNode.setColor(node.getColor());
            curNode.setLongText(node.getLongText());
            curNode.setData(node.getData());
            this.assembleSelectNode(leftRoot, rootNode, curNode);
        }
        return rootNode;
    }

    private void assembleSelectNode(TreeNode leftRoot, TreeNode rightRoot, TreeNode curNode) {
        String parentId = curNode.getParentid();
        TreeNode parentNode = rightRoot.getTreeNode(parentId);
        if (null == parentNode) {
            parentNode = leftRoot.getTreeNode(parentId);
            String parentid = parentNode.getParentid();
            TreeNode treeNode = new TreeNode(parentid, parentNode.getId(), parentNode.getText());
            treeNode.setColor(parentNode.getColor());
            treeNode.addChild(curNode);
            treeNode.setIsOpened(true);
            this.assembleSelectNode(leftRoot, rightRoot, treeNode);
        } else {
            parentNode.addChild(curNode);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String treeCache = this.getPageCache().get(TREE_N0DE_CACHE);
        TreeNode treeNode = (TreeNode)SerializationUtils.fromJsonString((String)treeCache, TreeNode.class);
        String nodeId = (String)evt.getNodeId();
        if (nodeId == null) {
            return;
        }
        TreeNode node = treeNode.getTreeNode(nodeId);
        this.setEntryEntity(node);
    }

    private void createIndex(List<TreeNode> selectTreeNodes) {
        ArrayList index = new ArrayList(selectTreeNodes.size());
        selectTreeNodes.forEach(node -> index.add(node.getId()));
        this.getPageCache().put(SELECT_TREE_INDEX, SerializationUtils.toJsonString(index));
    }

    private void getChild(TreeNode treeNode, List<String> list) {
        if (treeNode.getChildren() != null) {
            for (TreeNode node : treeNode.getChildren()) {
                this.getChild(node, list);
            }
        }
        list.add(treeNode.getId());
    }

    private void setEntryEntity(TreeNode node) {
        if (node == null) {
            return;
        }
        boolean isLeaf = node.getChildren() != null && !node.getChildren().isEmpty();
        int size = 0;
        Map<TreeNode, List<Map<String, String>>> childProperties = this.getChildProperties(node, isLeaf);
        for (Map.Entry<TreeNode, List<Map<String, String>>> entry : childProperties.entrySet()) {
            if (entry.getValue() == null) {
                ++size;
                continue;
            }
            if (entry.getValue().isEmpty()) continue;
            size += entry.getValue().size();
        }
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        if (size == 0) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, size);
        this.getModel().beginInit();
        this.fillEntryProperty(childProperties);
        this.getModel().endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    private void fillEntryProperty(Map<TreeNode, List<Map<String, String>>> childProperties) {
        int index = 0;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>(childProperties.size());
        for (Map.Entry<TreeNode, List<Map<String, String>>> entry : childProperties.entrySet()) {
            TreeNode node = entry.getKey();
            List<Map<String, String>> value = entry.getValue();
            this.setSimpleProperty(value, cellStyles, node, index);
            if (value == null) {
                ++index;
                continue;
            }
            index += value.size();
        }
        entryGrid.setCellStyle(cellStyles);
    }

    private void setSimpleProperty(List<Map<String, String>> map, List<CellStyle> cellStyles, TreeNode node, int index) {
        String key = node.getText();
        if (map == null || map.isEmpty()) {
            if (NODE_COLOR_ADD.equals(node.getColor()) || NODE_COLOR_REMOVE.equals(node.getColor())) {
                this.getModel().setValue(ELEMENT_NAME, (Object)key, index);
                cellStyles.add(this.getCellStyle(index, node));
            }
            return;
        }
        for (int i = 0; i < map.size(); ++i) {
            Map<String, String> property = map.get(i);
            String propertyName = property.get("name");
            String caption = property.get("caption");
            if (StringUtils.isNotBlank((CharSequence)caption)) {
                propertyName = String.format("%s\uff08%s\uff09", propertyName, caption);
            }
            CellStyle cellStyle = this.getCellStyle(i + index, node);
            cellStyles.add(cellStyle);
            String baseValue = property.get("baseValue");
            String currValue = property.get("currValue");
            this.getModel().setValue(ELEMENT_NAME, (Object)key, i + index);
            this.getModel().setValue(PROPERTY_NAME, (Object)propertyName, i + index);
            this.getModel().setValue(CURRENT, (Object)currValue, i + index);
            this.getModel().setValue(TARGET, (Object)baseValue, i + index);
        }
    }

    private CellStyle getCellStyle(int row, TreeNode node) {
        CellStyle cellStyle = new CellStyle();
        cellStyle.setForeColor(node.getColor());
        cellStyle.setFieldKey(ELEMENT_NAME);
        cellStyle.setRow(row);
        return cellStyle;
    }

    private Map<TreeNode, List<Map<String, String>>> getChildProperties(TreeNode node, boolean isLeaf) {
        LinkedHashMap<TreeNode, List<Map<String, String>>> properties = new LinkedHashMap<TreeNode, List<Map<String, String>>>(16);
        this.traversalTreeNode(node, properties, isLeaf, 0);
        return properties;
    }

    private void traversalTreeNode(TreeNode node, Map<TreeNode, List<Map<String, String>>> properties, boolean isLeaf, int level) {
        if (node != null) {
            List map;
            String name = node.getText();
            Object data = node.getData();
            List list = map = data == null ? null : (List)data;
            if (isLeaf) {
                if (NODE_COLOR_ADD.equals(node.getColor()) || NODE_COLOR_REMOVE.equals(node.getColor())) {
                    if (level == 0) {
                        properties.put(node, map);
                    } else {
                        properties.put(node, null);
                    }
                } else if (map != null && !map.isEmpty() && NODE_COLOR_EDIT.equals(node.getColor())) {
                    properties.put(node, map);
                }
            } else if (map != null && !map.isEmpty()) {
                properties.put(node, map);
            }
            ++level;
            if (node.getChildren() == null) {
                return;
            }
            for (TreeNode treeNode : node.getChildren()) {
                this.traversalTreeNode(treeNode, properties, isLeaf, level);
                ++level;
            }
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        if (COMPARE.equals(tabKey)) {
            String baseDym = (String)this.getView().getFormShowParameter().getCustomParam("baseDym");
            String lastDym = (String)this.getView().getFormShowParameter().getCustomParam("lastDym");
            this.handleXmlToIframe(baseDym, lastDym);
        }
    }
}

