/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.meta.log;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.designer.bizobjext.DesignerDataUtil;
import kd.bos.designer.meta.log.MetaLog;
import kd.bos.designer.meta.log.MetaLogDao;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractDesignMeta;
import kd.bos.metadata.dao.MetaLogType;
import kd.bos.metadata.dao.MetaType;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataLogService;
import kd.bos.util.ExceptionUtils;

public class MetaDataLogListBizExtPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(MetaDataLogListBizExtPlugin.class);
    private static final String TRUE = "true";
    private static final String BIZ_OPERATE_KEY = "bizObjExtKey";
    private static final String TEST_SAVE = "testsave";
    private static final String TEST_DEPLOY = "testdeploy";
    private static final String OPERATE = "operate";
    private static final String LAST_DYM = "lastDym";
    private static final String BASE_DYM = "baseDym";
    private static final String CLOSE = "close";
    private static final String RESTORE = "restore";
    private static final String REVERT_BEGIN = "revertbegin";
    private static final String XML = "xml";
    private static final String STATUS = "status";
    private static final String MESSAGE = "message";
    private static final String SUCCESS = "success";
    private static final String ERROR = "error";
    private static final String RESTORE_CONFIRM_CALLBACK = "restoreConfirmCallBack";
    private static final String REVERT_BEGIN_CONFIRM_CALLBACK = "revertBeginConfirmCallBack";
    private static final String BOS_DEVP_METAMERGE = "bos_devp_metadatadiff";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{CLOSE, RESTORE, REVERT_BEGIN});
    }

    public void afterBindData(EventObject e) {
        if (this.isDesignerMetaLog()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"filtercontainerap", ""});
            BillList billList = (BillList)this.getControl("billlistap");
            billList.addListRowClickListener((ListRowClickListener)this);
        }
        if (!this.isBizObjExt()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{REVERT_BEGIN});
        }
    }

    public void setFilter(SetFilterEvent e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String designerMetaLog = (String)parameter.getCustomParam("designerMetaLog");
        if (TRUE.equals(designerMetaLog)) {
            String bizExt = (String)parameter.getCustomParam("bizext");
            String id = (String)parameter.getCustomParam("id");
            e.getQFilters().add(new QFilter("entryentity.metaid", "=", (Object)id));
            List<String> types = Arrays.asList(String.valueOf(MetaLogType.BizObjExtDeploy.getValue()), String.valueOf(MetaLogType.FormDesign.getValue()));
            if (TRUE.equals(bizExt)) {
                String bizOperateKey = (String)parameter.getCustomParam(BIZ_OPERATE_KEY);
                if (TEST_SAVE.equals(bizOperateKey)) {
                    e.getQFilters().add(new QFilter("type", "=", (Object)String.valueOf(MetaLogType.BizObjExtSave.getValue())));
                } else if (TEST_DEPLOY.equals(bizOperateKey)) {
                    e.getQFilters().add(new QFilter("type", "in", types));
                }
            } else {
                e.getQFilters().add(new QFilter("type", "in", types));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Donothing donothing;
        String operateKey;
        if (args.getSource() instanceof Donothing && OPERATE.equals(operateKey = (donothing = (Donothing)args.getSource()).getOperateKey())) {
            String xml;
            long newCommitId;
            String formId = (String)this.getView().getFormShowParameter().getCustomParam("id");
            if (this.isBizObjExt()) {
                DeployMetadata bizObjExtMetadata = MetadataDao.getBizObjExtMetadata((String)formId);
                newCommitId = bizObjExtMetadata.getVersion();
                xml = bizObjExtMetadata.toDeployFile("").getFileContent();
            } else {
                xml = MetaLogDao.getXmlById(formId);
                newCommitId = MetaLogDao.getVersionById(formId);
            }
            BillList billList = (BillList)this.getControl("billlistap");
            Long id = (Long)billList.getSelectedRows().get(0).getEntryPrimaryKeyValue();
            MetaLog metaLog = MetaLogDao.getDataById(id);
            String currentXml = metaLog.getXml();
            long oldCommitId = metaLog.getVersion();
            if (this.isPrintModel() || StringUtils.isBlank((CharSequence)currentXml)) {
                this.showMerge(currentXml, xml, oldCommitId, newCommitId, TRUE);
            } else {
                this.showMerge(currentXml, xml, oldCommitId, newCommitId, "false");
            }
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        HashMap<String, String> result = new HashMap<String, String>();
        if (CLOSE.equals(key)) {
            result.put("action", CLOSE);
            this.getView().returnDataToParent(result);
            this.getView().close();
        } else if (RESTORE.equals(key)) {
            this.restoreMeta();
        } else if (REVERT_BEGIN.equals(key)) {
            this.revertBeginVersion();
        }
    }

    private void revertBeginVersion() {
        if (!this.isCanRestore()) {
            return;
        }
        String id = (String)this.getView().getFormShowParameter().getCustomParam("id");
        Map<String, String> res = MetaLogDao.getAppIdAndUnitId(id);
        if (StringUtils.isBlank(res)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8868\u5355\u6240\u5c5e\u5206\u7ec4\u6216\u5e94\u7528\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MetaDataLogRestorePlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String bizAppId = res.get("bizAppId");
        String bizUnitId = res.get("bizUnitId");
        this.getPageCache().put("bizAppId", bizAppId);
        this.getPageCache().put("bizUnitId", bizUnitId);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u8fd8\u539f\u81f3\u6269\u5c55\u65f6\u7684\u521d\u59cb\u72b6\u6001\uff0c\u4e0d\u5305\u542b\u6269\u5c55\u540e\u4fee\u6539\u5185\u5bb9\uff0c\u5b8c\u6210\u6a21\u62df\u6d4b\u8bd5\u548c\u53d1\u5e03\u540e\u751f\u6548\uff0c\u786e\u5b9a\u8fd8\u539f\u81f3\u521d\u59cb\u72b6\u6001\uff1f", (String)"MetaDataLogRestorePlugin_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(REVERT_BEGIN_CONFIRM_CALLBACK));
    }

    private void restoreMeta() {
        if (!this.isCanRestore()) {
            return;
        }
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u4e00\u6761\u8bb0\u5f55\u3002", (String)"MetaDataLogRestorePlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        Long pkId = (Long)billList.getSelectedRows().get(0).getEntryPrimaryKeyValue();
        MetaLog metaLog = MetaLogDao.getDataById(pkId);
        String xml = metaLog.getXml();
        this.getPageCache().put(XML, xml);
        String id = (String)this.getView().getFormShowParameter().getCustomParam("id");
        Map<String, String> res = MetaLogDao.getAppIdAndUnitId(id);
        if (StringUtils.isBlank(res)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8868\u5355\u6240\u5c5e\u5206\u7ec4\u6216\u5e94\u7528\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MetaDataLogRestorePlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String bizAppId = res.get("bizAppId");
        String bizUnitId = res.get("bizUnitId");
        this.getPageCache().put("bizAppId", bizAppId);
        this.getPageCache().put("bizUnitId", bizUnitId);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u5c06\u5f53\u524d\u7248\u672c\u5143\u6570\u636e\u8fd8\u539f\u81f3\u6570\u636e\u5e93\u5417\uff1f", (String)"MetaDataLogRestorePlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(RESTORE_CONFIRM_CALLBACK));
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (RESTORE_CONFIRM_CALLBACK.equals(event.getCallBackId()) && MessageBoxResult.Yes.equals((Object)event.getResult())) {
            String id = (String)this.getView().getFormShowParameter().getCustomParam("id");
            String bizAppId = this.getPageCache().get("bizAppId");
            String bizUnitId = this.getPageCache().get("bizUnitId");
            String xml = this.getPageCache().get(XML);
            HashMap<String, String> result = new HashMap<String, String>(2);
            result.put("action", RESTORE);
            try {
                if (this.isBizObjExt()) {
                    MetaLogDao.deployBizExtMetadata(xml);
                } else {
                    MetadataDao.deployMetadata((String)xml, (String)bizUnitId, (String)bizAppId);
                    MetadataDao.rebuildRuntimeMetaById((String)id);
                }
                this.writeLog(id, MetadataDao.getNumberById((String)id));
                result.put(STATUS, SUCCESS);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                result.put(STATUS, ERROR);
                result.put(MESSAGE, e.getMessage());
            }
            this.getView().returnDataToParent(result);
            this.getView().close();
        } else if (REVERT_BEGIN_CONFIRM_CALLBACK.equals(event.getCallBackId()) && MessageBoxResult.Yes.equals((Object)event.getResult())) {
            HashMap<String, String> result = new HashMap<String, String>(2);
            result.put("action", RESTORE);
            String id = (String)this.getView().getFormShowParameter().getCustomParam("id");
            try {
                if (this.isBizObjExt()) {
                    List<AbstractDesignMeta> designDatas = DesignerDataUtil.rollbackExtBillMetadataToBegin(id);
                    MetaLogDao.deployBizExtMetadata(designDatas, id);
                }
                this.writeLog(id, MetadataDao.getNumberById((String)id));
                result.put(STATUS, SUCCESS);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                result.put(STATUS, ERROR);
                result.put(MESSAGE, e.getMessage());
            }
            this.getView().returnDataToParent(result);
            this.getView().close();
        }
    }

    private void showMerge(String lastXml, String currentXml, long oldCommitId, long newCommitId, String isNotShowTree) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(BOS_DEVP_METAMERGE);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("newCommitId", (Object)String.valueOf(newCommitId));
        parameter.setCustomParam("oldCommitId", (Object)String.valueOf(oldCommitId));
        parameter.setCustomParam(LAST_DYM, (Object)lastXml);
        parameter.setCustomParam(BASE_DYM, (Object)currentXml);
        if (StringUtils.equals((CharSequence)TRUE, (CharSequence)isNotShowTree)) {
            String id = (String)this.getView().getFormShowParameter().getCustomParam("id");
            String number = MetadataDao.getNumberById((String)id);
            parameter.setCustomParam("number", (Object)number);
        }
        parameter.setCustomParam("isNotShowTree", (Object)isNotShowTree);
        this.getView().showForm(parameter);
    }

    private void writeLog(String formId, String formNumber) {
        try {
            long fid = DB.genGlobalLongId();
            MetadataLogService logService = (MetadataLogService)ServiceFactory.getService(MetadataLogService.class);
            if (this.isBizObjExt()) {
                logService.addMetaLog(formId, formNumber, (int)MetaLogType.BizObjExtSave.getValue(), fid, (int)MetaType.Form.getValue());
            } else {
                logService.addMetaLog(formId, formNumber, (int)MetaLogType.FormDesign.getValue(), fid, (int)MetaType.Form.getValue());
            }
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u5143\u6570\u636e\u65e5\u5fd7\u5931\u8d25\uff0cerr\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    private boolean isPrintModel() {
        return TRUE.equals(this.getView().getFormShowParameter().getCustomParam("isPrintModel"));
    }

    private boolean isDesignerMetaLog() {
        return TRUE.equals(this.getView().getFormShowParameter().getCustomParam("designerMetaLog"));
    }

    private boolean isBizObjExt() {
        return TRUE.equals(this.getView().getFormShowParameter().getCustomParam("bizext"));
    }

    private boolean isCanRestore() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        boolean gray = (Boolean)parameter.getCustomParam("gray");
        if (gray) {
            String errorMsg = ResManager.loadKDString((String)"\u7070\u5ea6\u529f\u80fd\u4e0d\u5141\u8bb8\u7f16\u8f91\u5143\u6570\u636e\u3002", (String)"FormDesignerPlugin_32", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            return false;
        }
        boolean prod = (Boolean)parameter.getCustomParam("prod");
        if (prod) {
            String errorMsg = ResManager.loadKDString((String)"\u4e3a\u4fdd\u8bc1\u73af\u5883\u7a33\u5b9a\uff0c\u751f\u4ea7\u73af\u5883\u6682\u4e0d\u5141\u8bb8\u7f16\u8f91\u5143\u6570\u636e\u3002", (String)"FormDesignerPlugin_28", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            return false;
        }
        boolean deploy = (Boolean)parameter.getCustomParam("deploy");
        if (deploy) {
            String errorMsg = ResManager.loadKDString((String)"\u5e73\u53f0\u6b63\u5728\u8fdb\u884c\u7cfb\u7edf\u5347\u7ea7\uff0c\u6682\u4e0d\u5141\u8bb8\u8fdb\u884c\u6b64\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"FormDesignerPlugin_31", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            return false;
        }
        boolean currentIsv = (Boolean)parameter.getCustomParam("currentIsvIsBank");
        if (currentIsv) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u672a\u6ce8\u518c\u5f00\u53d1\u5546\uff0c\u8bf7\u7528\u8d85\u7ea7\u7528\u6237\u767b\u5f55\u5e76\u6ce8\u518c\u5f00\u53d1\u5546\u3002", (String)"MetaDataLogRestorePlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            return false;
        }
        boolean isvIsSame = (Boolean)parameter.getCustomParam("isvIsSame");
        if (!isvIsSame) {
            String errorMsg = ResManager.loadKDString((String)"\u8d44\u6e90\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5f00\u53d1\u5546\uff0c\u8bf7\u8fdb\u5165\u5f00\u53d1\u5e73\u53f0\u5e94\u7528\uff0c\u5c06\u8d44\u6e90\u6269\u5c55\u540e\u518d\u8fdb\u884c\u7f16\u8f91\u3002", (String)"FormDesignerPlugin_27", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            return false;
        }
        return true;
    }
}

