/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.meta.log;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaLogType;
import kd.bos.metadata.dao.MetaType;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataLogService;
import kd.bos.util.ExceptionUtils;

public class MetaDataLogRestorePlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final Log log = LogFactory.getLog(MetaDataLogRestorePlugin.class);
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String VERSION = "version";
    private static final String ISV = "isv";
    private static final String OPERATOR = "operator";
    private static final String OPERATE_TIME = "operatetime";
    private static final String OPERATE = "operate";
    private static final String BTN_OK = "btnok";
    private static final String ID = "id";
    private static final String XML = "xml";
    private static final String LAST_DYM = "lastDym";
    private static final String BASE_DYM = "baseDym";
    private static final String CURRENT_INDEX = "currentIndex";
    private static final String STATUS = "status";
    private static final String MESSAGE = "message";
    private static final String SUCCESS = "success";
    private static final String ERROR = "error";
    private static final String MODE_TYPE = "modelType";
    private static final String BOS_DEVP_METAMERGE = "bos_devp_metadatadiff";
    private static final String RESTORE_CONFIRM_CALLBACK = "restoreConfirmCallBack";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String id = (String)parameter.getCustomParam(ID);
        if (StringUtils.isBlank((CharSequence)id)) {
            return;
        }
        this.getPageCache().put(ID, id);
        List<MetaLog> metaLog = this.getMetaLog(id);
        if (metaLog.size() < 1) {
            return;
        }
        this.getPageCache().put("newCommitId", String.valueOf(metaLog.get(0).getVersion()));
        this.initEntry(metaLog);
    }

    private void initEntry(List<MetaLog> metaLogs) {
        int[] indexes;
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        for (int index : indexes = this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, metaLogs.size())) {
            MetaLog metaLog = metaLogs.get(index);
            this.getModel().setValue(OPERATOR, (Object)metaLog.getOperator(), index);
            this.getModel().setValue(VERSION, (Object)metaLog.getVersion(), index);
            this.getModel().setValue(ISV, (Object)metaLog.getIsv(), index);
            this.getModel().setValue(OPERATE_TIME, (Object)metaLog.getOperateTime(), index);
            this.getModel().setValue(ID, (Object)metaLog.getId(), index);
            this.getModel().setValue(OPERATE, (Object)ResManager.loadKDString((String)"\u6bd4\u8f83", (String)"MetaDataLogRestorePlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), index);
        }
        this.getView().updateView(ENTRY_ENTITY);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if (OPERATE.equals(fieldName)) {
            String id = this.getPageCache().get(ID);
            if (StringUtils.isBlank((CharSequence)id)) {
                return;
            }
            String xml = this.getXmlById(id);
            int rowIndex = evt.getRowIndex();
            this.getPageCache().put(CURRENT_INDEX, String.valueOf(rowIndex));
            Long currentXmlId = (Long)this.getModel().getValue(ID, rowIndex);
            String currentXml = this.getDataById(currentXmlId);
            long oldCommit = (Long)this.getModel().getValue(VERSION, rowIndex);
            if (this.isPrintModel() || StringUtils.isBlank((CharSequence)currentXml)) {
                this.showMerge(currentXml, xml, oldCommit, "true");
            } else {
                this.showMerge(currentXml, xml, oldCommit, "false");
            }
        }
    }

    private boolean isPrintModel() {
        try {
            String modelType = this.getPageCache().get(MODE_TYPE);
            if (StringUtils.isNotBlank((CharSequence)modelType) && "PrintModel".equals(modelType)) {
                return true;
            }
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            String id = (String)showParameter.getCustomParam(ID);
            Map content = MetadataDao.loadDesignerMetadata((String)id, (String)RequestContext.get().getLang().toString());
            if (content != null && content.get(MODE_TYPE) != null) {
                return "PrintModel".equals(content.get(MODE_TYPE).toString());
            }
            return false;
        }
        catch (Exception e) {
            log.error("\u65e7\u6253\u5370\u8bbe\u8ba1\u5668\u5224\u65ad\u662f\u5426\u662f\u6253\u5370\u6a21\u578b\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
            return false;
        }
    }

    private String getXmlById(String id) {
        List deployFiles = MetadataDao.getFormDeployFile((String)id);
        return ((DeployFile)deployFiles.get(0)).getFileContent();
    }

    private void showMerge(String lastXml, String currentXml, long oldCommitId, String isNotShowTree) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(BOS_DEVP_METAMERGE);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        String newCommitId = this.getPageCache().get("newCommitId");
        parameter.setCustomParam("newCommitId", (Object)newCommitId);
        parameter.setCustomParam("oldCommitId", (Object)String.valueOf(oldCommitId));
        parameter.setCustomParam(LAST_DYM, (Object)lastXml);
        parameter.setCustomParam(BASE_DYM, (Object)currentXml);
        if (StringUtils.equals((CharSequence)"true", (CharSequence)isNotShowTree)) {
            String id = this.getPageCache().get(ID);
            String number = MetadataDao.getNumberById((String)id);
            parameter.setCustomParam("number", (Object)number);
        }
        parameter.setCustomParam("isNotShowTree", (Object)isNotShowTree);
        this.getView().showForm(parameter);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BTN_OK.equals(key)) {
            if (!this.isCanRestore()) {
                return;
            }
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u4e00\u6761\u8bb0\u5f55\u3002", (String)"MetaDataLogRestorePlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return;
            }
            Long xmlId = (Long)this.getModel().getValue(ID, selectRows[0]);
            String xml = this.getDataById(xmlId);
            this.getPageCache().put(XML, xml);
            String id = this.getPageCache().get(ID);
            Map<String, String> res = this.getAppIdAndUnitId(id);
            if (StringUtils.isBlank(res)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8868\u5355\u6240\u5c5e\u5206\u7ec4\u6216\u5e94\u7528\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MetaDataLogRestorePlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                return;
            }
            String bizAppId = res.get("bizAppId");
            String bizUnitId = res.get("bizUnitId");
            this.getPageCache().put("bizAppId", bizAppId);
            this.getPageCache().put("bizUnitId", bizUnitId);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u5c06\u5f53\u524d\u7248\u672c\u5143\u6570\u636e\u8fd8\u539f\u81f3\u6570\u636e\u5e93\u5417\uff1f", (String)"MetaDataLogRestorePlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(RESTORE_CONFIRM_CALLBACK));
        }
    }

    private boolean isCanRestore() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        boolean gray = (Boolean)parameter.getCustomParam("gray");
        if (gray) {
            String errorMsg = ResManager.loadKDString((String)"\u7070\u5ea6\u529f\u80fd\u4e0d\u5141\u8bb8\u7f16\u8f91\u5143\u6570\u636e\u3002", (String)"FormDesignerPlugin_32", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            return false;
        }
        boolean prod = (Boolean)parameter.getCustomParam("prod");
        if (prod) {
            String errorMsg = ResManager.loadKDString((String)"\u4e3a\u4fdd\u8bc1\u73af\u5883\u7a33\u5b9a\uff0c\u751f\u4ea7\u73af\u5883\u6682\u4e0d\u5141\u8bb8\u7f16\u8f91\u5143\u6570\u636e\u3002", (String)"FormDesignerPlugin_28", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            return false;
        }
        boolean deploy = (Boolean)parameter.getCustomParam("deploy");
        if (deploy) {
            String errorMsg = ResManager.loadKDString((String)"\u5e73\u53f0\u6b63\u5728\u8fdb\u884c\u7cfb\u7edf\u5347\u7ea7\uff0c\u6682\u4e0d\u5141\u8bb8\u8fdb\u884c\u6b64\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"FormDesignerPlugin_31", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            return false;
        }
        boolean currentIsv = (Boolean)parameter.getCustomParam("currentIsvIsBank");
        if (currentIsv) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u672a\u6ce8\u518c\u5f00\u53d1\u5546\uff0c\u8bf7\u7528\u8d85\u7ea7\u7528\u6237\u767b\u5f55\u5e76\u6ce8\u518c\u5f00\u53d1\u5546\u3002", (String)"MetaDataLogRestorePlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            return false;
        }
        boolean isvIsSame = (Boolean)parameter.getCustomParam("isvIsSame");
        if (!isvIsSame) {
            String errorMsg = ResManager.loadKDString((String)"\u8d44\u6e90\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5f00\u53d1\u5546\uff0c\u8bf7\u8fdb\u5165\u5f00\u53d1\u5e73\u53f0\u5e94\u7528\uff0c\u5c06\u8d44\u6e90\u6269\u5c55\u540e\u518d\u8fdb\u884c\u7f16\u8f91\u3002", (String)"FormDesignerPlugin_27", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            return false;
        }
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (RESTORE_CONFIRM_CALLBACK.equals(event.getCallBackId()) && MessageBoxResult.Yes.equals((Object)event.getResult())) {
            String id = this.getPageCache().get(ID);
            String bizAppId = this.getPageCache().get("bizAppId");
            String bizUnitId = this.getPageCache().get("bizUnitId");
            String xml = this.getPageCache().get(XML);
            HashMap<String, String> result = new HashMap<String, String>(2);
            try {
                MetadataDao.deployMetadata((String)xml, (String)bizUnitId, (String)bizAppId);
                MetadataDao.rebuildRuntimeMetaById((String)id);
                String number = MetadataDao.getNumberById((String)id);
                this.writeLog(id, number);
                result.put(STATUS, SUCCESS);
                result.put(XML, xml);
            }
            catch (Exception e) {
                result.put(STATUS, ERROR);
                result.put(MESSAGE, e.getMessage());
                log.error((Throwable)e);
            }
            this.getView().returnDataToParent(result);
            this.getView().close();
        }
    }

    private void writeLog(String formId, String formNumber) {
        try {
            long fid = DB.genGlobalLongId();
            MetadataLogService logService = (MetadataLogService)ServiceFactory.getService(MetadataLogService.class);
            logService.addMetaLog(formId, formNumber, (int)MetaLogType.FormDesign.getValue(), fid, (int)MetaType.Form.getValue());
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u5143\u6570\u636e\u65e5\u5fd7\u5931\u8d25\uff0cerr\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    private String getDataById(Long id) {
        String sql = "select fdata from t_log_metaversion where fentryid = ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":fentryid", -5, (Object)id)};
        return (String)DB.query((DBRoute)DBRoute.log, (String)sql, (Object[])params, rs -> {
            while (rs.next()) {
                if (!StringUtils.isNotBlank((CharSequence)rs.getString("fdata"))) continue;
                return rs.getString("fdata");
            }
            return null;
        });
    }

    private List<MetaLog> getMetaLog(String id) {
        String sql = "select a.fentryid, a.fmetaver , b.foperator , b.foperatetime , b.fisv from t_log_metaversion a join t_log_metaoperate b on a.fid = b.fid and a.fmetaid = ? order by b.foperatetime desc";
        Object[] params = new SqlParameter[]{new SqlParameter(":fmetaid", 12, (Object)id)};
        return (List)DB.query((DBRoute)DBRoute.log, (String)sql, (Object[])params, rs -> {
            ArrayList<MetaLog> metaLogs = new ArrayList<MetaLog>(10);
            while (rs.next()) {
                long entryId = rs.getLong("fentryid");
                long metaVer = rs.getLong("fmetaver");
                long operator = rs.getLong("foperator");
                Timestamp operateTime = rs.getTimestamp("foperatetime");
                String isv = rs.getString("fisv");
                MetaLog metaLog = new MetaLog();
                metaLog.setIsv(isv);
                metaLog.setOperateTime(operateTime);
                metaLog.setOperator(operator);
                metaLog.setVersion(metaVer);
                metaLog.setId(entryId);
                metaLogs.add(metaLog);
            }
            return metaLogs;
        });
    }

    private Map<String, String> getAppIdAndUnitId(String formId) {
        String sql = String.format("select fbizappid, fbizunitid from %s where fformid = ? ", "t_meta_bizunitrelform");
        Object[] params = new SqlParameter[]{new SqlParameter(":fformid", 12, (Object)formId)};
        ResultSetHandler action = rs -> {
            HashMap<String, String> res = new HashMap<String, String>(2);
            if (rs.next()) {
                String bizAppId = rs.getString("fbizappid");
                String bizUnitId = rs.getString("fbizunitid");
                res.put("bizAppId", bizAppId);
                res.put("bizUnitId", bizUnitId);
                return res;
            }
            return null;
        };
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    static class MetaLog {
        private long version;
        private String isv;
        private long operator;
        private Date operateTime;
        private Long id;

        public MetaLog() {
        }

        public MetaLog(long version, String isv, long operator, Date operateTime, String xml) {
            this.version = version;
            this.isv = isv;
            this.operator = operator;
            this.operateTime = operateTime;
        }

        public long getVersion() {
            return this.version;
        }

        public void setVersion(long version) {
            this.version = version;
        }

        public String getIsv() {
            return this.isv;
        }

        public void setIsv(String isv) {
            this.isv = isv;
        }

        public long getOperator() {
            return this.operator;
        }

        public void setOperator(long operator) {
            this.operator = operator;
        }

        public Date getOperateTime() {
            return this.operateTime;
        }

        public void setOperateTime(Date operateTime) {
            this.operateTime = operateTime;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }
    }
}

