/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.meta.log;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.designer.bizobjext.DesignerDataUtil;
import kd.bos.designer.meta.log.MetaLog;
import kd.bos.metadata.AbstractDesignMeta;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.metadata.deploy.DeployMetadata;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.extensible.BizObjExtMeta;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

public class MetaLogDao {
    public static List<MetaLog> getMetaLogById(String id, int start, int limit) {
        return MetaLogDao.getMetaLogById(id, 0, start, limit);
    }

    public static List<MetaLog> getMetaLogById(String id, int type, int start, int limit) {
        String selectFields = "type,operator,operatetime,isv,entryentity.id,entryentity.metaver";
        QFilter qFilter = new QFilter("entryentity.metaid", "=", (Object)id);
        if (type != 0) {
            QFilter qFilter1 = new QFilter("type", "=", (Object)String.valueOf(type));
            qFilter.and(qFilter1);
        }
        QFilter[] filters = new QFilter[]{qFilter};
        String orderBy = "operatetime desc";
        ArrayList<MetaLog> metaLogList = new ArrayList<MetaLog>(10);
        try (DataSet dataSet = ORM.create().queryDataSet("meta_log", "meta_log", selectFields, filters, orderBy, start, limit);){
            while (dataSet.hasNext()) {
                MetaLog metaLog = new MetaLog();
                Row row = dataSet.next();
                metaLog.setIsv(row.getString("isv"));
                metaLog.setOperateTime(row.getDate("operatetime"));
                metaLog.setId(row.getLong("entryentity.id"));
                metaLog.setOperator(row.getLong("operator"));
                metaLog.setVersion(row.getLong("entryentity.metaver"));
                metaLogList.add(metaLog);
            }
        }
        return metaLogList;
    }

    public static MetaLog getDataById(Long id) {
        String sql = "select fmetaver, fdata from t_log_metaversion where fentryid = ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":fentryid", -5, (Object)id)};
        return (MetaLog)DB.query((DBRoute)DBRoute.log, (String)sql, (Object[])params, rs -> {
            if (rs.next()) {
                MetaLog metaLog = new MetaLog();
                metaLog.setXml(rs.getString("fdata"));
                metaLog.setVersion(rs.getLong("fmetaver"));
                return metaLog;
            }
            return null;
        });
    }

    public static String getXmlById(String id) {
        List deployFiles = MetadataDao.getFormDeployFile((String)id);
        return ((DeployFile)deployFiles.get(0)).getFileContent();
    }

    public static long getVersionById(String id) {
        String sql = "select fversion from t_meta_formdesign where fid = ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":fid", 12, (Object)id)};
        return (Long)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, rs -> {
            if (rs.next()) {
                return rs.getLong("fversion");
            }
            return null;
        });
    }

    public static Map<String, String> getAppIdAndUnitId(String formId) {
        String sql = String.format("select fbizappid, fbizunitid from %s where fformid = ? ", "t_meta_bizunitrelform");
        Object[] params = new SqlParameter[]{new SqlParameter(":fformid", 12, (Object)formId)};
        ResultSetHandler action = rs -> {
            HashMap<String, String> res = new HashMap<String, String>(2);
            if (rs.next()) {
                String bizAppId = rs.getString("fbizappid");
                String bizUnitId = rs.getString("fbizunitid");
                res.put("bizAppId", bizAppId);
                res.put("bizUnitId", bizUnitId);
                return res;
            }
            return null;
        };
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    public static List<String> deployBizExtMetadata(String content) {
        DcxmlSerializer serializer = new DcxmlSerializer(DeployMetadata.getDCBinder());
        serializer.setColloctionIgnorePKValue(true);
        DeployMetadata deployNew = (DeployMetadata)serializer.deserializeFromString(content, null);
        String id = MetaLogDao.deployBizExtMetadata(deployNew);
        ArrayList<String> list = new ArrayList<String>();
        list.add(id);
        return list;
    }

    public static String deployBizExtMetadata(DeployMetadata deployNew) {
        String formId = deployNew.getId();
        IDataEntityType dataEntityType = OrmUtils.getDataEntityType(BizObjExtMeta.class);
        BizObjExtMeta bizObjExtMeta = (BizObjExtMeta)BusinessDataReader.read((Object)formId, (IDataEntityType)dataEntityType, (Boolean)false);
        List designDatas = deployNew.getDesignMetas();
        for (AbstractDesignMeta designMeta : designDatas) {
            if (designMeta instanceof DesignFormMeta) {
                bizObjExtMeta.setFormdata(designMeta.getDataXml());
                bizObjExtMeta.setModifierId(Long.parseLong(((DesignFormMeta)designMeta).getModifierId()));
                bizObjExtMeta.setModifyDate(((DesignFormMeta)designMeta).getModifyDate());
                continue;
            }
            if (!(designMeta instanceof DesignEntityMeta)) continue;
            bizObjExtMeta.setEntitydata(designMeta.getDataXml());
        }
        String sql = "update t_meta_bizobj_ext set fformdata_tag = ? ,fentitydata_tag = ? ,fmodifydate = ? ,fmodifier = ?, fstatus = '1' where fid = ? ";
        DB.execute((DBRoute)DBRoute.meta, (String)sql, (Object[])new Object[]{bizObjExtMeta.getFormdata(), bizObjExtMeta.getEntitydata(), bizObjExtMeta.getModifyDate(), bizObjExtMeta.getModifierId(), bizObjExtMeta.getId()});
        DesignerDataUtil.clearBizExtCache(bizObjExtMeta.getId());
        return deployNew.getMasterId() == null ? deployNew.getId() : deployNew.getMasterId();
    }

    public static void deployBizExtMetadata(List<AbstractDesignMeta> designDatas, String formId) {
        IDataEntityType dataEntityType = OrmUtils.getDataEntityType(BizObjExtMeta.class);
        BizObjExtMeta bizObjExtMeta = (BizObjExtMeta)BusinessDataReader.read((Object)formId, (IDataEntityType)dataEntityType, (Boolean)false);
        for (AbstractDesignMeta designMeta : designDatas) {
            if (designMeta instanceof DesignFormMeta) {
                bizObjExtMeta.setFormdata(designMeta.getDataXml());
                bizObjExtMeta.setModifierId(Long.parseLong(((DesignFormMeta)designMeta).getModifierId()));
                bizObjExtMeta.setModifyDate(((DesignFormMeta)designMeta).getModifyDate());
                continue;
            }
            if (!(designMeta instanceof DesignEntityMeta)) continue;
            bizObjExtMeta.setEntitydata(designMeta.getDataXml());
        }
        String sql = "update t_meta_bizobj_ext set fformdata_tag = ? ,fentitydata_tag = ? ,fmodifydate = ? ,fmodifier = ?, fstatus = '1' where fid = ? ";
        DB.execute((DBRoute)DBRoute.meta, (String)sql, (Object[])new Object[]{bizObjExtMeta.getFormdata(), bizObjExtMeta.getEntitydata(), bizObjExtMeta.getModifyDate(), bizObjExtMeta.getModifierId(), bizObjExtMeta.getId()});
        DesignerDataUtil.clearBizExtCache(bizObjExtMeta.getId());
    }
}

