/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.product.ProductSettingService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.util.StringUtils;

public class AbstractEntityTreePlugin
extends StandardTreeListPlugin
implements RowClickEventListener,
ClickListener {
    protected static final String BILLISTAP = "billlistap";
    protected static final String BTNOK = "btnok";
    private static final String CODE_NUMBER = "codenumber";
    private static final String BILL_TYPE = "billtype";
    private static final String WORK_FLOW = "workflow";
    private static final String VOUCHER = "voucher";
    private static final String VALUE = "value";
    private static final String NUMBER = "number";
    private static final String ITEM_ID = "itemId";
    private static final String META_TYPE = "metaType";
    private static final String PROPERTY_NAME = "propertyName";

    public void initialize() {
        super.initialize();
        ((ListView)this.getView()).setNeedRefreshTree(false);
    }

    public void initializeTree(EventObject e) {
        this.intiTree();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btn = (Button)this.getControl(BTNOK);
        if (btn != null) {
            btn.addClickListener((ClickListener)this);
        }
    }

    private String booleanConvert(Boolean temp) {
        return temp != false ? "1" : "0";
    }

    protected List<QFilter> addModelFilter(Boolean isTemplate, Map<String, Boolean> businessControlConfig) {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        if (isTemplate.booleanValue()) {
            list.add(new QFilter("istemplate", "=", (Object)"1"));
        }
        if (businessControlConfig != null && businessControlConfig.size() > 0) {
            if (businessControlConfig.containsKey(CODE_NUMBER)) {
                list.add(new QFilter(CODE_NUMBER, "=", (Object)this.booleanConvert(businessControlConfig.get(CODE_NUMBER))));
            }
            if (businessControlConfig.containsKey(BILL_TYPE)) {
                list.add(new QFilter(BILL_TYPE, "=", (Object)this.booleanConvert(businessControlConfig.get(BILL_TYPE))));
            }
            if (businessControlConfig.containsKey(WORK_FLOW)) {
                list.add(new QFilter(WORK_FLOW, "=", (Object)this.booleanConvert(businessControlConfig.get(WORK_FLOW))));
            }
            if (businessControlConfig.containsKey("botp")) {
                list.add(new QFilter("botp", "=", (Object)this.booleanConvert(businessControlConfig.get("botp"))));
            }
            if (businessControlConfig.containsKey(VOUCHER)) {
                list.add(new QFilter(VOUCHER, "=", (Object)this.booleanConvert(businessControlConfig.get(VOUCHER))));
            }
        }
        return list;
    }

    public void beforeClick(BeforeClickEvent evt) {
        if (evt.getSource() instanceof Button) {
            Button btn = (Button)evt.getSource();
            String type = (String)this.getView().getFormShowParameter().getCustomParam("selectaction");
            if (type != null) {
                if (BTNOK.equalsIgnoreCase(btn.getKey()) && type.equals("FieldEdit")) {
                    this.returnData();
                } else if (BTNOK.equalsIgnoreCase(btn.getKey()) && type.equals("doOpenParent")) {
                    this.getView().returnDataToParent(this.getCurrentSelector());
                    this.getView().close();
                }
            } else {
                BillList billList = (BillList)this.getView().getControl(BILLISTAP);
                Object skipCheckSelectRows = this.getView().getFormShowParameter().getCustomParam("skipCheckSelectRows");
                if (skipCheckSelectRows != null && ((Boolean)skipCheckSelectRows).booleanValue()) {
                    billList.getSelectedRows().setClearFlag(true);
                }
                this.getView().returnDataToParent((Object)billList.getSelectedRows());
                this.getView().close();
            }
            evt.setCancel(true);
        } else {
            super.beforeClick(evt);
        }
    }

    protected void returnData() {
        Object oldId;
        Map<String, Object> row = this.getCurrentSelector();
        if (row != null && !ObjectUtils.nullSafeEquals(oldId = this.getView().getFormShowParameter().getCustomParams().get(VALUE), (Object)row.get(NUMBER))) {
            ArrayList paras = new ArrayList();
            HashMap<String, Object> para = new HashMap<String, Object>();
            para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
            para.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
            para.put(PROPERTY_NAME, this.getView().getFormShowParameter().getCustomParams().get(PROPERTY_NAME));
            para.put(VALUE, row.get("id"));
            String name = "";
            if (row.get("name") != null) {
                name = row.get("name").toString();
            }
            para.put("alias", name);
            paras.add(para);
            para = new HashMap();
            para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
            para.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
            para.put(PROPERTY_NAME, "BizBasedata");
            para.put(VALUE, this.isBizBasedata((String)row.get("id")));
            paras.add(para);
            para = new HashMap();
            para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
            para.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
            para.put(PROPERTY_NAME, "RefProps");
            para.put(VALUE, new ArrayList());
            paras.add(para);
            para = new HashMap();
            para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
            para.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
            para.put(PROPERTY_NAME, "DefValue");
            para.put(VALUE, "");
            paras.add(para);
            para = new HashMap();
            para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
            para.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
            para.put(PROPERTY_NAME, "RefLayout");
            para.put(VALUE, "");
            paras.add(para);
            this.getView().returnDataToParent(paras);
            this.getView().close();
        }
    }

    private boolean isBizBasedata(String baseEntityId) {
        if (StringUtils.isBlank((String)baseEntityId)) {
            return false;
        }
        String entityNumber = MetadataDao.getNumberById((String)baseEntityId);
        if (StringUtils.isBlank((String)entityNumber)) {
            return false;
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (!(mainType instanceof BasedataEntityType)) {
            return false;
        }
        return ((BasedataEntityType)mainType).getMasteridType() == 2;
    }

    private void setBarItemEnable(boolean enable, boolean isSetAll) {
        if (isSetAll) {
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{"btnnew", "btnedit", "btndel"});
        } else {
            this.getView().setEnable(Boolean.valueOf(enable), new String[]{"btnnew"});
            this.getView().setEnable(Boolean.valueOf(!enable), new String[]{"btnedit", "btndel"});
        }
    }

    public Map<String, Object> getCurrentSelector() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ListSelectedRow lsr = ((ListView)this.getView()).getCurrentSelectedRowInfo();
        if (lsr == null) {
            return null;
        }
        QFilter filter = new QFilter(NUMBER, "=", lsr.getPrimaryKeyValue());
        DynamicObject doj = QueryServiceHelper.queryOne((String)"bos_entityobject", (String)"id, dentityid, number, name", (QFilter[])new QFilter[]{filter});
        ret.put("id", doj.get("dentityid"));
        ret.put(NUMBER, doj.get(NUMBER));
        ret.put("name", doj.get("name"));
        return ret;
    }

    protected QFilter getModelFilter(String nodeId) {
        QFilter qFilter = null;
        ORM orm = ORM.create();
        boolean isCloud = orm.exists("bos_devportal_bizcloud", (Object)nodeId);
        if (nodeId.equals("-1")) {
            qFilter = new QFilter("dentityid", "is not null", (Object)"");
        } else if (isCloud) {
            JSONArray units = this.getUnitIdsByCloudId(nodeId);
            qFilter = new QFilter("bizappid", "in", (Object)units);
        } else {
            qFilter = new QFilter("bizappid", "=", (Object)nodeId);
        }
        return qFilter;
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent nodeEvent) {
        super.buildTreeListFilter(nodeEvent);
        String nodeId = nodeEvent.getNodeId().toString();
        QFilter modelFilter = this.filter();
        modelFilter.and(this.getModelFilter(nodeId));
        nodeEvent.addQFilter(modelFilter);
        nodeEvent.setCancel(true);
    }

    private void intiTree() {
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"AbstractEntityTreePlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
        root.setParentid("");
        root.setId("-1");
        root.setIsOpened(true);
        List<TreeNode> cloudNodes = this.getAllCloudNodes();
        ArrayList<String> cloudIds = new ArrayList<String>(cloudNodes.size());
        for (TreeNode treeNode : cloudNodes) {
            cloudIds.add(treeNode.getId());
        }
        List<TreeNode> appNodes = this.getAppNodesByCloudId(cloudIds);
        for (TreeNode treeNode : cloudNodes) {
            this.addChildNode(treeNode, appNodes);
        }
        root.addChildren(cloudNodes);
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        this.setBarItemEnable(false, true);
    }

    protected List<TreeNode> getAllCloudNodes() {
        ArrayList<TreeNode> cloudNode = new ArrayList<TreeNode>();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String pageType = (String)formShowParameter.getCustomParam("pagetype");
        if (pageType != null && "extend".equals(pageType)) {
            String refAppId = (String)formShowParameter.getCustomParam("refappid");
            DynamicObject cloudObject = BizCloudServiceHelp.getBizCloudByAppID((String)refAppId);
            TreeNode node = new TreeNode("-1", cloudObject.getString("id"), ((OrmLocaleValue)cloudObject.get("name")).toString());
            cloudNode.add(node);
        } else {
            String selectFields = "id, sequence, number, name, image, backimage, ismodel";
            QFilter[] filters = RunModeServiceHelper.getCloudIdBlacklistFilters(null, (String)"id");
            filters = this.appendCloudIdQFilter(filters, "id");
            Map mapObject = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizcloud", (String)selectFields, (QFilter[])filters);
            for (DynamicObject dynamicObject : mapObject.values()) {
                TreeNode node = new TreeNode();
                node.setId(dynamicObject.getString("id"));
                node.setText(((OrmLocaleValue)dynamicObject.get("name")).toString());
                node.setParentid("-1");
                cloudNode.add(node);
            }
        }
        return cloudNode;
    }

    private QFilter[] appendCloudIdQFilter(QFilter[] oldCloudIdFilter, String fieldName) {
        ProductSettingService productService = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
        List appids = productService.getCloudIdBlackList();
        if (!appids.isEmpty()) {
            ArrayList<QFilter> list = new ArrayList<QFilter>();
            list.add(new QFilter(fieldName, "not in", (Object)appids.toArray()));
            if (oldCloudIdFilter != null) {
                list.addAll(Arrays.asList(oldCloudIdFilter));
            }
            return list.toArray(new QFilter[list.size()]);
        }
        return oldCloudIdFilter;
    }

    @Deprecated
    protected List<TreeNode> getAppNodesByCloudId(String cloudId) {
        ArrayList<TreeNode> appNodes = new ArrayList<TreeNode>();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String pageType = (String)formShowParameter.getCustomParam("pagetype");
        if (pageType != null && "extend".equals(pageType)) {
            String refAppId = (String)formShowParameter.getCustomParam("refappid");
            AppMetadata refAppMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)refAppId, (boolean)false);
            String refAppName = refAppMeta.getName().getLocaleValue();
            TreeNode node = new TreeNode(cloudId, refAppId, refAppName);
            appNodes.add(node);
        } else {
            DynamicObjectCollection dynamicObjects = BizAppServiceHelp.getAllBizAppsByCloudID((String)cloudId);
            for (DynamicObject dynamicObject : dynamicObjects) {
                TreeNode node = new TreeNode();
                String nodeId = dynamicObject.getString("id");
                node.setId(nodeId);
                node.setText(dynamicObject.getString("name"));
                node.setParentid(cloudId);
                appNodes.add(node);
            }
        }
        return appNodes;
    }

    protected List<TreeNode> getAppNodesByCloudId(List<String> cloudIds) {
        ArrayList<TreeNode> appNodes = new ArrayList<TreeNode>();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String pageType = (String)formShowParameter.getCustomParam("pagetype");
        if (pageType != null && "extend".equals(pageType)) {
            String refAppId = (String)formShowParameter.getCustomParam("refappid");
            AppMetadata refAppMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)refAppId, (boolean)false);
            String refAppName = refAppMeta.getName().getLocaleValue();
            for (String cloudId : cloudIds) {
                TreeNode node = new TreeNode(cloudId, refAppId, refAppName);
                appNodes.add(node);
            }
        } else {
            DynamicObjectCollection dynamicObjects = BizAppServiceHelp.getAllBizAppsByCloudID(cloudIds);
            for (DynamicObject dynamicObject : dynamicObjects) {
                TreeNode node = new TreeNode();
                String nodeId = dynamicObject.getString("id");
                node.setId(nodeId);
                node.setText(dynamicObject.getString("name"));
                node.setParentid(dynamicObject.getString("bizcloud"));
                appNodes.add(node);
            }
        }
        return appNodes;
    }

    private TreeNode addChildNode(TreeNode pnode, List<TreeNode> childNodes) {
        for (int i = 0; i < childNodes.size(); ++i) {
            TreeNode cnode = childNodes.get(i);
            String parentId = cnode.getParentid();
            if (!pnode.getId().equals(parentId)) continue;
            pnode.addChild(this.addChildNode(cnode, childNodes));
        }
        return pnode;
    }

    public void refreshNode(RefreshNodeEvent e) {
        List<TreeNode> childNodes = this.getChildNodes(e.getNodeId());
        e.setChildNodes(childNodes);
    }

    private List<TreeNode> getChildNodes(Object parentId) {
        List<TreeNode> cloudNodes = null;
        if (this.getTreeModel().getRoot().getId().equals(parentId)) {
            cloudNodes = this.getAllCloudNodes();
            ArrayList<String> cloudIds = new ArrayList<String>(cloudNodes.size());
            for (TreeNode treeNode : cloudNodes) {
                cloudIds.add(treeNode.getId());
            }
            List<TreeNode> appNodes = this.getAppNodesByCloudId(cloudIds);
            for (TreeNode treeNode : cloudNodes) {
                this.addChildNode(treeNode, appNodes);
            }
        } else {
            TreeNode node = this.getTreeModel().getRoot().getTreeNode((String)parentId, 20);
            if (node != null) {
                return node.getChildren();
            }
        }
        return cloudNodes;
    }

    protected JSONArray getModelFilterContent() {
        String modeltype = (String)this.getView().getFormShowParameter().getCustomParam("modeltype");
        JSONArray modelFilterContent = new JSONArray();
        if (!StringUtils.isEmpty((String)modeltype)) {
            String[] modelTypes;
            for (String modelType : modelTypes = modeltype.split(",")) {
                modelFilterContent.add((Object)modelType);
            }
        } else {
            modelFilterContent.add((Object)"BaseFormModel");
            modelFilterContent.add((Object)"BillFormModel");
            modelFilterContent.add((Object)"ReportFormModel");
            modelFilterContent.add((Object)"DynamicFormModel");
            modelFilterContent.add((Object)"QueryListModel");
            modelFilterContent.add((Object)"MobileFormModel");
            modelFilterContent.add((Object)"BalanceModel");
            modelFilterContent.add((Object)"LogBillFormModel");
            modelFilterContent.add((Object)"KMModel");
        }
        modelFilterContent.add((Object)"PCLayoutModel");
        return modelFilterContent;
    }

    protected QFilter filter() {
        return new QFilter("modeltype", "in", (Object)this.getModelFilterContent());
    }

    protected JSONArray getUnitIdsByCloudId(String bizCloudId) {
        JSONArray unitIds = new JSONArray();
        ORM orm = ORM.create();
        QFilter q = new QFilter("bizcloud", "=", (Object)bizCloudId);
        QFilter[] filters = new QFilter[]{q};
        String selectFields = "id";
        DynamicObjectCollection query = orm.query("bos_devportal_bizapp", selectFields, filters, "sequence asc");
        for (int i = 0; i < query.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)query.get(i);
            String bizAppId = dynamicObject.getString("id");
            unitIds.add((Object)bizAppId);
        }
        return unitIds;
    }

    public void setFilter(SetFilterEvent e) {
    }

    public void itemClick(ItemClickEvent evt) {
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
    }

    public void billListHyperLinkClick(HyperLinkClickArgs evt) {
    }
}

