/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;

public class AssistantSelectorPlugin
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener {
    private static final String BASE_TYPES = "basetypes";
    private static final String NUMBER = "number";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(BASE_TYPES);
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject eo) {
        DynamicObjectCollection coll;
        Long parentGroupId = this.getParentAssistantGroupId();
        QFilter[] filters = null;
        if (parentGroupId != null) {
            filters = new QFilter[]{new QFilter("parent", "=", (Object)parentGroupId)};
        }
        if (!CollectionUtils.isEmpty((Collection)(coll = QueryServiceHelper.query((String)"bos_assistantdatagroup", (String)"id,number,name,fbizcloudid", filters)))) {
            IDataModel model = this.getModel();
            model.batchCreateNewEntryRow(BASE_TYPES, coll.size());
            for (int i = 0; i < coll.size(); ++i) {
                DynamicObject form = (DynamicObject)coll.get(i);
                model.setValue("fid", (Object)form.getString("id"), i);
                model.setValue(NUMBER, (Object)form.getString(NUMBER), i);
                model.setValue("name", (Object)form.getString("name"), i);
                model.setValue("cloud", (Object)form.getString("fbizcloudid"), i);
            }
        }
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        List<Map<String, Object>> datas = this.getReurnData();
        this.getView().returnDataToParent(datas);
        this.getView().close();
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        if ("btnok".equalsIgnoreCase(c.getKey())) {
            List<Map<String, Object>> datas = this.getReurnData();
            this.getView().returnDataToParent(datas);
        }
        this.getView().close();
    }

    private List<Map<String, Object>> getReurnData() {
        Object oldnumber;
        ArrayList<Map<String, Object>> paras = new ArrayList<Map<String, Object>>();
        Map<String, Object> row = this.getCurrentSelector();
        if (row == null) {
            return paras;
        }
        if (!row.isEmpty() && !ObjectUtils.nullSafeEquals(oldnumber = this.getView().getFormShowParameter().getCustomParams().get("value"), (Object)row.get("id"))) {
            HashMap<String, Object> para = new HashMap<String, Object>();
            para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
            para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
            para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
            para.put("value", row.get("id"));
            para.put("alias", row.get("name"));
            HashMap<String, Object> cloudNumberParam = new HashMap<String, Object>();
            cloudNumberParam.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
            cloudNumberParam.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
            cloudNumberParam.put("propertyName", "AsstTypeNumber");
            cloudNumberParam.put("value", row.get(NUMBER));
            cloudNumberParam.put("alias", row.get("name"));
            paras.add(cloudNumberParam);
            HashMap<String, Object> typeNumberParam = new HashMap<String, Object>();
            typeNumberParam.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
            typeNumberParam.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
            typeNumberParam.put("propertyName", "AsstCloudNumber");
            typeNumberParam.put("value", ((DynamicObject)row.get("cloud")).getString(NUMBER));
            typeNumberParam.put("alias", row.get("name"));
            paras.add(typeNumberParam);
            paras.add(para);
        }
        return paras;
    }

    private Long getParentAssistantGroupId() {
        List contexts = (List)this.getView().getFormShowParameter().getCustomParam("context");
        if (null == contexts || contexts.isEmpty() || contexts.size() < 2) {
            return null;
        }
        List context = (List)contexts.get(0);
        if (null == context || context.isEmpty()) {
            return null;
        }
        Map asstProp = (Map)context.get(0);
        if (null == asstProp) {
            return null;
        }
        List maps = (List)contexts.get(1);
        if (null == maps || maps.isEmpty()) {
            return null;
        }
        Object parentFieldKey = asstProp.get("AsstParentId");
        for (Map mp : maps) {
            Object oo = mp.get("Id");
            if (oo == null || !oo.equals(parentFieldKey)) continue;
            Object parentGroupId = mp.get("AsstTypeId");
            return Long.valueOf(parentGroupId.toString());
        }
        return null;
    }

    private Map<String, Object> getCurrentSelector() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(BASE_TYPES);
        int row = grid.getEntryState().getFocusRow();
        if (StringUtils.isNotBlank((Object)row) && row != -1) {
            ret.put("id", this.getModel().getValue("fid", row));
            ret.put(NUMBER, this.getModel().getValue(NUMBER, row));
            ret.put("name", this.getModel().getValue("name", row));
            ret.put("cloud", this.getModel().getValue("cloud", row));
        }
        return ret;
    }
}

