/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class AssociatedFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ITEM_ID = "itemId";
    private static final String META_TYPE = "metaType";
    private static final String PROPERTY_NAME = "propertyName";
    private static final String CONTEXT = "context";
    private static final String FORM = "formid";
    private static final String BOS_FORMMETA = "bos_formmeta";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String BTN_OK = "btnok";
    private static final String MOBILE_BILL = "mobilebill";
    private static final String MOBILE_LIST = "mobilelist";
    private static final String MOBILE_BASE = "mobilebase";
    private static final String TYPE = "type";
    private static final Object[] MODEL_TYPES = new Object[]{"BillFormModel", "BaseFormModel", "MobileFormModel", "MobileBillFormModel"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(FORM);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        Map value = (Map)this.getView().getFormShowParameter().getCustomParam("value");
        if (value != null) {
            Object pkId = value.get("formId");
            if (StringUtils.isNotBlank(pkId)) {
                this.getModel().setValue(FORM, pkId);
            }
            String modelType = (String)value.get(TYPE);
            this.setModelType(pkId, modelType);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TYPE});
        }
    }

    public void afterBindData(EventObject e) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (FORM.equalsIgnoreCase(e.getProperty().getName())) {
            DynamicObject value = (DynamicObject)this.getModel().getValue(FORM);
            if (value == null) {
                this.getView().setVisible(Boolean.FALSE, new String[]{TYPE});
                return;
            }
            this.setModelType(value.getPkValue(), null);
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_OK.contentEquals(key)) {
            DynamicObject form = (DynamicObject)this.getModel().getValue(FORM);
            HashMap<String, Object> returnData = new HashMap<String, Object>(9);
            if (form != null) {
                String number = form.getString("number");
                String name = form.getString("name");
                HashMap<String, Object> value = new HashMap<String, Object>(6);
                value.put("formId", form.getPkValue());
                Object modelType = this.getModel().getValue(TYPE);
                if (modelType != null) {
                    value.put(TYPE, modelType.toString());
                    if (MOBILE_BILL.equals(modelType) || MOBILE_BASE.equals(modelType)) {
                        number = number + "_mob";
                    }
                }
                value.put("formNumber", number);
                returnData.put("value", value);
                returnData.put("alias", StringUtils.isNotBlank((CharSequence)name) ? name : number);
            }
            returnData.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
            returnData.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
            returnData.put(PROPERTY_NAME, this.getView().getFormShowParameter().getCustomParams().get(PROPERTY_NAME));
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    private void setModelType(Object formId, String value) {
        if (formId == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TYPE});
            return;
        }
        DynamicObject form = BusinessDataServiceHelper.loadSingleFromCache((Object)formId, (String)BOS_FORMMETA, (String)"modeltype");
        if (form == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TYPE});
            return;
        }
        String modelType = form.getString("modeltype");
        if (StringUtils.isBlank((CharSequence)modelType)) {
            this.getModel().setValue(TYPE, null);
            this.getView().setVisible(Boolean.FALSE, new String[]{TYPE});
            return;
        }
        if ("MobileFormModel".equals(modelType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{TYPE});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{TYPE});
        }
        String defaultValue = this.setComboEdit(modelType);
        if (StringUtils.isBlank((CharSequence)value)) {
            value = defaultValue;
        }
        this.getModel().setValue(TYPE, (Object)value);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        formShowParameter.setFormId("bos_devp_formtreelistf7");
        formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("modeltype", "in", (Object)MODEL_TYPES));
    }

    private String setComboEdit(String formType) {
        ComboEdit modelTypeCombo = (ComboEdit)this.getView().getControl(TYPE);
        ArrayList<ComboItem> modelTypeItem = new ArrayList<ComboItem>(2);
        switch (formType) {
            case "BillFormModel": {
                modelTypeItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u79fb\u52a8\u8868\u5355", (String)"AssociatedFormPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), MOBILE_BILL));
                modelTypeItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u79fb\u52a8\u5217\u8868", (String)"AssociatedFormPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), MOBILE_LIST));
                modelTypeCombo.setComboItems(modelTypeItem);
                break;
            }
            case "BaseFormModel": {
                modelTypeItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u79fb\u52a8\u8868\u5355", (String)"AssociatedFormPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), MOBILE_BASE));
                modelTypeItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u79fb\u52a8\u5217\u8868", (String)"AssociatedFormPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), MOBILE_LIST));
                modelTypeCombo.setComboItems(modelTypeItem);
                break;
            }
            case "MobileFormModel": {
                modelTypeItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u79fb\u52a8\u8868\u5355", (String)"AssociatedFormPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), "mobileform"));
                modelTypeCombo.setComboItems(modelTypeItem);
                break;
            }
            case "MobileBillFormModel": {
                modelTypeItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u79fb\u52a8\u8868\u5355", (String)"AssociatedFormPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), "mobileform"));
                modelTypeItem.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u79fb\u52a8\u5217\u8868", (String)"AssociatedFormPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), MOBILE_LIST));
                modelTypeCombo.setComboItems(modelTypeItem);
                break;
            }
        }
        if (!CollectionUtils.isEmpty(modelTypeItem)) {
            return ((ComboItem)modelTypeItem.get(0)).getValue();
        }
        return null;
    }
}

