/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;

public class BaseEntityIdEdit
extends AbstractFormPlugin
implements ClickListener,
RowClickEventListener {
    private static final String BASE_TYPES = "basetypes";
    private static final String VALUE = "value";
    private static final String NUMBER = "number";
    private static final String ITEM_ID = "itemId";
    private static final String META_TYPE = "metaType";
    private static final String PROPERTY_NAME = "propertyName";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(BASE_TYPES);
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        this.reurnData();
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        if ("btnok".equalsIgnoreCase(c.getKey())) {
            this.reurnData();
        } else if ("btncancel".equalsIgnoreCase(c.getKey())) {
            this.getView().close();
        }
    }

    private void reurnData() {
        Object oldId;
        Map<String, Object> row = this.getCurrentSelector();
        if (row != null && !ObjectUtils.nullSafeEquals(oldId = this.getView().getFormShowParameter().getCustomParams().get(VALUE), (Object)row.get(NUMBER))) {
            ArrayList paras = new ArrayList();
            HashMap<String, Object> para = new HashMap<String, Object>();
            para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
            para.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
            para.put(PROPERTY_NAME, this.getView().getFormShowParameter().getCustomParams().get(PROPERTY_NAME));
            para.put(VALUE, row.get("id"));
            para.put("alias", row.get("name"));
            paras.add(para);
            para = new HashMap();
            para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
            para.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
            para.put(PROPERTY_NAME, "RefProps");
            para.put(VALUE, new ArrayList());
            paras.add(para);
            this.getView().returnDataToParent(paras);
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject eo) {
        List formList;
        Object[] params = new SqlParameter[]{new SqlParameter(":FLOCALEID", 12, (Object)"zh_CN")};
        String sql = null;
        sql = "ide_itemclasstypeedit".equals(this.getView().getParentView().getRootControl().getKey()) ? "select a.FID, a.FNumber,a.FNAME from T_META_ENTITYDESIGN_L a inner join t_meta_mainentityinfo b on a.FID = b.FDENTITYID where b.FMODELTYPE='BaseFormModel' AND b.FPKFIELDTYPE='1'AND FLOCALEID = ?" : "select a.FID, a.FNumber,a.FNAME from T_META_ENTITYDESIGN_L a inner join T_META_ENTITYDESIGN b on a.FID = b.FID where b.FMODELTYPE='BaseFormModel' AND FLOCALEID = ?";
        try {
            formList = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

                public List<Map<String, Object>> handle(ResultSet rs) throws SQLException {
                    ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(10);
                    while (rs.next()) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("id", rs.getString(1));
                        map.put(BaseEntityIdEdit.NUMBER, rs.getString(2));
                        map.put("name", rs.getString(3));
                        list.add(map);
                    }
                    return list;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format("error:%s;  sql:%s", e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        if (!formList.isEmpty()) {
            IDataModel model = this.getModel();
            model.batchCreateNewEntryRow(BASE_TYPES, formList.size());
            int i = 0;
            for (Map form : formList) {
                model.setValue("fid", form.get("id"), i);
                model.setValue("fnumber", form.get(NUMBER), i);
                model.setValue("fname", form.get("name"), i);
                ++i;
            }
        }
    }

    private Map<String, Object> getCurrentSelector() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(BASE_TYPES);
        int row = grid.getEntryState().getFocusRow();
        if (!StringUtils.isNotBlank((Object)row)) {
            return null;
        }
        ret.put("id", this.getModel().getValue("fid", row));
        ret.put(NUMBER, this.getModel().getValue("fnumber", row));
        ret.put("name", this.getModel().getValue("fname", row));
        return ret;
    }
}

