/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.designer.dao.FormMetadataUtil;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.EntryGridColAllCheckedEvent;
import kd.bos.form.control.events.EntryGridColAllCheckedListener;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.MobileBillFormAp;
import kd.bos.metadata.form.MobileFormAp;
import kd.bos.metadata.form.cardentry.CardEntryFieldAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;

public class BatchEditFieldPlugin
extends AbstractFormPlugin
implements ClickListener,
EntryGridBindDataListener,
EntryGridColAllCheckedListener {
    private static final String KEY_FIELD_SEQ = "fieldseq";
    private static final String KEY_FIELD_KEY = "fieldkey";
    private static final String KEY_FIELD_NAME = "fieldname";
    private static final String KEY_FIELD_ID = "fieldid";
    private static final String[] VISIBLE_STATUS = new String[]{"vinit", "vnew", "vedit", "vview", "vsubmit", "vaudit"};
    private static final String[] LOCK_STATUS = new String[]{"lnew", "ledit", "lsubmit", "laudit"};
    private static final String CHANGE_ROWS = "changeRows";
    private static final String ITEM_ID = "itemId";
    private static final String META_TYPE = "metaType";
    private static final String PROPERTY_NAME = "propertyName";
    private static final String VALUE = "value";
    private static final String ALLOW_VOUCHER = "AllowVoucher";
    private static final String MUST_INPUT = "MustInput";
    private static final String COPY_ABLE = "Copyable";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String KEY_ENABLE_COPY = "enablecopy";
    private static final String KEY_MUST_INPUT = "mustinput";
    private static final String KEY_ALLOW_VOUCHER = "allowvoucher";
    private static final String ENTRY_FIELD_TYPE = "fieldtype";
    String entryKey = "entryap";

    public void initialize() {
        Button button = (Button)this.getControl("Submit");
        button.addClickListener((ClickListener)this);
        button = (Button)this.getControl("Cancel");
        button.addClickListener((ClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl(this.entryKey);
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
    }

    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(this.entryKey);
        entryGrid.addColAllCheckedListener((EntryGridColAllCheckedListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String columnName = e.getProperty().getName();
        String changeRows = this.getPageCache().get(CHANGE_ROWS);
        HashSet<Integer> changeRowsSet = null;
        if (StringUtils.isNotBlank((CharSequence)changeRows)) {
            changeRowsSet = (HashSet<Integer>)SerializationUtils.fromJsonString((String)changeRows, Set.class);
        }
        if (changeRowsSet == null) {
            changeRowsSet = new HashSet<Integer>();
        }
        changeRowsSet.add(rowIndex);
        this.getPageCache().put(CHANGE_ROWS, SerializationUtils.toJsonString(changeRowsSet));
        this.markColumnSelectAllStatus(columnName);
    }

    private void markColumnSelectAllStatus(String columnName) {
        DynamicObjectCollection cols = this.getModel().getEntryEntity(this.entryKey);
        EntryProp entryProp = (EntryProp)this.getModel().getDataEntityType().findProperty(this.entryKey);
        ConcurrentHashMap<String, String> allCheckedCol = new ConcurrentHashMap<String, String>();
        for (IDataEntityProperty prop : entryProp.getDynamicCollectionItemPropertyType().getProperties()) {
            if (!(prop instanceof BooleanProp)) continue;
            allCheckedCol.put(prop.getName(), prop.getName());
        }
        for (Map.Entry ctlKey : allCheckedCol.entrySet()) {
            if (columnName != null) {
                if (!columnName.equals(ctlKey.getKey())) continue;
                this.setGridColAllValue(this.entryKey, columnName, false);
                continue;
            }
            this.setGridColAllValue(this.entryKey, (String)ctlKey.getKey(), false);
        }
        for (DynamicObject dym : cols) {
            allCheckedCol.forEach((k, v) -> {
                if (!dym.getBoolean(k.toLowerCase())) {
                    allCheckedCol.remove(k);
                }
            });
        }
        if (cols.size() > 0) {
            for (Map.Entry ctlKey : allCheckedCol.entrySet()) {
                this.setGridColAllValue(this.entryKey, (String)ctlKey.getKey(), true);
            }
        }
    }

    private void setGridColAllValue(String entryGrid, String colKey, boolean checked) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> ret = new HashMap<String, Object>(2);
        ret.put("c", colKey);
        ret.put("v", checked);
        clientViewProxy.invokeControlMethod(entryGrid, "setGridColAllValue", new Object[]{ret});
    }

    public void click(EventObject e) {
        Button button = (Button)e.getSource();
        switch (button.getKey().toLowerCase(Locale.ENGLISH)) {
            case "submit": {
                this.closeAndReturn();
                break;
            }
            case "cancel": {
                this.getView().close();
                break;
            }
        }
    }

    public void closeAndReturn() {
        ArrayList paras = new ArrayList();
        Object object = this.getView().getFormShowParameter().getCustomParams().get("context");
        String entryIds = this.getPageCache().get("entryIds");
        String changeRows = this.getPageCache().get(CHANGE_ROWS);
        Set changeRowsSet = null;
        if (StringUtils.isNotBlank((CharSequence)changeRows)) {
            changeRowsSet = (Set)SerializationUtils.fromJsonString((String)changeRows, Set.class);
        }
        if (changeRowsSet != null) {
            for (Integer rowIndex : changeRowsSet) {
                DynamicObject obj = this.getModel().getEntryRowEntity(this.entryKey, rowIndex.intValue());
                HashMap<String, Object> para = new HashMap<String, Object>();
                para.put(ITEM_ID, obj.get(KEY_FIELD_ID));
                para.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
                para.put(PROPERTY_NAME, "Visible");
                String visible = "";
                visible = this.buildProperty(obj, false);
                para.put(VALUE, visible);
                paras.add(para);
                para = new HashMap();
                para.put(ITEM_ID, obj.get(KEY_FIELD_ID));
                para.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
                para.put(PROPERTY_NAME, "Lock");
                String lock = "";
                lock = this.buildProperty(obj, true);
                para.put(VALUE, lock);
                paras.add(para);
                para = new HashMap();
                para.put(ITEM_ID, obj.get(KEY_FIELD_ID));
                para.put(META_TYPE, "entitymeta");
                para.put(PROPERTY_NAME, "Features");
                Map<Object, Object> features = new HashMap<String, Object>();
                if (obj.get(KEY_ENABLE_COPY) != null) {
                    if (object instanceof List) {
                        List listValue = (List)((List)object).get(1);
                        features = this.getFeatrue(listValue, obj.getString(KEY_FIELD_ID));
                        features.put(COPY_ABLE, obj.get(KEY_ENABLE_COPY));
                    } else {
                        features.put(COPY_ABLE, obj.get(KEY_ENABLE_COPY));
                    }
                }
                if (obj.get(ALLOW_VOUCHER) != null) {
                    features.put(ALLOW_VOUCHER, obj.get(ALLOW_VOUCHER));
                }
                para.put(VALUE, features);
                paras.add(para);
                para = new HashMap();
                para.put(ITEM_ID, obj.get(KEY_FIELD_ID));
                para.put(PROPERTY_NAME, MUST_INPUT);
                if (StringUtils.isNotBlank((CharSequence)entryIds)) {
                    List ids = (List)SerializationUtils.fromJsonString((String)entryIds, List.class);
                    for (String entryId : ids) {
                        if (!obj.get(KEY_FIELD_ID).equals(entryId)) continue;
                        para.put(PROPERTY_NAME, "EntryMustInput");
                        break;
                    }
                }
                para.put(META_TYPE, "entitymeta");
                if (obj.get(KEY_MUST_INPUT) == null) continue;
                para.put(VALUE, obj.get(KEY_MUST_INPUT));
                paras.add(para);
            }
        }
        this.getView().returnDataToParent(paras);
        this.getView().close();
    }

    public void afterCreateNewData(EventObject arg0) {
        String name;
        Boolean isVoucher;
        Boolean mustInput;
        Object isCopyAble;
        Map<String, Object> featrue;
        PropertyEditHelper helper = new PropertyEditHelper();
        List<Map<String, Object>> formItems = helper.getFormMeta(this.getView());
        List<Map<String, Object>> entityItems = helper.getEntityMeta(this.getView());
        ArrayList<String> entryIds = new ArrayList<String>();
        FormMetadata formMetadata = FormMetadataUtil.getFormMetadata(formItems);
        formMetadata.createIndex();
        for (ControlAp control : formMetadata.getItems()) {
            if (!(control instanceof FieldAp) || control instanceof EntryFieldAp || control instanceof CardEntryFieldAp) continue;
            featrue = this.getFeatrue(entityItems, control.getId());
            isCopyAble = featrue.get(COPY_ABLE) == null ? Boolean.FALSE : (Boolean)featrue.get(COPY_ABLE);
            mustInput = this.getMustInput(entityItems, control.getId());
            isVoucher = featrue.get(ALLOW_VOUCHER) == null ? Boolean.FALSE : (Boolean)featrue.get(ALLOW_VOUCHER);
            this.fieldRule(control.getId(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u5934\u00b7%s", (String)"BatchEditFieldPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), control.getName().toString()), control.getKey(), control.getVisible(), control.getLock(), (Boolean)isCopyAble, mustInput, isVoucher, control, entityItems);
        }
        for (ControlAp control : formMetadata.getItems()) {
            if (!(control instanceof EntryAp)) continue;
            Boolean entryMustInput = this.getMustInput(entityItems, control.getId());
            this.fieldRule(control.getId(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u4f53\u540d\u00b7%s", (String)"BatchEditFieldPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), control.getName().toString()), control.getKey(), control.getVisible(), control.getLock(), null, entryMustInput, null, control, entityItems);
            entryIds.add(control.getId());
            for (ControlAp controlAp : ((EntryAp)control).getItems()) {
                String s = control.getName().toString();
                String string = name = StringUtils.isNotBlank((CharSequence)s) ? s : control.getKey();
                if (!(controlAp instanceof EntryFieldAp)) continue;
                Map<String, Object> featrue2 = this.getFeatrue(entityItems, controlAp.getId());
                Boolean isCopyAble2 = featrue2.get(COPY_ABLE) == null ? Boolean.FALSE : (Boolean)featrue2.get(COPY_ABLE);
                Boolean mustInput2 = this.getMustInput(entityItems, controlAp.getId());
                Boolean isVoucher2 = featrue2.get(ALLOW_VOUCHER) == null ? Boolean.FALSE : (Boolean)featrue2.get(ALLOW_VOUCHER);
                this.fieldRule(controlAp.getId(), name + "\u00b7" + controlAp.getName().toString(), controlAp.getKey(), controlAp.getVisible(), controlAp.getLock(), isCopyAble2, mustInput2, isVoucher2, controlAp, entityItems);
            }
        }
        for (ControlAp controlAp : formMetadata.getItems()) {
            if (!(controlAp instanceof CardEntryFieldAp)) continue;
            featrue = this.getFeatrue(entityItems, controlAp.getId());
            isCopyAble = featrue.get(COPY_ABLE) == null ? Boolean.FALSE : (Boolean)featrue.get(COPY_ABLE);
            mustInput = this.getMustInput(entityItems, controlAp.getId());
            isVoucher = featrue.get(ALLOW_VOUCHER) == null ? Boolean.FALSE : (Boolean)featrue.get(ALLOW_VOUCHER);
            name = "";
            for (ControlAp item : formMetadata.getItems()) {
                if (!item.getId().equals(controlAp.getParentId())) continue;
                name = StringUtils.isNotBlank((CharSequence)item.getName().toString()) ? item.getName().toString() : item.getKey();
            }
            this.fieldRule(controlAp.getId(), name + "\u00b7" + controlAp.getName().toString(), controlAp.getKey(), controlAp.getVisible(), controlAp.getLock(), (Boolean)isCopyAble, mustInput, isVoucher, controlAp, entityItems);
        }
        if (formMetadata.getRootAp() instanceof MobileBillFormAp || formMetadata.getRootAp() instanceof MobileFormAp) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_ALLOW_VOUCHER, KEY_MUST_INPUT, KEY_ENABLE_COPY});
        }
        this.getPageCache().put("entryIds", SerializationUtils.toJsonString(entryIds));
        this.markColumnSelectAllStatus(null);
    }

    public void afterBindData(EventObject e) {
        String formId = this.getView().getFormShowParameter().getParentFormId();
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        if (!StringUtils.equals((CharSequence)formMetadata.getEntityId(), (CharSequence)formMetadata.getId())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_ALLOW_VOUCHER, KEY_MUST_INPUT, KEY_ENABLE_COPY});
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl(this.entryKey);
        grid.setColumnProperty(KEY_FIELD_NAME, "isFixed", (Object)true);
        grid.setColumnProperty(KEY_FIELD_KEY, "isFixed", (Object)true);
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("ModifierField", "CreateDateField", "ModifyDateField", "UserAvatarField", "BasedataPropField", "BaseUnitqtyField", "PrintCountField", "BillStatusField", "CreaterField"));
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam("modeltype");
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(this.entryKey);
        if (dynamicObjects == null || dynamicObjects.isEmpty()) {
            return;
        }
        int row = 0;
        for (DynamicObject dynamicObject : dynamicObjects) {
            String fieldType;
            boolean isFieldAp = dynamicObject.getBoolean("isfieldap");
            if (isFieldAp) {
                this.setLockMapCache("lview", row);
            }
            if (list.contains(fieldType = dynamicObject.getString(ENTRY_FIELD_TYPE))) {
                this.setLockMapCache("lnew", row);
                this.setLockMapCache("ledit", row);
                this.setLockMapCache("lview", row);
                this.setLockMapCache("lsubmit", row);
                this.setLockMapCache("laudit", row);
            }
            if ("RadioGroupField".equals(fieldType)) {
                this.setLockMapCache("lnew", row);
                this.setLockMapCache("ledit", row);
                this.setLockMapCache("lview", row);
                this.setLockMapCache("lsubmit", row);
                this.setLockMapCache("laudit", row);
                this.setLockMapCache("vinit", row);
                this.setLockMapCache("vnew", row);
                this.setLockMapCache("vedit", row);
                this.setLockMapCache("vview", row);
                this.setLockMapCache("vsubmit", row);
                this.setLockMapCache("vaudit", row);
            }
            ++row;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(this.entryKey);
        String lock = this.getPageCache().get("lockMap");
        if (StringUtils.isNotBlank((CharSequence)lock)) {
            Map lockMap = (Map)SerializationUtils.fromJsonString((String)lock, Map.class);
            Map data = e.getData();
            Map dataIndex = (Map)data.get("dataindex");
            Integer intcprop = (Integer)dataIndex.get("cprop");
            List rows = (List)data.get("rows");
            for (int i = 0; i < rows.size(); ++i) {
                List rowObjList = (List)rows.get(i);
                Map cpropMap = (Map)rowObjList.get(intcprop);
                for (Map.Entry entry : lockMap.entrySet()) {
                    if (entry.getValue() == null || !((List)entry.getValue()).contains(i)) continue;
                    ArrayList blankList = (ArrayList)cpropMap.get("blank");
                    if (blankList == null) {
                        blankList = new ArrayList();
                        cpropMap.put("blank", blankList);
                    }
                    blankList.add(entry.getKey());
                }
            }
            e.getData().put("rows", rows);
            for (Map.Entry lockEntryMap : lockMap.entrySet()) {
                if (row != ((List)lockEntryMap.getValue()).size()) continue;
                entryGrid.setColumnProperty((String)lockEntryMap.getKey(), "vi", (Object)false);
            }
        }
    }

    private void setLockMapCache(String feature, int i) {
        Map<String, HashSet<Integer>> lockMap = new HashMap(16);
        HashSet<Integer> rows = new HashSet<Integer>(10);
        String lock = this.getPageCache().get("lockMap");
        if (StringUtils.isNotBlank((CharSequence)lock) && (lockMap = (Map)SerializationUtils.fromJsonString((String)lock, Map.class)).get(feature) != null) {
            rows = new HashSet((Collection)lockMap.get(feature));
        }
        rows.add(i);
        lockMap.put(feature, rows);
        this.getPageCache().put("lockMap", SerializationUtils.toJsonString(lockMap));
    }

    public Map<String, Object> getFeatrue(List<Map<String, Object>> listValue, String id) {
        Map<String, Object> featureCopyAble = new HashMap<String, Object>();
        for (Map<String, Object> map : listValue) {
            Object vfeatures = map.get("Features");
            if (!id.equals(map.get("Id")) || !StringUtils.isNotBlank((Object)vfeatures)) continue;
            featureCopyAble = vfeatures instanceof Map ? (Map)vfeatures : (Map)SerializationUtils.fromJsonString((String)((String)vfeatures), Map.class);
            break;
        }
        return featureCopyAble;
    }

    public Boolean getMustInput(List<Map<String, Object>> listValue, String id) {
        Boolean mustInput = false;
        for (Map<String, Object> map : listValue) {
            Object mustInputObj;
            Object object = mustInputObj = map.get(MUST_INPUT) != null ? map.get(MUST_INPUT) : map.get("EntryMustInput");
            if (!id.equals(map.get("Id"))) continue;
            if ("BasedataPropField".equals(map.get("_Type_")) || "UserAvatarField".equals(map.get("_Type_"))) {
                mustInput = null;
                continue;
            }
            if (!StringUtils.isNotBlank((Object)mustInputObj)) continue;
            mustInput = (Boolean)mustInputObj;
            break;
        }
        return mustInput;
    }

    private void fieldRule(String id, String name, String key, String visible, String lock, Boolean featureCopyAble, Boolean mustInput, Boolean isVoucher, ControlAp control, List<Map<String, Object>> entityItems) {
        FieldEdit field;
        String fieldType = "";
        for (Map<String, Object> e : entityItems) {
            if (!id.equals(e.get("Id"))) continue;
            fieldType = (String)e.get("_Type_");
        }
        this.getModel().beginInit();
        int rowIndex = this.getModel().createNewEntryRow(this.entryKey);
        this.getModel().setValue(KEY_FIELD_ID, (Object)id, rowIndex);
        this.getModel().setValue(KEY_FIELD_NAME, (Object)name, rowIndex);
        this.getModel().setValue(KEY_FIELD_KEY, (Object)key, rowIndex);
        this.getModel().setValue(ENTRY_FIELD_TYPE, (Object)fieldType, rowIndex);
        if (featureCopyAble == null) {
            field = (FieldEdit)this.getView().getControl(KEY_ENABLE_COPY);
            field.setEnable(null, false, rowIndex);
        } else {
            this.getModel().setValue(KEY_ENABLE_COPY, (Object)featureCopyAble, rowIndex);
        }
        if (isVoucher == null) {
            field = (FieldEdit)this.getView().getControl(KEY_ALLOW_VOUCHER);
            field.setEnable(null, false, rowIndex);
        } else {
            this.getModel().setValue(KEY_ALLOW_VOUCHER, (Object)isVoucher, rowIndex);
        }
        if (mustInput == null) {
            field = (FieldEdit)this.getView().getControl(KEY_MUST_INPUT);
            field.setEnable(null, false, rowIndex);
        } else {
            this.getModel().setValue(KEY_MUST_INPUT, (Object)mustInput, rowIndex);
        }
        if (StringUtils.isNotBlank((CharSequence)visible)) {
            String[] visibleStatus;
            for (String status : visibleStatus = visible.split(",")) {
                this.getModel().setValue(BatchEditFieldPlugin.buildVisibleKey(status), (Object)true, rowIndex);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)lock)) {
            String[] lockStatus;
            for (String status : lockStatus = lock.split(",")) {
                this.getModel().setValue(BatchEditFieldPlugin.buildLockKey(status), (Object)true, rowIndex);
            }
        }
        boolean isFieldAp = false;
        if (control instanceof FieldAp) {
            isFieldAp = true;
        }
        this.getModel().setValue("isfieldap", (Object)isFieldAp, rowIndex);
        this.getModel().endInit();
    }

    private static String buildVisibleKey(String status) {
        return String.format("v%s", status);
    }

    private static String buildLockKey(String status) {
        return String.format("l%s", status);
    }

    private static String getStatus(String fieldKey) {
        return fieldKey.substring(1);
    }

    private String buildProperty(DynamicObject propEditRow, boolean isLock) {
        ArrayList<String> status = new ArrayList<String>();
        String[] statusKeys = null;
        statusKeys = isLock ? LOCK_STATUS : VISIBLE_STATUS;
        for (String statusKey : statusKeys) {
            if (!propEditRow.getBoolean(statusKey)) continue;
            status.add(BatchEditFieldPlugin.getStatus(statusKey));
        }
        return status.stream().collect(Collectors.joining(","));
    }

    public void entryGridColAllChecked(EntryGridColAllCheckedEvent e) {
        boolean oldValue;
        int i;
        e.setCancel(true);
        EntryGrid entryGrid = (EntryGrid)this.getControl(this.entryKey);
        int startIndex = 0;
        int endIndex = entryGrid.getModel().getEntryRowCount(this.entryKey);
        String locks = this.getPageCache().get("lockMap");
        Map lockMap = (Map)SerializationUtils.fromJsonString((String)locks, Map.class);
        List rows = (List)lockMap.get(e.getColKey());
        HashSet<Integer> rowSet = new HashSet<Integer>(16);
        this.getModel().beginInit();
        if (rows != null) {
            for (i = startIndex; i < endIndex; ++i) {
                if (rows.contains(i) || (oldValue = ((Boolean)this.getModel().getValue(e.getColKey(), i)).booleanValue()) == e.isChecked()) continue;
                this.getModel().setValue(e.getColKey(), (Object)e.isChecked(), i);
                rowSet.add(i);
            }
        } else {
            for (i = startIndex; i < endIndex; ++i) {
                oldValue = (Boolean)this.getModel().getValue(e.getColKey(), i);
                if (oldValue == e.isChecked()) continue;
                this.getModel().setValue(e.getColKey(), (Object)e.isChecked(), i);
                rowSet.add(i);
            }
        }
        this.getModel().endInit();
        String changeRows = this.getPageCache().get(CHANGE_ROWS);
        HashSet<Integer> changeRowsSet = null;
        if (StringUtils.isNotBlank((CharSequence)changeRows)) {
            changeRowsSet = (HashSet<Integer>)SerializationUtils.fromJsonString((String)changeRows, Set.class);
        }
        if (changeRowsSet == null) {
            changeRowsSet = new HashSet<Integer>();
        }
        changeRowsSet.addAll(rowSet);
        this.getPageCache().put(CHANGE_ROWS, SerializationUtils.toJsonString(changeRowsSet));
        this.getView().updateView(this.entryKey);
        this.setGridColAllValue(this.entryKey, e.getColKey(), e.isChecked());
    }
}

