/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.designer.dao.FormMetadataUtil;
import kd.bos.designer.property.alias.FeaturesConverter;
import kd.bos.devportal.common.util.DesignerUtils;
import kd.bos.entity.Features;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.EntryGridColAllCheckedEvent;
import kd.bos.form.control.events.EntryGridColAllCheckedListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.define.DomainModelTypeFactory;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.extensible.ExtLockTypeEnum;
import kd.bos.metadata.extensible.ExtensibleDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.cardentry.CardEntryFieldAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.EntryFieldGroupAp;
import kd.bos.metadata.form.control.FieldAp;

public class BatchFeaturesEditPlugin
extends AbstractFormPlugin
implements EntryGridBindDataListener,
EntryGridColAllCheckedListener {
    private static final String BTN_OK = "ok";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String ENTRY_FIELD_ID = "fieldid";
    private static final String ENTRY_FIELD_NAME = "fieldname";
    private static final String ENTRY_FIELD_KEY = "fieldkey";
    private static final String ENTRY_PARENT_FIELD_TYPE = "parentfieldtype";
    private static final String ENTRY_PARENT_FIELD_ID = "parentid";
    private static final String ENTRY_FIELD_TYPE = "fieldtype";
    private static final String ENTRY_COPYABLE = "copyable";
    private static final String ENTRY_IMPORTABLE = "importable";
    private static final String ENTRY_EXPORTABLE = "exportable";
    private static final String ENTRY_BULKEDITABLE = "bulkeditable";
    private static final String ENTRY_MULTIFILLABLE = "multifillable";
    private static final String ENTRY_SERIESNEWTOTE = "seriesnewtote";
    private static final String ENTRY_CONVERTTOTE = "converttote";
    private static final String ENTRY_ALLOWVOUCHER = "allowvoucher";
    private static final String ENTRY_F7BATCHFILL = "f7batchfill";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String CHANGE_ROWS = "changeRows";

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        entryGrid.addDataBindListener((EntryGridBindDataListener)this);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        entryGrid.addColAllCheckedListener((EntryGridColAllCheckedListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Features features;
        PropertyEditHelper helper = new PropertyEditHelper();
        String modelType = helper.getModelType(this.getView());
        List<Map<String, Object>> formMeta = helper.getFormMeta(this.getView());
        List<Map<String, Object>> entityMeta = helper.getEntityMeta(this.getView());
        FormMetadata formMetadata = new FormMetadata();
        if ("BalanceModel".equals(modelType)) {
            DomainModelBinder binder = new DomainModelBinder(DomainModelTypeFactory.getDomainModelType((String)"BalanceModel", (boolean)true));
            DcJsonSerializer ser = new DcJsonSerializer((DcBinder)binder);
            HashMap<String, Object> form = new HashMap<String, Object>(2);
            form.put("Items", formMeta);
            form.put("_Type_", "FormMetadata");
            formMetadata = (FormMetadata)ser.deserializeFromMap(form, null);
        } else {
            formMetadata = FormMetadataUtil.getFormMetadata(formMeta);
        }
        formMetadata.createIndex();
        for (ControlAp control : formMetadata.getItems()) {
            if (!(control instanceof FieldAp) || control instanceof EntryFieldAp || control instanceof CardEntryFieldAp) continue;
            features = this.getFeatures(entityMeta, control.getId(), modelType);
            this.setFieldFeatures(control.getId(), String.format(ResManager.loadKDString((String)"\u5355\u636e\u5934\u00b7%s", (String)"BatchFeaturesEditPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), control.getName().toString()), control.getKey(), features, entityMeta);
        }
        for (ControlAp control : formMetadata.getItems()) {
            if (!(control instanceof EntryAp)) continue;
            for (ControlAp controlAp : ((EntryAp)control).getItems()) {
                if (controlAp instanceof EntryFieldAp) {
                    Features features2 = this.getFeatures(entityMeta, controlAp.getId(), modelType);
                    String s = control.getName().toString();
                    String name = StringUtils.isNotBlank((CharSequence)s) ? s : control.getKey();
                    this.setFieldFeatures(controlAp.getId(), name + "\u00b7" + controlAp.getName().toString(), controlAp.getKey(), features2, entityMeta);
                    continue;
                }
                if (!(controlAp instanceof EntryFieldGroupAp)) continue;
                String s = control.getName().toString();
                String name = StringUtils.isNotBlank((CharSequence)s) ? s : control.getKey();
                this.addEntryFieldGroup(entityMeta, controlAp, modelType, name);
            }
        }
        for (ControlAp controlAp : formMetadata.getItems()) {
            if (!(controlAp instanceof CardEntryFieldAp)) continue;
            features = this.getFeatures(entityMeta, controlAp.getId(), modelType);
            String name = "";
            for (ControlAp item : formMetadata.getItems()) {
                if (!item.getId().equals(controlAp.getParentId())) continue;
                name = StringUtils.isNotBlank((CharSequence)item.getName().toString()) ? item.getName().toString() : item.getKey();
            }
            this.setFieldFeatures(controlAp.getId(), name + "\u00b7" + controlAp.getName().toString(), controlAp.getKey(), features, entityMeta);
        }
        this.markColumnSelectAllStatus(null);
        this.putCacheLockInfo();
    }

    private void addEntryFieldGroup(List<Map<String, Object>> entityMeta, ControlAp<?> controlAp, String modelType, String name) {
        for (ControlAp groupFieldAp : ((EntryFieldGroupAp)controlAp).getItems()) {
            if (groupFieldAp instanceof EntryFieldAp) {
                Features features = this.getFeatures(entityMeta, groupFieldAp.getId(), modelType);
                this.setFieldFeatures(groupFieldAp.getId(), name + "\u00b7" + groupFieldAp.getName().toString(), groupFieldAp.getKey(), features, entityMeta);
                continue;
            }
            if (!(groupFieldAp instanceof EntryFieldGroupAp)) continue;
            this.addEntryFieldGroup(entityMeta, groupFieldAp, modelType, name);
        }
    }

    private Features getFeatures(List<Map<String, Object>> listValue, String id, String modelType) {
        Features features = new Features();
        Map feature = new HashMap(16);
        for (Map<String, Object> map : listValue) {
            Object vfeatures = map.get("Features");
            if (!id.equals(map.get("Id")) || !StringUtils.isNotBlank((Object)vfeatures)) continue;
            feature = vfeatures instanceof Map ? (Map)vfeatures : (Map)SerializationUtils.fromJsonString((String)((String)vfeatures), Map.class);
            features = (Features)new MetadataSerializer(modelType).deserializeFromMap(feature, null);
            break;
        }
        return features;
    }

    private void setFieldFeatures(String id, String name, String key, Features features, List<Map<String, Object>> entityMeta) {
        String fieldType = "";
        String parentId = "";
        String parentFieldType = "";
        for (Map<String, Object> e : entityMeta) {
            if (!id.equals(e.get("Id"))) continue;
            fieldType = (String)e.get("_Type_");
            parentId = (String)e.get("ParentId");
        }
        for (Map<String, Object> e : entityMeta) {
            if (!e.get("Id").equals(parentId)) continue;
            parentFieldType = (String)e.get("_Type_");
        }
        this.getModel().beginInit();
        int rowIndex = this.getModel().createNewEntryRow(ENTRY_ENTITY);
        this.getModel().setValue(ENTRY_FIELD_ID, (Object)id, rowIndex);
        this.getModel().setValue(ENTRY_PARENT_FIELD_TYPE, (Object)parentFieldType, rowIndex);
        this.getModel().setValue(ENTRY_PARENT_FIELD_ID, (Object)parentId, rowIndex);
        this.getModel().setValue(ENTRY_FIELD_NAME, (Object)name, rowIndex);
        this.getModel().setValue(ENTRY_FIELD_KEY, (Object)key, rowIndex);
        this.getModel().setValue(ENTRY_FIELD_TYPE, (Object)fieldType, rowIndex);
        this.getModel().setValue(ENTRY_COPYABLE, (Object)features.isCopyable(), rowIndex);
        this.getModel().setValue(ENTRY_MULTIFILLABLE, (Object)features.isMultiFillable(), rowIndex);
        this.getModel().setValue(ENTRY_F7BATCHFILL, (Object)features.isF7BatchFill(), rowIndex);
        this.getModel().setValue(ENTRY_IMPORTABLE, (Object)features.isImportable(), rowIndex);
        this.getModel().setValue(ENTRY_EXPORTABLE, (Object)features.isExportable(), rowIndex);
        this.getModel().setValue(ENTRY_SERIESNEWTOTE, (Object)features.isSeriesNewTote(), rowIndex);
        this.getModel().setValue(ENTRY_BULKEDITABLE, (Object)features.isBulkEditable(), rowIndex);
        this.getModel().setValue(ENTRY_CONVERTTOTE, (Object)features.isConvertTote(), rowIndex);
        this.getModel().setValue(ENTRY_ALLOWVOUCHER, (Object)features.isAllowvoucher(), rowIndex);
        this.getModel().endInit();
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        this.lockNotEditableFeatures();
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(ENTRY_ENTITY);
        if (dynamicObjects == null) {
            return;
        }
        int row = 0;
        for (DynamicObject dynamicObject : dynamicObjects) {
            String fieldType = dynamicObject.getString(ENTRY_FIELD_TYPE);
            String parentFieldType = dynamicObject.getString(ENTRY_PARENT_FIELD_TYPE);
            String parentId = dynamicObject.getString(ENTRY_PARENT_FIELD_ID);
            String fieldId = dynamicObject.getString(ENTRY_FIELD_ID);
            this.lockCopyable(fieldType, row);
            this.lockSeriesNewTote(fieldType, row);
            this.lockF7BatchFill(this.isLockF7BatchFill(fieldType, parentId), row);
            this.lockConvertTote(fieldType, row);
            this.lockImportableExportable(fieldType, row);
            this.lockMultifillable(parentFieldType, fieldType, row);
            this.byParentFieldTypeLock(parentFieldType, row);
            ++row;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        String lock = this.getPageCache().get("lockMap");
        if (StringUtils.isNotBlank((CharSequence)lock)) {
            Map lockMap = (Map)SerializationUtils.fromJsonString((String)lock, Map.class);
            Map data = e.getData();
            Map dataIndex = (Map)data.get("dataindex");
            Integer intcprop = (Integer)dataIndex.get("cprop");
            List rows = (List)data.get("rows");
            for (int i = 0; i < rows.size(); ++i) {
                List rowObjList = (List)rows.get(i);
                Map cpropMap = (Map)rowObjList.get(intcprop);
                for (Map.Entry entry : lockMap.entrySet()) {
                    if (entry.getValue() == null || !((List)entry.getValue()).contains(i)) continue;
                    ArrayList blankList = (ArrayList)cpropMap.get("blank");
                    if (blankList == null) {
                        blankList = new ArrayList();
                        cpropMap.put("blank", blankList);
                    }
                    blankList.add(entry.getKey());
                }
            }
            e.getData().put("rows", rows);
            for (Map.Entry lockEntryMap : lockMap.entrySet()) {
                if (row != ((List)lockEntryMap.getValue()).size()) continue;
                entryGrid.setColumnProperty((String)lockEntryMap.getKey(), "vi", (Object)false);
            }
        }
        entryGrid.setColumnProperty(ENTRY_FIELD_NAME, "isFixed", (Object)Boolean.TRUE);
        entryGrid.setColumnProperty(ENTRY_FIELD_KEY, "isFixed", (Object)Boolean.TRUE);
    }

    private void putCacheLockInfo() {
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("itemId");
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam("modelType");
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(ENTRY_ENTITY);
        if (dynamicObjects == null) {
            return;
        }
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Form);
        List isvList = DesignerUtils.ISV_LIST;
        ArrayList<Integer> lockRows = new ArrayList<Integer>(1);
        ArrayList<Integer> unlockRows = new ArrayList<Integer>(1);
        ArrayList<Integer> specialLockRows = new ArrayList<Integer>(1);
        int row = 0;
        boolean isUnLockColumn = false;
        for (DynamicObject dynamicObject : dynamicObjects) {
            String elementId = dynamicObject.getString(ENTRY_FIELD_ID);
            ControlAp item = formMetadata.getItem(elementId);
            String elementIsv = "";
            if (item != null) {
                elementIsv = item.getIsv();
            }
            if (isvList.contains(elementIsv) && !StringUtils.equals((CharSequence)formMetadata.getIsv(), (CharSequence)elementIsv)) {
                ExtLockTypeEnum lockType = ExtensibleDao.getExtLockType((String)entityId, (String)"Field", (String)modelType, (String)elementId, (String)"Features");
                if (ExtLockTypeEnum.lock.equals((Object)lockType)) {
                    lockRows.add(row);
                } else if (ExtLockTypeEnum.unlock.equals((Object)lockType)) {
                    isUnLockColumn = true;
                    unlockRows.add(row);
                } else if (ExtLockTypeEnum.speciallock.equals((Object)lockType)) {
                    specialLockRows.add(row);
                }
            }
            ++row;
        }
        this.getPageCache().put("isUnLockColumn_cache", String.valueOf(isUnLockColumn));
        this.getPageCache().put("lockRows_cache", SerializationUtils.toJsonString(lockRows));
        this.getPageCache().put("unlockRows_cache", SerializationUtils.toJsonString(unlockRows));
        this.getPageCache().put("specialLockRows_cache", SerializationUtils.toJsonString(specialLockRows));
    }

    private void lockNotEditableFeatures() {
        EntryGrid grid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("itemId");
        String modelType = (String)this.getView().getFormShowParameter().getCustomParam("modelType");
        if (StringUtils.isBlank((CharSequence)entityId)) {
            return;
        }
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        ExtLockTypeEnum lockType = ExtensibleDao.getExtLockType((AbstractMetadata)entityMetadata, (String)"Field", (String)entityMetadata.getModelType(), (String)entityId, (String)"BatchFeaturesEdit");
        if (ExtLockTypeEnum.speciallock.equals((Object)lockType)) {
            List lockRows = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("lockRows_cache"), Integer.class);
            List specialLockRows = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("specialLockRows_cache"), Integer.class);
            if ("true".equals(this.getPageCache().get("isUnLockColumn_cache"))) {
                for (Integer lockRow : lockRows) {
                    this.getView().setEnable(Boolean.FALSE, lockRow.intValue(), new String[]{ENTRY_COPYABLE, ENTRY_IMPORTABLE, ENTRY_EXPORTABLE, ENTRY_BULKEDITABLE, ENTRY_MULTIFILLABLE, ENTRY_SERIESNEWTOTE, ENTRY_CONVERTTOTE, ENTRY_ALLOWVOUCHER, ENTRY_F7BATCHFILL});
                }
                for (Integer specialLockRow : specialLockRows) {
                    this.getView().setEnable(Boolean.FALSE, specialLockRow.intValue(), new String[]{ENTRY_COPYABLE, ENTRY_IMPORTABLE, ENTRY_BULKEDITABLE, ENTRY_MULTIFILLABLE, ENTRY_SERIESNEWTOTE, ENTRY_CONVERTTOTE, ENTRY_ALLOWVOUCHER, ENTRY_F7BATCHFILL});
                }
            } else {
                this.getView().setEnable(Boolean.FALSE, -1, new String[]{ENTRY_COPYABLE, ENTRY_IMPORTABLE, ENTRY_BULKEDITABLE, ENTRY_MULTIFILLABLE, ENTRY_SERIESNEWTOTE, ENTRY_CONVERTTOTE, ENTRY_ALLOWVOUCHER, ENTRY_F7BATCHFILL});
                if (lockRows.size() > 0) {
                    Integer[] integers = lockRows.toArray(new Integer[lockRows.size()]);
                    int[] rows = Arrays.stream(integers).mapToInt(Integer::valueOf).toArray();
                    grid.setRowLock(Boolean.TRUE.booleanValue(), rows);
                }
            }
        }
    }

    private void lockCopyable(String fieldType, int row) {
        if ("AttachmentCountField".equals(fieldType) || "SignatureField".equals(fieldType)) {
            this.getView().setEnable(Boolean.FALSE, row, new String[]{ENTRY_COPYABLE});
            this.setLockMapCache(ENTRY_COPYABLE, row);
        }
    }

    private void setLockMapCache(String feature, int i) {
        Map<String, HashSet<Integer>> lockMap = new HashMap(16);
        HashSet<Integer> rows = new HashSet<Integer>(10);
        String lock = this.getPageCache().get("lockMap");
        if (StringUtils.isNotBlank((CharSequence)lock) && (lockMap = (Map)SerializationUtils.fromJsonString((String)lock, Map.class)).get(feature) != null) {
            rows = new HashSet((Collection)lockMap.get(feature));
        }
        rows.add(i);
        lockMap.put(feature, rows);
        this.getPageCache().put("lockMap", SerializationUtils.toJsonString(lockMap));
    }

    private void byParentFieldTypeLock(String parentFieldType, int row) {
        if ("EntryEntity".equals(parentFieldType) || "SubEntryEntity".equals(parentFieldType) || "TreeEntryEntity".equals(parentFieldType) || "JsonSubEntryEntity".equals(parentFieldType)) {
            this.getView().setEnable(Boolean.FALSE, row, new String[]{ENTRY_SERIESNEWTOTE});
            this.setLockMapCache(ENTRY_SERIESNEWTOTE, row);
        }
        if ("".equals(parentFieldType) || parentFieldType == null || "BalanceEntity".equals(parentFieldType) || "MainEntity".equals(parentFieldType)) {
            this.getView().setEnable(Boolean.FALSE, row, new String[]{ENTRY_MULTIFILLABLE, ENTRY_F7BATCHFILL});
            this.setLockMapCache(ENTRY_MULTIFILLABLE, row);
            this.setLockMapCache(ENTRY_F7BATCHFILL, row);
        }
    }

    private void lockMultifillable(String parentFieldType, String fieldType, int row) {
        if (("".equals(parentFieldType) || parentFieldType == null) && "LargeTextField".equals(fieldType) || "SignatureField".equals(fieldType)) {
            this.getView().setEnable(Boolean.FALSE, row, new String[]{ENTRY_MULTIFILLABLE});
            this.setLockMapCache(ENTRY_MULTIFILLABLE, row);
        }
    }

    private void lockImportableExportable(String fieldType, int row) {
        if ("BasedataPropField".equals(fieldType) || "SignatureField".equals(fieldType) || "RichTextField".equals(fieldType)) {
            this.getView().setEnable(Boolean.FALSE, row, new String[]{ENTRY_IMPORTABLE, ENTRY_EXPORTABLE});
            this.setLockMapCache(ENTRY_IMPORTABLE, row);
            this.setLockMapCache(ENTRY_EXPORTABLE, row);
        }
    }

    private void lockConvertTote(String fieldType, int row) {
        if ("PictureField".equals(fieldType) || "SignatureField".equals(fieldType)) {
            this.getView().setEnable(Boolean.FALSE, row, new String[]{ENTRY_CONVERTTOTE});
            this.setLockMapCache(ENTRY_CONVERTTOTE, row);
        }
    }

    private boolean isLockF7BatchFill(String fieldType, String parentId) {
        Object id;
        List formContext = (List)this.getView().getFormShowParameter().getCustomParams().get("context");
        List entities = (List)formContext.get(0);
        Optional<Map> optional = entities.stream().filter(item -> item.get("Id").equals(parentId)).findFirst();
        if (optional.isPresent() && optional.get() != null && StringUtils.isNotBlank(id = optional.get().get("Id")) && ((Map)entities.get(0)).get("Id").equals(id)) {
            return false;
        }
        switch (fieldType) {
            case "BasedataField": 
            case "UserField": 
            case "OrgField": 
            case "AssistantField": 
            case "CreaterField": 
            case "MaterielField": 
            case "CurrencyField": 
            case "UnitField": 
            case "AdminDivisionField": 
            case "SignatureField": {
                return true;
            }
        }
        return false;
    }

    private void lockF7BatchFill(boolean lockF7BatchFill, int row) {
        if (!lockF7BatchFill) {
            this.getView().setEnable(Boolean.FALSE, row, new String[]{ENTRY_F7BATCHFILL});
            this.setLockMapCache(ENTRY_F7BATCHFILL, row);
        }
    }

    private void lockSeriesNewTote(String fieldType, int row) {
        switch (fieldType) {
            case "LargeTextField": 
            case "RadioField": 
            case "SignatureField": {
                this.getView().setEnable(Boolean.FALSE, row, new String[]{ENTRY_SERIESNEWTOTE});
                this.setLockMapCache(ENTRY_SERIESNEWTOTE, row);
                break;
            }
        }
    }

    private void markColumnSelectAllStatus(String columnName) {
        DynamicObjectCollection cols = this.getModel().getEntryEntity(ENTRY_ENTITY);
        EntryProp entryProp = (EntryProp)this.getModel().getDataEntityType().findProperty(ENTRY_ENTITY);
        ConcurrentHashMap<String, String> allCheckedCol = new ConcurrentHashMap<String, String>();
        for (IDataEntityProperty prop : entryProp.getDynamicCollectionItemPropertyType().getProperties()) {
            if (!(prop instanceof BooleanProp)) continue;
            allCheckedCol.put(prop.getName(), prop.getName());
        }
        for (Map.Entry ctlKey : allCheckedCol.entrySet()) {
            if (columnName != null) {
                if (!columnName.equals(ctlKey.getKey())) continue;
                this.setGridColAllValue(ENTRY_ENTITY, columnName, false);
                continue;
            }
            this.setGridColAllValue(ENTRY_ENTITY, (String)ctlKey.getKey(), false);
        }
        for (DynamicObject dym : cols) {
            allCheckedCol.forEach((k, v) -> {
                if (!dym.getBoolean(k.toLowerCase())) {
                    allCheckedCol.remove(k);
                }
            });
        }
        if (cols.size() > 0) {
            for (Map.Entry ctlKey : allCheckedCol.entrySet()) {
                this.setGridColAllValue(ENTRY_ENTITY, (String)ctlKey.getKey(), true);
            }
        }
    }

    private void setGridColAllValue(String entryGrid, String colKey, boolean checked) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> ret = new HashMap<String, Object>(2);
        ret.put("c", colKey);
        ret.put("v", checked);
        clientViewProxy.invokeControlMethod(entryGrid, "setGridColAllValue", new Object[]{ret});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String columnName = e.getProperty().getName();
        String changeRows = this.getPageCache().get(CHANGE_ROWS);
        HashSet<Integer> changeRowsSet = null;
        if (StringUtils.isNotBlank((CharSequence)changeRows)) {
            changeRowsSet = (HashSet<Integer>)SerializationUtils.fromJsonString((String)changeRows, Set.class);
        }
        if (changeRowsSet == null) {
            changeRowsSet = new HashSet<Integer>();
        }
        changeRowsSet.add(rowIndex);
        this.getPageCache().put(CHANGE_ROWS, SerializationUtils.toJsonString(changeRowsSet));
        this.markColumnSelectAllStatus(columnName);
    }

    public void click(EventObject e) {
        Button button = (Button)e.getSource();
        if (BTN_OK.equals(button.getKey().toLowerCase())) {
            this.closeAndReturn();
        }
    }

    private void closeAndReturn() {
        String changeRows = this.getPageCache().get(CHANGE_ROWS);
        Set changeRowsSet = null;
        if (StringUtils.isNotBlank((CharSequence)changeRows)) {
            changeRowsSet = (Set)SerializationUtils.fromJsonString((String)changeRows, Set.class);
        }
        ArrayList paras = new ArrayList(10);
        if (changeRowsSet != null) {
            for (Integer rowIndex : changeRowsSet) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, rowIndex.intValue());
                HashMap<String, Object> para = new HashMap<String, Object>(5);
                para.put("itemId", rowEntity.getString(ENTRY_FIELD_ID));
                para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
                para.put("propertyName", "Features");
                para.put("value", this.getRowFeatures(rowEntity));
                para.put("alias", new FeaturesConverter().convert(this.getRowFeatures(rowEntity)));
                paras.add(para);
            }
        }
        this.getView().returnDataToParent(paras);
        this.getView().close();
    }

    private Map<String, Object> getRowFeatures(DynamicObject rowEntity) {
        HashMap<String, Object> features = new HashMap<String, Object>();
        features.put("_Type_", "Features");
        features.put("Copyable", rowEntity.getString(ENTRY_COPYABLE));
        features.put("MultiFillable", rowEntity.getString(ENTRY_MULTIFILLABLE));
        features.put("F7BatchFill", rowEntity.getString(ENTRY_F7BATCHFILL));
        features.put("Importable", rowEntity.getString(ENTRY_IMPORTABLE));
        features.put("Exportable", rowEntity.getString(ENTRY_EXPORTABLE));
        features.put("SeriesNewTote", rowEntity.getString(ENTRY_SERIESNEWTOTE));
        features.put("BulkEditable", rowEntity.getString(ENTRY_BULKEDITABLE));
        features.put("ConvertTote", rowEntity.getString(ENTRY_CONVERTTOTE));
        features.put("AllowVoucher", rowEntity.getString(ENTRY_ALLOWVOUCHER));
        return features;
    }

    public void entryGridColAllChecked(EntryGridColAllCheckedEvent e) {
        boolean oldValue;
        int i;
        e.setCancel(true);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int startIndex = 0;
        int endIndex = entryGrid.getModel().getEntryRowCount(ENTRY_ENTITY);
        String locks = this.getPageCache().get("lockMap");
        Map lockMap = (Map)SerializationUtils.fromJsonString((String)locks, Map.class);
        List rows = (List)lockMap.get(e.getColKey());
        HashSet<Integer> rowSet = new HashSet<Integer>(16);
        this.getModel().beginInit();
        if (rows != null) {
            for (i = startIndex; i < endIndex; ++i) {
                if (rows.contains(i) || (oldValue = ((Boolean)this.getModel().getValue(e.getColKey(), i)).booleanValue()) == e.isChecked()) continue;
                this.getModel().setValue(e.getColKey(), (Object)e.isChecked(), i);
                rowSet.add(i);
            }
        } else {
            for (i = startIndex; i < endIndex; ++i) {
                oldValue = (Boolean)this.getModel().getValue(e.getColKey(), i);
                if (oldValue == e.isChecked()) continue;
                this.getModel().setValue(e.getColKey(), (Object)e.isChecked(), i);
                rowSet.add(i);
            }
        }
        this.getModel().endInit();
        String changeRows = this.getPageCache().get(CHANGE_ROWS);
        HashSet<Integer> changeRowsSet = null;
        if (StringUtils.isNotBlank((CharSequence)changeRows)) {
            changeRowsSet = (HashSet<Integer>)SerializationUtils.fromJsonString((String)changeRows, Set.class);
        }
        if (changeRowsSet == null) {
            changeRowsSet = new HashSet<Integer>();
        }
        changeRowsSet.addAll(rowSet);
        this.getPageCache().put(CHANGE_ROWS, SerializationUtils.toJsonString(changeRowsSet));
        this.getView().updateView(ENTRY_ENTITY);
        this.setGridColAllValue(ENTRY_ENTITY, e.getColKey(), e.isChecked());
    }
}

