/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.dao.FormMetadataUtil;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.filter.SchemeFilterColumnAp;
import kd.bos.metadata.filter.SchemeFilterViewAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;

public class BatchSetfilterPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
TreeNodeCheckListener {
    private static final String ITEMS = "Items";
    private static final String FIELD_TREE = "FieldTree";
    private static final String CHECK_NODES = "checkNodes";
    private static final String FTNAME = "ftname";
    private static final String FT_DISPLAY_NAME = "ftdisplayname";
    private static final String TEXT_FIELD = "textfield";
    private static final String TYPE = "type";
    private String entryKey = "ftargetprops";
    private String treeKey = "fieldtree";

    public void initialize() {
        Button button = (Button)this.getControl("fsubmit");
        button.addClickListener((ClickListener)this);
        button = (Button)this.getControl("fcancel");
        button.addClickListener((ClickListener)this);
        button = (Button)this.getControl("btnremove");
        button.addClickListener((ClickListener)this);
        EntryGrid grid = (EntryGrid)this.getControl(this.entryKey);
        grid.addRowClickListener((RowClickEventListener)this);
        TreeView fieldtree = (TreeView)this.getView().getControl(this.treeKey);
        fieldtree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void click(EventObject evt) {
        Button button = (Button)evt.getSource();
        switch (button.getKey().toLowerCase(Locale.ENGLISH)) {
            case "fsubmit": {
                this.save();
                break;
            }
            case "fcancel": {
                this.getView().close();
                break;
            }
            case "btnremove": {
                this.delete();
                break;
            }
        }
    }

    private List<Map<String, Object>> filterItems(List<Map<String, Object>> items, List<String> fieldTypes, boolean isNeedBaseData) {
        ArrayList<Map<String, Object>> newItems = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> item : items) {
            if ("Entity".equalsIgnoreCase(item.get("Type").toString())) {
                newItems.addAll(this.filterItems((List)item.get(ITEMS), fieldTypes, isNeedBaseData));
                continue;
            }
            boolean isBaseData = false;
            if (item.get("IsBaseData") != null) {
                isBaseData = (Boolean)item.get("IsBaseData");
            }
            if (!isNeedBaseData && isBaseData) continue;
            String dataType = "";
            if (item.get("DataType") != null) {
                dataType = item.get("DataType").toString();
            }
            if (fieldTypes.isEmpty() || !fieldTypes.contains(dataType.toLowerCase())) continue;
            newItems.add(item);
        }
        return newItems;
    }

    public void afterCreateNewData(EventObject e) {
        String fieldtype;
        Map fieldTree = (Map)this.getView().getFormShowParameter().getCustomParam("schemefilter");
        if (fieldTree == null || fieldTree.isEmpty()) {
            return;
        }
        List<Map<String, Object>> fieldItems = (List<Map<String, Object>>)fieldTree.get(ITEMS);
        fieldItems.removeIf(item -> Boolean.TRUE.equals(item.get("Encrypt")));
        fieldItems.removeIf(item -> "EntitySeq".equals(item.get("SeqType")));
        boolean fromProFormDesign = Boolean.parseBoolean((String)this.getView().getFormShowParameter().getCustomParam("fromProFormDesigner"));
        if (fromProFormDesign && !fieldItems.isEmpty()) {
            LinkedHashMap fieldItemMaps = new LinkedHashMap();
            fieldItems = fieldItems.stream().filter(t -> fieldItemMaps.put(t.get("Id"), t) == null).collect(Collectors.toList());
        }
        if ((fieldtype = (String)this.getView().getFormShowParameter().getCustomParam("fieldtype")) != null) {
            ArrayList<String> fieldTypes = new ArrayList<String>();
            fieldTypes.add(fieldtype);
            fieldTree.put(ITEMS, this.filterItems(fieldItems, fieldTypes, false));
        } else if (fromProFormDesign) {
            fieldTree.put(ITEMS, fieldItems);
        }
        TreeView tree = (TreeView)this.getView().getControl(FIELD_TREE);
        TreeNode root = TreeNode.Parse((String)"", (Map)fieldTree, (String)"Id", (String)"Name", (String)ITEMS);
        root.setIsOpened(true);
        tree.addNode(root);
        Object value = this.getView().getFormShowParameter().getCustomParams().get("context");
        List obj = (List)value;
        FormMetadata formMetadata = FormMetadataUtil.getFormMetadata(obj);
        formMetadata.createIndex();
        ArrayList<String> checkNodeIds = new ArrayList<String>();
        ArrayList<TreeNode> checkNodes = new ArrayList<TreeNode>();
        List<String> items = new ArrayList<String>();
        String formId = (String)this.getView().getFormShowParameter().getCustomParam("formid");
        String fields = (String)this.getView().getFormShowParameter().getCustomParam("fields");
        if ("bos_comparetypeconfig".equals(formId) && fields != null) {
            items.addAll(Arrays.asList(fields.split(",")));
        }
        items = this.initBatchSetFilter(root, formMetadata, checkNodeIds, checkNodes, items, formId);
        tree.checkNodes(checkNodes);
        this.getPageCache().put(FIELD_TREE, SerializationUtils.toJsonString((Object)root));
        this.getPageCache().put(CHECK_NODES, SerializationUtils.toJsonString(checkNodeIds));
        IDataModel model = this.getModel();
        model.deleteEntryData(this.entryKey);
        for (String name : items) {
            TreeNode node = root.getTreeNode(name, 16);
            if (node == null) continue;
            int rowindex = model.createNewEntryRow(this.entryKey);
            model.setValue(FTNAME, (Object)node.getId(), rowindex);
            model.setValue(FT_DISPLAY_NAME, (Object)node.getText(), rowindex);
            model.setValue(TEXT_FIELD, (Object)node.getId(), rowindex);
        }
    }

    private List<String> initBatchSetFilter(TreeNode root, FormMetadata formMetadata, List<String> checkNodeIds, List<TreeNode> checkNodes, List<String> items, String formId) {
        ControlAp controlAp;
        ArrayList<String> newItems = new ArrayList<String>();
        newItems.addAll(items);
        if ("ide_batchsetfilter".equals(formId) && StringUtils.isNotBlank((Object)(controlAp = formMetadata.getItem("schemefilterview")))) {
            SchemeFilterViewAp sFilterViewAp = (SchemeFilterViewAp)controlAp;
            List items2 = sFilterViewAp.getItems();
            for (ControlAp controlAp2 : items2) {
                if (!(controlAp2 instanceof SchemeFilterColumnAp)) continue;
                newItems.add(((SchemeFilterColumnAp)controlAp2).getFieldName());
            }
        }
        HashMap<String, Boolean> repeatMap = new HashMap<String, Boolean>();
        Iterator iterator = newItems.iterator();
        while (iterator.hasNext()) {
            String nodeId = (String)iterator.next();
            if (repeatMap.get(nodeId) == null) {
                repeatMap.put(nodeId, true);
                TreeNode treeNode = root.getTreeNode(nodeId, 16);
                if (nodeId == null || treeNode == null) continue;
                checkNodeIds.add(nodeId);
                checkNodes.add(treeNode);
                continue;
            }
            iterator.remove();
        }
        return newItems;
    }

    private void save() {
        ArrayList paras = new ArrayList();
        DynamicObjectCollection listCloseField = this.getModel().getEntryEntity(this.entryKey);
        HashMap para = new HashMap();
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", "BatchSetFilter");
        HashMap<String, Object> tmp = null;
        for (DynamicObject map : listCloseField) {
            tmp = new HashMap<String, Object>();
            tmp.put("Name", map.get(FT_DISPLAY_NAME));
            tmp.put("TextField", map.get(FTNAME));
            tmp.put("Id", map.get(TEXT_FIELD));
            tmp.put("Type", map.get(TYPE));
            tmp.put("Value", "seniorfilter");
            paras.add(tmp);
        }
        para.put("value", paras);
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(FIELD_TREE), TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl(FIELD_TREE);
        List currChecks = tree.getTreeState().getCheckedNodeIds();
        List checkNodes = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(CHECK_NODES), List.class);
        IDataModel model = this.getModel();
        if (evt.getChecked().booleanValue()) {
            if (checkNodes.isEmpty() || currChecks.removeAll(checkNodes)) {
                for (String id : currChecks) {
                    TreeNode node = root.getTreeNode(id, 16);
                    if (node == null || node.getChildren() != null) continue;
                    int row = model.createNewEntryRow(this.entryKey);
                    model.setValue(FTNAME, (Object)node.getId(), row);
                    model.setValue(FT_DISPLAY_NAME, (Object)node.getText(), row);
                    model.setValue(TEXT_FIELD, (Object)node.getId(), row);
                    model.setValue(TYPE, ((LinkedHashMap)node.getData()).get("SchemeFilterApType"), row);
                }
            }
        } else if (!currChecks.isEmpty()) {
            int entryRowCount = model.getEntryRowCount(this.entryKey);
            ArrayList<Integer> removeIndexList = new ArrayList<Integer>();
            for (int i = entryRowCount - 1; i >= 0; --i) {
                if (currChecks.contains(model.getValue(TEXT_FIELD, i))) continue;
                removeIndexList.add(i);
            }
            int[] rows = new int[removeIndexList.size()];
            int i = 0;
            for (Integer integer : removeIndexList) {
                rows[i++] = integer;
            }
            model.deleteEntryRows(this.entryKey, rows);
        } else if (!checkNodes.isEmpty()) {
            model.deleteEntryData(this.entryKey);
        }
        this.getPageCache().put(CHECK_NODES, SerializationUtils.toJsonString((Object)tree.getTreeState().getCheckedNodeIds()));
    }

    public void entryRowClick(RowClickEvent evt) {
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        Control source = (Control)evt.getSource();
        if (this.entryKey.equals(source.getKey())) {
            this.delete();
        }
    }

    private void delete() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(this.entryKey);
        int[] rows = grid.getEntryState().getSelectedRows();
        if (rows == null || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u79fb\u9664\u7684\u884c\u3002", (String)"BatchSetfilterPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
            return;
        }
        IDataModel model = this.getModel();
        ArrayList<String> nodeIds = new ArrayList<String>();
        for (int row : rows) {
            if (row < 0) continue;
            nodeIds.add((String)model.getValue(TEXT_FIELD, row));
        }
        model.deleteEntryRows(this.entryKey, rows);
        TreeView tree = (TreeView)this.getView().getControl(FIELD_TREE);
        tree.uncheckNodes(nodeIds);
        this.getPageCache().put(CHECK_NODES, SerializationUtils.toJsonString((Object)tree.getTreeState().getCheckedNodeIds()));
    }
}

