/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.AbstractFormDesignerPlugin;
import kd.bos.designer.ISubDesginer;
import kd.bos.designer.dao.DynamicFormTemplate;
import kd.bos.designer.dao.FormMetadataUtil;
import kd.bos.designer.dao.FormTemplateFactory;
import kd.bos.designer.dao.IFormTemplate;
import kd.bos.designer.property.BillListCDWDesignerUtil;
import kd.bos.designer.property.ListDesignerValidator;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.FormDesigner;
import kd.bos.form.control.events.PropertyEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.isv.ISVService;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.EntityMetadataUtil;
import kd.bos.metadata.filter.FastSearchGridViewAp;
import kd.bos.metadata.filter.FilterContainerAp;
import kd.bos.metadata.filter.FilterGridViewAp;
import kd.bos.metadata.filter.SchemeFilterColumnAp;
import kd.bos.metadata.filter.SchemeFilterViewAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.ToolbarAp;
import kd.bos.metadata.form.mcontrol.MobAdvFilterPanelAp;
import kd.bos.metadata.form.mcontrol.MobFilterPanelAp;
import kd.bos.metadata.form.mcontrol.MobFilterSortAp;
import kd.bos.metadata.form.mcontrol.MobSortPanelAp;
import kd.bos.metadata.form.mcontrol.MobileSearchAp;
import kd.bos.metadata.list.BillListAp;
import kd.bos.metadata.list.CardRowPanelAp;
import kd.bos.metadata.list.ListCardViewAp;
import kd.bos.metadata.list.ListFormAp;
import kd.bos.metadata.list.ListGridViewAp;
import kd.bos.metadata.list.MobileListFormAp;
import kd.bos.metadata.list.QingViewAp;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;

public class BillListCDWDesignerPlugin
extends AbstractFormDesignerPlugin
implements ISubDesginer {
    public static final String PARAM_LISTCONTEXT = "listContext";
    private static final String CARDVIEWDESIGNER = "subformdesigner";
    private static final String ENTITY_TREE = "entitytree";
    private static final String FORM_META = "formmeta";
    private static final String COLUMN = "column";
    private static final String STRETCH = "stretch";
    private static final String ZH_CN = "zh_CN";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String PROPERTY_NAME = "propertyName";
    private static final String TYPE = "_Type_";
    private static final String VALUE = "value";
    private static final String CONTEXT = "context";
    private static final List<String> INHERIT_AP = Arrays.asList("FormAp", "MobileListFormAp", "MobileBillFormAp");

    @Override
    protected String getDesignerKey() {
        return CARDVIEWDESIGNER;
    }

    public Map<String, Object> loadData(FormDesigner designer, Object context, String propertyName, Object value, String lang) {
        Map<String, Object> tMap;
        Map formmeta = null;
        boolean isMob = "MobListMeta".equals(propertyName);
        if (value instanceof Map) {
            if (!isMob) {
                Map mapName = (Map)value;
                String billName = (String)((Map)((List)context).get(0)).get("Name");
                ((Map)((List)mapName.get("Items")).get(0)).put("Name", billName);
                formmeta = mapName;
            } else {
                formmeta = (Map)value;
            }
        }
        if (isMob) {
            this.getPageCache().put("isPC", "false");
            tMap = this.createMobFormMetadata(formmeta, (List)context, lang);
            designer.open("MobileListModel", tMap);
        } else {
            tMap = this.createFormMetadata(formmeta, (List)context, lang);
            designer.open("BillListCardViewModel", tMap);
        }
        designer.sendMulLangProperty((Map)tMap.remove("localeItemProps"));
        designer.resetSideBar(new String[]{ENTITY_TREE, "outline"});
        this.getPageCache().put(PARAM_LISTCONTEXT, SerializationUtils.toJsonString((Object)context));
        return tMap;
    }

    protected Map<String, Object> createMobFormMetadata(Map<String, Object> srcFormmeta, List<Map<String, Object>> context, String lang) {
        Map localeItemMap;
        Object formLocaleItems;
        IFormTemplate template = FormTemplateFactory.createTemplate("MobileListModel");
        FormMetadata formMeta = null;
        String name = "";
        String entityId = null;
        if (context != null && !context.isEmpty()) {
            Map<String, Object> curItem = context.get(0);
            name = (String)curItem.get("Name");
            entityId = (String)curItem.get("Id");
        }
        if (srcFormmeta == null) {
            formMeta = this.createBlankMobFormMetadata(name, entityId);
        } else {
            formMeta = (FormMetadata)template.deserializeFromMap(srcFormmeta, null);
            formMeta.createIndex();
        }
        if (formMeta.getItem("mobilesearch") == null) {
            this.createMobileSearchAp(formMeta);
            formMeta.createIndex(true);
        }
        if (formMeta.getItem("mobfiltersort") == null) {
            this.createMobFilterSortAp(formMeta);
            formMeta.createIndex(true);
        } else {
            this.updateMobAdvFilterPanelAp(formMeta.getItem("mobfiltersort"));
        }
        BillListAp billListAp = (BillListAp)formMeta.getItem("_BillList_");
        if (billListAp != null) {
            billListAp.setEntityId(entityId);
        }
        formMeta.getRootAp().setLanguage(lang);
        HashMap<String, Object> tMap = new HashMap<String, Object>(8);
        tMap.put("entityreadonly", true);
        tMap.put(ENTITY_TREE, EntityMetadataUtil.getMoblistFieldTree(context));
        tMap.put("id", formMeta.getId());
        tMap.put("ui", formMeta.builderDesgnerControls());
        tMap.put("billentityid", entityId);
        Map formDesigner = ((FormDesigner)this.getView().getControl("formdesigner")).getContent();
        Map<String, Object> newFormMeta = this.fillBackFormApAndPluginInherit(srcFormmeta, template.serializeToMap(formMeta));
        if (newFormMeta == null) {
            newFormMeta = new HashMap<String, Object>(16);
        }
        if (formDesigner != null && StringUtils.isNotBlank(formDesigner.get("devType"))) {
            newFormMeta.put("DevType", formDesigner.get("devType"));
        }
        if (formDesigner != null && ((Map)formDesigner.get(FORM_META)).get("EnableGlobalExtLimits") instanceof Boolean) {
            newFormMeta.put("EnableGlobalExtLimits", ((Map)formDesigner.get(FORM_META)).get("EnableGlobalExtLimits"));
        }
        String pageIsv = "";
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((Object)entityId, (String)"bos_formmeta", (String)"isv");
        if (object != null) {
            pageIsv = object.getString("isv");
        }
        newFormMeta.put("Isv", pageIsv);
        tMap.put(FORM_META, newFormMeta);
        tMap.put("islayout", true);
        tMap.put("isPC", false);
        tMap.put("isv", ISVService.getISVInfo().getId());
        String localeItemsStr = this.getPageCache().get("localeItems");
        if (StringUtils.isNotBlank((CharSequence)localeItemsStr) && (formLocaleItems = (localeItemMap = (Map)SerializationUtils.fromJsonString((String)localeItemsStr, Map.class)).get("form")) instanceof List) {
            this.restoreLang((AbstractMetadata)formMeta, (List)formLocaleItems, lang);
            Map<String, Map<String, Object>> localeItemProps = this.extractControlAttribute(ControlAp.class, formMeta.getItems(), Arrays.asList("Height", "Width"));
            tMap.put("localeItemProps", localeItemProps);
        }
        return tMap;
    }

    public FormMetadata createBlankMobFormMetadata(String name, String entityId) {
        FormMetadata formMeta = new FormMetadata();
        MobileListFormAp formAp = this.createMobListFormAp();
        formAp.setDirection(COLUMN);
        formAp.setAlignItems(STRETCH);
        formAp.setListFormId("bos_moblist");
        formAp.setF7ListFormId("bos_moblistmodalf7");
        formAp.setShowType("Modal");
        formMeta.getItems().add(formAp);
        formMeta.setId(DBServiceHelper.genStringId());
        formMeta.setKey(CARDVIEWDESIGNER);
        formMeta.setModelType("MobileListModel");
        this.createMobileSearchAp(formMeta);
        this.createMobFilterSortAp(formMeta);
        BillListAp bl = new BillListAp();
        bl.setId("_BillList_");
        bl.setKey("_BillList_");
        bl.setParentId(formMeta.getId());
        bl.setName(new LocaleString(ZH_CN, String.format(ResManager.loadKDString((String)"%s\u79fb\u52a8\u5217\u8868", (String)"BillListCDWDesignerPlugin_17", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), name)));
        bl.setEntityId(entityId);
        formMeta.getItems().add(bl);
        formMeta.setName(bl.getName());
        ListCardViewAp cw = new ListCardViewAp();
        cw.setId("cardview");
        cw.setKey("cardview");
        cw.setParentId(bl.getId());
        cw.setName(new LocaleString(ZH_CN, ResManager.loadKDString((String)"\u5361\u7247\u89c6\u56fe", (String)"BillListCDWDesignerPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        formMeta.getItems().add(cw);
        CardRowPanelAp cwr = new CardRowPanelAp();
        cwr.setId(DBServiceHelper.genStringId());
        cwr.setKey("cardviewrow");
        cwr.setName(new LocaleString(ZH_CN, ResManager.loadKDString((String)"\u5361\u7247", (String)"BillListCDWDesignerPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        cwr.setParentId(cw.getId());
        formMeta.getItems().add(cwr);
        formMeta.createIndex(true);
        return formMeta;
    }

    private void createMobFilterSortAp(FormMetadata formMeta) {
        MobFilterSortAp mobFilterSortAp = new MobFilterSortAp();
        mobFilterSortAp.setId("mobfiltersort");
        mobFilterSortAp.setKey("mobfiltersort");
        mobFilterSortAp.setParentId(formMeta.getId());
        mobFilterSortAp.setName(new LocaleString(ZH_CN, ResManager.loadKDString((String)"\u79fb\u52a8\u7b5b\u9009\u6392\u5e8f\u63a7\u4ef6", (String)"BillListCDWDesignerPlugin_18", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        if (formMeta.getItems().size() > 1 && formMeta.getItems().get(1) instanceof MobileSearchAp) {
            formMeta.getItems().add(2, mobFilterSortAp);
        } else if (!formMeta.getItems().isEmpty() && formMeta.getItems().get(1) instanceof BillListAp) {
            formMeta.getItems().add(1, mobFilterSortAp);
        } else {
            formMeta.getItems().add(mobFilterSortAp);
        }
        MobFilterPanelAp mobFilterPanelAp = new MobFilterPanelAp();
        mobFilterPanelAp.setId("mobfilterpanel");
        mobFilterPanelAp.setKey("mobfilterpanel");
        mobFilterPanelAp.setParentId(mobFilterSortAp.getId());
        mobFilterPanelAp.setName(new LocaleString(ZH_CN, ResManager.loadKDString((String)"\u79fb\u52a8\u8fc7\u6ee4\u9879", (String)"BillListCDWDesignerPlugin_19", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        formMeta.getItems().add(mobFilterPanelAp);
        MobSortPanelAp mobSortPanelAp = new MobSortPanelAp();
        mobSortPanelAp.setId("mobsortpanel");
        mobSortPanelAp.setKey("mobsortpanel");
        mobSortPanelAp.setParentId(mobFilterSortAp.getId());
        mobSortPanelAp.setName(new LocaleString(ZH_CN, ResManager.loadKDString((String)"\u79fb\u52a8\u6392\u5e8f\u9879", (String)"BillListCDWDesignerPlugin_20", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        formMeta.getItems().add(mobSortPanelAp);
        MobAdvFilterPanelAp mobAdvancedFilterPanelAp = new MobAdvFilterPanelAp();
        mobAdvancedFilterPanelAp.setId("mobadvfilterpanel");
        mobAdvancedFilterPanelAp.setKey("mobadvfilterpanel");
        mobAdvancedFilterPanelAp.setParentId(mobFilterSortAp.getId());
        mobAdvancedFilterPanelAp.setName(new LocaleString(ZH_CN, ResManager.loadKDString((String)"\u9ad8\u7ea7\u7b5b\u9009\u9762\u677f", (String)"BillListCDWDesignerPlugin_21", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        formMeta.getItems().add(mobAdvancedFilterPanelAp);
    }

    private void createMobileSearchAp(FormMetadata formMeta) {
        MobileSearchAp fSearchGridViewAp = new MobileSearchAp();
        fSearchGridViewAp.setId("mobilesearch");
        fSearchGridViewAp.setKey("mobilesearch");
        fSearchGridViewAp.setParentId(formMeta.getId());
        fSearchGridViewAp.setName(new LocaleString(ZH_CN, ResManager.loadKDString((String)"\u79fb\u52a8\u641c\u7d22\u63a7\u4ef6", (String)"BillListCDWDesignerPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        formMeta.getItems().add(1, fSearchGridViewAp);
    }

    private void updateMobAdvFilterPanelAp(ControlAp<?> item) {
        MobFilterSortAp mobFilterSortAp = (MobFilterSortAp)item;
        List items = mobFilterSortAp.getItems();
        for (ControlAp ap : items) {
            if (!(ap instanceof MobAdvFilterPanelAp)) continue;
            if (StringUtils.equals((CharSequence)"mobadvfilterpanel", (CharSequence)ap.getId())) {
                return;
            }
            MobAdvFilterPanelAp mobAdvFilterPanelAp = (MobAdvFilterPanelAp)ap;
            mobAdvFilterPanelAp.setId("mobadvfilterpanel");
            List fieldList = mobAdvFilterPanelAp.getItems();
            for (ControlAp controlAp : fieldList) {
                controlAp.setParentId("mobadvfilterpanel");
            }
            return;
        }
    }

    private MobileListFormAp createMobListFormAp() {
        return new MobileListFormAp();
    }

    protected Map<String, Object> createFormMetadata(Map<String, Object> srcFormmeta, List<Map<String, Object>> context, String lang) {
        Map localeItemMap;
        Object formLocaleItems;
        DynamicFormTemplate template = new DynamicFormTemplate("DynamicFormModel");
        FormMetadata formMeta = null;
        String name = "";
        String entityId = null;
        if (context != null && !context.isEmpty()) {
            Map<String, Object> curItem = context.get(0);
            name = (String)curItem.get("Name");
            entityId = (String)curItem.get("Id");
        }
        if (srcFormmeta == null) {
            formMeta = this.createBlankFormMetadata(name, entityId);
        } else {
            formMeta = (FormMetadata)template.deserializeFromMap(srcFormmeta, null);
            formMeta.createIndex();
            FormAp fm = formMeta.getRootAp();
            fm.setDirection(COLUMN);
            fm.setWrap(false);
            fm.setAlignItems(STRETCH);
            FilterContainerAp filterContainerAp = (FilterContainerAp)formMeta.getItem("_FilterContainer_");
            if (filterContainerAp == null) {
                formMeta.getItems().add(1, this.createFilter(formMeta, entityId, name));
                formMeta.createIndex(true);
            } else {
                filterContainerAp.setEntityId(entityId);
            }
            BillListAp billListAp = (BillListAp)formMeta.getItem("_BillList_");
            if (billListAp != null) {
                billListAp.setEntityId(entityId);
            }
            if (formMeta.getItem("_toolbar_") == null) {
                formMeta.getItems().add(2, this.createToolbar(formMeta));
                formMeta.createIndex(true);
            }
        }
        HashMap<String, Object> tMap = new HashMap<String, Object>(8);
        formMeta.getRootAp().setLanguage(lang);
        tMap.put("entityreadonly", true);
        tMap.put(ENTITY_TREE, EntityMetadataUtil.getlistFieldTree(context));
        tMap.put("id", formMeta.getId());
        tMap.put("ui", formMeta.builderDesgnerControls());
        tMap.put("billentityid", entityId);
        Map formDesigner = ((FormDesigner)this.getView().getControl("formdesigner")).getContent();
        Map<String, Object> newFormMeta = this.fillBackFormApAndPluginInherit(srcFormmeta, template.serializeToMap(formMeta));
        if (newFormMeta == null) {
            newFormMeta = new HashMap<String, Object>(16);
        }
        if (formDesigner != null && StringUtils.isNotBlank(formDesigner.get("devType"))) {
            newFormMeta.put("DevType", formDesigner.get("devType"));
        }
        if (formDesigner != null && ((Map)formDesigner.get(FORM_META)).get("EnableGlobalExtLimits") instanceof Boolean) {
            newFormMeta.put("EnableGlobalExtLimits", ((Map)formDesigner.get(FORM_META)).get("EnableGlobalExtLimits"));
        }
        String pageIsv = "";
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((Object)entityId, (String)"bos_formmeta", (String)"isv");
        if (object != null) {
            pageIsv = object.getString("isv");
        }
        newFormMeta.put("Isv", pageIsv);
        tMap.put(FORM_META, newFormMeta);
        tMap.put("islayout", true);
        tMap.put("isPC", true);
        tMap.put("isv", ISVService.getISVInfo().getId());
        String localeItemsStr = this.getPageCache().get("localeItems");
        if (StringUtils.isNotBlank((CharSequence)localeItemsStr) && (formLocaleItems = (localeItemMap = (Map)SerializationUtils.fromJsonString((String)localeItemsStr, Map.class)).get("form")) instanceof List) {
            this.restoreLang((AbstractMetadata)formMeta, (List)formLocaleItems, lang);
            Map<String, Map<String, Object>> localeItemProps = this.extractControlAttribute(ControlAp.class, formMeta.getItems(), Arrays.asList("Height", "Width"));
            tMap.put("localeItemProps", localeItemProps);
        }
        return tMap;
    }

    private Map<String, Object> fillBackFormApAndPluginInherit(Map<String, Object> originMeta, Map<String, Object> needFillMeta) {
        Map<String, Object> r = this.fillBackFormApInherit(originMeta, needFillMeta);
        return this.fillBackPluginInheritProperty(originMeta, r);
    }

    private Map<String, Object> fillBackFormApInherit(Map<String, Object> originMeta, Map<String, Object> needFillMeta) {
        if (null == originMeta || originMeta.isEmpty() || null == needFillMeta || needFillMeta.isEmpty()) {
            return needFillMeta;
        }
        List items = (List)needFillMeta.get("Items");
        if (null == items) {
            return needFillMeta;
        }
        Map<String, Boolean> inheritMap = this.getInheritMap(originMeta);
        for (Map item : items) {
            String id = (String)item.get("Id");
            if (!StringUtils.isNotBlank((CharSequence)id) || !inheritMap.containsKey(id)) continue;
            item.put("Inherit", inheritMap.get(id));
        }
        return needFillMeta;
    }

    private Map<String, Boolean> getInheritMap(Map<String, Object> meta) {
        HashMap<String, Boolean> inheritMap = new HashMap<String, Boolean>();
        if (null == meta || meta.isEmpty()) {
            return inheritMap;
        }
        List items = (List)meta.get("Items");
        if (null == items || items.isEmpty()) {
            return inheritMap;
        }
        items.stream().forEach(item -> {
            String id = (String)item.get("Id");
            Boolean inherit = (Boolean)item.get("Inherit");
            if (StringUtils.isNotBlank((CharSequence)id) && null != inherit && INHERIT_AP.contains(item.get(TYPE))) {
                inheritMap.put(id, inherit);
            }
        });
        return inheritMap;
    }

    private Map<String, Object> fillBackPluginInheritProperty(Map<String, Object> originMeta, Map<String, Object> needFillMeta) {
        if (originMeta == null || originMeta.isEmpty() || needFillMeta == null || needFillMeta.isEmpty()) {
            return needFillMeta;
        }
        if (originMeta == null || originMeta.isEmpty()) {
            return needFillMeta;
        }
        List originItems = (List)originMeta.get("Items");
        List needFillItems = (List)needFillMeta.get("Items");
        if (originItems == null || originItems.isEmpty() || needFillItems == null || needFillItems.isEmpty()) {
            return needFillMeta;
        }
        if (originItems.get(0) == null || needFillItems.get(0) == null) {
            return needFillMeta;
        }
        Map<String, Boolean> inheritMap = new HashMap<String, Boolean>(16);
        Map content = (Map)originItems.get(0);
        List plugins = (List)content.get("Plugins");
        if (plugins != null && !plugins.isEmpty()) {
            inheritMap = this.getPluginInheritMap(plugins);
        }
        this.fillPluginInherit(needFillMeta, inheritMap);
        return needFillMeta;
    }

    private Map<String, Boolean> getPluginInheritMap(List<Map<String, Object>> plugins) {
        HashMap<String, Boolean> inheritMap = new HashMap<String, Boolean>();
        if (plugins == null) {
            return inheritMap;
        }
        for (Map<String, Object> plugin : plugins) {
            String className = (String)plugin.get("ClassName");
            Boolean inherit = (Boolean)plugin.get("Inherit");
            if (!StringUtils.isNotBlank((CharSequence)className) || inherit == null) continue;
            inheritMap.put(className, inherit);
        }
        return inheritMap;
    }

    private void fillPluginInherit(Map<String, Object> meta, Map<String, Boolean> inheritMap) {
        if (meta == null) {
            return;
        }
        List items = (List)meta.get("Items");
        if (items == null) {
            return;
        }
        List plugins = (List)((Map)items.get(0)).get("Plugins");
        if (plugins == null) {
            return;
        }
        for (Map plugin : plugins) {
            String className = (String)plugin.get("ClassName");
            if (!StringUtils.isNotBlank((CharSequence)className) || !inheritMap.containsKey(className)) continue;
            plugin.put("Inherit", inheritMap.get(className));
        }
    }

    public FormMetadata createBlankFormMetadata(String name, String entityId) {
        FormMetadata formMeta = new FormMetadata();
        ListFormAp formAp = this.createListFormAp();
        formAp.setDirection(COLUMN);
        formAp.setAlignItems(STRETCH);
        formMeta.getItems().add(formAp);
        formMeta.setId(DBServiceHelper.genStringId());
        formMeta.setKey(CARDVIEWDESIGNER);
        formMeta.setModelType("BillListCardViewModel");
        formMeta.getItems().add(this.createFilter(formMeta, entityId, name));
        formMeta.getItems().add(this.createToolbar(formMeta));
        BillListAp bl = new BillListAp();
        bl.setId("_BillList_");
        bl.setKey("_BillList_");
        bl.setParentId(formMeta.getId());
        bl.setName(new LocaleString(ZH_CN, String.format(ResManager.loadKDString((String)"%s\u5217\u8868", (String)"BillListCDWDesignerPlugin_22", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), name)));
        bl.setEntityId(entityId);
        bl.setQueryType("1");
        formMeta.getItems().add(bl);
        formMeta.setName(bl.getName());
        ListGridViewAp gw = new ListGridViewAp();
        gw.setId("gridview");
        gw.setKey("gridview");
        gw.setParentId(bl.getId());
        gw.setName(new LocaleString(ZH_CN, ResManager.loadKDString((String)"\u8868\u683c\u89c6\u56fe", (String)"BillListCDWDesignerPlugin_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        formMeta.getItems().add(gw);
        ListCardViewAp cw = new ListCardViewAp();
        cw.setId("cardview");
        cw.setKey("cardview");
        cw.setParentId(bl.getId());
        cw.setName(new LocaleString(ZH_CN, ResManager.loadKDString((String)"\u5361\u7247\u89c6\u56fe", (String)"BillListCDWDesignerPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        cw.setLayoutStyle(2);
        cw.setAlignContent("flex-start");
        formMeta.getItems().add(cw);
        QingViewAp qw = new QingViewAp();
        qw.setId("qingview");
        qw.setKey("qingview");
        qw.setParentId(bl.getId());
        qw.setName(new LocaleString(ZH_CN, ResManager.loadKDString((String)"\u8f7b\u5206\u6790\u89c6\u56fe", (String)"BillListCDWDesignerPlugin_23", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        formMeta.getItems().add(qw);
        CardRowPanelAp cwr = new CardRowPanelAp();
        cwr.setId(DBServiceHelper.genStringId());
        cwr.setKey("cardviewrow");
        cwr.setName(new LocaleString(ZH_CN, ResManager.loadKDString((String)"\u5361\u7247", (String)"BillListCDWDesignerPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        cwr.setParentId(cw.getId());
        formMeta.getItems().add(cwr);
        formMeta.createIndex(true);
        return formMeta;
    }

    protected ListFormAp createListFormAp() {
        return new ListFormAp();
    }

    protected boolean isNewFilter() {
        return true;
    }

    private FilterContainerAp createFilter(FormMetadata formMeta, String entityId, String name) {
        FilterContainerAp fContainerAp = new FilterContainerAp();
        fContainerAp.setId("_FilterContainer_");
        fContainerAp.setKey("_FilterContainer_");
        fContainerAp.setParentId(formMeta.getId());
        fContainerAp.setName(new LocaleString(ZH_CN, (Object)new LocaleString(ZH_CN, String.format(ResManager.loadKDString((String)"%s\u5217\u8868", (String)"BillListCDWDesignerPlugin_22", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), name))));
        fContainerAp.setGrow(0);
        FastSearchGridViewAp fSearchGridViewAp = new FastSearchGridViewAp();
        fSearchGridViewAp.setId("fastsearchgridview");
        fSearchGridViewAp.setKey("fastsearchgridview");
        fSearchGridViewAp.setParentId(fContainerAp.getId());
        fSearchGridViewAp.setName(new LocaleString(ZH_CN, ResManager.loadKDString((String)"\u5feb\u6377\u641c\u7d22\u89c6\u56fe", (String)"BillListCDWDesignerPlugin_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        formMeta.getItems().add(fSearchGridViewAp);
        FilterGridViewAp fw = new FilterGridViewAp();
        fw.setId("filtergridview");
        fw.setKey("filtergridview");
        fw.setParentId(fContainerAp.getId());
        fw.setName(new LocaleString(ZH_CN, ResManager.loadKDString((String)"\u5e38\u7528\u8fc7\u6ee4\u89c6\u56fe", (String)"BillListCDWDesignerPlugin_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        fw.setNewFilter(this.isNewFilter());
        formMeta.getItems().add(fw);
        SchemeFilterViewAp schemeFilterViewAp = new SchemeFilterViewAp();
        schemeFilterViewAp.setId("schemefilterview");
        schemeFilterViewAp.setKey("schemefilterview");
        schemeFilterViewAp.setParentId(fContainerAp.getId());
        schemeFilterViewAp.setName(new LocaleString(ZH_CN, ResManager.loadKDString((String)"\u65b9\u6848\u8fc7\u6ee4\u89c6\u56fe", (String)"BillListCDWDesignerPlugin_8", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        formMeta.getItems().add(schemeFilterViewAp);
        return fContainerAp;
    }

    protected void createToolbarItems(FormMetadata formMeta, String parentId) {
    }

    private ToolbarAp createToolbar(FormMetadata formMeta) {
        ToolbarAp tb = new ToolbarAp();
        tb.setId("_toolbar_");
        tb.setKey("_toolbar_");
        tb.setParentId(formMeta.getId());
        tb.setName(new LocaleString(ZH_CN, ResManager.loadKDString((String)"\u5217\u8868\u5de5\u5177\u680f", (String)"BillListCDWDesignerPlugin_9", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        this.createToolbarItems(formMeta, tb.getId());
        return tb;
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        if ("btnok".equalsIgnoreCase(c.getKey())) {
            this.returnData();
        }
    }

    private void returnData() {
        FormDesigner designer = (FormDesigner)this.getView().getControl(this.getDesignerKey());
        Object v = this.getReturnData(designer, (Map<String, Object>)this.getView().getFormShowParameter().getCustomParams());
        if (v instanceof String) {
            this.getView().showTipNotification((String)v);
        } else {
            this.getView().returnDataToParent(v);
            this.getView().close();
        }
    }

    @Override
    public Object getReturnData(FormDesigner designer, Map<String, Object> parms) {
        if (designer.getContent() == null) {
            return false;
        }
        Map map = (Map)designer.getContent().get(FORM_META);
        String metastr = SerializationUtils.toJsonString((Object)map);
        String propName = (String)parms.get(PROPERTY_NAME);
        if (metastr == null) {
            return "";
        }
        ListDesignerValidator listDesignerValidator = new ListDesignerValidator();
        String validate = listDesignerValidator.validate(designer.getContent(), propName, this.getContext());
        if (StringUtils.isNotBlank((CharSequence)validate)) {
            this.getView().showErrorNotification(validate);
            return "";
        }
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("itemId", parms.get("itemId"));
        para.put("metaType", parms.get("metaType"));
        para.put(PROPERTY_NAME, parms.get(PROPERTY_NAME));
        para.put(VALUE, SerializationUtils.fromJsonString((String)metastr, Map.class));
        return para;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        List list;
        Object object = e.getReturnData();
        if (object == null) {
            return;
        }
        Map map = null;
        if (object instanceof Map) {
            map = (Map)object;
        } else if (object instanceof List && !(list = (List)object).isEmpty()) {
            map = (Map)list.get(0);
        }
        if (map == null) {
            return;
        }
        if ("BatchSetFilter".equals(map.get(PROPERTY_NAME).toString())) {
            List value = (List)map.get(VALUE);
            FormDesigner designer = (FormDesigner)this.getView().getControl(this.getDesignerKey());
            HashMap<String, String> container = new HashMap<String, String>();
            container.put("Id", "schemefilterview");
            designer.removeUIElements(container.get("Id").toString());
            for (Map tmp : value) {
                ControlAp<?> ctl;
                String name = tmp.get("Name").toString();
                if (tmp.get("Value") == null || StringUtils.isEmpty((CharSequence)tmp.get("Value").toString())) continue;
                HashMap<String, Object> newItem = null;
                newItem = new HashMap<String, Object>(1);
                Object type = tmp.get("Type");
                newItem.put(TYPE, StringUtils.isBlank(type) ? "SchemeFilterColumnAp" : type);
                try {
                    ctl = FormMetadataUtil.getControlAp("BillListCardViewModel", newItem);
                }
                catch (RuntimeException exception) {
                    newItem.put(TYPE, "SchemeFilterColumnAp");
                    ctl = FormMetadataUtil.getControlAp("BillListCardViewModel", newItem);
                }
                SchemeFilterColumnAp schemeFilterColumnAp = (SchemeFilterColumnAp)ctl;
                schemeFilterColumnAp.setFieldName(tmp.get("Id").toString());
                ctl.setId(DBServiceHelper.genStringId());
                ctl.setParentId("schemefilterview");
                ctl.setName(new LocaleString(name));
                designer.createUIElement(FormMetadataUtil.controlApToMap("BillListCardViewModel", ctl), container);
            }
        } else if ("OperationKey".equals(map.get(PROPERTY_NAME).toString())) {
            List<Map<String, Object>> listContext = this.getContext();
            Map<String, Object> map2 = listContext.get(0);
            map2.put("Operations", ((Map)map.get("operations")).get(VALUE));
            this.getPageCache().put(PARAM_LISTCONTEXT, SerializationUtils.toJsonString(listContext));
        }
        super.closedCallBack(e);
    }

    @Override
    protected void beforeShowPropertyEdit(PropertyEvent e, FormShowParameter showParameter) {
        Map item;
        Object itemParam;
        if ("ide_listpictureid".equals(showParameter.getFormId())) {
            BillListCDWDesignerUtil.listPictured(this, showParameter);
        } else if ("ide_batchsetfilter".equals(showParameter.getFormId()) || "bos_comparetypeconfig".equals(showParameter.getFormId())) {
            BillListCDWDesignerUtil.batchSetFilterOrCompareTypeConfig(this, showParameter);
        } else if ("ide_clientrules".endsWith(showParameter.getFormId()) || "ide_listclientrules".endsWith(showParameter.getFormId())) {
            BillListCDWDesignerUtil.clientRulesOrListClientRules(this, showParameter);
        } else if ("ide_listcolumnconfig".equalsIgnoreCase(showParameter.getFormId()) || "ide_listfieldid".equalsIgnoreCase(showParameter.getFormId())) {
            BillListCDWDesignerUtil.listColumnConfigOrListFieldId(this, e, showParameter);
        } else if ("ide_filterseditnew".equalsIgnoreCase(showParameter.getFormId())) {
            BillListCDWDesignerUtil.filtersEditNew(this, showParameter);
        } else if ("ide_moblistfieldid".equalsIgnoreCase(showParameter.getFormId())) {
            showParameter.setCustomParam("designerContext", this.getContext());
        } else {
            showParameter.setCustomParam(CONTEXT, this.getContext());
        }
        if (this.getPageCache().get("isPC") != null) {
            showParameter.setCustomParam("isPC", (Object)Boolean.parseBoolean(this.getPageCache().get("isPC")));
        }
        if ((itemParam = e.getParam().get("item")) != null && (item = (Map)e.getParam().get("item")) != null && item.get(TYPE) != null) {
            showParameter.setCustomParam(TYPE, item.get(TYPE));
        }
        super.beforeShowPropertyEdit(e, showParameter);
    }

    public List<Map<String, Object>> getContext() {
        return SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(PARAM_LISTCONTEXT), Map.class);
    }
}

