/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import com.alibaba.fastjson.JSONArray;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.designer.property.AbstractEntityTreePlugin;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.product.ProductSettingService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.util.CollectionUtils;

public class BosEntityTreePlugin
extends AbstractEntityTreePlugin {
    private static final String SELECTACTION = "selectaction";
    private static final String FIELD_EDIT = "FieldEdit";
    private static final String DO_OPEN_PARENT = "doOpenParent";
    private static final String BIZAPPID = "bizappid";
    private static final String BOS_DEVPORTAL_BIZCLOUD = "bos_devportal_bizcloud";
    private static final String MODELTYPE = "modeltype";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private Map<String, List<DynamicObject>> cloudAppInfos = new HashMap<String, List<DynamicObject>>(10);

    @Override
    public void itemClick(ItemClickEvent evt) {
        String type = (String)this.getView().getFormShowParameter().getCustomParam(SELECTACTION);
        if (type != null) {
            if ("btnok".equalsIgnoreCase(evt.getItemKey()) && type.equals(FIELD_EDIT)) {
                this.returnData();
            } else if ("btnok".equalsIgnoreCase(evt.getItemKey()) && type.equals(DO_OPEN_PARENT)) {
                this.getView().returnDataToParent(this.getCurrentSelector());
                this.getView().close();
            }
        } else {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            this.getView().returnDataToParent((Object)billList.getSelectedRows());
            this.getView().close();
        }
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs evt) {
        String type = (String)this.getView().getFormShowParameter().getCustomParam(SELECTACTION);
        if (type != null) {
            if (type.equals(FIELD_EDIT)) {
                this.returnData();
            } else if (type.equals(DO_OPEN_PARENT)) {
                this.getView().returnDataToParent(this.getCurrentSelector());
                this.getView().close();
            }
        } else {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            this.getView().returnDataToParent((Object)billList.getSelectedRows());
            this.getView().close();
        }
        evt.setCancel(true);
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        QFilter typeFilter = this.filter();
        Boolean ismodel = (Boolean)this.getView().getFormShowParameter().getCustomParam("ismodel");
        Map businessControlConfig = (Map)this.getView().getFormShowParameter().getCustomParam("businesscontrol");
        List<QFilter> list = ismodel != null ? this.addModelFilter(ismodel, businessControlConfig) : this.addModelFilter(false, businessControlConfig);
        for (QFilter qFilter : list) {
            typeFilter.and(qFilter);
        }
        ArrayList<QFilter> templist = new ArrayList<QFilter>();
        templist.add(typeFilter);
        List filters = e.getQFilters();
        filters.addAll(templist);
        e.setCustomQFilters(filters);
    }

    @Override
    public void listRowDoubleClick(ListRowClickEvent evt) {
        String type = (String)this.getView().getFormShowParameter().getCustomParam(SELECTACTION);
        if (type != null) {
            if (type.equals(FIELD_EDIT)) {
                this.returnData();
            } else if (type.equals(DO_OPEN_PARENT)) {
                this.getView().returnDataToParent(this.getCurrentSelector());
                this.getView().close();
            }
        } else {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            this.getView().returnDataToParent((Object)billList.getSelectedRows());
            this.getView().close();
        }
        evt.setCancel(true);
    }

    @Override
    protected QFilter filter() {
        return new QFilter(MODELTYPE, "in", (Object)this.getModelFilterContent());
    }

    @Override
    public void buildTreeListFilter(BuildTreeListFilterEvent nodeEvent) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        if (!DO_OPEN_PARENT.equals(showParameter.getCustomParam(SELECTACTION))) {
            super.buildTreeListFilter(nodeEvent);
            return;
        }
        String nodeId = nodeEvent.getNodeId().toString();
        String thisAppId = (String)this.getView().getFormShowParameter().getCustomParam(BIZAPPID);
        String pagetype = (String)this.getView().getFormShowParameter().getCustomParam("pagetype");
        if (pagetype != null && "extend".equals(pagetype)) {
            String refappId = (String)this.getView().getFormShowParameter().getCustomParam("refappid");
            QFilter filters = new QFilter(BIZAPPID, "in", (Object)refappId);
            filters.and(this.filter());
            nodeEvent.addQFilter(filters);
            nodeEvent.setCancel(true);
            return;
        }
        if (nodeId.equals("-1") && StringUtils.isNotEmpty((CharSequence)thisAppId)) {
            ORM orm = ORM.create();
            JSONArray clouds = new JSONArray();
            clouds.add((Object)"SYS");
            clouds.add((Object)"DEV");
            QFilter filter = new QFilter("number", "in", (Object)clouds);
            try (DataSet dataset = orm.queryDataSet(BOS_DEVPORTAL_BIZCLOUD, BOS_DEVPORTAL_BIZCLOUD, "id,number", new QFilter[]{filter});){
                JSONArray apps = new JSONArray();
                if (StringUtils.isNotEmpty((CharSequence)thisAppId)) {
                    DynamicObject doj = BizCloudServiceHelp.getBizCloudByAppID((String)thisAppId);
                    Iterator thisCloudId = doj.getString("id");
                    apps.addAll((Collection)this.getUnitIdsByCloudId((String)((Object)thisCloudId)));
                }
                ArrayList<String> tempList = new ArrayList<String>();
                for (Row row : dataset) {
                    tempList.add(row.getString(0));
                }
                for (String cloudId : tempList) {
                    apps.addAll((Collection)this.getUnitIdsByCloudId(cloudId));
                }
                QFilter filters = new QFilter(BIZAPPID, "in", (Object)apps);
                filters.and(this.filter());
                nodeEvent.addQFilter(filters);
                nodeEvent.setCancel(true);
            }
        } else {
            super.buildTreeListFilter(nodeEvent);
        }
    }

    private List<DynamicObject> getAllBizAppsByCloudId(String cloudId) {
        if (this.cloudAppInfos.isEmpty()) {
            QFilter[] filters = RunModeServiceHelper.getAppIdBlacklistFilters(null, (String)"id");
            filters = this.appendAppIdQFilter(filters, "id");
            Map mapObject = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (String)"id,number,name,description,sequence,image,masterid,type,parentid,inheritpath,bizcloud,deploystatus,visible", (QFilter[])filters);
            Collection allBizapps = mapObject.values();
            for (DynamicObject app : allBizapps) {
                String bizcloudId = app.getString("bizcloud.id");
                if (this.cloudAppInfos.get(bizcloudId) == null) {
                    this.cloudAppInfos.put(bizcloudId, new ArrayList(10));
                }
                this.cloudAppInfos.get(bizcloudId).add(app);
            }
        }
        return this.cloudAppInfos.getOrDefault(cloudId, new ArrayList(3));
    }

    private QFilter[] appendAppIdQFilter(QFilter[] appIdFilter, String fieldName) {
        ProductSettingService productService = (ProductSettingService)ServiceFactory.getService(ProductSettingService.class);
        List appids = productService.getAppIdBlackList();
        if (!appids.isEmpty()) {
            ArrayList<QFilter> list = new ArrayList<QFilter>();
            if (appIdFilter != null) {
                list.addAll(Arrays.asList(appIdFilter));
            }
            list.add(new QFilter(fieldName, "not in", (Object)appids.toArray()));
            return list.toArray(new QFilter[list.size()]);
        }
        return appIdFilter;
    }

    @Override
    protected List<TreeNode> getAppNodesByCloudId(List<String> cloudIds) {
        ArrayList<TreeNode> appNodes = new ArrayList<TreeNode>();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String pageType = (String)formShowParameter.getCustomParam("pagetype");
        if (pageType != null && "extend".equals(pageType)) {
            String refAppId = (String)formShowParameter.getCustomParam("refappid");
            AppMetadata refAppMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)refAppId, (boolean)true);
            String refAppName = refAppMeta.getName().toString();
            for (String cloudId : cloudIds) {
                TreeNode node = new TreeNode(cloudId, refAppId, refAppName);
                appNodes.add(node);
            }
        } else {
            ArrayList<String> appIds = new ArrayList<String>(10);
            DynamicObjectCollection allBizApps = BizAppServiceHelp.getAllBizApps();
            for (DynamicObject app : allBizApps) {
                appIds.add(app.getString("id"));
            }
            Map<String, Map<String, Object>> dictionaries = this.getDictionaries(appIds);
            for (String cloudId : cloudIds) {
                List<DynamicObject> dynamicObjects = this.getAllBizAppsByCloudId(cloudId);
                for (DynamicObject dynamicObject : dynamicObjects) {
                    String name = ((OrmLocaleValue)dynamicObject.get("name")).toString();
                    String type = dynamicObject.getString("type");
                    if (!"0".equals(type)) continue;
                    TreeNode node = new TreeNode();
                    String nodeId = dynamicObject.getString("id");
                    for (Map.Entry<String, Map<String, Object>> map : dictionaries.entrySet()) {
                        if (!nodeId.equals(map.getKey())) continue;
                        name = (String)map.getValue().get("name");
                    }
                    node.setId(nodeId);
                    node.setText(name);
                    node.setParentid(cloudId);
                    appNodes.add(node);
                }
            }
        }
        return appNodes;
    }

    private Map<String, Map<String, Object>> getDictionaries(List<String> appIds) {
        String sql = "select b.fid, d.fname, d.fdescription from t_meta_bizapp b left join t_meta_appruntime_l d on b.fnumber = d.fappid where b.fid in (%s) and d.flocaleid = '%s'";
        sql = String.format(sql, BosEntityTreePlugin.changeSetToSqlStr(appIds), Lang.get().toString());
        return (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)new ResultSetHandler<Map<String, Map<String, Object>>>(){

            public Map<String, Map<String, Object>> handle(ResultSet resultSet) throws Exception {
                HashMap<String, Map<String, Object>> rs = new HashMap<String, Map<String, Object>>(16);
                while (resultSet.next()) {
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    String id = resultSet.getString(1);
                    map.put("name", resultSet.getString(2));
                    map.put("description", resultSet.getString(3));
                    rs.put(id, map);
                }
                return rs;
            }
        });
    }

    private static String changeSetToSqlStr(List<String> set) {
        if (set == null || set.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String item : set) {
            if (item == null) continue;
            String val = null;
            if (item instanceof String) {
                val = item.toString();
            } else if (item instanceof Map.Entry) {
                Object tVal = ((Map.Entry)((Object)item)).getValue();
                String string = val = tVal == null ? null : tVal.toString();
            }
            if (!StringUtils.isNotEmpty((CharSequence)val)) continue;
            sb.append('\'').append(val).append("',");
        }
        String str = sb.toString();
        if (str.length() > 0) {
            return str.substring(0, str.length() - 1);
        }
        return null;
    }

    @Override
    protected QFilter getModelFilter(String nodeId) {
        QFilter qFilter = null;
        ORM orm = ORM.create();
        boolean isCloud = orm.exists(BOS_DEVPORTAL_BIZCLOUD, (Object)nodeId);
        if (nodeId.equals("-1")) {
            qFilter = new QFilter("dentityid", "is not null", (Object)"");
        } else if (isCloud) {
            JSONArray units = this.getUnitIdsByCloudId(nodeId);
            qFilter = new QFilter(BIZAPPID, "in", (Object)units);
        } else {
            JSONArray units = this.geUnitIdsByAppId(nodeId);
            qFilter = new QFilter(BIZAPPID, "in", (Object)units);
        }
        return qFilter;
    }

    private JSONArray geUnitIdsByAppId(String appId) {
        DynamicObject app = BusinessDataServiceHelper.loadSingleFromCache((Object)appId, (String)"bos_devportal_bizapp", (String)"id, bizcloud");
        DynamicObject bizcloud = app.getDynamicObject("bizcloud");
        String cloudId = bizcloud.getString("id");
        DynamicObjectCollection appList = BizAppServiceHelp.getAllBizAppsByCloudID((String)cloudId);
        JSONArray appIds = new JSONArray();
        for (DynamicObject obj : appList) {
            String bizAppId = obj.getString("id");
            String tMasterId = obj.getString("masterid");
            if (!StringUtils.equals((CharSequence)appId, (CharSequence)tMasterId)) continue;
            appIds.add((Object)bizAppId);
        }
        appIds.add((Object)appId);
        return appIds;
    }

    @Override
    public void initializeTree(EventObject e) {
        TreeNode node;
        super.initializeTree(e);
        String treeNodeId = (String)this.getView().getFormShowParameter().getCustomParam("treeRootNodeId");
        if (StringUtils.isNotBlank((CharSequence)treeNodeId) && (node = this.getTreeModel().getRoot().getTreeNode(treeNodeId, 10)) != null) {
            node.setParentid("");
            node.setIsOpened(true);
            this.getTreeListView().getTreeModel().setRoot(node);
            this.getTreeModel().setCurrentNodeId((Object)node.getId());
        }
    }

    public void afterCreateNewData(EventObject e) {
        TreeNode node;
        String currentNodeId = (String)this.getView().getFormShowParameter().getCustomParam("currentNodeId");
        if (StringUtils.isNotBlank((CharSequence)currentNodeId) && (node = this.getTreeModel().getRoot().getTreeNode(currentNodeId, 10)) != null) {
            this.getTreeModel().setCurrentNodeId((Object)currentNodeId);
            this.getTreeListView().getTreeView().focusNode(node);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        if (this.isBillFormModel(args.getFormShowParameter())) {
            FormShowParameter form = (FormShowParameter)args.getSource();
            form.setCaption(ResManager.loadKDString((String)"\u5355\u636e\u5217\u8868", (String)"BosEntityTreePlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        if (this.isBillFormModel(this.getView().getFormShowParameter())) {
            List columns = args.getListColumns();
            if (CollectionUtils.isEmpty((Collection)columns)) {
                return;
            }
            Iterator it = columns.iterator();
            while (it.hasNext()) {
                IListColumn listColumn = (IListColumn)it.next();
                if (!StringUtils.equals((CharSequence)MODELTYPE, (CharSequence)listColumn.getListFieldKey()) || !(listColumn instanceof ListColumn)) continue;
                it.remove();
                return;
            }
        }
    }

    private boolean isBillFormModel(FormShowParameter showParameter) {
        String modeltype;
        return showParameter != null && showParameter.getCustomParam(MODELTYPE) != null && StringUtils.isNotEmpty((CharSequence)(modeltype = (String)showParameter.getCustomParam(MODELTYPE))) && StringUtils.equals((CharSequence)"BillFormModel", (CharSequence)modeltype);
    }
}

