/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.property.alias.BusinessControlConvert;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Button;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.BusinessControl;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.extensible.ExtLockTypeEnum;
import kd.bos.metadata.extensible.ExtensibleDao;

public class BusinessControlEditPlugin
extends AbstractFormPlugin {
    private static final String BILL_TYPE = "billtype";
    private static final String VOUCHER = "voucher";
    private static final String ENABLE_IMPORT = "EnableImport";
    private static final String IS_QING_ANALYSIS = "IsQingAnalysis";
    private static final Log LOG = LogFactory.getLog(BusinessControlEditPlugin.class);

    public void initialize() {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        Map businessControls = null;
        Object value = this.getView().getFormShowParameter().getCustomParams().get("value");
        if (StringUtils.isNotBlank(value)) {
            Map map = businessControls = value instanceof Map ? (Map)value : (Map)SerializationUtils.fromJsonString((String)((String)value), Map.class);
        }
        if (businessControls != null && !businessControls.isEmpty()) {
            this.getModel().setValue("codenumber", (Object)Boolean.TRUE.equals(businessControls.get("CodeNumber")));
            this.getModel().setValue(BILL_TYPE, (Object)Boolean.TRUE.equals(businessControls.get("BillType")));
            this.getModel().setValue("workflow", (Object)Boolean.TRUE.equals(businessControls.get("WorkFlow")));
            this.getModel().setValue("botp", (Object)Boolean.TRUE.equals(businessControls.get("BOTP")));
            this.getModel().setValue(VOUCHER, (Object)Boolean.TRUE.equals(businessControls.get("Voucher")));
            this.getModel().setValue("nosearchenabled", (Object)Boolean.TRUE.equals(businessControls.get("NoSearchEnabled")));
            this.getModel().setValue("enableimport", (Object)(businessControls.get(ENABLE_IMPORT) == null ? true : Boolean.TRUE.equals(businessControls.get(ENABLE_IMPORT))));
            this.getModel().setValue("isqinganalysis", (Object)(businessControls.get(IS_QING_ANALYSIS) == null ? true : Boolean.TRUE.equals(businessControls.get(IS_QING_ANALYSIS))));
            this.getModel().setValue("isprint", (Object)Boolean.TRUE.equals(businessControls.get("IsPrint")));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.lockNotEditableBizControl();
    }

    private void lockNotEditableBizControl() {
        try {
            String entityId = (String)this.getView().getFormShowParameter().getCustomParam("itemId");
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
            ExtLockTypeEnum lockType = ExtensibleDao.getExtLockType((AbstractMetadata)entityMetadata, (String)"Field", (String)entityMetadata.getModelType(), (String)entityId, (String)"BusinessControl");
            Set businessControl = ExtensibleDao.getBasePropIds((IPageCache)this.getPageCache(), (MetaCategory)MetaCategory.Entity, (String)entityId, (String)entityMetadata.getParentId(), (String)"BusinessControl", (boolean)false, o -> {
                HashSet<String> strings = new HashSet<String>(8);
                strings.add(String.format("%1$s_%2$s", BILL_TYPE, String.valueOf(((BusinessControl)o).isBillType())));
                strings.add(String.format("%1$s_%2$s", "botp", String.valueOf(((BusinessControl)o).isBotp())));
                strings.add(String.format("%1$s_%2$s", "nosearchenabled", String.valueOf(((BusinessControl)o).isNoSearchEnabled())));
                strings.add(String.format("%1$s_%2$s", "isqinganalysis", String.valueOf(((BusinessControl)o).isQingAnalysis())));
                strings.add(String.format("%1$s_%2$s", "codenumber", String.valueOf(((BusinessControl)o).isCodeNumber())));
                strings.add(String.format("%1$s_%2$s", VOUCHER, String.valueOf(((BusinessControl)o).isVoucher())));
                strings.add(String.format("%1$s_%2$s", "enableimport", String.valueOf(((BusinessControl)o).isEnableImport())));
                strings.add(String.format("%1$s_%2$s", "isprint", String.valueOf(((BusinessControl)o).isIsprint())));
                return strings;
            });
            if (ExtLockTypeEnum.speciallock.equals((Object)lockType)) {
                for (String bc : businessControl) {
                    if (!bc.contains("true")) continue;
                    this.getView().setEnable(Boolean.FALSE, new String[]{bc.split("_")[0]});
                }
            }
        }
        catch (Exception e) {
            LOG.info("\u83b7\u53d6\u4e1a\u52a1\u5bf9\u8c61\u53ef\u6269\u5c55\u6027\u62a5\u9519\uff1a" + e);
        }
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        if ("btnok".equalsIgnoreCase(btn.getKey())) {
            HashMap para = new HashMap();
            para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
            para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
            para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
            para.put("value", this.getBusinessControls());
            String alias = (String)new BusinessControlConvert().convert(this.getBusinessControls());
            para.put("alias", alias);
            this.getView().returnDataToParent(para);
            this.getView().close();
        }
    }

    private Map<String, Object> getBusinessControls() {
        HashMap<String, Object> businessControls = new HashMap<String, Object>();
        IDataModel model = this.getModel();
        businessControls.put("_Type_", "BusinessControl");
        businessControls.put("CodeNumber", model.getValue("codenumber"));
        businessControls.put("BillType", model.getValue(BILL_TYPE));
        businessControls.put("WorkFlow", model.getValue("workflow"));
        businessControls.put("BOTP", model.getValue("botp"));
        businessControls.put("Voucher", model.getValue(VOUCHER));
        businessControls.put("NoSearchEnabled", model.getValue("nosearchenabled"));
        businessControls.put(IS_QING_ANALYSIS, model.getValue("isqinganalysis"));
        businessControls.put(ENABLE_IMPORT, model.getValue("enableimport"));
        businessControls.put("IsPrint", model.getValue("isprint"));
        return businessControls;
    }
}

