/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.entity.commonfield.CardOperationBarItem;

public class CardOperationBarPlugin
extends AbstractFormPlugin {
    private static final String Id_EntryEntity = "entryentity";
    private static final String Id_fID = "fid";
    private static final String Id_fKey = "fkey";
    private static final String Id_fName = "fname";
    private static final String Id_fOpKey = "foperationkey";
    private static final String Id_fVisible = "fvisible";
    private static final String Id_fLock = "flock";
    private static final String Id_Btnok = "btnok";
    private static final String Id_fVector = "fvector";
    private static final String FormId_Ope = "ide_operationselect";
    private static final String FormId_Vec = "ide_vectorlist";
    private static final String ActionId_SelectOpe = "operationselect";
    private static final String ActionId_Vector = "vectorlist";
    private static final String CONTEXT = "context";
    private static final String VALUE = "value";
    private static final String OpName = "opName";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String BarItem_New = "baritem_new";
    private static final String BarItem_Del = "baritem_del";
    private static final String ToolBarAp = "toolbarap";
    private static final String ForeColor_Enable = "#5582F3";
    private static final String ForeColor_Disable = "#B5CAFF";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{Id_Btnok, Id_fOpKey, Id_fVector});
        this.addItemClickListeners(new String[]{ToolBarAp});
    }

    public void afterCreateNewData(EventObject e) {
        this.loadOperationBarItems();
    }

    private void loadOperationBarItems() {
        int rowCount;
        Object value = this.getView().getFormShowParameter().getCustomParams().get(VALUE);
        List items = (List)value;
        if (items != null && !items.isEmpty()) {
            IDataModel model = this.getModel();
            int[] rowIndex = model.batchCreateNewEntryRow(Id_EntryEntity, items.size());
            int i = 0;
            model.beginInit();
            for (Map item : items) {
                model.setValue(Id_fID, item.get("Id"), rowIndex[i]);
                model.setValue(Id_fKey, item.get("Key"), rowIndex[i]);
                model.setValue(Id_fName, item.get("Name"), rowIndex[i]);
                model.setValue(Id_fOpKey, item.get("OpKey"), rowIndex[i]);
                model.setValue(Id_fVisible, item.get("Visible"), rowIndex[i]);
                model.setValue(Id_fLock, item.get("Lock"), rowIndex[i]);
                model.setValue(Id_fVector, item.get("Vector"), rowIndex[i]);
                ++i;
            }
            model.endInit();
            this.getView().updateView(Id_EntryEntity);
        }
        if ((rowCount = this.getModel().getEntryRowCount(Id_EntryEntity)) >= 3) {
            this.enableBarItem(Boolean.FALSE, BarItem_New);
        } else {
            this.enableBarItem(Boolean.TRUE, BarItem_New);
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.returnData();
                break;
            }
            case "foperationkey": {
                this.showOperationSelector();
                break;
            }
            case "fvector": {
                this.showVectorList();
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        int rowCount = this.getModel().getEntryRowCount(Id_EntryEntity);
        if (BarItem_New.equalsIgnoreCase(key)) {
            if (rowCount >= 3) {
                this.enableBarItem(Boolean.FALSE, BarItem_New);
            }
        } else if (BarItem_Del.equalsIgnoreCase(key) && rowCount <= 3) {
            this.enableBarItem(Boolean.TRUE, BarItem_New);
        }
    }

    private void enableBarItem(boolean isEnable, String itemKey) {
        this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{itemKey});
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("fc", isEnable ? ForeColor_Enable : ForeColor_Disable);
        this.getView().updateControlMetadata(itemKey, map);
    }

    private void showOperationSelector() {
        FormShowParameter parameter = new FormShowParameter();
        List context = (List)this.getView().getFormShowParameter().getCustomParam(CONTEXT);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId(FormId_Ope);
        parameter.setCustomParam(CONTEXT, (Object)context);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ActionId_SelectOpe));
        this.getView().showForm(parameter);
    }

    private void showVectorList() {
        FormShowParameter para = new FormShowParameter();
        para.setFormId(FormId_Vec);
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ActionId_Vector));
        this.getView().showForm(para);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (evt.getReturnData() == null) {
            return;
        }
        String actionId = evt.getActionId();
        IDataModel model = this.getModel();
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(Id_EntryEntity);
        int rowIndex = grid.getEntryState().getFocusRow();
        switch (actionId) {
            case "operationselect": {
                Object data = evt.getReturnData();
                if (data instanceof Map) {
                    model.setValue(Id_fOpKey, ((Map)data).get(VALUE), rowIndex);
                    model.setValue(Id_fKey, ((Map)data).get(VALUE), rowIndex);
                    model.setValue(Id_fName, ((Map)data).get(OpName), rowIndex);
                    break;
                }
                model.setValue(Id_fOpKey, ((Map)((List)data).get(0)).get(VALUE), rowIndex);
                model.setValue(Id_fKey, ((Map)((List)data).get(0)).get(VALUE), rowIndex);
                model.setValue(Id_fName, ((Map)((List)data).get(0)).get(OpName), rowIndex);
                break;
            }
            case "vectorlist": {
                Map data = (Map)evt.getReturnData();
                String picValue = (String)data.get(VALUE);
                if (!StringUtils.isNotBlank((CharSequence)picValue)) break;
                model.setValue(Id_fVector, (Object)picValue);
                break;
            }
        }
    }

    private void returnData() {
        HashSet<String> allKeys = new HashSet<String>(16);
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>(10);
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount(Id_EntryEntity);
        for (int i = 0; i < rowCount; ++i) {
            String id = (String)model.getValue(Id_fID, i);
            String key = (String)model.getValue(Id_fKey, i);
            String name = (String)model.getValue(Id_fName, i);
            String opKey = (String)model.getValue(Id_fOpKey, i);
            String visible = (String)model.getValue(Id_fVisible, i);
            String lock = (String)model.getValue(Id_fLock, i);
            String vector = (String)model.getValue(Id_fVector, i);
            if (StringUtils.isBlank((CharSequence)key)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b2c%d\u884c\uff1a\u201c\u6807\u8bc6\u201d\u3002", (String)"LongPressOpEditPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), i + 1));
                return;
            }
            if (StringUtils.isBlank((CharSequence)name)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b2c%d\u884c\uff1a\u201c\u540d\u79f0\u201d\u3002", (String)"LongPressOpEditPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), i + 1));
                return;
            }
            if (allKeys.contains(key)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u201c\u6807\u8bc6\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"LongPressOpEditPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), i + 1));
                return;
            }
            allKeys.add(key);
            CardOperationBarItem item = new CardOperationBarItem(id, key, name, opKey, visible, lock, vector, i + 1);
            DcJsonSerializer serializer = new DcJsonSerializer(new DcBinder(){

                public IDataEntityType tryBindToType(String paramString, Map<String, String> paramMap) {
                    return OrmUtils.getDataEntityType(CardOperationBarItem.class);
                }
            });
            items.add(serializer.serializeToMap((Object)item, null));
        }
        HashMap retData = new HashMap();
        retData.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        retData.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        retData.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        retData.put(VALUE, items);
        retData.put("alias", this.getAlias(items));
        this.getView().returnDataToParent(retData);
        this.getView().close();
    }

    private String getAlias(List<Map<String, Object>> items) {
        if (items == null || items.isEmpty()) {
            return " ";
        }
        StringBuilder alias = new StringBuilder();
        for (Map<String, Object> item : items) {
            alias.append(alias.length() == 0 ? alias.toString() : "; ");
            alias.append(item.get("Name").toString());
        }
        return alias.toString();
    }
}

