/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.ListDcxmlBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.CarouselFigureImageItem;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.url.UrlService;

public class CarouselFigureImageEditPlugin
extends AbstractFormPlugin {
    private static final String BTN_ADD = "btnadd";
    private static final String BTN_DEL = "btndel";
    private static final String BTN_OK = "btnok";
    private static final String VALUE = "value";
    private static final String NAME = "name";
    private static final String IMAGE_KEY = "image";
    private static final int limit = 10;
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    String entryKey = "EntryEntity";

    public void initialize() {
        this.addClickListeners(new String[]{BTN_ADD, BTN_DEL, BTN_OK, IMAGE_KEY});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        Object value = this.getView().getFormShowParameter().getCustomParams().get(VALUE);
        List items = (List)(value instanceof List ? value : new ArrayList());
        if (!items.isEmpty()) {
            IDataModel model = this.getModel();
            int[] rowIndexs = model.batchCreateNewEntryRow(this.entryKey, items.size());
            int i = 0;
            String rootUrl = UrlService.getDomainContextUrl();
            for (Map item : items) {
                String url = (String)item.get("Url");
                if (StringUtils.isNotBlank((CharSequence)url)) {
                    model.setValue(IMAGE_KEY, (Object)(rootUrl + url), rowIndexs[i]);
                }
                model.setValue(NAME, item.get("Name"), rowIndexs[i]);
                ++i;
            }
        }
        this.getPageCache().put(VALUE, SerializationUtils.toJsonString((Object)items));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof FormOperate) {
            String key;
            switch (key = ((FormOperate)args.getSource()).getOperateKey()) {
                case "newentry": {
                    int rowCount = this.getView().getModel().getEntryEntity(this.entryKey).getRowCount();
                    if (rowCount < 10) break;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u56fe\u7247\u9ed8\u8ba4\u4e0a\u9650\u4e3a10\u5f20\u3002", (String)"CarouselFigureImageEditPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase(Locale.ENGLISH)) {
            case "image": {
                this.showImageSelector(evt);
                break;
            }
            case "btnok": {
                if (!this.checkImage()) break;
                this.returnData();
                break;
            }
        }
    }

    private void showImageSelector(EventObject evt) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("ide_pictureselector");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectImage"));
        this.getView().showForm(parameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        int rowIndex = this.getModel().getEntryCurrentRowIndex(this.entryKey);
        Object imageKey = this.getModel().getValue(IMAGE_KEY, rowIndex);
        if (IMAGE_KEY.equals(key) && StringUtils.isBlank((Object)imageKey)) {
            this.getModel().setValue(NAME, (Object)"", rowIndex);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (evt.getReturnData() == null) {
            return;
        }
        String actionId = evt.getActionId();
        if ("selectImage".equalsIgnoreCase(actionId)) {
            Map imgData = (Map)evt.getReturnData();
            AbstractGrid grid = (AbstractGrid)this.getView().getControl(this.entryKey);
            int rowKey = grid.getEntryState().getFocusRow();
            String rootUrl = UrlService.getDomainContextUrl();
            if (StringUtils.isBlank(imgData.get(VALUE))) {
                this.getModel().setValue(IMAGE_KEY, (Object)"", rowKey);
            } else {
                this.getModel().setValue(IMAGE_KEY, (Object)(rootUrl + imgData.get(VALUE)), rowKey);
            }
            String imgName = (String)imgData.get(NAME);
            this.getModel().setValue(NAME, (Object)imgName);
        }
    }

    private void returnData() {
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        Object items = this.getImageItems();
        para.put(VALUE, items);
        if (!(items instanceof List) || ((List)items).isEmpty()) {
            para.put("alias", " ");
        }
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    private boolean checkImage() {
        boolean valid = true;
        IDataModel model = this.getModel();
        int rowCount = model.getEntryEntity(this.entryKey).getRowCount();
        if (rowCount > 0) {
            StringBuilder sb = new StringBuilder();
            int index = 1;
            for (int i = 0; i < rowCount; ++i) {
                Object imageKey = model.getValue(IMAGE_KEY, i);
                if (ObjectUtils.isEmpty((Object)imageKey)) {
                    if (sb.length() == 0) {
                        sb.append(index);
                    } else {
                        sb.append("\u3001").append(index);
                    }
                    valid = false;
                }
                ++index;
            }
            if (!valid) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u56fe\u7247\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u56fe\u7247\u3002", (String)"CarouselFigureImageEditPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), sb.toString()));
            }
        }
        return valid;
    }

    private Object getImageItems() {
        ArrayList<CarouselFigureImageItem> items = new ArrayList<CarouselFigureImageItem>();
        IDataModel model = this.getModel();
        int rowCount = model.getEntryEntity(this.entryKey).getRowCount();
        if (rowCount > 0) {
            String rootUrl = UrlService.getDomainContextUrl();
            if (rootUrl.endsWith("/")) {
                rootUrl = rootUrl.substring(0, rootUrl.length() - 1);
            }
            for (int i = 0; i < rowCount; ++i) {
                Object imageKey = model.getValue(IMAGE_KEY, i);
                Object name = model.getValue(NAME, i);
                if (ObjectUtils.isEmpty((Object)imageKey) && ObjectUtils.isEmpty((Object)name)) continue;
                if (StringUtils.isNotBlank((Object)imageKey)) {
                    imageKey = StringUtils.substringAfter((String)imageKey.toString(), (String)rootUrl);
                }
                items.add(new CarouselFigureImageItem((String)name, (String)imageKey));
            }
        }
        CarouseJsonSerializer CarouseJson = new CarouseJsonSerializer();
        CarouseJson.setItems(items);
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(CarouseJsonSerializer.class));
        DcJsonSerializer serializer = new DcJsonSerializer((DcBinder)new ListDcxmlBinder(false, dts));
        Map map = serializer.serializeToMap((Object)CarouseJson, null);
        return map.containsKey("Items") ? map.get("Items") : items;
    }

    public static class CarouseJsonSerializer {
        private List<CarouselFigureImageItem> items = new ArrayList<CarouselFigureImageItem>();

        @CollectionPropertyAttribute(collectionItemPropertyType=CarouselFigureImageItem.class)
        public List<CarouselFigureImageItem> getItems() {
            return this.items;
        }

        public void setItems(List<CarouselFigureImageItem> items) {
            this.items = items;
        }
    }
}

