/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.plugin.AbstractFormPlugin;

public class CollapFieldsPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
TreeNodeCheckListener {
    private static final String ENTRY_KEY = "entryentity";
    private static final String treeKey = "treeviewap";
    private static final String BTN_OK = "btnok";
    private static final String RESET = "reset";
    private static final String VALUE = "value";
    private static final String PARENT_ID = "ParentId";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String ROOT_NODE = "_rootNode_";
    private static final String HEAD_NODE = "_headNode_";
    private static final String FIELD_TREE = "fieldTree";
    private List<Map<String, Object>> allFields = new ArrayList<Map<String, Object>>();
    private List<Map<String, Object>> childFields = new ArrayList<Map<String, Object>>();
    private static final Set<String> notSupportFoldSummaryField = new HashSet<String>(Arrays.asList("RichTextField", "FlexField", "AttachmentField", "PictureField", "SignatureField", "AddressField", "GeoPointField", "FlexField"));

    public void initialize() {
        this.addClickListeners(new String[]{BTN_OK, RESET});
        EntryGrid entity = (EntryGrid)this.getControl(ENTRY_KEY);
        entity.addClickListener((ClickListener)this);
        TreeView tree = (TreeView)this.getView().getControl(treeKey);
        tree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        PropertyEditHelper helper = new PropertyEditHelper();
        ArrayList<Map<String, Object>> value = new ArrayList();
        if (!StringUtils.isBlank((Object)helper.getParamValue(this.getView(), VALUE))) {
            value = (List)helper.getParamValue(this.getView(), VALUE);
        }
        List<Map<String, Object>> formMeta = helper.getFormMeta(this.getView());
        List<Map<String, Object>> entityMeta = helper.getEntityMeta(this.getView());
        if (formMeta != null && entityMeta != null) {
            Map<String, Object> selectMap = helper.getItem(this.getView());
            String currentPanelId = selectMap.get("Id").toString();
            List<Map<String, Object>> newItems = this.getCurrentFlexFields(currentPanelId, formMeta);
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(16);
            for (Map<String, Object> item : newItems) {
                map.put((String)item.get("Id"), item);
            }
            HashMap<Object, Map<String, Object>> entityMetaMap = new HashMap<Object, Map<String, Object>>(entityMeta.size());
            for (Map<String, Object> item : entityMeta) {
                entityMetaMap.put(item.get("Id"), item);
            }
            this.getChildControl(map, currentPanelId, entityMetaMap);
            this.addItem(this.allFields, value);
            if (this.allFields != null && !this.allFields.isEmpty()) {
                this.buildTree(this.allFields, value);
            }
        }
    }

    private List<Map<String, Object>> getCurrentFlexFields(String currentPanelId, List<Map<String, Object>> items) {
        for (Map<String, Object> item : items) {
            if (item.get(PARENT_ID) == null || !item.get(PARENT_ID).toString().equals(currentPanelId)) continue;
            this.getCurrentFlexFields(item.get("Id").toString(), items);
            this.childFields.add(item);
        }
        return this.childFields;
    }

    private void getChildControl(Map<String, Object> map, String selId, Map<Object, Map<String, Object>> entityMetaMap) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object fieldId;
            Map<String, Object> entityField;
            String key = entry.getKey();
            Map itemMap = (Map)map.get(key);
            if (!selId.equals(itemMap.get(PARENT_ID))) continue;
            if (itemMap.get("_Type_").toString().equals("FieldAp") && (entityField = entityMetaMap.get(fieldId = itemMap.get("FieldId"))) != null) {
                String fieldType = (String)entityField.get("_Type_");
                if (this.notSupportFoldSummary(fieldType)) continue;
                this.allFields.add(itemMap);
            }
            this.getChildControl(map, key, entityMetaMap);
        }
    }

    private boolean notSupportFoldSummary(String fieldType) {
        return notSupportFoldSummaryField.contains(fieldType);
    }

    private void getItemById(List<Map<String, Object>> value, Map<String, Object> field) {
        for (int i = 0; i < value.size(); ++i) {
            Map<String, Object> map = value.get(i);
            if (!((String)map.get("Id")).equals(field.get("Id"))) continue;
            value.set(i, field);
            return;
        }
    }

    private List<Map<String, Object>> addItem(List<Map<String, Object>> fields, List<Map<String, Object>> value) {
        for (Map<String, Object> map : fields) {
            this.getItemById(value, map);
        }
        return value;
    }

    protected void returnData(String key) {
        HashMap para = new HashMap();
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        ArrayList list = new ArrayList();
        String alias = "";
        if (BTN_OK.equalsIgnoreCase(key)) {
            if (this.getModel().getEntryRowCount(ENTRY_KEY) > 7) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6298\u53e0\u6458\u8981\u201d\u7684\u5b57\u6bb5\u6570\u4e0d\u80fd\u8d85\u8fc77\u4e2a\u3002", (String)"CollapFieldsPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            for (int i = 0; i < this.getModel().getEntryRowCount(ENTRY_KEY); ++i) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("Id", this.getModel().getValue("id", i));
                map.put("Seq", i);
                String name = this.getModel().getValue("name", i).toString();
                alias = alias + (i + 1 == this.getModel().getEntryRowCount(ENTRY_KEY) ? name : name + ";");
                map.put("_Type_", "FieldId");
                map.put("Name", name);
                list.add(map);
            }
        }
        para.put(VALUE, list);
        para.put("alias", alias);
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    public void entryRowClick(RowClickEvent arg0) {
    }

    public void entryRowDoubleClick(RowClickEvent arg0) {
        this.returnData(BTN_OK);
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        this.selectTreeNode(evt.getChecked(), (String)evt.getNodeId());
    }

    public void click(EventObject e) {
        String key = ((Control)e.getSource()).getKey();
        if (BTN_OK.equalsIgnoreCase(key)) {
            this.returnData(key);
        } else if (RESET.equalsIgnoreCase(key)) {
            this.returnData(key);
        }
    }

    private void buildTree(List<Map<String, Object>> allField, List<Map<String, Object>> value) {
        TreeNode root = new TreeNode();
        root.setParentid("");
        String rootId = ROOT_NODE;
        root.setId(rootId);
        root.setText(ResManager.loadKDString((String)"\u6298\u53e0\u9762\u677f", (String)"CollapFieldsPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        String headId = HEAD_NODE;
        TreeNode headNode = new TreeNode();
        headNode.setParentid(rootId);
        headNode.setId(headId);
        headNode.setText(ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"CollapFieldsPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        headNode.setIsOpened(true);
        for (Map<String, Object> item : allField) {
            TreeNode fieldNode = new TreeNode();
            fieldNode.setParentid(headId);
            fieldNode.setId((String)item.get("Id"));
            fieldNode.setData(item.get("Key"));
            fieldNode.setText((String)item.get("Name"));
            headNode.addChild(fieldNode);
        }
        if (headNode.getChildren() != null && !headNode.getChildren().isEmpty()) {
            root.addChild(headNode);
        }
        TreeView tree = (TreeView)this.getView().getControl(treeKey);
        tree.addNode(root);
        root.setIsOpened(true);
        this.setCheckNodeAndEntry(value, root);
        this.getPageCache().put(FIELD_TREE, SerializationUtils.toJsonString((Object)root));
    }

    private void setCheckNodeAndEntry(List<Map<String, Object>> value, TreeNode root) {
        ArrayList<TreeNode> checkNodes = new ArrayList<TreeNode>(10);
        IDataModel model = this.getModel();
        for (Map<String, Object> item : value) {
            TreeNode node = root.getTreeNode((String)item.get("Id"), 16);
            if (node == null) continue;
            int row = model.createNewEntryRow(ENTRY_KEY);
            checkNodes.add(node);
            model.setValue("name", (Object)node.getText(), row);
            model.setValue("key", node.getData(), row);
            model.setValue("id", (Object)node.getId(), row);
        }
        TreeView tree = (TreeView)this.getView().getControl(treeKey);
        tree.checkNodes(checkNodes);
    }

    private void selectTreeNode(boolean isSelect, String nodeId) {
        TreeNode root;
        block5: {
            IDataModel model;
            block3: {
                block4: {
                    model = this.getModel();
                    root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(FIELD_TREE), TreeNode.class);
                    if (!isSelect) break block3;
                    if (!HEAD_NODE.equals(nodeId) && !ROOT_NODE.equals(nodeId)) break block4;
                    List children = ((TreeNode)root.getChildren().get(0)).getChildren();
                    model.deleteEntryData(ENTRY_KEY);
                    this.addRows(children);
                    break block5;
                }
                TreeNode node = root.getTreeNode(nodeId, 16);
                if (node == null || node.getChildren() != null && !node.getChildren().isEmpty()) break block5;
                int row = model.createNewEntryRow(ENTRY_KEY);
                model.setValue("name", (Object)node.getText(), row);
                model.setValue("key", node.getData(), row);
                model.setValue("id", (Object)node.getId(), row);
                break block5;
            }
            if (HEAD_NODE.equals(nodeId) || ROOT_NODE.equals(nodeId)) {
                model.deleteEntryData(ENTRY_KEY);
            } else {
                int rows = model.getEntryRowCount(ENTRY_KEY);
                for (int i = 0; i < rows; ++i) {
                    if (!model.getValue("id", i).toString().equals(nodeId)) continue;
                    model.deleteEntryRow(ENTRY_KEY, i);
                    break;
                }
            }
        }
        this.getPageCache().put(FIELD_TREE, SerializationUtils.toJsonString((Object)root));
    }

    private void addRows(List<TreeNode> children) {
        if (children != null && !children.isEmpty()) {
            for (TreeNode node : children) {
                int row = this.getModel().createNewEntryRow(ENTRY_KEY);
                this.getModel().setValue("name", (Object)node.getText(), row);
                this.getModel().setValue("key", node.getData(), row);
                this.getModel().setValue("id", (Object)node.getId(), row);
            }
        }
    }
}

