/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.ListDcxmlBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.extensible.ExtensibleDao;
import kd.bos.url.UrlService;

public class ComboItemsEditPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String BTN_ADD = "btnadd";
    private static final String BTN_DEL = "btndel";
    private static final String BTN_OK = "btnok";
    private static final String FIMAGE_KEY = "fimagekey";
    private static final String VALUE = "value";
    private static final String F_IMAGE_KEY = "FImageKey";
    private static final String ITEM_VISIBLE = "ItemVisible";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String TYPE = "_Type_";
    private static final String fvalue = "fvalue";
    String entryKey = "EntryEntity";
    private static final String[] ALL_ITEMS = new String[]{"btnup", "btndown", "btnadd", "btndel"};
    private static final String CACHE_KEY = "oriFieldItemsLockType_cache";

    public void initialize() {
        this.addClickListeners(new String[]{BTN_ADD, BTN_DEL, BTN_OK, FIMAGE_KEY});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        AbstractGrid grid = (AbstractGrid)this.getControl(this.entryKey);
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Object type;
        this.oriFieldItemsLockType();
        Object value = this.getView().getFormShowParameter().getCustomParams().get(VALUE);
        List items = (List)(value instanceof List ? value : new ArrayList());
        if (items != null && items.size() > 0) {
            IDataModel model = this.getModel();
            int[] rowIndexs = model.batchCreateNewEntryRow(this.entryKey, items.size());
            int i = 0;
            String cache = this.getPageCache().get(CACHE_KEY);
            Map mapping = (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
            EntryGrid grid = (EntryGrid)this.getControl(this.entryKey);
            String rootUrl = UrlService.getDomainContextUrl();
            for (Map item : items) {
                if (StringUtils.isNotBlank(item.get("ImageKey"))) {
                    model.setValue(F_IMAGE_KEY, (Object)(rootUrl + item.get("ImageKey")), rowIndexs[i]);
                }
                model.setValue("FCaption", item.get("Caption"), rowIndexs[i]);
                model.setValue("FValue", item.get("Value"), rowIndexs[i]);
                model.setValue(ITEM_VISIBLE, item.get(ITEM_VISIBLE), rowIndexs[i]);
                if ("lock".equals(mapping.get(item.get("Value"))) || "speciallock".equals(mapping.get(item.get("Value")))) {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{fvalue, "itemvisible"});
                }
                ++i;
            }
        }
        if ("MobCommonCheckBoxFilterColumnAp".equals(type = this.getView().getFormShowParameter().getCustomParams().get(TYPE))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_ADD, BTN_DEL, FIMAGE_KEY});
        } else if ("MobCommonFilterColumnAp".equals(type)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FIMAGE_KEY});
        }
        this.getPageCache().put(VALUE, SerializationUtils.toJsonString((Object)items));
    }

    private void oriFieldItemsLockType() {
        String itemId = (String)this.getView().getFormShowParameter().getCustomParam("itemId");
        String entityId = (String)((Map)((List)this.getView().getFormShowParameter().getCustomParam("context")).get(0)).get("Id");
        HashMap<String, String> map = new HashMap<String, String>(16);
        if (StringUtils.isNotBlank((CharSequence)entityId)) {
            Set oriFieldItems = ExtensibleDao.getBasePropIds((IPageCache)this.getPageCache(), (MetaCategory)MetaCategory.Entity, (String)entityId, (String)itemId, (String)"Items");
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
            String lockType = ExtensibleDao.getExtLockType((AbstractMetadata)entityMetadata, (String)"Field", (String)entityMetadata.getModelType(), (String)itemId, (String)"Items").toString();
            this.setItemsEnable(lockType);
            for (String oriFieldItem : oriFieldItems) {
                map.put(oriFieldItem, lockType);
            }
        }
        this.getPageCache().put(CACHE_KEY, SerializationUtils.toJsonString(map));
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase(Locale.ENGLISH)) {
            case "btnadd": {
                this.addComboItem();
                break;
            }
            case "btndel": {
                this.deleteComboItem();
                break;
            }
            case "fimagekey": {
                this.showImageSelector(evt);
                break;
            }
            case "btnok": {
                this.returnData();
                break;
            }
        }
    }

    private void showImageSelector(EventObject evt) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("ide_pictureselector");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectImage"));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (evt.getReturnData() == null) {
            return;
        }
        String actionId = evt.getActionId();
        if ("selectImage".equalsIgnoreCase(actionId)) {
            Map imgData = (Map)evt.getReturnData();
            AbstractGrid grid = (AbstractGrid)this.getView().getControl(this.entryKey);
            int rowKey = grid.getEntryState().getFocusRow();
            String rootUrl = UrlService.getDomainContextUrl();
            if (StringUtils.isBlank(imgData.get(VALUE))) {
                this.getModel().setValue(F_IMAGE_KEY, (Object)"", rowKey);
            } else {
                this.getModel().setValue(F_IMAGE_KEY, (Object)(rootUrl + imgData.get(VALUE)), rowKey);
            }
        }
    }

    private void returnData() {
        HashMap map = new HashMap(16);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(this.entryKey);
        for (Object entry : entryEntity) {
            String key = entry.getString(fvalue);
            if (map.containsKey(key)) {
                ((List)map.get(key)).add(entry);
                continue;
            }
            ArrayList<Object> list = new ArrayList<Object>(10);
            list.add(entry);
            map.put(key, list);
        }
        StringBuilder tips = new StringBuilder();
        for (List dynamicObjects : map.values()) {
            if (dynamicObjects.size() <= 1) continue;
            StringBuilder rows = new StringBuilder();
            for (DynamicObject dyn : dynamicObjects) {
                rows.append(dyn.get("seq")).append("\u3001");
            }
            tips.append(String.format(ResManager.loadKDString((String)"\u7b2c %s \u884c\u4e0b\u62c9\u503c\u91cd\u590d", (String)"ComboItemsEditPlugin_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), rows.substring(0, rows.length() - 1))).append("\uff1b");
        }
        if (StringUtils.isNotBlank((CharSequence)tips)) {
            String error = tips.replace(tips.length() - 1, tips.length(), "\u3002").toString();
            this.getView().showErrorNotification(error);
            return;
        }
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        para.put(VALUE, this.getComboItems());
        para.put("alias", this.getComboAlias());
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    private String getComboAlias() {
        String alias = "";
        IDataModel model = this.getModel();
        DynamicObjectCollection rowKeyobjs = model.getEntryEntity(this.entryKey);
        if (rowKeyobjs != null) {
            int i = 0;
            for (DynamicObject rowKeyObj : rowKeyobjs) {
                alias = (alias.equals("") ? alias : alias + ",") + new LocaleString(Lang.get().toString(), (String)model.getValue("fcaption", i)).toString();
                ++i;
            }
        }
        return alias;
    }

    private Object getComboItems() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        IDataModel model = this.getModel();
        DynamicObjectCollection rowKeyobjs = model.getEntryEntity(this.entryKey);
        if (rowKeyobjs != null) {
            String rootUrl = UrlService.getDomainContextUrl();
            if (rootUrl.endsWith("/")) {
                rootUrl = rootUrl.substring(0, rootUrl.length() - 1);
            }
            int i = 0;
            for (DynamicObject rowKeyObj : rowKeyobjs) {
                Object imageKey = model.getValue(FIMAGE_KEY, i);
                Object caption = model.getValue("fcaption", i);
                Object value = model.getValue(fvalue, i);
                if (ObjectUtils.isEmpty((Object)imageKey) && ObjectUtils.isEmpty((Object)caption) && ObjectUtils.isEmpty((Object)value)) continue;
                if (StringUtils.isNotBlank((Object)imageKey)) {
                    imageKey = StringUtils.substringAfter((String)imageKey.toString(), (String)rootUrl);
                }
                items.add(new ComboItem(i, new LocaleString(Lang.get().toString(), (String)caption), value, imageKey, Boolean.TRUE.equals(model.getValue(ITEM_VISIBLE, i))));
                ++i;
            }
        }
        ComboJsonSerializer comboJson = new ComboJsonSerializer();
        comboJson.setItems(items);
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(ComboJsonSerializer.class));
        DcJsonSerializer serializer = new DcJsonSerializer((DcBinder)new ListDcxmlBinder(false, dts));
        Map mapCombo = serializer.serializeToMap((Object)comboJson, null);
        return mapCombo.containsKey("Items") ? mapCombo.get("Items") : items;
    }

    private void deleteComboItem() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        IDataModel model = (IDataModel)this.getView().getService(IDataModel.class);
        int[] rowIndexs = proxy.getEntryState(this.entryKey).getSelectedRows();
        if (rowIndexs.length > 0 && rowIndexs[0] != -1) {
            model.deleteEntryRows(this.entryKey, rowIndexs);
            this.entryRowClick(new RowClickEvent((Object)this, rowIndexs[0] - 1));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ComboItemsEditPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), Integer.valueOf(3000));
        }
    }

    private void addComboItem() {
        IDataModel model = (IDataModel)this.getView().getService(IDataModel.class);
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(this.entryKey);
        model.getDataEntity(true);
        int newRowKey = model.createNewEntryRow(this.entryKey);
        grid.selectRows(newRowKey, true);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "btnadd": {
                this.addComboItem();
                break;
            }
            case "btndel": {
                this.deleteComboItem();
                break;
            }
            case "fimagekey": {
                this.showImageSelector((EventObject)evt);
                break;
            }
            case "btnok": {
                this.returnData();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("moveentryup".equals(e.getOperateKey())) {
            String cache = this.getPageCache().get(CACHE_KEY);
            Map mapping = (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
            EntryGrid entryGrid = (EntryGrid)this.getControl(this.entryKey);
            int[] selectRows = entryGrid.getSelectRows();
            int currentRow = selectRows[0];
            String value = (String)this.getModel().getValue(fvalue, currentRow - 1);
            String lockType = (String)mapping.get(value);
            if ("lock".equals(lockType) || "speciallock".equals(lockType)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"moveup"});
            }
            this.entryRowClick(new RowClickEvent((Object)this, currentRow));
        } else if ("moveentrydown".equals(e.getOperateKey())) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"moveup"});
        }
    }

    public void entryRowClick(RowClickEvent e) {
        if (e.getRow() < 0) {
            return;
        }
        this.getView().setEnable(Boolean.valueOf(true), ALL_ITEMS);
        String cache = this.getPageCache().get(CACHE_KEY);
        Map mapping = (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
        String value = (String)this.getModel().getValue(fvalue, e.getRow());
        String lockType = (String)mapping.get(value);
        String lastRowValue = (String)this.getModel().getValue(fvalue, e.getRow() - 1);
        String lastRowLockType = (String)mapping.get(lastRowValue);
        if ("lock".equals(lastRowLockType) || "speciallock".equals(lastRowLockType)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btnup"});
        }
        this.setItemsEnable(lockType);
    }

    private void setItemsEnable(String lockType) {
        if ("lock".equals(lockType)) {
            this.getView().setEnable(Boolean.FALSE, ALL_ITEMS);
        } else if ("speciallock".equals(lockType)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"btnup", "btndown", BTN_DEL});
        }
    }

    public static class ComboJsonSerializer {
        private List<ComboItem> items = new ArrayList<ComboItem>();

        @CollectionPropertyAttribute(collectionItemPropertyType=ComboItem.class)
        public List<ComboItem> getItems() {
            return this.items;
        }

        public void setItems(List<ComboItem> items) {
            this.items = items;
        }
    }
}

