/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.filter.CompareTypeConfig;
import kd.bos.filter.CompareTypeField;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;

public class CompareTypeConfigPlugin
extends AbstractFormPlugin {
    private static final String FIELD = "field";
    private static final String COMPARE_TYPE = "comparetype";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String VALUE = "value";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"ok", "close", FIELD});
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(COMPARE_TYPE);
        basedataEdit.addBeforeF7SelectListener(paramBeforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)paramBeforeF7SelectEvent.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("app.fbasedataid", "=", this.getView().getFormShowParameter().getCustomParam("bizappid")));
        });
        super.registerListener(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (COMPARE_TYPE.equals(e.getProperty().getName())) {
            int entrySelRow = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            this.getModel().setValue(FIELD, (Object)"", entrySelRow);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Object value = this.getView().getFormShowParameter().getCustomParam(VALUE);
        if (value != null) {
            List<IDataEntityType> dataEntityTypes = this.getDataEntityTypes();
            DcJsonSerializer dcJsonSerializer = new DcJsonSerializer(dataEntityTypes);
            CompareTypeConfig compareTypeConfig = (CompareTypeConfig)dcJsonSerializer.deserializeFromString(value.toString(), null);
            IDataModel model = this.getModel();
            model.clearNoDataRow();
            for (CompareTypeField compareTypeField : compareTypeConfig.getCompareTypeFields()) {
                int rowIndex = model.createNewEntryRow(ENTRY_ENTITY);
                model.setItemValueByID(COMPARE_TYPE, (Object)compareTypeField.getId(), rowIndex);
                model.setValue(FIELD, (Object)compareTypeField.getFieldNames(), rowIndex);
            }
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "ok": {
                this.save();
                break;
            }
            case "close": {
                this.getView().close();
                break;
            }
            case "field": {
                DynamicObject fieldObject;
                int entrySelRow = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("ide_batchsetfilter");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCustomParam("context", this.getView().getFormShowParameter().getCustomParam("context"));
                showParameter.setCustomParam("schemefilter", this.getView().getFormShowParameter().getCustomParam("schemefilter"));
                showParameter.setCustomParam("formid", (Object)"bos_comparetypeconfig");
                DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(COMPARE_TYPE, entrySelRow);
                if (dynamicObject != null && (fieldObject = (DynamicObject)dynamicObject.get(FIELD)) != null) {
                    String number = fieldObject.get("number").toString();
                    if (number.length() > 5) {
                        showParameter.setCustomParam("fieldtype", (Object)number.toLowerCase().substring(0, number.length() - 5));
                    } else {
                        showParameter.setCustomParam("fieldtype", (Object)number.toLowerCase());
                    }
                }
                showParameter.setCustomParam("fields", this.getModel().getValue(FIELD, entrySelRow));
                showParameter.setCaption(ResManager.loadKDString((String)"\u9002\u7528\u5b57\u6bb5", (String)"CompareTypeConfigPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ide_batchsetfilter&" + entrySelRow));
                this.getView().showForm(showParameter);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() != null && e.getActionId().startsWith("ide_batchsetfilter")) {
            int rowKey = Integer.parseInt(e.getActionId().split("&")[1]);
            Map map = (Map)e.getReturnData();
            List valueMapList = (List)map.get(VALUE);
            ArrayList<String> fields = new ArrayList<String>(10);
            for (Map valueMap : valueMapList) {
                fields.add(valueMap.get("Id").toString());
            }
            this.getModel().setValue(FIELD, (Object)String.join((CharSequence)",", fields), rowKey);
            return;
        }
    }

    private void save() {
        DynamicObjectCollection listCloseField = this.getModel().getEntryEntity(ENTRY_ENTITY);
        HashMap para = new HashMap();
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", "CompareTypeConfig");
        CompareTypeConfig compareTypeConfig = new CompareTypeConfig();
        for (DynamicObject map : listCloseField) {
            if (map.get("comparetype_id").equals(0L) || !StringUtils.isNotBlank((CharSequence)map.get(FIELD).toString())) continue;
            CompareTypeField compareTypeField = new CompareTypeField(map.get("comparetype_id").toString(), map.get(FIELD).toString());
            compareTypeConfig.addCompareTypeField(compareTypeField);
        }
        List<IDataEntityType> dataEntityTypes = this.getDataEntityTypes();
        DcJsonSerializer dcJsonSerializer = new DcJsonSerializer(dataEntityTypes);
        para.put(VALUE, dcJsonSerializer.serializeToMap((Object)compareTypeConfig, null));
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    private List<IDataEntityType> getDataEntityTypes() {
        ArrayList<IDataEntityType> dataEntityTypes = new ArrayList<IDataEntityType>();
        dataEntityTypes.add(OrmUtils.getDataEntityType(CompareTypeConfig.class));
        dataEntityTypes.add(OrmUtils.getDataEntityType(CompareTypeField.class));
        return dataEntityTypes;
    }
}

