/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.Listbox;
import kd.bos.ext.form.control.Markdown;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.plugin.AbstractFormPlugin;

public class DateFormulaSettings
extends AbstractFormPlugin
implements ListboxClickListener {
    private static final String BTN_CANCEL = "btncancel";
    private static final String BTN_OK = "btnok";
    private static final String MARKDOWN = "markdown";
    private static final String RESET = "reset";
    private static final String RESULT = "result";
    private static final String EXAMPLE_LIST = "examplelist";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";

    public void afterCreateNewData(EventObject e) {
        List<DateFormula> dateFormulas = this.initFunctions();
        this.doReset();
        Listbox exampleListBox = (Listbox)this.getView().getControl(EXAMPLE_LIST);
        exampleListBox.addItems(this.getExampleList(dateFormulas));
        this.getView().setVisible(Boolean.valueOf(false), new String[]{MARKDOWN});
        this.trySelect(dateFormulas);
    }

    private void trySelect(List<DateFormula> dateFormulas) {
        String expr = Optional.ofNullable(this.getView().getFormShowParameter().getCustomParam("expr")).map(Object::toString).orElse("");
        Optional<DateFormula> first = dateFormulas.stream().filter(dateFormula -> expr.equals(dateFormula.getFormula())).findFirst();
        if (first.isPresent()) {
            Listbox exampleListBox = (Listbox)this.getView().getControl(EXAMPLE_LIST);
            exampleListBox.activeItem(first.get().getKey());
            exampleListBox.addListboxClickListener((ListboxClickListener)this);
            exampleListBox.listboxClick(first.get().getKey());
        }
    }

    private List<ListboxItem> getExampleList(List<DateFormula> dateFormulas) {
        ArrayList<ListboxItem> result = new ArrayList<ListboxItem>(dateFormulas.size());
        for (DateFormula dateFormula : dateFormulas) {
            result.add(new ListboxItem(dateFormula.getKey(), dateFormula.getName()));
        }
        return result;
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.equals(BTN_OK)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("expr", this.getModel().getValue(RESULT));
            this.getView().returnDataToParent(map);
            this.getView().close();
        } else if (key.equals(BTN_CANCEL)) {
            this.getView().close();
        } else if (key.equals(RESET)) {
            this.doReset();
        } else if (this.getPageCache().get(key) != null) {
            DateFormula dateFormula = (DateFormula)SerializationUtils.fromJsonString((String)this.getPageCache().get(key), DateFormula.class);
            this.setMarkdown(dateFormula.getMarkdown());
            this.getModel().setValue(RESULT, (Object)dateFormula.getFormula());
        }
    }

    private List<DateFormula> initFunctions() {
        ArrayList<DateFormula> functionList = new ArrayList<DateFormula>();
        functionList.add(new DateFormula("func_null", ResManager.loadKDString((String)"\u7a7a\u503c", (String)"DateFormulaSettings_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "", ResManager.loadKDString((String)"# \u7a7a\u503c", (String)"DateFormulaSettings_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])));
        functionList.add(new DateFormula("func_timestamp", ResManager.loadKDString((String)"\u5177\u4f53\u65f6\u95f4", (String)"DateFormulaSettings_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "2020-01-01 08:00:00", String.format(ResManager.loadKDString((String)"## \u5177\u4f53\u65f6\u95f4%1$s### \u516c\u5f0f\u8bf4\u660e%2$s\u683c\u5f0f\uff1a`yyyy-MM-dd HH:mm:ss`%3$s### \u4f8b\u5b50%4$s2000-01-01 00:00:00%5$s2010-02-28 00:01:00%6$s2020-03-31 00:00:01", (String)"DateFormulaSettings_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "\r\n\r\n", "\r\n\r\n", "\r\n\r\n", "\r\n\r\n", "\r\n\r\n", "\r\n\r\n")));
        functionList.add(new DateFormula("func_currenttime", ResManager.loadKDString((String)"\u5f53\u524d\u65f6\u95f4", (String)"DateFormulaSettings_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "now()", String.format(ResManager.loadKDString((String)"## \u5f53\u524d\u65f6\u95f4%1$s### \u516c\u5f0f\u8bf4\u660e%2$s\u8fd4\u56de\u5f53\u524d\u65f6\u95f4\uff0c\u683c\u5f0f\uff1a`yyyy-MM-dd HH:mm:ss`%3$s", (String)"DateFormulaSettings_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "\r\n\r\n", "\r\n\r\n", "\r\n\r\n")));
        functionList.add(new DateFormula("func_after24hours", ResManager.loadKDString((String)"24\u5c0f\u65f6\u540e", (String)"DateFormulaSettings_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "left(dateAdd(now(),1),11) + right(now(),8)", String.format(ResManager.loadKDString((String)"## 24 \u5c0f\u65f6\u540e%1$s### \u516c\u5f0f\u8bf4\u660e%2$s`now()` \u8fd4\u56de `yyyy-MM-dd HH:mm:ss` \u7684\u65e5\u671f\u683c\u5f0f%3$s`dateAdd(now(), 1)` \u8fd4\u56de\u7b2c\u4e8c\u5929 0 \u70b9%4$s`left(dateAdd(now(), 1), 11)` \u622a\u53d6\u7b2c\u4e8c\u5929 0 \u70b9\u7684 `\u201cYYYY-MM-DD \u201d` \u90e8\u5206%5$s`right(now(), 8)` \u622a\u53d6 `\u201cHH:MM:SS\u201d`%6$s`left(dateAdd(now(), 1), 11) + right(now(), 8)` \u8868\u793a 24 \u5c0f\u65f6\u540e%7$s### \u4f8b\u5b50%8$sleft(dateAdd(now(), -2), 11) + right(now(), 8) \u8868\u793a 48 \u5c0f\u65f6\u524d%9$sleft(dateAdd(now(), -3), 11) + right(now(), 8) \u8868\u793a 72 \u5c0f\u65f6\u524d%10$s", (String)"DateFormulaSettings_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "\r\n\r\n", "\r\n\r\n", "\r\n\r\n", "\r\n\r\n", "\r\n\r\n", "\r\n\r\n", "\r\n\r\n", "\r\n\r\n", "\r\n\r\n", "\r\n\r\n")));
        functionList.add(new DateFormula("func_yesterday0", ResManager.loadKDString((String)"\u6628\u59290\u70b9", (String)"DateFormulaSettings_8", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "dateAdd(now(), -1)", String.format(ResManager.loadKDString((String)"## \u6628\u59290\u70b9%1$s### \u516c\u5f0f\u8bf4\u660e%2$s`now()` \u8fd4\u56de `yyyy-MM-dd HH:mm:ss` \u7684\u65e5\u671f\u683c\u5f0f%3$s`dateAdd(now(), -1)` \u8fd4\u56de\u6628\u5929 0 \u70b9%4$s### \u4f8b\u5b50%5$sdateAdd(now(), 1) \u8868\u793a\u660e\u59290\u70b9%6$sdateAdd(now(), 2) \u8868\u793a\u540e\u59290\u70b9", (String)"DateFormulaSettings_9", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "\r\n\r\n", "\r\n\r\n", "\r\n\r\n", "\r\n\r\n", "\r\n\r\n", "\r\n\r\n")));
        functionList.add(new DateFormula("func_tomorrow1", ResManager.loadKDString((String)"\u660e\u59291\u70b9", (String)"DateFormulaSettings_10", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "left(dateAdd(now(), 1), 11) + \"01:00:00\"", String.format(ResManager.loadKDString((String)"## \u660e\u59291\u70b9%1$s### \u516c\u5f0f\u8bf4\u660e%2$s`now()` \u8fd4\u56de `yyyy-MM-dd HH:mm:ss` \u7684\u65e5\u671f\u683c\u5f0f%3$s`dateAdd(now(), 1)` \u8fd4\u56de\u660e\u59290\u70b9%4$s`left(dateAdd(now(), 1), 11)` \u622a\u53d6\u660e\u59290\u70b9\u7684 `YYYY-MM-DD ` \u90e8\u5206%5$sleft(dateAdd(now(), 1), 11) + \"01:00:00\" \u8868\u793a\u660e\u59291\u70b9%6$s### \u4f8b\u5b50%7$sleft(dateAdd(now(), -1), 11) + \"08:00:00\" \u8868\u793a\u6628\u59298\u70b9%8$sleft(dateAdd(now(), 2), 11) + \"10:00:00\" \u8868\u793a\u540e\u592910\u70b9", (String)"DateFormulaSettings_11", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "\r\n\r\n", "\r\n\r\n", "\r\n\r\n", "\r\n\r\n", "\r\n\r\n", "\r\n\r\n", "\r\n\r\n", "\r\n\r\n")));
        functionList.add(new DateFormula("func_nextmonday", ResManager.loadKDString((String)"\u4e0b\u5468\u4e00", (String)"DateFormulaSettings_12", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "dateAdd(now(), 7 - weekday(now())+1)", String.format(ResManager.loadKDString((String)"## \u4e0b\u5468\u4e00%1$s### \u516c\u5f0f\u8bf4\u660e%2$s`now()` \u8fd4\u56de `yyyy-MM-dd HH:mm:ss` \u7684\u65e5\u671f\u683c\u5f0f%3$s`weekday(now())` \u8fd4\u56de\u672c\u5468\u7b2c\u51e0\u5929\uff08\u661f\u671f\u65e5\u4e3a0\uff0c\u661f\u671f\u4e00\u4e3a1\uff0c\u661f\u671f\u516d\u4e3a6\uff09%4$s`dateAdd(now(), 7 - weekday(now()) + 1)` \u8fd4\u56de\u4e0b\u5468\u4e00%5$s### \u4f8b\u5b50%6$sdateAdd(now(), 7 - weekday(now()) + 0) \u8868\u793a\u4e0b\u5468\u65e5%7$sdateAdd(now(), 7 - weekday(now()) + 3) \u8868\u793a\u4e0b\u5468\u4e09%8$sdateAdd(now(), 7 - weekday(now()) + 5) \u8868\u793a\u4e0b\u5468\u4e94", (String)"DateFormulaSettings_13", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "\r\n\r\n", "\r\n\r\n", "\r\n\r\n", "\r\n\r\n", "\r\n\r\n", "\r\n\r\n", "\r\n\r\n", "\r\n\r\n")));
        functionList.add(new DateFormula("func_lasttuesday", ResManager.loadKDString((String)"\u4e0a\u5468\u4e8c", (String)"DateFormulaSettings_14", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "dateAdd(now(), 0 - weekday(now())-7+2)", String.format(ResManager.loadKDString((String)"## \u4e0a\u5468\u4e8c%1$s### \u516c\u5f0f\u8bf4\u660e%2$s`now()` \u8fd4\u56de `yyyy-MM-dd HH:mm:ss` \u7684\u65e5\u671f\u683c\u5f0f%3$s`weekday(now())` \u8fd4\u56de\u672c\u5468\u7b2c\u51e0\u5929\uff08\u661f\u671f\u65e5\u4e3a0\uff0c\u661f\u671f\u4e00\u4e3a1\uff0c\u661f\u671f\u516d\u4e3a6\uff09%4$s`dateAdd(now(), 0 - weekday(now()) - 7 + 2)` \u8fd4\u56de\u4e0a\u5468\u4e8c%5$s### \u4f8b\u5b50%6$sdateAdd(now(), 0 - weekday(now()) - 7 + 0) \u8868\u793a\u4e0a\u5468\u65e5%7$sdateAdd(now(), 0 - weekday(now()) - 7 + 3) \u8868\u793a\u4e0a\u5468\u4e09%8$sdateAdd(now(), 0 - weekday(now()) - 7 + 5) \u8868\u793a\u4e0a\u5468\u4e94", (String)"DateFormulaSettings_15", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "\r\n\r\n", "\r\n\r\n", "\r\n\r\n", "\r\n\r\n", "\r\n\r\n", "\r\n\r\n", "\r\n\r\n", "\r\n\r\n")));
        Map<String, String> functions = functionList.stream().collect(Collectors.toMap(DateFormula::getKey, DateFormula::toString));
        this.getPageCache().put(functions);
        return functionList;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (e.getProperty().getName().startsWith("func_") && StringUtils.isBlank((Object)e.getChangeSet()[0].getNewValue())) {
            this.getModel().setValue(e.getProperty().getName(), e.getChangeSet()[0].getOldValue());
        }
    }

    public void registerListener(EventObject e) {
        Listbox exampleListBox = (Listbox)this.getView().getControl(EXAMPLE_LIST);
        exampleListBox.addListboxClickListener((ListboxClickListener)this);
        this.addClickListeners(new String[]{BTN_OK, BTN_CANCEL, RESET});
    }

    private void doReset() {
        this.getModel().setValue(RESULT, (Object)Optional.ofNullable(this.getView().getFormShowParameter().getCustomParam("expr")).map(Object::toString).orElse(""));
    }

    private void setMarkdown(String content) {
        Markdown markdown = (Markdown)this.getControl(MARKDOWN);
        markdown.setText(content);
        this.getView().setVisible(Boolean.valueOf(!StringUtils.isBlank((CharSequence)content)), new String[]{MARKDOWN});
    }

    public void listboxClick(ListboxEvent listboxEvent) {
        String itemId = listboxEvent.getItemId();
        if (this.getPageCache().get(itemId) != null) {
            DateFormula dateFormula = (DateFormula)SerializationUtils.fromJsonString((String)this.getPageCache().get(itemId), DateFormula.class);
            this.setMarkdown(dateFormula.getMarkdown());
            this.getModel().setValue(RESULT, (Object)dateFormula.getFormula());
        }
    }

    public static class DateFormula {
        private String formula;
        private String key;
        private String markdown;
        private String name;

        public DateFormula() {
        }

        public DateFormula(String key, String name, String formula, String markdown) {
            this.key = key;
            this.name = name;
            this.formula = formula;
            this.markdown = markdown;
        }

        public String getFormula() {
            return this.formula;
        }

        public void setFormula(String formula) {
            this.formula = formula;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getMarkdown() {
            return this.markdown;
        }

        public void setMarkdown(String markdown) {
            this.markdown = markdown;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            return SerializationUtils.toJsonString((Object)this);
        }
    }
}

