/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.logback.LogbackFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataWriter;
import kd.bos.metadata.dao.designer.DesignerMetaDao;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.orm.query.QFilter;

public class DefaultPageSettingPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String PC_BILL = "pcbill";
    private static final String PC_LIST = "pclist";
    private static final String MOBILE_BILL = "mbbill";
    private static final String MOBILE_LIST = "mblist";
    private static final String ITEMID = "itemId";
    private static final String DEFAULTPAGESETTINGPLUGIN = "DefaultPageSettingPlugin";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String VALUE = "value";
    private static final String MODEL_TYPE = "ModelType";
    private static final String BASEENTITYID = "BaseEntityId";
    private static final String BTN_OK = "btnok";
    private static final String KEY_NUMBER = "number";
    private static final String KEY_NAME = "name";
    private Log logger = LogbackFactory.getLog(DefaultPageSettingPlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{PC_BILL, PC_LIST, MOBILE_BILL, MOBILE_LIST, BTN_OK});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (e.getProperty().getName().endsWith("id")) {
            return;
        }
        if (e.getChangeSet().length > 0) {
            for (ChangeData changeData : e.getChangeSet()) {
                if (!"".equals(changeData.getNewValue())) continue;
                this.getModel().setValue(e.getProperty().getName() + "id", (Object)"");
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map<String, String> valJson = new HashMap();
        Object value = this.getView().getFormShowParameter().getCustomParams().get(VALUE);
        if (value != null && !StringUtils.isEmpty((CharSequence)value.toString())) {
            try {
                valJson = (Map)SerializationUtils.fromJsonString((String)value.toString(), Map.class);
            }
            catch (Exception ex) {
                this.logger.warn("\u83b7\u53d6\u9ed8\u8ba4\u503c\u914d\u7f6e\u62a5\u9519", (Object)ex.getMessage());
                return;
            }
        } else {
            return;
        }
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ITEMID);
        String masterId = MetadataDao.getMasterId((String)entityId);
        QFilter[] qFilters = new QFilter[]{new QFilter(KEY_NUMBER, "in", (Object)valJson.values().toArray()), new QFilter("basedatafield", "=", (Object)masterId)};
        DynamicObject[] formDesignMeta = new DesignerMetaDao().getFormDesignMeta("id,name,number", qFilters);
        HashMap resultMap = new HashMap(1);
        for (DynamicObject rs : formDesignMeta) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(VALUE, rs.getString(KEY_NUMBER));
            map.put("id", rs.getString("id"));
            map.put(KEY_NAME, rs.getString(KEY_NAME));
            resultMap.put(rs.getString(KEY_NUMBER), map);
        }
        valJson.forEach((k, v) -> {
            if (resultMap.containsKey(v)) {
                this.setValue((String)k, (Map)resultMap.get(v));
            }
        });
    }

    private void setValue(String key, Map<String, Object> data) {
        IDataModel model = this.getModel();
        String title = ResManager.loadKDString((String)"PC\u8868\u5355", (String)"DefaultPageSettingPlugin_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
        switch (key) {
            case "pcbill": {
                title = ResManager.loadKDString((String)"PC\u8868\u5355", (String)"DefaultPageSettingPlugin_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
                break;
            }
            case "pclist": {
                title = ResManager.loadKDString((String)"PC\u5217\u8868", (String)"DefaultPageSettingPlugin_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
                break;
            }
            case "mbbill": {
                title = ResManager.loadKDString((String)"\u79fb\u52a8\u8868\u5355", (String)"DefaultPageSettingPlugin_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
                break;
            }
            case "mblist": {
                title = ResManager.loadKDString((String)"\u79fb\u52a8\u5217\u8868", (String)"DefaultPageSettingPlugin_8", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            }
        }
        model.setValue(key, (Object)(data.get(KEY_NAME) + "-" + title + "(" + data.get(VALUE) + ")"));
        model.setValue(key + "id", data.get(VALUE));
    }

    private void showPageSelectForm(String tips, String type, String entityId) {
        String modeltype = "BillFormModel";
        switch (type) {
            case "pcbill": 
            case "pclist": {
                modeltype = this.getView().getFormShowParameter().getCustomParam("modelType").toString();
                break;
            }
            case "mbbill": 
            case "mblist": {
                modeltype = "MobileBillFormModel";
            }
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCaption(tips);
        showParameter.setFormId("ide_linklayout");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> context = new HashMap<String, String>();
        String masterId = MetadataDao.getMasterId((String)entityId);
        context.put(BASEENTITYID, masterId);
        context.put(MODEL_TYPE, modeltype);
        showParameter.setCustomParam("context", context);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, type));
        this.getView().showForm(showParameter);
    }

    public void click(EventObject evt) {
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam(ITEMID);
        String key = ((Control)evt.getSource()).getKey();
        if (PC_BILL.equalsIgnoreCase(key)) {
            this.showPageSelectForm(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9PC\u8868\u5355\u5e03\u5c40\u3002", (String)"DefaultPageSettingPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), key, entityId);
        } else if (PC_LIST.equalsIgnoreCase(key)) {
            this.showPageSelectForm(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9PC\u5217\u8868\u5e03\u5c40\u3002", (String)"DefaultPageSettingPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), key, entityId);
        } else if (MOBILE_BILL.equalsIgnoreCase(key)) {
            this.showPageSelectForm(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u79fb\u52a8\u8868\u5355\u5e03\u5c40\u3002", (String)"DefaultPageSettingPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), key, entityId);
        } else if (MOBILE_LIST.equalsIgnoreCase(key)) {
            this.showPageSelectForm(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u79fb\u52a8\u5217\u8868\u5e03\u5c40\u3002", (String)"DefaultPageSettingPlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), key, entityId);
        } else if (BTN_OK.equalsIgnoreCase(key)) {
            this.closeAndReturn();
        }
    }

    private void closeAndReturn() {
        String pcbillId = (String)this.getModel().getValue("pcbillid");
        String pclistd = (String)this.getModel().getValue("pclistid");
        String mobileId = (String)this.getModel().getValue("mbbillid");
        String mobileListId = (String)this.getModel().getValue("mblistid");
        HashMap<String, String> pageSetting = new HashMap<String, String>();
        pageSetting.put(PC_BILL, pcbillId);
        pageSetting.put(PC_LIST, pclistd);
        pageSetting.put(MOBILE_BILL, mobileId);
        pageSetting.put(MOBILE_LIST, mobileListId);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String entityId = (String)customParams.get(ITEMID);
        String value = SerializationUtils.toJsonString(pageSetting);
        HashMap<String, String> para = new HashMap<String, String>(16);
        para.put(ITEMID, entityId);
        para.put("metaType", (String)customParams.get("metaType"));
        para.put("propertyName", (String)customParams.get("propertyName"));
        para.put(VALUE, value);
        String tag = (String)customParams.get("tag");
        if ("mxfl_defaultLayout".equals(tag)) {
            this.saveDefaultLayout(entityId, value);
        } else {
            this.getView().returnDataToParent(para);
            this.getView().close();
        }
    }

    private void saveDefaultLayout(String entityId, String value) {
        EntityMetadata metadata = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        ((BillEntity)metadata.getRootEntity()).setDefaultPageSetting(value);
        MetadataWriter writer = new MetadataWriter(metadata.getModelType());
        Map saveInfo = writer.save(new AbstractMetadata[]{metadata});
        if (((Boolean)saveInfo.get("success")).booleanValue()) {
            this.getView().showSuccessNotification(saveInfo.get("message").toString());
            this.getView().close();
        } else {
            this.getView().showErrorNotification(saveInfo.get("message").toString());
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        if (event.getReturnData() == null) {
            return;
        }
        String callBackID = event.getActionId();
        IDataModel model = this.getModel();
        HashMap rt = (HashMap)event.getReturnData();
        this.setValue(callBackID, rt);
    }
}

