/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.property.AbstractPropertyPlugin;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.entity.fielddefvalue.AbstractDefValueParamPlugIn;
import kd.bos.mvc.SessionManager;

public class DefaultValueEditPlugin
extends AbstractPropertyPlugin {
    private static final String CONTEXT = "context";
    private static final String TYPE = "_Type_";
    private static final String FUNC_LIST = "funclist";
    private static final String DEF_VALUE_DESIGN = "DefValueDesign";
    private static final String FUNC_TYPE = "FuncType";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String FUNCPANEL_PAGE_ID = "funcpanel_PageId";
    private boolean checkPass = true;
    private static Map<String, String> funcFormIds = new HashMap<String, String>();
    private static final String GET_TODAY = "getToday";
    private static final String GET_NOW = "getNow";
    private static final String TO_DATE = "toDate";
    private static final String GET_TODAY_SYS_TZ = "getTodaySysTZ";
    private static final String GET_NOW_USER_TZ = "getNowUserTZ";
    private static final String GET_TODAY_ORG_TZ = "getTodayOrgTZ";
    private static final String GET_NOW_ORG_TZ = "getNowOrgTZ";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        String funcTypeId;
        List ctx = (List)this.getView().getFormShowParameter().getCustomParam(CONTEXT);
        if (ctx == null) {
            return;
        }
        List context = ctx;
        ArrayList<Map<String, Object>> entityMeta = new ArrayList(10);
        if (ctx.get(0) instanceof List) {
            context = (List)ctx.get(0);
            entityMeta = (List)ctx.get(1);
        }
        String fieldType = (String)((Map)context.get(0)).get(TYPE);
        List<ComboItem> funclist = this.createFuncList(fieldType);
        ((ComboEdit)this.getControl(FUNC_LIST)).setComboItems(funclist);
        this.setTips(fieldType);
        this.getPageCache().put("funcList", SerializationUtils.toJsonString(funclist));
        Object defValueObject = ((Map)context.get(0)).get(DEF_VALUE_DESIGN);
        Map defValueDesign = null;
        if (defValueObject instanceof Map) {
            defValueDesign = (Map)defValueObject;
        }
        String string = funcTypeId = defValueDesign != null ? (String)defValueDesign.get(FUNC_TYPE) : null;
        if (!funclist.isEmpty()) {
            if (StringUtils.isBlank((CharSequence)funcTypeId)) {
                funcTypeId = funclist.get(0).getValue();
            }
            this.getModel().setValue(FUNC_LIST, (Object)funcTypeId);
            this.showFuncPanel(funcTypeId, context, entityMeta);
        }
    }

    private void setTips(String fieldType) {
        if ("DateField".equals(fieldType)) {
            HashMap value = new HashMap(8);
            HashMap<String, LocaleString> tipValue = new HashMap<String, LocaleString>(8);
            LocaleString tips = ResManager.getLocaleString((String)"1.\u83b7\u53d6\u5f53\u524d\u65e5\u671f-\u7528\u6237\u65f6\u533a\uff1a\u6309\u7167\u7528\u6237\u9009\u9879\u8bbe\u7f6e\u7684\u65f6\u533a\uff0c\u83b7\u5f97\u5f53\u524d\u7684\u65e5\u671f\n2. \u83b7\u53d6\u5f53\u524d\u65e5\u671f-\u7ec4\u7ec7\u65f6\u533a\uff1a\u6309\u7167\u5355\u636e\u4e0a\u6307\u5b9a\u4e1a\u52a1\u5355\u5143\u7684\u65f6\u533a\uff0c\u83b7\u5f97\u5f53\u524d\u7684\u65e5\u671f\uff1b\u65b0\u589e\u5355\u636e\u65f6\uff0c\u5982\u7ec4\u7ec7\u65e0\u9ed8\u8ba4\u503c\u6216\u6ca1\u6709\u8bbe\u7f6e\u65f6\u533a\uff0c\u5219\u6309\u7167\u7528\u6237\u65f6\u533a\u83b7\u5f97\u5f53\u524d\u65e5\u671f\uff08\u6216\u65f6\u95f4\uff09\n3. \u83b7\u53d6\u5f53\u524d\u65e5\u671f-\u670d\u52a1\u5668\u65f6\u533a\uff1a\u6309\u7167\u670d\u52a1\u5668\u65f6\u533a\uff0c\u83b7\u5f97\u5f53\u524d\u7684\u65e5\u671f\n4. \u83b7\u53d6\u5f53\u524d\u65e5\u671f-\u6307\u5b9a\u65f6\u533a\uff1a\u9009\u62e9\u4e00\u4e2a\u65f6\u533a\u5e38\u91cf\uff0c\u83b7\u5f97\u5f53\u524d\u7684\u65e5\u671f\uff08\u6216\u65f6\u95f4\uff09\n", (String)"DefaultValueEditPlugin_18", (String)BOS_DESIGNER_PLUGIN);
            tipValue.put("content", tips);
            value.put("tips", tipValue);
            this.getView().updateControlMetadata(FUNC_LIST, value);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (FUNC_LIST.equals(e.getProperty().getName())) {
            List ctx;
            List context = ctx = (List)this.getView().getFormShowParameter().getCustomParam(CONTEXT);
            List<Map<String, Object>> entityMeta = new ArrayList<Map<String, Object>>(10);
            if (ctx.get(0) instanceof List) {
                context = (List)ctx.get(0);
                entityMeta = (List)ctx.get(1);
            }
            this.showFuncPanel((String)this.getModel().getValue(FUNC_LIST), context, entityMeta);
        }
    }

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equalsIgnoreCase("btnok")) {
            this.returnDefValue();
        }
    }

    private List<ComboItem> createFuncList(String fieldType) {
        ArrayList<ComboItem> funclist = new ArrayList<ComboItem>();
        switch (fieldType) {
            case "DateField": {
                funclist.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u65e5\u671f-\u7528\u6237\u65f6\u533a", (String)"DefaultValueEditPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), GET_TODAY));
                funclist.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u65e5\u671f-\u7ec4\u7ec7\u65f6\u533a", (String)"DefaultValueEditPlugin_15", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), GET_TODAY_ORG_TZ));
                funclist.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u65e5\u671f-\u670d\u52a1\u5668\u65f6\u533a", (String)"DefaultValueEditPlugin_14", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), GET_TODAY_SYS_TZ));
                funclist.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u65e5\u671f-\u6307\u5b9a\u65f6\u533a", (String)"DefaultValueEditPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), TO_DATE));
                break;
            }
            case "DateTimeField": {
                funclist.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u65e5\u671f\u65f6\u95f4", (String)"DefaultValueEditPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), GET_NOW));
                funclist.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u6307\u5b9a\u65e5\u671f", (String)"DefaultValueEditPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), TO_DATE));
                break;
            }
            case "CityField": {
                funclist.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6307\u5b9a\u57ce\u5e02", (String)"DefaultValueEditPlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), "getCity"));
                break;
            }
            case "NameSegBasedataField": 
            case "BasedataField": 
            case "MaterielField": 
            case "CustomerField": 
            case "SupplierField": 
            case "CurrencyField": 
            case "GroupField": 
            case "UnitField": 
            case "AssistantField": {
                funclist.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u83b7\u53d6\u57fa\u7840\u8d44\u6599", (String)"DefaultValueEditPlugin_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), "getBasedata"));
                break;
            }
            case "OrgField": {
                funclist.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u7ec4\u7ec7", (String)"DefaultValueEditPlugin_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), "getCurrentOrg"));
                funclist.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u83b7\u53d6\u6307\u5b9a\u7ec4\u7ec7", (String)"DefaultValueEditPlugin_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), "getOrg"));
                break;
            }
            case "UserField": {
                funclist.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u7528\u6237", (String)"DefaultValueEditPlugin_8", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), "getCurrentUser"));
                break;
            }
            case "ComboField": 
            case "BillStatusField": 
            case "RadioGroupField": {
                funclist.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u83b7\u53d6\u679a\u4e3e\u503c", (String)"DefaultValueEditPlugin_9", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), "getEnum"));
                break;
            }
            case "MulBasedataField": {
                funclist.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u83b7\u53d6\u591a\u9009\u57fa\u7840\u8d44\u6599", (String)"DefaultValueEditPlugin_10", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), "getMulBasedata"));
                break;
            }
            case "AdminDivisionField": {
                funclist.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u83b7\u53d6\u884c\u653f\u533a\u5212", (String)"DefaultValueEditPlugin_11", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), "getAdminvidision"));
                break;
            }
            case "MulComboField": {
                funclist.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u83b7\u53d6\u591a\u9009\u4e0b\u62c9\u5217\u8868", (String)"DefaultValueEditPlugin_12", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), "getMulEnum"));
                break;
            }
            case "CheckBoxField": {
                funclist.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u83b7\u53d6\u590d\u9009\u6846\u9ed8\u8ba4\u503c", (String)"DefaultValueEditPlugin_13", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])), "getBoolean"));
                break;
            }
        }
        return funclist;
    }

    private void showFuncPanel(String funcType, List<Map<String, Object>> context, List<Map<String, Object>> entityMeta) {
        String pageId = this.getPageCache().get(FUNCPANEL_PAGE_ID);
        if (pageId != null) {
            HashMap<String, String> arg = new HashMap<String, String>();
            arg.put("pageId", pageId);
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("closeWindow", arg);
            this.getPageCache().remove(FUNCPANEL_PAGE_ID);
        }
        if (!StringUtils.isBlank((CharSequence)funcType)) {
            FormShowParameter paraSettings = new FormShowParameter();
            paraSettings.getOpenStyle().setShowType(ShowType.InContainer);
            paraSettings.getOpenStyle().setTargetKey("funcpanel");
            paraSettings.setFormId(funcFormIds.containsKey(funcType) ? funcFormIds.get(funcType) : funcType);
            paraSettings.setCustomParam("Context", context);
            paraSettings.setCustomParam(FUNC_TYPE, (Object)funcType);
            paraSettings.setCustomParam("Entitymeta", entityMeta);
            paraSettings.setCustomParam("formLayoutScheme", this.getView().getFormShowParameter().getCustomParam("formLayoutScheme"));
            if (StringUtils.equals((CharSequence)funcType, (CharSequence)TO_DATE)) {
                paraSettings.addCustPlugin("kd.bos.designer.func.DateTimeDefValueParamPlugIn");
            }
            this.getView().showForm(paraSettings);
            this.getPageCache().put(FUNCPANEL_PAGE_ID, paraSettings.getPageId());
        }
    }

    private void returnDefValue() {
        String propertyName = (String)this.getView().getFormShowParameter().getCustomParams().get("propertyName");
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", propertyName);
        if (!StringUtils.equals((CharSequence)DEF_VALUE_DESIGN, (CharSequence)propertyName)) {
            para.put("value", this.getDefValue());
        } else {
            para.put("value", this.getDefValueDesign());
            Object funcType = this.getModel().getValue(FUNC_LIST);
            if (funcType instanceof String && (funcType.toString().equals(GET_TODAY) || funcType.toString().equals(GET_NOW) || funcType.equals(TO_DATE))) {
                List funclist = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("funcList"), ComboItem.class);
                for (ComboItem comboItem : funclist) {
                    if (!comboItem.getValue().equals(funcType.toString())) continue;
                    para.put("alias", comboItem.getCaption().getDefaultItem());
                }
            }
        }
        if (this.checkPass) {
            this.getView().returnDataToParent(para);
            this.getView().close();
        }
    }

    private Object getDefValue() {
        String pageId = this.getPageCache().get(FUNCPANEL_PAGE_ID);
        IFormView funcFormView = SessionManager.getCurrent().getView(pageId);
        if (funcFormView != null) {
            String fieldType;
            List ctx;
            IDataModel funcModel = (IDataModel)funcFormView.getService(IDataModel.class);
            Object defaultValue = funcModel.getValue("defaultvalue");
            List context = ctx = (List)this.getView().getFormShowParameter().getCustomParam(CONTEXT);
            if (ctx.get(0) instanceof List) {
                context = (List)ctx.get(0);
            }
            if (("DateField".equals(fieldType = (String)((Map)context.get(0)).get(TYPE)) || "DateTimeField".equals(fieldType)) && defaultValue instanceof Date) {
                DateFormat mediumDateFormat = DateFormat.getDateTimeInstance(2, 2);
                return mediumDateFormat.format((Date)defaultValue);
            }
            return defaultValue;
        }
        return null;
    }

    private Map<String, Object> getDefValueDesign() {
        String pageId = this.getPageCache().get(FUNCPANEL_PAGE_ID);
        if (StringUtils.isBlank((CharSequence)pageId)) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(TYPE, DEF_VALUE_DESIGN);
        IFormView funcFormView = SessionManager.getCurrent().getView(pageId);
        FormViewPluginProxy proxy = (FormViewPluginProxy)funcFormView.getService(FormViewPluginProxy.class);
        AbstractDefValueParamPlugIn plugIn = null;
        if (proxy != null) {
            for (IFormPlugin p : proxy.getPlugIns()) {
                if (!(p instanceof AbstractDefValueParamPlugIn)) continue;
                plugIn = (AbstractDefValueParamPlugIn)p;
                break;
            }
        }
        data.put(FUNC_TYPE, this.getModel().getValue(FUNC_LIST));
        if (plugIn == null) {
            data.put("FuncParameter", String.valueOf(this.getDefValue()));
        } else {
            StringBuilder sBuilder = new StringBuilder();
            if (!plugIn.check(sBuilder)) {
                this.getView().showTipNotification(sBuilder.toString());
                this.checkPass = false;
                return null;
            }
            data.put("FuncParameter", plugIn.returnParameter());
        }
        return data;
    }

    static {
        funcFormIds.put(GET_TODAY, "ide_gettodayedit");
        funcFormIds.put(GET_NOW, "ide_getnowedit");
        funcFormIds.put(TO_DATE, "bos_func_todate");
        funcFormIds.put(GET_TODAY_SYS_TZ, "ide_gettodayedit");
        funcFormIds.put(GET_NOW_USER_TZ, "ide_getnowedit");
        funcFormIds.put(GET_TODAY_ORG_TZ, "ide_getdate_orgtz");
        funcFormIds.put(GET_NOW_ORG_TZ, "ide_getdate_orgtz");
        funcFormIds.put("getCurrentCity", "ide_currentcity");
        funcFormIds.put("getCity", "ide_city_default");
        funcFormIds.put("getBasedata", "ide_getbasedataedit");
        funcFormIds.put("getCurrentOrg", "ide_getcurrentorgedit");
        funcFormIds.put("getOrg", "ide_getorgedit");
        funcFormIds.put("getCurrentUser", "ide_getcurrentuseredit");
        funcFormIds.put("getMulBasedata", "ide_getmulbasedataedit");
        funcFormIds.put("getAdminvidision", "ide_getadmindivisionedit");
        funcFormIds.put("getEnum", "ide_getenumedit");
        funcFormIds.put("getBoolean", "ide_getcheckboxedit");
        funcFormIds.put("getMulEnum", "ide_getmulenumedit");
    }
}

