/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class DisplayPropsEdit
extends AbstractFormPlugin {
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String LONG_NUMBER = "longNumber";
    private static final String FULL_NAME = "fullName";
    private static final String CONNECTOR = "connector";
    private static final String TIP_FLEX_PANEL = "tipflexpanelap";
    private static final String TIP = "tip";
    private static final String DISPLAY_FIELD = "displayfield";
    private static final String SPACE = "space";
    private static final String BRACKETS = "()";
    private static final String ITEM_ID = "itemId";
    private static final String META_TYPE = "metaType";
    private static final String PROPERTY_NAME = "propertyName";
    private static final String VALUE = "value";
    private static final String CONTEXT = "context";
    private static final String BTN_OK = "btnok";
    private static final String DISPLAY_PROP = "DisplayProp";
    private static final String COMMA = ",";
    private static final String BOS_FORMMETA = "bos_formmeta";
    private static final String INHERIT_PATH = "inheritpath";
    private static final String BASE_TREE_TPL = "b0d31cea000001ac";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String BOS_ORG = "73f9bf0200001dac";
    public static final String BOS_ADMIN_ORG_ID = "PKJP6FA0=V1";
    private static final String SIMPLE_NAME = "simplename";
    private PropertyEditHelper helper = new PropertyEditHelper();

    public void initialize() {
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_OK.equals(key)) {
            this.returnData();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Label tipLab;
        DynamicObject dataEntity;
        ChangeData changeData = e.getChangeSet()[0];
        Object newData = changeData.getNewValue();
        String field = e.getProperty().getName();
        if (newData == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)DISPLAY_FIELD, (CharSequence)field)) {
            dataEntity = this.getModel().getDataEntity();
            tipLab = (Label)this.getControl(TIP);
            if (StringUtils.contains((CharSequence)newData.toString(), (CharSequence)COMMA)) {
                if (dataEntity.get(CONNECTOR) == null) {
                    dataEntity.set(CONNECTOR, (Object)COMMA);
                }
                tipLab.setText(this.getTip(this.getDisplayField(newData.toString(), dataEntity.get(CONNECTOR))));
                this.getView().setVisible(Boolean.valueOf(true), new String[]{CONNECTOR});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{TIP_FLEX_PANEL});
                this.getView().updateView();
            } else {
                this.getModel().getDataEntity().set(CONNECTOR, null);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{CONNECTOR});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{TIP_FLEX_PANEL});
            }
        }
        if (StringUtils.equals((CharSequence)CONNECTOR, (CharSequence)field)) {
            dataEntity = this.getModel().getDataEntity();
            tipLab = (Label)this.getControl(TIP);
            String displayProp = dataEntity.get(DISPLAY_FIELD) == null ? NAME : dataEntity.get(DISPLAY_FIELD).toString();
            tipLab.setText(this.getTip(this.getDisplayField(displayProp, newData)));
        }
    }

    public void afterCreateNewData(EventObject e) {
        if (this.isOrgType()) {
            this.addDisplayPropertyCombo(Arrays.asList(LONG_NUMBER, FULL_NAME, SIMPLE_NAME));
        } else if (this.isBaseTreeTpl()) {
            this.addDisplayPropertyCombo(Arrays.asList(LONG_NUMBER, FULL_NAME));
        }
        Object value = this.getView().getFormShowParameter().getCustomParams().get(VALUE);
        if (value == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{CONNECTOR});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TIP_FLEX_PANEL});
            return;
        }
        String displayProp = value.toString();
        String connector = displayProp.replace(SIMPLE_NAME, "").replace(LONG_NUMBER, "").replace(FULL_NAME, "").replace(NUMBER, "").replace(NAME, "");
        String displayField = displayProp;
        if (!"".equals(connector)) {
            displayField = BRACKETS.equals(connector) ? displayProp.replaceAll("[( )]", COMMA).substring(0, displayProp.length() - 1) : displayProp.replace(connector, COMMA);
            if (" ".equals(connector)) {
                connector = SPACE;
            }
        } else {
            connector = null;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        dataEntity.set(DISPLAY_FIELD, (Object)displayField);
        dataEntity.set(CONNECTOR, (Object)connector);
        Label tipLab = (Label)this.getControl(TIP);
        tipLab.setText(this.getTip(displayProp));
        if (connector == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{CONNECTOR});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TIP_FLEX_PANEL});
        }
    }

    private boolean isOrgType() {
        List context = (List)this.helper.getParamValue(this.getView(), CONTEXT);
        if (context.isEmpty()) {
            return false;
        }
        Object baseEntityId = ((Map)context.get(0)).get("BaseEntityId");
        Object type = ((Map)context.get(0)).get("_Type_");
        if ("OrgField".equals(type)) {
            return true;
        }
        return BOS_ORG.equals(baseEntityId) || BOS_ADMIN_ORG_ID.equals(baseEntityId);
    }

    private boolean isBaseTreeTpl() {
        PropertyEditHelper helper = new PropertyEditHelper();
        List context = (List)helper.getParamValue(this.getView(), CONTEXT);
        if (CollectionUtils.isEmpty((Collection)context)) {
            return false;
        }
        Object baseEntityId = ((Map)context.get(0)).get("BaseEntityId");
        Object type = ((Map)context.get(0)).get("_Type_");
        if ("AssistantField".equals(type)) {
            return true;
        }
        if (baseEntityId == null) {
            return false;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)BOS_FORMMETA, (String)INHERIT_PATH, (QFilter[])new QFilter[]{new QFilter("id", "=", baseEntityId)});
        if (dynamicObject != null) {
            String[] split;
            String inheritPath = dynamicObject.getString(INHERIT_PATH);
            for (String path : split = inheritPath.split(COMMA)) {
                if (!StringUtils.equals((CharSequence)BASE_TREE_TPL, (CharSequence)path)) continue;
                return true;
            }
        }
        return false;
    }

    private void addDisplayPropertyCombo(List<String> fieldKeys) {
        ComboEdit displayField = (ComboEdit)this.getControl(DISPLAY_FIELD);
        ComboProp property = (ComboProp)displayField.getProperty();
        List comboItems = property.getComboItems();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(comboItems.size());
        for (ValueMapItem comboItem : comboItems) {
            boolean itemVisible = comboItem.isItemVisible();
            if (fieldKeys.contains(comboItem.getValue())) {
                itemVisible = true;
            }
            items.add(new ComboItem(comboItem.getImageKey(), comboItem.getName(), comboItem.getValue(), itemVisible));
        }
        displayField.setComboItems(items);
    }

    protected void returnData() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String displayProp = dataEntity.get(DISPLAY_FIELD) == null ? NAME : dataEntity.get(DISPLAY_FIELD).toString();
        Object connector = dataEntity.get(CONNECTOR);
        String displayField = this.getDisplayField(displayProp, connector);
        HashMap<String, String> para = new HashMap<String, String>();
        para.put(DISPLAY_PROP, displayField);
        ArrayList<HashMap<String, String>> paras = new ArrayList<HashMap<String, String>>();
        para.put(ITEM_ID, (String)this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
        para.put(META_TYPE, (String)this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
        para.put(PROPERTY_NAME, (String)this.getView().getFormShowParameter().getCustomParams().get(PROPERTY_NAME));
        para.put(VALUE, displayField);
        paras.add(para);
        this.getView().returnDataToParent(paras);
        this.getView().close();
    }

    private String getDisplayField(String displayProp, Object connector) {
        if (connector != null && !COMMA.equals(connector)) {
            if (SPACE.equals(connector)) {
                connector = " ";
            } else if (BRACKETS.equals(connector)) {
                connector = "(";
                displayProp = displayProp + ")";
            }
            displayProp = displayProp.replace(COMMA, connector.toString());
        }
        return displayProp;
    }

    private String getTip(String displayField) {
        return displayField.replace(NUMBER, ResManager.loadKDString((String)"\u7f16\u7801", (String)"DisplayPropsEdit_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0])).replace(NAME, ResManager.loadKDString((String)"\u540d\u79f0", (String)"DisplayPropsEdit_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
    }
}

