/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;

public class EntityTypeIdPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String ENTITY_TYPES = "entitytypes";
    private static final String VALUE = "value";
    private static final String NUMBER = "number";

    public void initialize() {
        this.addClickListeners(new String[]{"btncancel", "btnok"});
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTITY_TYPES);
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterBindData(EventObject e) {
        String selectedKey = null;
        if (this.getView().getFormShowParameter().getCustomParams().get(VALUE) != null) {
            selectedKey = this.getView().getFormShowParameter().getCustomParams().get(VALUE).toString();
        }
        int rows = this.getModel().getEntryRowCount(ENTITY_TYPES);
        for (int i = 0; i < rows; ++i) {
            if (!this.getModel().getValue("fid", i).equals(selectedKey)) continue;
            EntryGrid grid = (EntryGrid)this.getControl(ENTITY_TYPES);
            grid.selectRows(new int[]{i}, i);
            break;
        }
    }

    public void entryRowClick(RowClickEvent evt) {
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        this.reurnData();
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        if ("btnok".equalsIgnoreCase(c.getKey())) {
            this.reurnData();
        } else if ("btncancel".equalsIgnoreCase(c.getKey())) {
            this.getView().close();
        }
    }

    private void reurnData() {
        Object oldId;
        Map<String, Object> row = this.getCurrentSelector();
        if (row != null && !ObjectUtils.nullSafeEquals(oldId = this.getView().getFormShowParameter().getCustomParams().get(VALUE), (Object)row.get(NUMBER))) {
            ArrayList paras = new ArrayList();
            HashMap<String, Object> para = new HashMap<String, Object>();
            para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
            para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
            para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
            para.put(VALUE, row.get("id"));
            para.put("alias", row.get("name"));
            paras.add(para);
            this.getView().returnDataToParent(paras);
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject eo) {
        List formList;
        Object[] params = new SqlParameter[]{new SqlParameter(":FLOCALEID", 12, (Object)Lang.get().toString())};
        String sql = "select a.FID, a.FNumber,a.FNAME from T_META_ENTITYDESIGN_L a right join T_META_ENTITYDESIGN b on a.FID = b.FID where b.FMODELTYPE in('BaseFormModel','BillFormModel') AND  a.FLOCALEID = ?";
        try {
            formList = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

                public List<Map<String, Object>> handle(ResultSet rs) throws SQLException {
                    ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(10);
                    while (rs.next()) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("id", rs.getString(1));
                        String num = rs.getString(2);
                        map.put(EntityTypeIdPlugin.NUMBER, num);
                        String name = rs.getString(3);
                        map.put("name", StringUtils.isBlank((CharSequence)name) ? num : name);
                        list.add(map);
                    }
                    return list;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format("error:%s;  sql:%s", e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        if (formList.size() > 0) {
            IDataModel model = this.getModel();
            model.batchCreateNewEntryRow(ENTITY_TYPES, formList.size());
            int i = 0;
            for (Map form : formList) {
                model.setValue("fid", form.get("id"), i);
                model.setValue("fnumber", form.get(NUMBER), i);
                model.setValue("fname", form.get("name"), i);
                ++i;
            }
        }
    }

    private Map<String, Object> getCurrentSelector() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTITY_TYPES);
        int row = grid.getEntryState().getFocusRow();
        if (!StringUtils.isNotBlank((Object)row)) {
            return null;
        }
        ret.put("id", (String)this.getModel().getValue("fid", row));
        ret.put(NUMBER, (String)this.getModel().getValue("fnumber", row));
        ret.put("name", (String)this.getModel().getValue("fname", row));
        return ret;
    }
}

