/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.property.AbstractPropertyPlugin;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.AbstractGrid;

public class EntryIdPlugin
extends AbstractPropertyPlugin {
    private static final String ENTRY_KEY = "entrys";
    private static final String ITEM_ID = "itemId";
    private static final String META_TYPE = "metaType";
    private static final String PROPERTY_NAME = "propertyName";

    public void afterCreateNewData(EventObject e) {
        List items = (List)this.getView().getFormShowParameter().getCustomParams().get("context");
        if (items != null) {
            ArrayList<Map> entrys = new ArrayList<Map>();
            for (Map item : items) {
                Object type = item.get("_Type_");
                if (!"EntryEntity".equals(type) && !"SubEntryEntity".equals(type)) continue;
                entrys.add(item);
            }
            if (entrys.size() > 0) {
                IDataModel model = this.getModel();
                int count = model.getEntryRowCount(ENTRY_KEY);
                if (entrys.size() > count) {
                    model.batchCreateNewEntryRow(ENTRY_KEY, entrys.size() - count);
                }
                int i = 0;
                for (Map entry : entrys) {
                    model.setValue("fid", entry.get("Id"), i);
                    model.setValue("fkey", entry.get("Key"), i);
                    model.setValue("fname", entry.get("Name"), i);
                    ++i;
                }
            }
        }
    }

    @Override
    protected void returnData() {
        Map<String, Object> row = this.getCurrentSelector();
        if (row != null) {
            ArrayList paras = new ArrayList(10);
            HashMap<String, Object> para = new HashMap<String, Object>(16);
            para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
            para.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
            para.put(PROPERTY_NAME, this.getView().getFormShowParameter().getCustomParams().get(PROPERTY_NAME));
            para.put("value", row.get("id"));
            para.put("alias", row.get("key"));
            paras.add(para);
            HashMap<String, Object> keyPara = new HashMap<String, Object>(16);
            keyPara.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
            keyPara.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
            keyPara.put(PROPERTY_NAME, "Key");
            keyPara.put("value", row.get("key"));
            paras.add(keyPara);
            this.getView().returnDataToParent(paras);
            this.getView().close();
        }
    }

    private Map<String, Object> getCurrentSelector() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_KEY);
        int row = grid.getEntryState().getFocusRow();
        if (!StringUtils.isNotBlank((Object)row)) {
            return null;
        }
        ret.put("id", (String)this.getModel().getValue("fid", row));
        ret.put("name", (String)this.getModel().getValue("fname", row));
        ret.put("key", (String)this.getModel().getValue("fkey", row));
        return ret;
    }
}

