/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.designer.dao.FormMetadataUtil;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Button;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.formula.FormulaEngine;
import kd.bos.metadata.treebuilder.EntityFieldTreeBuildOption;
import kd.bos.metadata.treebuilder.FormTreeBuilder;

public class ExpressionPlugin
extends AbstractFormPlugin
implements TreeNodeCheckListener,
TreeNodeClickListener {
    private static final String BACK_SPACE = "backspace";
    private static final Map<String, String> operationCharacter = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("plus", "+");
            this.put("subtract", "-");
            this.put("multiple", "*");
            this.put("divide", "/");
            this.put("equal", "=");
            this.put("less", "<");
            this.put("lessequal", "<=");
            this.put("leftparentheses", "(");
            this.put("greater", ">");
            this.put("greaterequal", ">=");
            this.put("squarebrackets", "<>");
            this.put("rightparentheses", ")");
            this.put("and", "AND");
            this.put("not", "NOT");
            this.put("or", "OR");
            this.put("clr", "CLR");
            this.put(ExpressionPlugin.BACK_SPACE, "Backspace");
        }
    };
    private static final String[] OPERATER = new String[]{"=", "+", "-", "*", "/", "<", ">"};
    public static final String TREE_VIEW_AP = "TreeViewAp";
    public static final String TEXT_AREA_FIELD = "TextAreaField";
    public static final String CONTEXT = "context";

    public void initialize() {
        Button btn = null;
        for (Map.Entry<String, String> entry : operationCharacter.entrySet()) {
            String key = entry.getKey().toString().toLowerCase();
            btn = (Button)this.getControl(key);
            btn.addClickListener((ClickListener)this);
        }
        TreeView tree = (TreeView)this.getView().getControl(TREE_VIEW_AP);
        tree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        tree = (TreeView)this.getView().getControl(TREE_VIEW_AP);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        String key = btn.getKey();
        if (key != null) {
            this.operation(key);
        }
    }

    public void operation(String xx) {
        String character = operationCharacter.get(xx);
        if (character.equalsIgnoreCase("clr")) {
            this.getModel().setValue(TEXT_AREA_FIELD, (Object)"");
            this.getView().updateView();
            return;
        }
        String currentText = null;
        if (this.getModel().getValue(TEXT_AREA_FIELD) != null && this.getModel().getValue(TEXT_AREA_FIELD).toString().length() > 0) {
            if (BACK_SPACE.equalsIgnoreCase(character)) {
                String field;
                String deleteField = field = this.getModel().getValue(TEXT_AREA_FIELD).toString();
                for (String str : OPERATER) {
                    if (field.lastIndexOf(str) <= 0 || !"".equals((deleteField = field.substring(field.lastIndexOf(str) + 1)).trim())) continue;
                    deleteField = str;
                }
                String[] fieldList = deleteField.split(" ");
                for (int i = fieldList.length - 1; i >= 0; --i) {
                    if ("".equals(fieldList[i].trim())) continue;
                    deleteField = fieldList[i];
                    break;
                }
                currentText = field.substring(0, field.lastIndexOf(deleteField));
            } else {
                currentText = this.getModel().getValue(TEXT_AREA_FIELD) + " " + character + " ";
            }
        } else {
            currentText = BACK_SPACE.equalsIgnoreCase(character) ? "" : character;
        }
        this.getModel().setValue(TEXT_AREA_FIELD, (Object)currentText);
        this.getView().updateView();
    }

    public void createNewData(BizDataEventArgs e) {
    }

    public void afterCreateNewData(EventObject e) {
        if (this.getView().getFormShowParameter().getCustomParams().get(CONTEXT) == null || this.getView().getFormShowParameter().getCustomParams().get("metaType") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"ExpressionPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
            return;
        }
        List context = null;
        String metaType = this.getView().getFormShowParameter().getCustomParams().get("metaType").toString();
        boolean isOnlyHeader = false;
        TreeNode root = new TreeNode();
        if ("formmeta".equalsIgnoreCase(metaType)) {
            List contextList = (List)this.getView().getFormShowParameter().getCustomParams().get(CONTEXT);
            context = (List)contextList.get(0);
            isOnlyHeader = true;
            FormMetadataUtil formMetadataUtil = new FormMetadataUtil();
        } else {
            List contextEntitymeata;
            context = contextEntitymeata = (List)this.getView().getFormShowParameter().getCustomParams().get(CONTEXT);
            EntityFieldTreeBuildOption option = new EntityFieldTreeBuildOption();
            option.setOnlyBillHead(isOnlyHeader);
            root = FormTreeBuilder.buildEntityFieldsTree((List)contextEntitymeata, (EntityFieldTreeBuildOption)option);
        }
        TreeView tree = (TreeView)this.getView().getControl(TREE_VIEW_AP);
        tree.addNode(root);
        Object valueOb = this.getView().getFormShowParameter().getCustomParams().get("value");
        if (valueOb != null && !((Map)valueOb).isEmpty()) {
            Map value = (Map)valueOb;
            this.getModel().setValue(TEXT_AREA_FIELD, value.get("expression"));
        }
        this.getPageCache().put(CONTEXT, SerializationUtils.toJsonString((Object)context));
        this.getView().updateView();
    }

    public void treeNodeClick(TreeNodeEvent e) {
        if (e.getNodeId() != null && !"".equals(e.getNodeId().toString().trim())) {
            String character = e.getNodeId().toString();
            if (this.getModel().getValue(TEXT_AREA_FIELD) != null) {
                character = this.getModel().getValue(TEXT_AREA_FIELD).toString() + " " + character + " ";
            }
            this.getModel().setValue(TEXT_AREA_FIELD, (Object)character);
        }
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
    }

    public void treeNodeCheck(TreeNodeCheckEvent arg0) {
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if (this.getModel().getValue(TEXT_AREA_FIELD) != null) {
            HashMap<String, String> textMap = new HashMap<String, String>();
            String textAreaField = null;
            textAreaField = this.getModel().getValue(TEXT_AREA_FIELD).toString();
            textMap.put("RuleCondition", textAreaField);
            try {
                FormulaEngine.parseFormula((String)textAreaField);
            }
            catch (Exception e1) {
                this.getView().getFormShowParameter().setCustomParam("errExpression", (Object)String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bef\uff1a%s\u3002", (String)"ExpressionPlugin_1", (String)"bos-designer-plugin", (Object[])new Object[0]), e1.getMessage()));
                return;
            }
            this.getView().returnDataToParent(textMap);
        }
    }
}

