/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.property.alias.FeaturesConverter;
import kd.bos.entity.Features;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Button;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.extensible.ExtLockTypeEnum;
import kd.bos.metadata.extensible.ExtensibleDao;

public class FeaturesEditPlugin
extends AbstractFormPlugin {
    private static final String MULTI_FILLABLE = "multifillable";
    private static final String F7_BATCH_FILL = "f7batchfill";
    private static final String SERIES_NEWTOTE = "seriesnewtote";
    private static final String CONVERT_TOTE = "converttote";
    private static final String TYPE = "_Type_";
    private static final String IMPORTABLE = "importable";
    private static final String EXPORTABLE = "exportable";
    private static final Log LOG = LogFactory.getLog(FeaturesEditPlugin.class);

    public void initialize() {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        this.lockNotEditableFeatures();
        Map featuresMap = null;
        Object value = this.getView().getFormShowParameter().getCustomParams().get("value");
        Features features = null;
        if (StringUtils.isNotBlank(value)) {
            featuresMap = value instanceof Map ? (Map)value : (Map)SerializationUtils.fromJsonString((String)((String)value), Map.class);
            features = (Features)new MetadataSerializer(this.getModelType()).deserializeFromMap(featuresMap, null);
        } else {
            features = new Features();
        }
        this.getModel().setValue("copyable", (Object)features.isCopyable());
        this.getModel().setValue(MULTI_FILLABLE, (Object)features.isMultiFillable());
        this.getModel().setValue(F7_BATCH_FILL, (Object)features.isF7BatchFill());
        this.getModel().setValue(IMPORTABLE, (Object)features.isImportable());
        this.getModel().setValue(EXPORTABLE, (Object)features.isExportable());
        this.getModel().setValue(SERIES_NEWTOTE, (Object)features.isSeriesNewTote());
        this.getModel().setValue("bulkeditable", (Object)features.isBulkEditable());
        this.getModel().setValue(CONVERT_TOTE, (Object)features.isConvertTote());
        this.getModel().setValue("allowvoucher", (Object)features.isAllowvoucher());
    }

    private void lockNotEditableFeatures() {
        try {
            String fieldId = (String)this.getView().getFormShowParameter().getCustomParam("itemId");
            String entityId = (String)((Map)((List)((List)this.getView().getFormShowParameter().getCustomParam("context")).get(0)).get(0)).get("Id");
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
            ExtLockTypeEnum lockType = ExtensibleDao.getExtLockType((AbstractMetadata)entityMetadata, (String)"Field", (String)entityMetadata.getModelType(), (String)fieldId, (String)"Features");
            if (ExtLockTypeEnum.speciallock.equals((Object)lockType)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{MULTI_FILLABLE, "copyable", F7_BATCH_FILL, IMPORTABLE, SERIES_NEWTOTE, "bulkeditable", CONVERT_TOTE, "allowvoucher"});
            } else if (ExtLockTypeEnum.lock.equals((Object)lockType)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{MULTI_FILLABLE, "copyable", F7_BATCH_FILL, IMPORTABLE, SERIES_NEWTOTE, "bulkeditable", CONVERT_TOTE, "allowvoucher", EXPORTABLE});
            }
        }
        catch (Exception e) {
            LOG.error("\u83b7\u53d6\u4e1a\u52a1\u5bf9\u8c61\u53ef\u6269\u5c55\u6027\u62a5\u9519\uff1a" + e);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        List formContext = (List)this.getView().getFormShowParameter().getCustomParams().get("context");
        List entities = (List)formContext.get(0);
        Map field = (Map)((List)formContext.get(1)).get(0);
        String fieldType = (String)field.get(TYPE);
        this.hideSeriesnewtote(fieldType);
        this.getView().setVisible(Boolean.valueOf(this.isShowF7BatchFill(field, entities)), new String[]{F7_BATCH_FILL});
        if ("AttachmentCountField".equals(fieldType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"copyable"});
        }
        if ("BasedataPropField".equals(fieldType) || "RichTextField".equals(fieldType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{IMPORTABLE, EXPORTABLE});
            this.getView().getModel().setValue(EXPORTABLE, (Object)false);
            this.getView().getModel().setValue(IMPORTABLE, (Object)false);
        }
        String fieldParentId = (String)field.get("ParentId");
        boolean isHeadField = true;
        for (Map entity : entities) {
            if (!((String)entity.get("Id")).equals(fieldParentId)) continue;
            Object type = entity.get(TYPE);
            if (!"EntryEntity".equals(type) && !"SubEntryEntity".equals(type) && !"TreeEntryEntity".equals(type) && !"TreeSubEntryEntity".equals(type)) break;
            this.getView().setVisible(Boolean.valueOf(true), new String[]{MULTI_FILLABLE});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SERIES_NEWTOTE});
            isHeadField = false;
            break;
        }
        if (isHeadField) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{MULTI_FILLABLE, F7_BATCH_FILL});
        }
    }

    private void hideSeriesnewtote(String fieldType) {
        switch (fieldType) {
            case "LargeTextField": {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{MULTI_FILLABLE});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{SERIES_NEWTOTE});
                break;
            }
            case "RadioField": {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{SERIES_NEWTOTE});
                break;
            }
            default: {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{SERIES_NEWTOTE});
            }
        }
    }

    private boolean isShowF7BatchFill(Map<String, Object> field, List<Map<String, Object>> entities) {
        Object id;
        Optional<Map> optional = entities.stream().filter(item -> item.get("Id").equals(field.get("ParentId"))).findFirst();
        if (optional.isPresent() && optional.get() != null && StringUtils.isNotBlank(id = optional.get().get("Id")) && entities.get(0).get("Id").equals(id)) {
            return false;
        }
        switch (field.get(TYPE).toString()) {
            case "BasedataField": 
            case "UserField": 
            case "OrgField": 
            case "AssistantField": 
            case "CreaterField": 
            case "MaterielField": 
            case "CurrencyField": 
            case "UnitField": 
            case "AdminDivisionField": 
            case "QueryField": 
            case "PersonField": 
            case "HisModelBasedataField": {
                return true;
            }
        }
        return false;
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        if ("btnok".equalsIgnoreCase(btn.getKey())) {
            HashMap<String, Object> para = new HashMap<String, Object>();
            para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
            para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
            para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
            para.put("value", this.getFeatures());
            para.put("alias", new FeaturesConverter().convert(this.getFeatures()));
            this.getView().returnDataToParent(para);
            this.getView().close();
        }
    }

    private Map<String, Object> getFeatures() {
        List formContext = (List)this.getView().getFormShowParameter().getCustomParams().get("context");
        List entities = (List)formContext.get(0);
        Map field = (Map)((List)formContext.get(1)).get(0);
        HashMap<String, Object> features = new HashMap<String, Object>();
        IDataModel model = this.getModel();
        features.put(TYPE, "Features");
        features.put("Copyable", model.getValue("copyable"));
        features.put("MultiFillable", model.getValue(MULTI_FILLABLE));
        if (this.isShowF7BatchFill(field, entities)) {
            features.put("F7BatchFill", model.getValue(F7_BATCH_FILL));
        }
        features.put("Importable", model.getValue(IMPORTABLE));
        features.put("Exportable", model.getValue(EXPORTABLE));
        features.put("SeriesNewTote", model.getValue(SERIES_NEWTOTE));
        features.put("BulkEditable", model.getValue("bulkeditable"));
        features.put("ConvertTote", model.getValue(CONVERT_TOTE));
        features.put("AllowVoucher", model.getValue("allowvoucher"));
        return features;
    }

    private String getModelType() {
        String modelType = (String)this.getView().getFormShowParameter().getCustomParams().get("modelType");
        if (StringUtils.isBlank((CharSequence)modelType)) {
            modelType = "DynamicFormModel";
        }
        return modelType;
    }
}

