/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.designer.property.AbstractPropertyPlugin;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.EntryGrid;

public class FieldIdPlugin
extends AbstractPropertyPlugin {
    private static final String ENTRY_KEY = "fields";
    private static final String ITEM_ID = "itemId";

    public void afterCreateNewData(EventObject e) {
        String itemId;
        List data = (List)this.getView().getFormShowParameter().getCustomParams().get("context");
        List<Map<String, Object>> fields = FieldIdPlugin.getFields(data, itemId = (String)this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
        if (fields.size() > 0) {
            IDataModel model = this.getModel();
            int count = model.getEntryRowCount(ENTRY_KEY);
            if (fields.size() > count) {
                model.batchCreateNewEntryRow(ENTRY_KEY, fields.size() - count);
            }
            int i = 0;
            for (Map<String, Object> field : fields) {
                model.setValue("fid", field.get("Id"), i);
                model.setValue("fkey", field.get("Key"), i);
                model.setValue("fname", field.get("Name"), i);
                ++i;
            }
        }
    }

    public static List<Map<String, Object>> getFields(List<List<Map<String, Object>>> context, String itemId) {
        ArrayList<Map<String, Object>> fields = new ArrayList<Map<String, Object>>(10);
        if (context == null || context.get(1) == null) {
            return fields;
        }
        List<Map<String, Object>> items = context.get(1);
        List<Map<String, Object>> entityitems = context.get(0);
        if (items != null && itemId != null) {
            HashMap<String, Object> itemMap = new HashMap<String, Object>(16);
            for (Map<String, Object> item : items) {
                itemMap.put((String)item.get("Id"), item);
            }
            String entityId = FieldIdPlugin.getEntityId(itemId, itemMap);
            if (entityId != null) {
                for (Map<String, Object> entityitem : entityitems) {
                    if (!entityId.equals(entityitem.get("ParentId"))) continue;
                    fields.add(entityitem);
                }
            }
        }
        return fields;
    }

    public static String getEntityId(String id, Map<String, Object> itemMap) {
        Map item = (Map)itemMap.get(id);
        if (item == null) {
            return null;
        }
        String parentId = (String)item.get("ParentId");
        if (parentId == null) {
            return null;
        }
        Map parentItem = (Map)itemMap.get(parentId);
        if (parentItem == null) {
            return null;
        }
        if ("CardEntryAp".equals(parentItem.get("_Type_"))) {
            return (String)parentItem.get("EntryId");
        }
        return FieldIdPlugin.getEntityId((String)parentItem.get("Id"), itemMap);
    }

    @Override
    protected void returnData() {
        Map<String, Object> row = this.getCurrentSelector();
        if (row != null) {
            ArrayList paras = new ArrayList();
            HashMap<String, Object> para = new HashMap<String, Object>();
            para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
            para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
            para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
            para.put("value", row.get("id"));
            para.put("alias", row.get("name"));
            paras.add(para);
            this.getView().returnDataToParent(paras);
            this.getView().close();
        }
    }

    private Map<String, Object> getCurrentSelector() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_KEY);
        int row = grid.getEntryState().getFocusRow();
        if (this.getModel().getEntryRowCount(ENTRY_KEY) <= 0 || row < 0) {
            return null;
        }
        ret.put("id", (String)this.getModel().getValue("fid", row));
        ret.put("name", (String)this.getModel().getValue("fname", row));
        return ret;
    }
}

