/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;

public class FieldSelectPlugin
extends AbstractFormPlugin
implements TreeNodeQueryListener,
TreeNodeCheckListener,
TreeNodeClickListener {
    private static final String CUST_PARAM_KEY_TREE_NODES = "treenodes";
    private static final String FIELD_TREE = "FieldTree";
    private static final String NODE_MAP = "nodeMap";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok"});
        TreeView tree = (TreeView)this.getView().getControl(FIELD_TREE);
        tree.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        tree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equalsIgnoreCase("btnok")) {
            this.closeAndReturn();
        }
    }

    private void closeAndReturn() {
        if (this.getPageCache().get(NODE_MAP) != null) {
            this.getView().returnDataToParent(SerializationUtils.fromJsonString((String)this.getPageCache().get(NODE_MAP), Map.class));
        }
        this.getView().close();
    }

    public void afterCreateNewData(EventObject e) {
        Object formId = this.getView().getFormShowParameter().getCustomParam("formId");
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
        if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
            formId = entityNumber;
        }
        Object field = this.getView().getFormShowParameter().getCustomParam("field");
        String json = (String)this.getView().getFormShowParameter().getCustomParam(CUST_PARAM_KEY_TREE_NODES);
        TreeNode node = null;
        if (StringUtils.isBlank((CharSequence)json) && StringUtils.isBlank((Object)formId)) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)json)) {
            node = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
        }
        if (StringUtils.isBlank((CharSequence)json) && StringUtils.isNotBlank((Object)formId)) {
            PropTreeBuildOption option = new PropTreeBuildOption();
            option.setIncludePKField(true);
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)((String)formId));
            node = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)type, (PropTreeBuildOption)option);
        }
        TreeView tree = (TreeView)this.getView().getControl(FIELD_TREE);
        tree.addNode(node);
        if (StringUtils.isNotBlank((Object)field)) {
            TreeNode checkedNode;
            TreeNode treeNode = checkedNode = node == null ? null : node.getTreeNode((String)field, 16);
            if (checkedNode != null) {
                tree.focusNode(checkedNode);
            }
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        if (StringUtils.isNotBlank((Object)evt.getNodeId())) {
            TreeView tree = (TreeView)this.getView().getControl(FIELD_TREE);
            Map nodeMap = tree.getTreeState().getFocusNode();
            nodeMap.put("isRefPro", this.getView().getFormShowParameter().getCustomParam("refPro"));
            this.getPageCache().put(NODE_MAP, SerializationUtils.toJsonString((Object)nodeMap));
        }
    }

    public void treeNodeDoubleClick(TreeNodeEvent evt) {
        TreeView tree;
        Map nodeMap;
        if (StringUtils.isNotBlank((Object)evt.getNodeId()) && (nodeMap = (tree = (TreeView)this.getView().getControl(FIELD_TREE)).getTreeState().getFocusNode()).get("isParent") != null && !Boolean.parseBoolean(String.valueOf(nodeMap.get("isParent")))) {
            nodeMap.put("isRefPro", this.getView().getFormShowParameter().getCustomParam("refPro"));
            this.getView().returnDataToParent((Object)nodeMap);
            this.getView().close();
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
    }
}

