/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.FieldSort;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.list.ApproverListColumnAp;
import kd.bos.metadata.list.DynamicTextListColumnAp;
import kd.bos.metadata.list.ListColumnAp;
import kd.bos.metadata.list.ListColumnGroupAp;
import kd.bos.metadata.list.ListOperationColumnAp;
import kd.bos.metadata.list.MergeListColumnAp;
import kd.bos.metadata.list.VoucherNoListColumnAp;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.mservice.svc.attach.IAttachmentField;
import kd.bos.mservice.svc.picture.IPictureListColumnAp;

public class FieldSortConfigPlugin
extends AbstractFormPlugin {
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String CONTEXT = "context";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String FIELD = "field";
    private static final String FSEQ = "fseq";
    private static final String FIELD_NAME = "FieldName";
    private static final String GRIDVIEW = "gridview";
    private static final String SORT_TYPE = "sorttype";
    private static final String SORT_TYPE1 = "SortType";
    private static final String TYPE = "_Type_";
    private static final String VALUE = "value";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        this.addClickListeners(new String[]{"btncancel"});
        super.registerListener(e);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "btnok": {
                this.returnDataToParentAndClose();
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        PropertyEditHelper helper = new PropertyEditHelper();
        this.fillComboEdit(helper);
        List fieldSorts = (List)helper.getParamValue(this.getView(), VALUE);
        if (fieldSorts != null && !fieldSorts.isEmpty()) {
            this.getModel().clearNoDataRow();
            this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, fieldSorts.size());
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(ENTRY_ENTITY);
            int i = 0;
            for (Map fieldSort : fieldSorts) {
                ((DynamicObject)dynamicObjectCollection.get(i)).set(FIELD, fieldSort.get(FIELD_NAME));
                ((DynamicObject)dynamicObjectCollection.get(i)).set(SORT_TYPE, fieldSort.get(SORT_TYPE1));
                ++i;
            }
        }
        super.afterCreateNewData(e);
    }

    private void fillComboEdit(PropertyEditHelper helper) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        List<ControlAp<?>> billListColumnAp = this.getBillListColumnAp(helper);
        HashSet<String> attachmentFieldKey = new HashSet<String>();
        EntityMetadata entityMetadata = FormTreeBuilder.deserializeEntityMetadata(helper.getEntityMeta(this.getView()));
        for (EntityItem item : entityMetadata.getItems()) {
            if (!(item instanceof IAttachmentField)) continue;
            attachmentFieldKey.add(item.getKey());
        }
        List<ControlAp<?>> canSortField = null;
        canSortField = this.filterField(billListColumnAp, attachmentFieldKey);
        HashSet<String> isOnComboEdit = new HashSet<String>();
        if (!canSortField.isEmpty()) {
            for (ControlAp<?> ap : canSortField) {
                String listFieldId = ((ListColumnAp)ap).getListFieldId();
                if (!isOnComboEdit.add(listFieldId)) continue;
                comboItems.add(new ComboItem(ap.getName(), ((ListColumnAp)ap).getListFieldId()));
            }
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl(FIELD);
        comboEdit.setComboItems(comboItems);
    }

    private List<ControlAp<?>> getBillListColumnAp(PropertyEditHelper helper) {
        List context = (List)helper.getParamValue(this.getView(), CONTEXT);
        ArrayList billListColumnAp = new ArrayList();
        if (context != null) {
            FormMetadata listMetadata = FormTreeBuilder.deserialzeFormMetadata((List)context);
            listMetadata.createIndex();
            String gridviewId = listMetadata.getItem(GRIDVIEW).getId();
            for (ControlAp item : listMetadata.getItems()) {
                if (!gridviewId.equals(item.getParentId())) continue;
                billListColumnAp.add(item);
            }
        }
        return billListColumnAp;
    }

    private void traverseGetSubControlAp(ControlAp<?> ap, List<ControlAp<?>> canSortField, Set<String> attachmentFieldKey) {
        List subControlAps = ((ContainerAp)ap).getItems();
        for (ControlAp subControlAp : subControlAps) {
            if (this.isListColumn(subControlAp)) continue;
            if (subControlAp instanceof MergeListColumnAp || subControlAp instanceof ListColumnGroupAp) {
                this.traverseGetSubControlAp(subControlAp, canSortField, attachmentFieldKey);
                continue;
            }
            if (!(subControlAp instanceof ListColumnAp) || FSEQ.equals(((ListColumnAp)subControlAp).getListFieldId()) || attachmentFieldKey.contains(((ListColumnAp)subControlAp).getListFieldId())) continue;
            canSortField.removeIf(item -> ((ListColumnAp)subControlAp).getListFieldId().equals(((ListColumnAp)item).getListFieldId()));
            canSortField.add(subControlAp);
        }
    }

    private List<ControlAp<?>> filterField(List<ControlAp<?>> billListColumnAp, Set<String> attachmentFieldKey) {
        ArrayList canSortField = new ArrayList();
        for (ControlAp<?> ap : billListColumnAp) {
            if (this.isListColumn(ap)) continue;
            if (ap instanceof MergeListColumnAp || ap instanceof ListColumnGroupAp) {
                this.traverseGetSubControlAp(ap, canSortField, attachmentFieldKey);
                continue;
            }
            if (!(ap instanceof ListColumnAp) || FSEQ.equals(((ListColumnAp)ap).getListFieldId()) || this.isAttachmentField(ap, attachmentFieldKey)) continue;
            canSortField.removeIf(item -> ((ListColumnAp)ap).getListFieldId().equals(((ListColumnAp)item).getListFieldId()));
            canSortField.add(ap);
        }
        return canSortField;
    }

    private boolean isAttachmentField(ControlAp<?> controlAp, Set<String> attachmentFieldKey) {
        String listFieldId = ((ListColumnAp)controlAp).getListFieldId();
        String[] splitListFieldId = listFieldId.split("\\.");
        return attachmentFieldKey.contains(splitListFieldId[0]);
    }

    private void returnDataToParentAndClose() {
        Map<String, Object> fieldLocaleStrings = this.getSortFieldLocaleString();
        boolean hasDeletadField = this.hasDeletedField(fieldLocaleStrings);
        if (hasDeletadField) {
            return;
        }
        HashMap<String, Object> para = new HashMap<String, Object>(16);
        StringBuilder sortAlias = new StringBuilder();
        List<Map<String, Object>> value = this.returnValueData(fieldLocaleStrings, sortAlias);
        if (value == null) {
            return;
        }
        if (!value.isEmpty()) {
            para.put(VALUE, value);
        }
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        para.put("alias", sortAlias.toString());
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    private boolean hasDeletedField(Map<String, Object> fieldLocaleStrings) {
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(ENTRY_ENTITY);
        HashSet<String> errorMsg = new HashSet<String>();
        HashMap cacheBaseDataField = new HashMap(16);
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String fieldId;
            Map fieldName;
            if (!StringUtils.isNotBlank((CharSequence)dynamicObject.getString(FIELD)) || (fieldName = (Map)fieldLocaleStrings.get(fieldId = dynamicObject.getString(FIELD))) != null) continue;
            EntityMetadata entityMetadata = FormTreeBuilder.deserializeEntityMetadata(new PropertyEditHelper().getEntityMeta(this.getView()));
            String[] fieldIdArray = fieldId.split("\\.");
            if (fieldIdArray.length > 1) {
                if (StringUtils.isNotBlank(cacheBaseDataField.get(fieldId))) {
                    errorMsg.add("\u201c" + cacheBaseDataField.get(fieldId) + fieldId + "\u201d");
                    continue;
                }
                BasedataField basedataField = (BasedataField)entityMetadata.getFieldByKey(fieldIdArray[0]);
                List entityTreeNodes = basedataField.createEntityTreeNodes(true, fieldIdArray.length);
                for (Map entityTreeNode : entityTreeNodes) {
                    cacheBaseDataField.put(entityTreeNode.get("Id").toString(), entityTreeNode.get("Name"));
                }
                errorMsg.add("\u201c" + cacheBaseDataField.get(fieldId) + fieldId + "\u201d");
                continue;
            }
            errorMsg.add("\u201c" + entityMetadata.getFieldByKey(fieldId).getName().getLocaleValue() + fieldId + "\u201d");
        }
        if (!errorMsg.isEmpty()) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6392\u5e8f\u5b57\u6bb5%s\u4e0d\u5b58\u5728\uff0c\u8bf7\u5728\u3010\u6392\u5e8f\u8bbe\u7f6e\u3011\u4e2d\u5220\u9664\u8be5\u5b57\u6bb5\u3002", (String)"FieldSortConfigPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), String.join((CharSequence)"\u3001", errorMsg)));
            return true;
        }
        return false;
    }

    private List<Map<String, Object>> returnValueData(Map<String, Object> fieldLocaleStrings, StringBuilder sortAlias) {
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(ENTRY_ENTITY);
        ArrayList<Map<String, Object>> value = new ArrayList<Map<String, Object>>();
        ArrayList<String> isContainField = new ArrayList<String>();
        HashMap<String, String> fieldSortValue = null;
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String field;
            Map fieldName;
            if (!StringUtils.isNotBlank((CharSequence)dynamicObject.getString(FIELD)) || !StringUtils.isNotBlank((CharSequence)dynamicObject.getString(SORT_TYPE)) || (fieldName = (Map)fieldLocaleStrings.get(field = dynamicObject.getString(FIELD))) == null) continue;
            LocaleString fieldLocaleString = LocaleString.fromMap((Map)fieldName);
            if (!isContainField.contains(field)) {
                isContainField.add(field);
                fieldSortValue = new HashMap<String, String>();
                fieldSortValue.put(FIELD_NAME, field);
                fieldSortValue.put(SORT_TYPE1, dynamicObject.getString(SORT_TYPE));
                fieldSortValue.put(TYPE, FieldSort.class.getSimpleName());
                value.add(fieldSortValue);
                sortAlias.append(sortAlias.length() == 0 ? sortAlias.toString() : "; ").append(fieldLocaleString.getLocaleValue());
                continue;
            }
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s \u5b57\u6bb5\u6392\u5e8f\u91cd\u590d\uff0c\u8bf7\u5220\u9664\u91cd\u590d\u5b57\u6bb5\u3002", (String)"FieldSortConfigPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), fieldLocaleString.getLocaleValue()));
            return null;
        }
        return value;
    }

    private Map<String, Object> getSortFieldLocaleString() {
        PropertyEditHelper helper = new PropertyEditHelper();
        HashSet<String> attachmentFieldKey = new HashSet<String>();
        EntityMetadata entityMetadata = FormTreeBuilder.deserializeEntityMetadata(helper.getEntityMeta(this.getView()));
        for (EntityItem item : entityMetadata.getItems()) {
            if (!(item instanceof IAttachmentField)) continue;
            attachmentFieldKey.add(item.getKey());
        }
        List<ControlAp<?>> canSortField = this.filterField(this.getBillListColumnAp(helper), attachmentFieldKey);
        HashMap<String, Object> fieldLocaleStrings = new HashMap<String, Object>(canSortField.size());
        for (ControlAp<?> ap : canSortField) {
            fieldLocaleStrings.put(((ListColumnAp)ap).getListFieldId(), ap.getName());
        }
        return fieldLocaleStrings;
    }

    private boolean isListColumn(ControlAp<?> ap) {
        return ap instanceof IPictureListColumnAp || ap instanceof DynamicTextListColumnAp || ap instanceof ListOperationColumnAp || ap instanceof VoucherNoListColumnAp || ap instanceof ApproverListColumnAp;
    }
}

