/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.dao.FormTemplateFactory;
import kd.bos.designer.dao.IFormTemplate;
import kd.bos.devportal.common.util.DesignerUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.GetFilterFieldsParameter;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.CompareTypeDto;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterBuilderParameter;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.EntityMetadataUtil;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.AbstractBasedataField;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.businessfield.ParentBasedataField;
import kd.bos.metadata.entity.businessfield.RefBillField;
import kd.bos.metadata.extensible.ExtLockTypeEnum;
import kd.bos.metadata.extensible.ExtensibleDao;
import kd.bos.metadata.filter.CommonBaseDataFilterColumnAp;
import kd.bos.metadata.filter.CustomBaseDataFilterColumnAp;
import kd.bos.metadata.filter.SchemeBaseDataFilterColumnAp;
import kd.bos.metadata.list.BillListAp;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;

public class FiltersNewPlugin
extends AbstractFormPlugin {
    private static final String CONTEXT = "context";
    private static final String FILTER_GRIDAP = "filtergridap";
    private static final String FOR_LIST = "forlist";
    private static final String ENTITY_ID = "entityId";
    FilterCondition filterCondition;

    public void initialize() {
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addClickListeners(new String[]{"btnok"});
        this.addClickListeners(new String[]{"btncancel"});
        super.initialize();
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "btnok": {
                this.closeAndreturnData();
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
        }
    }

    private void closeAndreturnData() {
        FilterCondition myFilterCondition = this.createCondition();
        List<Map<String, Object>> filterColumns = this.getFilterColumns();
        block0: for (SimpleFilterRow simpleFilterRow : myFilterCondition.getFilterRow()) {
            for (Map<String, Object> map : filterColumns) {
                String fieldName = (String)map.get("fieldName");
                String compareType = simpleFilterRow.getCompareType();
                if (!fieldName.equals(simpleFilterRow.getFieldName())) continue;
                List compareTypeDtos = (List)map.get("compareTypes");
                for (CompareTypeDto compareTypeDto : compareTypeDtos) {
                    if (!compareType.equals(compareTypeDto.getId()) || !compareTypeDto.isFieldCompare()) continue;
                    FilterValue filterValue = (FilterValue)simpleFilterRow.getValue().get(0);
                    filterValue.setValue((Object)String.format("GetValue(%s)", filterValue.getValue()));
                    continue block0;
                }
                continue block0;
            }
        }
        String modelType = "DynamicFormModel";
        IFormTemplate template = FormTemplateFactory.createTemplate(modelType);
        Map<String, Object> entityItem = template.serializeToMap(myFilterCondition);
        HashMap para = new HashMap();
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        para.put("value", entityItem);
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    public void itemClick(ItemClickEvent evt) {
        if ("createcondition".equals(evt.getItemKey())) {
            this.createCondition();
        }
        super.itemClick(evt);
    }

    private EntityMetadata getEntityMetadata() {
        List formContext = (List)this.getView().getFormShowParameter().getCustomParams().get(CONTEXT);
        List context = (List)formContext.get(0);
        return EntityMetadataUtil.getEntityMetadata((List)context);
    }

    private List<Map<String, Object>> getFilterColumns() {
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        MainEntityType entityType = this.getBaseEntityType();
        if (null == entityType) {
            return new ArrayList<Map<String, Object>>();
        }
        Object sourceControl = this.getSourceControl();
        boolean isNeedCompareTypeField = !(sourceControl instanceof CommonBaseDataFilterColumnAp) && !(sourceControl instanceof SchemeBaseDataFilterColumnAp) && !(sourceControl instanceof BillListAp);
        GetFilterFieldsParameter getFilterFieldsParameter = new GetFilterFieldsParameter((IDataEntityType)entityType);
        getFilterFieldsParameter.setNeedMulBasedataField(true);
        getFilterFieldsParameter.setNeedFieldCompareType(isNeedCompareTypeField);
        getFilterFieldsParameter.setbCompatibleProductMode(false);
        getFilterFieldsParameter.setNeedBasedataIdField(true);
        return EntityTypeUtil.createFilterColumns((GetFilterFieldsParameter)getFilterFieldsParameter);
    }

    public void beforeBindData(EventObject e) {
        this.initFilterCondition();
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTER_GRIDAP);
        MainEntityType entityType = this.getBaseEntityType();
        if (entityType == null) {
            throw new KDException(BosErrorCode.metaNotFound, new Object[]{ResManager.loadKDString((String)"\u5b9e\u4f53\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u9875\u9762\u521d\u59cb\u5316\u5931\u8d25\u3002", (String)"FiltersNewPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0])});
        }
        filterGrid.setEntityNumber(entityType.getName());
        filterGrid.setFilterColumns(this.getFilterColumns());
        EntityMetadata entityMetadata = this.getEntityMetadata();
        EntityMetadataUtil entityMetadataUtil = new EntityMetadataUtil();
        List fieldColumns = entityMetadataUtil.getFilterColumns(entityMetadata);
        filterGrid.setFieldColumns(fieldColumns);
        if (this.filterCondition != null) {
            this.getModel().setValue(FOR_LIST, (Object)this.filterCondition.isForList());
        }
        super.beforeBindData(e);
    }

    private void initFilterCondition() {
        Object valJson = null;
        Object value = this.getView().getFormShowParameter().getCustomParams().get("value");
        if (value != null && !StringUtils.isEmpty((CharSequence)value.toString())) {
            valJson = value;
        }
        if (valJson == null) {
            return;
        }
        if (!(valJson instanceof Map)) {
            return;
        }
        Map filterConditionMap = valJson;
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(FilterCondition.class));
        dts.add(OrmUtils.getDataEntityType(SimpleFilterRow.class));
        DcJsonSerializer ser = new DcJsonSerializer(dts);
        this.filterCondition = (FilterCondition)ser.deserializeFromMap(filterConditionMap, null);
    }

    private void setFilterCondition() {
        if (this.filterCondition == null) {
            return;
        }
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTER_GRIDAP);
        List<Map<String, Object>> filterColumns = this.getFilterColumns();
        block0: for (SimpleFilterRow simpleFilterRow : this.filterCondition.getFilterRow()) {
            for (Map<String, Object> map : filterColumns) {
                String fieldName = (String)map.get("fieldName");
                String compareType = simpleFilterRow.getCompareType();
                if (!fieldName.equals(simpleFilterRow.getFieldName())) continue;
                List compareTypeDtos = (List)map.get("compareTypes");
                for (CompareTypeDto compareTypeDto : compareTypeDtos) {
                    if (!compareType.equals(compareTypeDto.getId()) || !compareTypeDto.isFieldCompare()) continue;
                    FilterValue filterValue = (FilterValue)simpleFilterRow.getValue().get(0);
                    filterValue.setValue((Object)filterValue.getValue().toString().replace("GetValue(", "").replace(")", ""));
                    continue block0;
                }
                continue block0;
            }
        }
        Set oriBaseDataFilterRowIds = new HashSet();
        String str = this.getPageCache().get("oriBaseDataFilterRowIds");
        if (StringUtils.isNotBlank((CharSequence)str)) {
            oriBaseDataFilterRowIds = (Set)SerializationUtils.fromJsonString((String)str, Set.class);
        }
        HashSet finalOriBaseDataFilterRowIds = oriBaseDataFilterRowIds;
        this.filterCondition.getFilterRow().forEach(row -> {
            if (finalOriBaseDataFilterRowIds.contains(row.getId())) {
                row.setLock(true);
            }
        });
        filterGrid.SetValue(this.filterCondition);
    }

    public void afterBindData(EventObject e) {
        this.setFilterCondition();
        this.setEncoding();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setFilterGridLock();
    }

    private void setEncoding() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTER_GRIDAP);
        filterGrid.setEncoding();
    }

    private void setFilterGridLock() {
        String itemId = (String)this.getView().getFormShowParameter().getCustomParam("itemId");
        List context = (List)this.getView().getFormShowParameter().getCustomParam(CONTEXT);
        if (context == null || context.isEmpty()) {
            return;
        }
        String entityId = (String)((Map)((List)context.get(0)).get(0)).get("Id");
        if (StringUtils.isBlank((CharSequence)entityId)) {
            return;
        }
        EntityMetadata metadata = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        ExtLockTypeEnum opLockType = ExtensibleDao.getExtLockType((AbstractMetadata)metadata, (String)"Field", (String)metadata.getModelType(), (String)itemId, (String)"Filter");
        this.updateControlLock(ExtLockTypeEnum.speciallock == opLockType || ExtLockTypeEnum.lock == opLockType);
        HashSet<String> oriBaseDataFilterRowIds = new HashSet<String>(16);
        if (ExtLockTypeEnum.speciallock.equals((Object)opLockType) || ExtLockTypeEnum.lock.equals((Object)opLockType)) {
            FilterCondition filter;
            List isvList = DesignerUtils.ISV_LIST;
            EntityItem entityItem = metadata.getItemById(itemId);
            if (entityItem instanceof AbstractBasedataField && (filter = ((AbstractBasedataField)entityItem).getFilter()) != null) {
                List filterRows = filter.getFilterRow();
                for (SimpleFilterRow filterRow : filterRows) {
                    if (!isvList.contains(filterRow.getIsv()) || StringUtils.equals((CharSequence)filterRow.getIsv(), (CharSequence)metadata.getIsv())) continue;
                    oriBaseDataFilterRowIds.add(filterRow.getId());
                }
            }
        }
        this.getPageCache().put("oriBaseDataFilterRowIds", SerializationUtils.toJsonString(oriBaseDataFilterRowIds));
    }

    private void updateControlLock(boolean dragDisabled) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>(2);
        dataMap.put("k", FILTER_GRIDAP);
        dataMap.put("dragDisabled", dragDisabled);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.addAction("u", dataMap);
    }

    private FilterCondition createCondition() {
        MainEntityType dataType = this.getBaseEntityType();
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTER_GRIDAP);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterBuilder filterBuilder = new FilterBuilder(new FilterBuilderParameter(dataType, filterGridState.getFilterCondition()).setCheckInput(true).setNeedParseBaseDataIds(true));
        filterBuilder.setTimeService((ITimeService)this.getView().getService(ITimeService.class));
        filterBuilder.setUserService((IUserService)this.getView().getService(IUserService.class));
        EntityMetadata entityMetadata = this.getEntityMetadata();
        EntityMetadataUtil entityMetadataUtil = new EntityMetadataUtil();
        List compareFields = entityMetadataUtil.getFilterFields(entityMetadata);
        filterBuilder.getFilterObject().addCompareFileds(compareFields);
        filterBuilder.buildFilter(false);
        filterGridState.getFilterCondition().setFilter(filterBuilder.getFilterObject().getFilter());
        this.getModel().setValue("fdescription", (Object)filterBuilder.getFilterObject().getFilter());
        FilterCondition filterCondition2 = filterGridState.getFilterCondition();
        filterCondition2.setForList(((Boolean)this.getModel().getValue(FOR_LIST)).booleanValue());
        return filterCondition2;
    }

    private MainEntityType getBaseEntityType() {
        String entityId = "";
        if (this.getPageCache().get(ENTITY_ID) == null) {
            List contextList = (List)this.getView().getFormShowParameter().getCustomParams().get(CONTEXT);
            List item = (List)contextList.get(1);
            if (item == null || item.isEmpty()) {
                return null;
            }
            entityId = this.getEntityId(contextList, item);
            if (StringUtils.isBlank((CharSequence)entityId)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u672a\u8bbe\u7f6e\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u3002", (String)"FiltersNewPlugin_1", (String)"bos-designer-plugin", (Object[])new Object[0]), ((Map)item.get(0)).get("Name")));
            }
            this.getPageCache().put(ENTITY_ID, entityId);
        } else {
            entityId = this.getPageCache().get(ENTITY_ID);
        }
        try {
            return EntityMetadataCache.getDataEntityTypeById((String)entityId);
        }
        catch (Exception ex) {
            throw new KDException(BosErrorCode.metaNotFound, new Object[]{String.format(ResManager.loadKDString((String)"entityId\u4e3a%1$s\u7684\u5b9e\u4f53\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"EntityMetadataCache_0", (String)"bos-entity-metadata", (Object[])new Object[0]), entityId)});
        }
    }

    private String getEntityId(List<List<Map<String, Object>>> contextList, List<Map<String, Object>> item) {
        String modelType = (String)this.getView().getFormShowParameter().getCustomParams().get("modelType");
        String entityId = "";
        Object ctrl = this.getSourceControl(item);
        if (ctrl instanceof MulBasedataField) {
            MulBasedataField fld = (MulBasedataField)ctrl;
            entityId = fld.getBaseEntityId();
        } else if (ctrl instanceof CustomBaseDataFilterColumnAp) {
            entityId = ((CustomBaseDataFilterColumnAp)ctrl).getBaseEntityId();
        } else if (ctrl instanceof CommonBaseDataFilterColumnAp) {
            entityId = ((CommonBaseDataFilterColumnAp)ctrl).getBaseEntityId();
        } else if (ctrl instanceof SchemeBaseDataFilterColumnAp) {
            entityId = ((SchemeBaseDataFilterColumnAp)ctrl).getBaseEntityId();
            String id = MetadataDao.getIdByNumber((String)entityId, (MetaCategory)MetaCategory.Entity);
            if (StringUtils.isNotBlank((CharSequence)id)) {
                entityId = id;
            }
        } else if (ctrl instanceof BillListAp) {
            entityId = ((BillListAp)ctrl).getEntityId();
        } else if (ctrl instanceof ParentBasedataField) {
            List<Map<String, Object>> listCustData = contextList.get(0);
            for (Map<String, Object> map : listCustData) {
                String type = (String)map.get("_Type_");
                if (!"BaseEntity".equals(type)) continue;
                entityId = (String)map.get("Id");
                break;
            }
        } else if (ctrl instanceof BasedataField) {
            BasedataField fld = (BasedataField)ctrl;
            entityId = fld.getBaseEntityId();
        } else if (ctrl instanceof RefBillField) {
            RefBillField fld = (RefBillField)ctrl;
            entityId = fld.getBillEntityId();
        }
        if (!"BaseFormModel".equals(modelType) && !"BillFormModel".equals(modelType) || !(ctrl instanceof BasedataField) && !(ctrl instanceof MulBasedataField) && !(ctrl instanceof RefBillField)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FOR_LIST});
        }
        return MetadataDao.getMasterId((String)entityId);
    }

    private Object getSourceControl() {
        List contextList = (List)this.getView().getFormShowParameter().getCustomParams().get(CONTEXT);
        List item = (List)contextList.get(1);
        if (item == null || item.isEmpty()) {
            return null;
        }
        return this.getSourceControl(item);
    }

    private Object getSourceControl(List<Map<String, Object>> item) {
        String modelType = (String)this.getView().getFormShowParameter().getCustomParams().get("modelType");
        IFormTemplate template = FormTemplateFactory.createTemplate(modelType);
        return template.deserializeFromMap(item.get(0), null);
    }
}

