/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;

public class FullTextIndexPlugin
extends AbstractFormPlugin
implements ICloseCallBack {
    private static final String F_FIELD_NAME = "ffieldname";
    private static final String F_ENTITY_NUMBER = "fentitynumber";
    private static final String IDE_LIST_FIELDID = "ide_listfieldid";

    public void registerListener(EventObject e) {
        TextEdit fieldnameedit = (TextEdit)this.getControl(F_FIELD_NAME);
        fieldnameedit.addButtonClickListener((ClickListener)this);
        super.registerListener(e);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (F_FIELD_NAME.equalsIgnoreCase(key.toLowerCase())) {
            if (this.getModel().getValue(F_ENTITY_NUMBER) == null) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5b9e\u4f53\u5bf9\u8c61", (String)"FullTextIndexPlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
                return;
            }
            this.showForm();
        }
    }

    public void propertyChanged(PropertyChangedArgs propertychangedargs) {
        if (propertychangedargs.getProperty().getName().equalsIgnoreCase(F_ENTITY_NUMBER)) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityTypeById((String)((DynamicObject)this.getModel().getValue(F_ENTITY_NUMBER)).getString("dentityid"));
            if (mainEntityType instanceof BasedataEntityType) {
                ArrayList<String> fieldList = new ArrayList<String>();
                BasedataEntityType basedataEntityType = (BasedataEntityType)mainEntityType;
                if (StringUtils.isNotEmpty((CharSequence)basedataEntityType.getNumberProperty())) {
                    fieldList.add(basedataEntityType.getNumberProperty());
                }
                if (StringUtils.isNotEmpty((CharSequence)basedataEntityType.getNameProperty())) {
                    fieldList.add(basedataEntityType.getNameProperty());
                }
                this.getModel().setValue(F_FIELD_NAME, (Object)StringUtils.join((Object[])fieldList.toArray(), (char)','));
            } else if (mainEntityType instanceof BillEntityType) {
                BillEntityType billEntityType = (BillEntityType)mainEntityType;
                if (StringUtils.isNotEmpty((CharSequence)billEntityType.getBillNo())) {
                    this.getModel().setValue(F_FIELD_NAME, (Object)billEntityType.getBillNo());
                } else {
                    this.getModel().setValue(F_FIELD_NAME, (Object)"");
                }
            } else {
                this.getModel().setValue(F_FIELD_NAME, (Object)"");
            }
        }
    }

    private void showForm() {
        DynamicObject entityObject = (DynamicObject)this.getModel().getValue(F_ENTITY_NUMBER);
        String entityId = entityObject.getString("dentityid");
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(IDE_LIST_FIELDID);
        parameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u7d22\u5f15\u5b57\u6bb5", (String)"FullTextIndexPlugin_1", (String)"bos-designer-plugin", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, IDE_LIST_FIELDID);
        parameter.setCloseCallBack(closeCallBack);
        parameter.setCustomParam("entityId", (Object)entityId);
        parameter.setCustomParam("isMulti", (Object)true);
        parameter.setCustomParam("isNeedSeq", (Object)false);
        parameter.setCustomParam("isNeedBaseData", (Object)false);
        parameter.setCustomParam("checkedFields", this.getModel().getValue(F_FIELD_NAME));
        ArrayList<String> fieldTypes = new ArrayList<String>();
        fieldTypes.add("text");
        fieldTypes.add("localetext");
        fieldTypes.add("textarea");
        parameter.setCustomParam("fieldTypes", fieldTypes);
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (IDE_LIST_FIELDID.equals(e.getActionId())) {
            List fieldList = (List)e.getReturnData();
            if (fieldList == null) {
                return;
            }
            this.getModel().setValue(F_FIELD_NAME, ((Map)fieldList.get(0)).get("value"));
        }
    }
}

