/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.designer.property.AbstractEntityTreePlugin;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityInfo;
import kd.bos.entity.MainEntityInfoQuery;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.fulltext.FTStatuEnum;
import kd.bos.fulltext.FullTextFactory;
import kd.bos.fulltext.MonitorValue;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.ORM;
import kd.bos.orm.dataentity.FullTextSync;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.fulltext.FullTextIndex;
import kd.bos.orm.query.fulltext.FullTextIndexQuery;
import kd.bos.service.ITimeService;
import kd.bos.servicehelper.FullTextIndexHelper;

public class FullTextIndexTreeListPlugin
extends AbstractEntityTreePlugin
implements IConfirmCallBack {
    protected static final String BTNINITORCREATEINDEXES = "initorcreateindexes";
    protected static final String BTNSYNCDATA = "syncdata";
    private static final String FFIELD_NAME = "ffieldname";
    private static final String FENTITY_NUMBER_NUMBER = "fentitynumber.number";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    Map<String, List<MonitorValue>> monitorValueMap;

    private Map<Object, DynamicObject> getSelectedObjectMap(ListSelectedRowCollection listSelectedRowCollection) {
        ArrayList<Object> pkObjects = new ArrayList<Object>();
        for (ListSelectedRow listSelectedRow : listSelectedRowCollection) {
            pkObjects.add(listSelectedRow.getPrimaryKeyValue());
        }
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("id");
        properties.add(FFIELD_NAME);
        properties.add(FENTITY_NUMBER_NUMBER);
        DynamicObjectType subDataEntityType = EntityMetadataCache.getSubDataEntityType((String)((IListView)this.getView()).getListModel().getDataEntityType().getName(), properties);
        return this.getModel().loadReferenceDataBatch(subDataEntityType, pkObjects.toArray(new Object[0]));
    }

    private List<MainEntityInfo> getSelectedMainEntityInfos() {
        ListSelectedRowCollection listSelectedRowCollection = ((IListView)this.getView()).getSelectedRows();
        Map<Object, DynamicObject> dynamicObjectMap = this.getSelectedObjectMap(listSelectedRowCollection);
        ArrayList<String> entityNames = new ArrayList<String>(10);
        for (Map.Entry<Object, DynamicObject> entry : dynamicObjectMap.entrySet()) {
            String entityNumber = entry.getValue().getString(FENTITY_NUMBER_NUMBER);
            entityNames.add(entityNumber);
        }
        MainEntityInfoQuery mainEntityInfoQuery = new MainEntityInfoQuery();
        return mainEntityInfoQuery.getMainEntityInfoList(entityNames.toArray(new String[0]), RequestContext.get().getLang());
    }

    private static List<MainEntityInfo> getMainEntityInfoList() {
        MainEntityInfoQuery mainEntityInfoQuery = new MainEntityInfoQuery();
        return mainEntityInfoQuery.getMainEntityInfoList();
    }

    private List<MainEntityInfo> copyOrGetAllMainEntityInfos(List<MainEntityInfo> mainEntityInfos) {
        ArrayList<MainEntityInfo> newMainEntityInfos = new ArrayList<MainEntityInfo>();
        if (mainEntityInfos.isEmpty()) {
            newMainEntityInfos = FullTextIndexTreeListPlugin.getMainEntityInfoList();
        } else {
            newMainEntityInfos.addAll(mainEntityInfos);
        }
        return newMainEntityInfos;
    }

    private void initOrCreateIndexes() {
        ArrayList<FullTextIndex> newFullTextIndexs = new ArrayList<FullTextIndex>();
        FullTextIndexQuery fullTextIndexQuery = new FullTextIndexQuery();
        if (!fullTextIndexQuery.isFullTextIndexesExist()) {
            FullTextSync.createAllBillNoIndex();
        }
        HashMap<String, MainEntityType> mainEntityTypeMap = new HashMap<String, MainEntityType>();
        CyclicBarrier cyclicBarrier = new CyclicBarrier(1, () -> {
            ITimeService timeService = (ITimeService)this.getView().getService(ITimeService.class);
            FullTextIndexHelper.syncData((List)newFullTextIndexs, (ITimeService)timeService, (Map)mainEntityTypeMap);
        });
        List fullTextIndexs = fullTextIndexQuery.getFullTextIndexes();
        List<MainEntityInfo> newMainEntityInfos = this.copyOrGetAllMainEntityInfos(this.getSelectedMainEntityInfos());
        Log log = LogFactory.getLog((String)"FullTextIndexTreeListPlugin");
        for (MainEntityInfo mainEntityInfo : newMainEntityInfos) {
            MainEntityType mainEntityType = null;
            ArrayList<String> properties = new ArrayList<String>();
            properties.add(mainEntityInfo.getNumberFieldKey());
            properties.add(mainEntityInfo.getNameFieldKey());
            try {
                mainEntityType = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)mainEntityInfo.getId(), properties);
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u4e3b\u5b9e\u4f53\u7c7b\u578b\u5931\u8d25" + mainEntityInfo.getId());
            }
            if (mainEntityType == null || mainEntityTypeMap.containsKey(mainEntityInfo.getId())) continue;
            mainEntityTypeMap.put(mainEntityInfo.getId(), mainEntityType);
        }
        InitOrCreateIndexesThread initOrCreateIndexes = new InitOrCreateIndexesThread(newFullTextIndexs, fullTextIndexs, RequestContext.get(), cyclicBarrier, mainEntityTypeMap);
        initOrCreateIndexes.start();
    }

    private void syncData() {
        ITimeService timeService = (ITimeService)this.getView().getService(ITimeService.class);
        List<FullTextIndex> fullTextIndexs = new ArrayList();
        ListSelectedRowCollection listSelectedRowCollection = ((IListView)this.getView()).getSelectedRows();
        Map<Object, DynamicObject> dynamicObjectMap = this.getSelectedObjectMap(listSelectedRowCollection);
        if (dynamicObjectMap.isEmpty()) {
            FullTextIndexQuery fullTextIndexQuery = new FullTextIndexQuery();
            fullTextIndexs = fullTextIndexQuery.getFullTextIndexes();
        } else {
            for (Map.Entry<Object, DynamicObject> entry : dynamicObjectMap.entrySet()) {
                String selectFields = entry.getValue().getString(FFIELD_NAME);
                String entityNumber = entry.getValue().getString(FENTITY_NUMBER_NUMBER);
                Long pkId = entry.getValue().getLong("id");
                FullTextIndex fullTextIndex = new FullTextIndex(entityNumber, selectFields);
                fullTextIndex.setId(pkId.longValue());
                fullTextIndexs.add(fullTextIndex);
            }
        }
        FullTextIndexHelper.syncData(fullTextIndexs, (ITimeService)timeService, new HashMap());
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        if (BTNINITORCREATEINDEXES.equalsIgnoreCase(evt.getItemKey())) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(BTNINITORCREATEINDEXES, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6216\u91cd\u5efa\u9700\u8981\u8f83\u957f\u65f6\u95f4\uff0c\u5e76\u4f1a\u5f71\u54cd\u73b0\u6709\u641c\u7d22\u529f\u80fd\u3002\u662f\u5426\u786e\u8ba4\u8fdb\u884c\u6b64\u64cd\u4f5c\uff1f", (String)"FullTextIndexTreeListPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBackListener);
        } else if (BTNSYNCDATA.equalsIgnoreCase(evt.getItemKey())) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(BTNSYNCDATA, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u540c\u6b65\u6570\u636e\u53ef\u80fd\u9700\u8981\u8f83\u957f\u65f6\u95f4\uff0c\u5e76\u4f1a\u5f71\u54cd\u73b0\u6709\u641c\u7d22\u529f\u80fd\u3002\u662f\u5426\u786e\u8ba4\u540c\u6b65\u6570\u636e\uff1f", (String)"FullTextIndexTreeListPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBackListener);
        }
    }

    public void afterBindData(EventObject e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnnew", "btnedit", "btndel"});
        super.afterBindData(e);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection dynamicObjectCollection = super.getData(start, limit);
                ArrayList<String> entityNumbers = new ArrayList<String>();
                for (DynamicObject dynamicObject : dynamicObjectCollection) {
                    if (dynamicObject.getString(FullTextIndexTreeListPlugin.FENTITY_NUMBER_NUMBER) == null) continue;
                    entityNumbers.add(dynamicObject.getString(FullTextIndexTreeListPlugin.FENTITY_NUMBER_NUMBER));
                }
                if (!entityNumbers.isEmpty()) {
                    FullTextIndexTreeListPlugin.this.monitorValueMap = FullTextFactory.getFullTextMonitor().entityNamesMonitor(entityNumbers.toArray(new String[0]));
                }
                return dynamicObjectCollection;
            }
        });
        super.beforeCreateListDataProvider(args);
    }

    private String convertStatusToChinese(FTStatuEnum ftStatus) {
        if (ftStatus == null) {
            return "";
        }
        String status = ResManager.loadKDString((String)"\u672a\u77e5", (String)"FullTextIndexTreeListPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
        switch (ftStatus) {
            case ADDED: {
                status = ResManager.loadKDString((String)"\u65b0\u589e\u7d22\u5f15\u5b8c\u6210", (String)"FullTextIndexTreeListPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
                break;
            }
            case ADDING: {
                status = ResManager.loadKDString((String)"\u6dfb\u52a0\u7d22\u5f15\u4e2d", (String)"FullTextIndexTreeListPlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
                break;
            }
            case ADDERROR: {
                status = ResManager.loadKDString((String)"\u65b0\u589e\u7d22\u5f15\u5931\u8d25", (String)"FullTextIndexTreeListPlugin_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
                break;
            }
            case DELETED: {
                status = ResManager.loadKDString((String)"\u5220\u9664\u5b8c\u6210", (String)"FullTextIndexTreeListPlugin_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
                break;
            }
            case DELETING: {
                status = ResManager.loadKDString((String)"\u5220\u9664\u7d22\u5f15\u4e2d", (String)"FullTextIndexTreeListPlugin_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
                break;
            }
            case DELETEERROR: {
                status = ResManager.loadKDString((String)"\u5220\u9664\u7d22\u5f15\u5931\u8d25", (String)"FullTextIndexTreeListPlugin_8", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
                break;
            }
        }
        return status;
    }

    public void packageData(PackageDataEvent e) {
        String entityNumber = e.getRowData().getString(FENTITY_NUMBER_NUMBER);
        String selectFields = e.getRowData().getString(FFIELD_NAME);
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        if ("fstatus".equalsIgnoreCase(columnDesc.getFieldKey()) && this.monitorValueMap != null && this.monitorValueMap.containsKey(entityNumber)) {
            StringBuilder stringBuilder = new StringBuilder();
            List<MonitorValue> monitorValues = this.monitorValueMap.get(entityNumber);
            HashMap<String, List<String>> map = new HashMap<String, List<String>>();
            for (String selectField : selectFields.split(",")) {
                for (MonitorValue monitorValue : monitorValues) {
                    this.packageRowData(map, selectField, monitorValue);
                }
            }
            for (Map.Entry entry : map.entrySet()) {
                stringBuilder.append(String.format("%s%s ", String.join((CharSequence)",", (Iterable)entry.getValue()), entry.getKey()));
            }
            e.setFormatValue((Object)stringBuilder);
        }
        super.packageData(e);
    }

    private void packageRowData(Map<String, List<String>> map, String selectField, MonitorValue monitorValue) {
        if (this.hasStatus(selectField, monitorValue)) {
            String propertyName = monitorValue.getPropertyName().equalsIgnoreCase(selectField + "_py") ? selectField + "_py" : selectField;
            String convertStatusToChinese = monitorValue.getStatus().toString();
            if ("zh_CN".equals(RequestContext.get().getLang().name())) {
                convertStatusToChinese = this.convertStatusToChinese(monitorValue.getStatus());
            }
            if (map.containsKey(convertStatusToChinese)) {
                List<String> numbers = map.get(convertStatusToChinese);
                numbers.add(propertyName);
                if (numbers.contains(selectField + "_py") && numbers.contains(selectField)) {
                    numbers.remove(selectField + "_py");
                    numbers.remove(selectField);
                    numbers.add(String.format(ResManager.loadKDString((String)"%s(\u542b\u62fc\u97f3)", (String)"FullTextIndexTreeListPlugin_9", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), selectField));
                }
                map.put(convertStatusToChinese, numbers);
            } else {
                ArrayList<String> numbers = new ArrayList<String>();
                numbers.add(propertyName);
                map.put(convertStatusToChinese, numbers);
            }
        }
    }

    private boolean hasStatus(String selectField, MonitorValue monitorValue) {
        return monitorValue.getPropertyName().equalsIgnoreCase(selectField + "_" + RequestContext.get().getLang().name()) || monitorValue.getPropertyName().equalsIgnoreCase(selectField + "_py") && "zh_CN".equals(RequestContext.get().getLang().name()) || monitorValue.getPropertyName().equalsIgnoreCase(selectField);
    }

    @Override
    protected QFilter getModelFilter(String nodeId) {
        QFilter qFilter = null;
        ORM orm = ORM.create();
        boolean isCloud = orm.exists("bos_devportal_bizcloud", (Object)nodeId);
        if (nodeId.equals("-1")) {
            qFilter = new QFilter("fentitynumber.dentityid", "is not null", (Object)"");
        } else if (isCloud) {
            JSONArray units = this.getUnitIdsByCloudId(nodeId);
            qFilter = new QFilter("fentitynumber.bizappid", "in", (Object)units);
        } else {
            qFilter = new QFilter("fentitynumber.bizappid", "=", (Object)nodeId);
        }
        return qFilter;
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        e.getQFilters().add(new QFilter(FENTITY_NUMBER_NUMBER, "<>", (Object)"all_billno"));
    }

    @Override
    protected QFilter filter() {
        return new QFilter("fentitynumber.modeltype", "in", (Object)this.getModelFilterContent());
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("viewdata".equals(afterDoOperationEventArgs.getOperateKey())) {
            ListSelectedRowCollection listSelectedRowCollection = ((IListView)this.getView()).getSelectedRows();
            Map<Object, DynamicObject> dynamicObjectMap = this.getSelectedObjectMap(listSelectedRowCollection);
            DynamicObject dynamicObject = dynamicObjectMap.get(((IListView)this.getView()).getFocusRowPkId());
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bos_syncdataquery");
            formShowParameter.setCustomParam("entityNumber", (Object)dynamicObject.getString(FENTITY_NUMBER_NUMBER));
            formShowParameter.setCustomParam("selectFields", (Object)dynamicObject.getString(FFIELD_NAME));
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(formShowParameter);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            if (BTNINITORCREATEINDEXES.equalsIgnoreCase(messageBoxClosedEvent.getCallBackId())) {
                this.initOrCreateIndexes();
                this.getView().showMessage(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u4efb\u52a1\u5df2\u542f\u52a8\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u67e5\u770b\u540c\u6b65\u7ed3\u679c\u3002", (String)"FullTextIndexTreeListPlugin_10", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            } else if (BTNSYNCDATA.equalsIgnoreCase(messageBoxClosedEvent.getCallBackId())) {
                this.syncData();
                this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u636e\u540c\u6b65\u4efb\u52a1\u5df2\u542f\u52a8\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u67e5\u770b\u540c\u6b65\u7ed3\u679c\u3002", (String)"FullTextIndexTreeListPlugin_11", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
        }
    }

    class InitOrCreateIndexesThread
    extends Thread {
        CyclicBarrier cyclicBarrier;
        RequestContext requestContext;
        List<FullTextIndex> fullTextIndexs;
        List<FullTextIndex> newFullTextIndexs;
        Map<String, MainEntityType> mainEntityTypeMap;

        public InitOrCreateIndexesThread(List<FullTextIndex> newFullTextIndexs, List<FullTextIndex> fullTextIndexs, RequestContext requestContext, CyclicBarrier cyclicBarrier, Map<String, MainEntityType> mainEntityTypeMap) {
            this.newFullTextIndexs = newFullTextIndexs;
            this.fullTextIndexs = fullTextIndexs;
            this.requestContext = requestContext;
            this.cyclicBarrier = cyclicBarrier;
            this.mainEntityTypeMap = mainEntityTypeMap;
        }

        @Override
        public void run() {
            HashMap errorInfoMap = new HashMap();
            ArrayList successInfo = new ArrayList();
            ArrayList errorInfo = new ArrayList();
            RequestContext.set((RequestContext)this.requestContext);
            this.newFullTextIndexs.addAll(FullTextIndexHelper.initOrCreateIndexes(this.fullTextIndexs, successInfo, errorInfo, errorInfoMap, this.mainEntityTypeMap));
            Log log = LogFactory.getLog((String)this.getClass().getSimpleName());
            try {
                log.info(String.format("\u672c\u6b21\u6210\u529f\u540c\u6b65\u6570\u636e%s\u6761,\u5931\u8d25%s\u6761", successInfo.size(), errorInfo.size()));
                for (Map.Entry entry : errorInfoMap.entrySet()) {
                    log.error(String.format("%s:%s", entry.getKey(), entry.getValue()));
                }
                this.cyclicBarrier.await();
            }
            catch (InterruptedException | BrokenBarrierException e) {
                log.error("InitOrCreateIndexesThread:" + e.getMessage());
            }
        }
    }
}

