/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.designer.dao.FormMetadataUtil;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.EntityMetadataUtil;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.container.GridFlatPanelAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.EntryFieldContainerAp;
import kd.bos.metadata.form.control.EntryFieldGroupAp;
import kd.bos.metadata.form.control.OperationColumnAp;
import kd.bos.util.CollectionUtils;

public class GridConfInitFieldPlugin
extends AbstractFormPlugin {
    private static final String CONTEXT = "context";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String VALUE = "value";
    private static final String FIELD_NAME = "fieldname";
    private static final String FIELD_KEY = "fieldkey";
    private static final String CHECKED = "checked";
    private static final String IS_VISIBLE = "isvisible";
    private static final String KEY_BUTTON_ALL_SHOW = "btnallshow";
    private static final String KEY_BUTTON_ALL_HIDE = "btnallhide";
    private static final String KEY_BUTTON_CANCEL = "btncancel";
    private static final String KEY_BUTTON_OK = "btnok";
    private static final String KEY_ADVCON_TOOLBARAP = "advcontoolbarap";
    private static final String MI_ROW_INDEX = "miRowIndex";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{KEY_BUTTON_CANCEL, KEY_BUTTON_OK});
        this.addItemClickListeners(new String[]{KEY_ADVCON_TOOLBARAP});
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "btnallhide": {
                this.toggleButton(CHECKED, false);
                break;
            }
            case "btnallshow": {
                this.toggleButton(CHECKED, true);
                break;
            }
        }
    }

    private void toggleButton(String fieldName, boolean isOpen) {
        int rowCount = this.getModel().getEntryRowCount(ENTRY_ENTITY);
        String miRowIndexStr = this.getPageCache().get(MI_ROW_INDEX);
        List miRowIndexes = new ArrayList(10);
        if (StringUtils.isNotBlank((CharSequence)miRowIndexStr)) {
            miRowIndexes = SerializationUtils.fromJsonStringToList((String)miRowIndexStr, Integer.class);
        }
        for (int i = 0; i < rowCount; ++i) {
            if (miRowIndexes.contains(i)) continue;
            this.getModel().setValue(fieldName, (Object)isOpen, i);
        }
    }

    public void afterCreateNewData(EventObject e) {
        List<InitGridRow> initGridRows;
        PropertyEditHelper propertyEditHelper = new PropertyEditHelper();
        ArrayList<Map<String, Object>> columValues = new ArrayList(10);
        Object paramValue = propertyEditHelper.getParamValue(this.getView(), VALUE);
        if (paramValue instanceof List) {
            columValues = (List)propertyEditHelper.getParamValue(this.getView(), VALUE);
        }
        if (CollectionUtils.isNotEmpty(initGridRows = this.getGridColumn(propertyEditHelper))) {
            int rowIndex = 0;
            this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, initGridRows.size());
            ArrayList<Integer> miRowIndexes = new ArrayList<Integer>(10);
            for (InitGridRow initGridRow : initGridRows) {
                rowIndex += this.insertIntoEntry(initGridRow, rowIndex, columValues, miRowIndexes);
            }
            if (!miRowIndexes.isEmpty()) {
                this.getPageCache().put(MI_ROW_INDEX, SerializationUtils.toJsonString(miRowIndexes));
            }
        }
    }

    private List<InitGridRow> getGridColumn(PropertyEditHelper propertyEditHelper) {
        List context = new ArrayList(10);
        Object paramValue = propertyEditHelper.getParamValue(this.getView(), CONTEXT);
        if (paramValue instanceof List) {
            context = (List)paramValue;
        }
        if (CollectionUtils.isEmpty(context)) {
            return new ArrayList<InitGridRow>(0);
        }
        EntityMetadata entityMeta = null;
        if (propertyEditHelper.getEntityMeta(this.getView()) != null) {
            entityMeta = EntityMetadataUtil.getEntityMetadata(propertyEditHelper.getEntityMeta(this.getView()));
            entityMeta.createIndex(true);
        }
        List<Object> entityItems = new ArrayList(10);
        FormMetadata formMetadata = FormMetadataUtil.getFormMetadata(propertyEditHelper.getFormMeta(this.getView()));
        formMetadata.createIndex();
        List items = formMetadata.getItems();
        for (ControlAp item : items) {
            EntryEntity entryEntity;
            if (!(item instanceof EntryAp)) continue;
            List gridItems = ((ContainerAp)item).getItems();
            String itemId = propertyEditHelper.getItemId(this.getView());
            if (!StringUtils.equals((CharSequence)itemId, (CharSequence)item.getId())) continue;
            this.removeInvisibleItem(gridItems);
            if (entityMeta != null && (entryEntity = entityMeta.getEntryById(item.getId())) != null) {
                entityItems = entryEntity.getItems();
            }
            return this.buildGridRows(gridItems, itemId, entityItems);
        }
        return new ArrayList<InitGridRow>(0);
    }

    private List<InitGridRow> buildGridRows(List<ControlAp<?>> items, String entryApId, List<EntityItem<?>> entityItems) {
        ArrayList<InitGridRow> currentFields = new ArrayList<InitGridRow>(items.size());
        for (ControlAp<?> ctlAp : items) {
            if (!(ctlAp instanceof EntryFieldAp) && !(ctlAp instanceof EntryFieldGroupAp) && !(ctlAp instanceof EntryFieldContainerAp) && !(ctlAp instanceof OperationColumnAp) || !Objects.equals(entryApId, ctlAp.getParentId()) || ctlAp.isHidden() || ctlAp.isInvisible() || !ctlAp.getVisible().contains("init")) continue;
            LocaleString name = ctlAp.getName();
            String key = ctlAp.getKey();
            boolean mustInput = false;
            if (ctlAp instanceof EntryFieldAp) {
                for (EntityItem<?> item : entityItems) {
                    String fieldId = ((EntryFieldAp)ctlAp).getFieldId();
                    if (!(item instanceof Field) || !StringUtils.equals((CharSequence)fieldId, (CharSequence)item.getId())) continue;
                    mustInput = ((Field)item).isMustInput();
                }
            }
            InitGridRow bean = new InitGridRow(name, key);
            bean.setMustInput(mustInput);
            if (ctlAp instanceof EntryFieldGroupAp) {
                EntryFieldGroupAp fieldGroupAp = (EntryFieldGroupAp)ctlAp;
                bean.setChildren(this.buildGridRows(fieldGroupAp.getItems(), ctlAp.getId(), entityItems));
            }
            currentFields.add(bean);
        }
        return currentFields;
    }

    private int insertIntoEntry(InitGridRow initGridRow, int rowIndex, List<Map<String, Object>> columValues, List<Integer> miRowIndexes) {
        int insertRows = 1;
        this.getModel().setValue(FIELD_NAME, (Object)initGridRow.getFieldName(), rowIndex);
        this.getModel().setValue(FIELD_KEY, (Object)initGridRow.getFieldKey(), rowIndex);
        if (initGridRow.isMustInput()) {
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{CHECKED});
            miRowIndexes.add(rowIndex);
        }
        if (CollectionUtils.isNotEmpty(columValues)) {
            for (Map<String, Object> columValue : columValues) {
                String key = initGridRow.getFieldKey();
                if (!StringUtils.equals((CharSequence)key, (CharSequence)String.valueOf(columValue.get(FIELD_KEY))) || !"false".equals(columValue.get(IS_VISIBLE))) continue;
                initGridRow.setVisible(Boolean.FALSE);
            }
        }
        this.getModel().setValue(CHECKED, (Object)(initGridRow.isVisible() || initGridRow.isMustInput() ? 1 : 0), rowIndex);
        List<InitGridRow> childrenList = initGridRow.getChildren();
        if (!CollectionUtils.isEmpty(childrenList)) {
            for (InitGridRow item : childrenList) {
                int insertEntryRow = this.getModel().insertEntryRow(ENTRY_ENTITY, rowIndex);
                insertRows += this.insertIntoEntry(item, insertEntryRow, columValues, miRowIndexes);
            }
        }
        return insertRows;
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (KEY_BUTTON_OK.equalsIgnoreCase(key)) {
            this.returnDataToParent();
        } else if (KEY_BUTTON_CANCEL.equals(key)) {
            this.getView().close();
        }
    }

    private void returnDataToParent() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
        ArrayList value = new ArrayList(10);
        HashMap para = new HashMap(16);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            this.getView().close();
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            for (DynamicObject dynamicObject : entryEntity) {
                String checked = dynamicObject.getString(CHECKED);
                if (checked == null || Boolean.parseBoolean(checked)) continue;
                HashMap<String, String> map = new HashMap<String, String>(3);
                map.put(FIELD_KEY, dynamicObject.getString(FIELD_KEY));
                map.put(IS_VISIBLE, checked);
                value.add(map);
            }
        }
        para.put(VALUE, value);
        para.put("itemId", customParams.get("itemId"));
        para.put("metaType", customParams.get("metaType"));
        para.put("propertyName", customParams.get("propertyName"));
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    private void removeInvisibleItem(List<ControlAp<?>> gridItems) {
        if (CollectionUtils.isNotEmpty(gridItems)) {
            Iterator<ControlAp<?>> iterator = gridItems.iterator();
            while (iterator.hasNext()) {
                ControlAp<?> controlAp = iterator.next();
                String key = controlAp.getKey();
                if (!"fseq".equals(key) && !controlAp.isInvisible() && !controlAp.isHidden() && !(controlAp instanceof GridFlatPanelAp)) continue;
                iterator.remove();
            }
        }
    }

    private static class InitGridRow {
        private LocaleString fieldName;
        private String fieldKey;
        private boolean isVisible = true;
        private boolean mustInput;
        private List<InitGridRow> children = new ArrayList<InitGridRow>();

        public InitGridRow(LocaleString fieldName, String fieldKey) {
            this.fieldName = fieldName;
            this.fieldKey = fieldKey;
        }

        public List<InitGridRow> getChildren() {
            return this.children;
        }

        public void setChildren(List<InitGridRow> children) {
            this.children = children;
        }

        public LocaleString getFieldName() {
            return this.fieldName;
        }

        public String getFieldKey() {
            return this.fieldKey;
        }

        public boolean isVisible() {
            return this.isVisible;
        }

        public void setVisible(boolean visible) {
            this.isVisible = visible;
        }

        public boolean isMustInput() {
            return this.mustInput;
        }

        public void setMustInput(boolean mustInput) {
            this.mustInput = mustInput;
        }
    }
}

