/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.basedata.query.BasedataGroupManager;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.sequence.SequenceReader;

public class GroupEditPlugin
extends AbstractBillPlugIn
implements ClickListener {
    private static final String TABLE = "table";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String PARENTID = "parentid";
    private static final String VALUE = "value";
    private static final String NUMBER = "number";
    private static final String MULTI_LANGUAGE_TEXT = "MultiLanguageText";
    private static final String DESCRIPTION = "description";
    private static final String CONTINUE_ADD = "continueadd";

    public void initialize() {
        this.addClickListeners(new String[]{"btncancel", "btnok"});
        Map valueMap = this.getView().getFormShowParameter().getCustomParams();
        if (valueMap == null || StringUtils.isBlank(valueMap.get(TABLE))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u7ec4\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GroupEditPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String tableName = valueMap.get(TABLE).toString();
        this.initMainEntityType(tableName);
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        if ("btnok".equalsIgnoreCase(c.getKey())) {
            this.saveData();
        } else if ("btncancel".equalsIgnoreCase(c.getKey())) {
            this.getView().close();
        } else if ("parentnumber".equalsIgnoreCase(c.getKey())) {
            this.groupEdit();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate c = (FormOperate)args.getSource();
        if ("save".equalsIgnoreCase(c.getOperateKey())) {
            Map valueMap = this.getView().getFormShowParameter().getCustomParams();
            String tableName = valueMap.get(TABLE).toString();
            MainEntityType entityType = this.getView().getModel().getDataEntityType();
            entityType.setAlias(tableName);
        }
    }

    private void groupEdit() {
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("formId", "bos_groupedit");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "edit"));
        showParameter.setParentFormId(this.getView().getFormShowParameter().getParentFormId());
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put(PARENTID, this.getModel().getValue(PARENTID));
        Map map = (Map)this.getView().getFormShowParameter().getCustomParams().get(VALUE);
        valueMap.put("fid", map.get("fid"));
        valueMap.put("tableName", map.get(TABLE).toString());
        showParameter.setCustomParam(VALUE, valueMap);
        this.getView().showForm(showParameter);
    }

    private boolean validate() {
        Object number = this.getModel().getValue(NUMBER);
        Object name = this.getModel().getValue("name");
        Map valueMap = (Map)this.getView().getFormShowParameter().getCustomParams().get(VALUE);
        if (StringUtils.isBlank((Object)number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GroupEditPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isBlank((Object)name)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GroupEditPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        Object fid = valueMap.get("fid");
        boolean idEmpty = false;
        if (fid == null || fid.toString().trim().isEmpty()) {
            idEmpty = true;
        }
        List formList = BasedataGroupManager.getTableData((String)((String)valueMap.get(TABLE)));
        for (Map map : formList) {
            if (!idEmpty && fid.toString().equals(map.get("fid")) || !number.toString().equals(map.get(NUMBER))) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"GroupEditPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void saveData() {
        if (!this.validate()) {
            return;
        }
        Map valueMap = (Map)this.getView().getFormShowParameter().getCustomParams().get(VALUE);
        MainEntityType entityType = this.getView().getModel().getDataEntityType();
        String tableName = entityType.getAlias();
        Object[] dataEntities = new DynamicObject[]{(DynamicObject)entityType.createInstance()};
        Object fid = valueMap.get("fid");
        boolean idEmpty = false;
        if (StringUtils.isBlank(fid)) {
            idEmpty = true;
        } else {
            Object[] pks_l = new Object[]{Integer.parseInt((String)fid)};
            DynamicCollectionProperty localeProperty = entityType.getLocaleProperty();
            localeProperty.getDynamicCollectionItemPropertyType().setAlias(String.format("%s_L", tableName));
            BusinessDataWriter.delete((IDataEntityType)entityType, (Object[])pks_l);
        }
        SequenceReader sequenceReader = new SequenceReader(DBRoute.basedata);
        DynamicCollectionProperty dp = dataEntities[0].getDynamicObjectType().getLocaleProperty();
        LocaleDynamicObjectCollection collection = (LocaleDynamicObjectCollection)dataEntities[0].get((IDataEntityProperty)dp);
        DynamicLocaleProperty localeProperty = (DynamicLocaleProperty)entityType.getProperty(MULTI_LANGUAGE_TEXT);
        DynamicObjectType localeType = localeProperty.getDynamicCollectionItemPropertyType();
        localeType.setAlias(String.format("%s_L", tableName));
        ILocaleString localeName = (ILocaleString)this.getModel().getValue("name");
        ILocaleString localeDesc = (ILocaleString)this.getModel().getValue(DESCRIPTION);
        HashSet<String> localeKey = new HashSet<String>();
        for (String localeString : localeName.keySet()) {
            localeKey.add(localeString);
        }
        for (String localeString : localeDesc.keySet()) {
            localeKey.add(localeString);
        }
        for (String key : localeKey) {
            DynamicObject localObject = (DynamicObject)localeType.createInstance();
            localObject.set("pkid", (Object)SequenceReader.getStringSequence((int)1));
            localObject.set("LocaleId", (Object)key);
            localObject.set("name", localeName.get((Object)key));
            localObject.set(DESCRIPTION, localeDesc.get((Object)key));
            collection.add((Object)localObject);
        }
        for (IDataEntityProperty property : entityType.getProperties()) {
            String propertyName = property.getName();
            if ("id".equals(propertyName)) {
                if (idEmpty) {
                    dataEntities[0].set(propertyName, (Object)sequenceReader.getSequences((Object[])new Integer[0], tableName, 1));
                    continue;
                }
                dataEntities[0].set(propertyName, (Object)Integer.parseInt((String)fid));
                continue;
            }
            if (property instanceof MuliLangTextProp) {
                ILocaleString localeString = (ILocaleString)this.getModel().getValue(propertyName);
                property.setValue(dataEntities[0], localeString.getDefaultItem());
                continue;
            }
            if (property instanceof DynamicLocaleProperty) {
                dataEntities[0].set(propertyName, (Object)collection);
                continue;
            }
            dataEntities[0].set(propertyName, this.getModel().getValue(propertyName));
        }
        BusinessDataWriter.save((IDataEntityType)entityType, (Object[])dataEntities);
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"GroupEditPlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        if (this.getModel().getValue(CONTINUE_ADD) != null && ((Boolean)this.getModel().getValue(CONTINUE_ADD)).booleanValue()) {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            map.put(CONTINUE_ADD, true);
            this.getView().returnDataToParent(map);
        }
        this.getView().close();
    }

    public void afterCreateNewData(EventObject eo) {
        Map valueMap = (Map)this.getView().getFormShowParameter().getCustomParams().get(VALUE);
        if (valueMap != null) {
            if (((Boolean)valueMap.get("isAdd")).booleanValue()) {
                HashMap<String, Object> enableMap = new HashMap<String, Object>();
                enableMap.put("policy", "");
                enableMap.put("enable", false);
                enableMap.put("keys", new String[]{PARENTID});
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("setEnable", enableMap);
                this.getModel().setValue(PARENTID, valueMap.get("fid"));
            } else {
                this.getModel().setValue(PARENTID, (Object)Integer.parseInt((String)valueMap.get("fparentid")));
                this.getView().setVisible(Boolean.valueOf(false), new String[]{CONTINUE_ADD});
            }
            if (StringUtils.isNotBlank(valueMap.get(PARENTID)) && !"0".equals(valueMap.get(PARENTID))) {
                this.getModel().setValue(PARENTID, (Object)Integer.parseInt((String)valueMap.get(PARENTID)));
            }
            this.getModel().setValue(NUMBER, valueMap.get("fnumber"));
            this.getModel().setValue("name", valueMap.get("fname"));
            this.getModel().setValue(DESCRIPTION, valueMap.get("fdescription"));
        }
    }

    private IClientViewProxy getService(Class<IClientViewProxy> class1) {
        return null;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map map;
        if ("edit".equals(e.getActionId()) && (map = (Map)e.getReturnData()) != null) {
            this.getModel().setValue(PARENTID, map.get(PARENTID));
        }
    }

    private void initMainEntityType(String tableName) {
        MainEntityType entityType = this.getView().getModel().getDataEntityType();
        entityType.setAlias(tableName);
        String langTableName = String.format("%s_l", tableName);
        ((BasedataEntityType)entityType).setAlias(tableName);
        DynamicLocaleProperty localeProperty = (DynamicLocaleProperty)entityType.getProperties().get((Object)MULTI_LANGUAGE_TEXT);
        localeProperty.setAlias(langTableName);
        for (IDataEntityProperty dataEntityProp : entityType.getProperties()) {
            if (dataEntityProp instanceof ParentBasedataProp) {
                EntityType subEntityProp = (EntityType)((ParentBasedataProp)dataEntityProp).getComplexType();
                subEntityProp.setAlias(tableName);
                DynamicLocaleProperty localeProp = (DynamicLocaleProperty)subEntityProp.getProperties().get((Object)MULTI_LANGUAGE_TEXT);
                localeProp.setAlias(langTableName);
                localeProp.getDynamicCollectionItemPropertyType().setAlias(langTableName);
                continue;
            }
            if (!(dataEntityProp instanceof DynamicLocaleProperty)) continue;
            ((DynamicLocaleProperty)dataEntityProp).setAlias(langTableName);
            ((DynamicLocaleProperty)dataEntityProp).getDynamicCollectionItemPropertyType().setAlias(langTableName);
        }
    }
}

