/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.basedata.query.BasedataGroupManager;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;

public class GroupSelectPlugin
extends AbstractFormPlugin
implements ClickListener,
TreeNodeClickListener {
    private static final String TREE_VIEW_AP = "treeviewap";
    private static final String FORM_LIST = "formList";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String GROUP_TABLE_NAME = "groupTableName";

    public void initialize() {
        this.addClickListeners(new String[]{"btncancel", "btnok", "addgroup", "editgroup", "lookup"});
        TreeView tree = (TreeView)this.getView().getControl(TREE_VIEW_AP);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        switch (c.getKey()) {
            case "btnok": {
                this.reurnData();
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
            case "addgroup": {
                this.add();
                break;
            }
            case "editgroup": {
                this.edit();
                break;
            }
            case "lookup": {
                this.lookUp();
                break;
            }
        }
    }

    private void lookUp() {
        List formList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(FORM_LIST), List.class);
        Object keyword = this.getModel().getValue("keyword");
        if (keyword != null && !keyword.toString().trim().isEmpty()) {
            List<String> listId = this.getListId(formList, keyword.toString());
            TreeNode root = BasedataGroupManager.keywordTree((List)formList, listId);
            if (root == null) {
                TreeNode node = new TreeNode();
                node.setParentid("");
                node.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"GroupSelectPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
                node.setId("0");
                root = node;
            }
            TreeView tree = (TreeView)this.getView().getControl(TREE_VIEW_AP);
            tree.updateNode(root);
            root.setIsOpened(true);
        }
    }

    public List<String> getListId(List<Map<String, Object>> formList, String keyword) {
        ArrayList<String> listId = new ArrayList<String>();
        for (Map<String, Object> map : formList) {
            if (map.get("fnumber").toString().contains(keyword)) {
                listId.add((String)map.get("fid"));
                continue;
            }
            if (!map.get("fname").toString().contains(keyword)) continue;
            listId.add((String)map.get("fid"));
        }
        return listId;
    }

    private void add() {
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("formId", "bos_group");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "add"));
        showParameter.setParentFormId(this.getView().getFormShowParameter().getParentFormId());
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        String nodeList = ((TreeView)this.getView().getControl(TREE_VIEW_AP)).getTreeState().getFocusNodeId();
        String tableName = (String)this.getView().getFormShowParameter().getCustomParams().get(GROUP_TABLE_NAME);
        String fid = "0";
        if (StringUtils.isNotBlank((CharSequence)nodeList)) {
            fid = nodeList;
            valueMap.put("parentid", fid);
            valueMap.put("table", tableName);
            valueMap.put("isAdd", true);
            showParameter.setCustomParam("value", valueMap);
            this.getView().showForm(showParameter);
        }
    }

    private void edit() {
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("formId", "bos_group");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "edit"));
        showParameter.setParentFormId(this.getView().getFormShowParameter().getParentFormId());
        String nodeList = ((TreeView)this.getView().getControl(TREE_VIEW_AP)).getTreeState().getFocusNodeId();
        if (StringUtils.isBlank((CharSequence)nodeList) || "0".equals(nodeList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u53ef\u7f16\u8f91\u5206\u7ec4\u3002", (String)"GroupSelectPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String fid = nodeList;
        String tableName = (String)this.getView().getFormShowParameter().getCustomParams().get(GROUP_TABLE_NAME);
        List list = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(FORM_LIST), List.class);
        Map map = BasedataGroupManager.getTableColumnValue((List)list, (String)fid);
        map.put("table", tableName);
        map.put("isAdd", false);
        showParameter.setCustomParam("value", (Object)map);
        this.getView().showForm(showParameter);
    }

    private void reurnData() {
        String fid = ((TreeView)this.getView().getControl(TREE_VIEW_AP)).getTreeState().getFocusNodeId();
        List formList = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(FORM_LIST), List.class);
        if (fid == null || "0".equals(fid)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u8fd4\u56de\u7684\u5206\u7ec4\u3002", (String)"GroupSelectPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String name = "";
        String number = "";
        ListSelectedRowCollection listSelectedRows = new ListSelectedRowCollection();
        ListSelectedRow row = new ListSelectedRow((Object)Long.parseLong(fid), Boolean.valueOf(true));
        for (Map map : formList) {
            if (!fid.equals(map.get("fid"))) continue;
            name = (String)map.get("fname");
            number = (String)map.get("number");
            if (name == null || name.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u540d\u79f0\u6709\u8bef\u3002", (String)"GroupSelectPlugin_3", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
            if (number == null || number.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u7f16\u7801\u6709\u8bef\u3002", (String)"GroupSelectPlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            }
            row.setName(name);
            row.setNumber(number);
            listSelectedRows.add((Object)row);
        }
        this.getView().returnDataToParent((Object)listSelectedRows);
        this.getView().close();
    }

    public void afterCreateNewData(EventObject eo) {
        String name = (String)this.getView().getFormShowParameter().getCustomParams().get(GROUP_TABLE_NAME);
        if (name == null || name.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u7ec4\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GroupSelectPlugin_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (BasedataGroupManager.createGroupTable((String)name, (String)DBRoute.basedata.getRouteKey())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u6709\u8bef\u3002", (String)"GroupSelectPlugin_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        }
        List formList = BasedataGroupManager.getTableData((String)name);
        TreeNode root = BasedataGroupManager.getTreeNode((List)formList);
        TreeView tree = (TreeView)this.getView().getControl(TREE_VIEW_AP);
        tree.addNode(root);
        root.setIsOpened(true);
        this.getPageCache().put(FORM_LIST, SerializationUtils.toJsonString((Object)formList));
    }

    public void treeNodeClick(TreeNodeEvent e) {
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
        this.reurnData();
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Map map = (Map)e.getReturnData();
        if (map != null && map.get("continueadd") != null && ((Boolean)map.get("continueadd")).booleanValue()) {
            this.add();
            return;
        }
        String name = (String)this.getView().getFormShowParameter().getCustomParams().get(GROUP_TABLE_NAME);
        List formList = BasedataGroupManager.getTableData((String)name);
        TreeNode root = BasedataGroupManager.getTreeNode((List)formList);
        TreeView tree = (TreeView)this.getView().getControl(TREE_VIEW_AP);
        tree.updateNode(root);
        root.setIsOpened(true);
        this.getPageCache().put(FORM_LIST, SerializationUtils.toJsonString((Object)formList));
    }
}

