/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class LayoutSelectorPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String ENTRYKEY = "entryentity";
    private static final String NUMBER = "number";
    private static final String BOS_FORMMETA = "bos_formmeta";

    public void initialize() {
        Button btn = (Button)this.getView().getControl("btnok");
        btn.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equalsIgnoreCase("btnok")) {
            this.closeAndReturn();
        }
    }

    private void closeAndReturn() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRYKEY);
        int rowIndex = grid.getEntryState().getFocusRow();
        if (rowIndex >= 0) {
            String layoutNubmer = (String)this.getModel().getValue(NUMBER, rowIndex);
            HashMap para = new HashMap(16);
            para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
            para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
            para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
            para.put("value", layoutNubmer);
            this.getView().returnDataToParent(para);
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject evt) {
        FormShowParameter param = this.getView().getFormShowParameter();
        String domainModelType = (String)param.getCustomParam("modelType");
        List context = (List)this.getView().getFormShowParameter().getCustomParams().get("context");
        String key = (String)((Map)context.get(0)).get("Key");
        ArrayList<Map> layouts = this.getBillLayoutWithoutExtByFormId(key, domainModelType);
        layouts = layouts == null ? new ArrayList<Map>() : layouts;
        String listType = (String)this.getView().getFormShowParameter().getCustomParams().get("_Type_");
        if ("MobileListFormAp".equals(listType)) {
            List<Map<String, Object>> mobileLayouts = this.getBillLayoutWithoutExtByFormId(key, "MobileBillFormModel");
            layouts.clear();
            if (null != mobileLayouts && !mobileLayouts.isEmpty()) {
                HashSet<String> existLayoutIds = new HashSet<String>(16);
                for (Map map : layouts) {
                    existLayoutIds.add((String)map.get("id"));
                }
                for (Map map : mobileLayouts) {
                    String id = (String)map.get("id");
                    if (!existLayoutIds.add(id)) continue;
                    layouts.add(map);
                }
            }
        }
        if (layouts.isEmpty()) {
            return;
        }
        IDataModel model = this.getModel();
        model.getEntryEntity(ENTRYKEY).clear();
        model.batchCreateNewEntryRow(ENTRYKEY, layouts.size());
        int i = 0;
        for (Map map : layouts) {
            ILocaleString name = (ILocaleString)map.get("name");
            Object number = map.get(NUMBER);
            model.setValue(NUMBER, number, i);
            model.setValue("name", (Object)name.getLocaleValue(), i);
            model.setValue("entityid", (Object)i, i++);
        }
    }

    private List<Map<String, Object>> getBillLayoutWithoutExtByFormId(String formId, String domainModelType) {
        DynamicObject[] formDatas;
        ArrayList<Map<String, Object>> layouts = new ArrayList<Map<String, Object>>(10);
        QFilter f = new QFilter(NUMBER, "=", (Object)formId);
        QFilter[] filters = new QFilter[]{f};
        DynamicObject formData = BusinessDataServiceHelper.loadSingle((String)BOS_FORMMETA, (String)"id, number,name,basedatafield, masterid", (QFilter[])filters);
        String masterid = formData.getString("masterid");
        if (StringUtils.isBlank((CharSequence)masterid)) {
            masterid = formData.getDynamicObject("basedatafield").getString("id");
        }
        filters = new QFilter[]{QFilter.of((String)"id <> basedatafield", (Object[])new Object[0]).and(new QFilter("basedatafield", "=", (Object)masterid)).and(new QFilter("modeltype", "=", (Object)domainModelType))};
        for (DynamicObject form : formDatas = BusinessDataServiceHelper.load((String)BOS_FORMMETA, (String)"id, number, name", (QFilter[])filters)) {
            HashMap<String, Object> layout = new HashMap<String, Object>();
            layout.put("id", form.getString("id"));
            layout.put(NUMBER, form.getString(NUMBER));
            layout.put("name", form.get("name"));
            layouts.add(layout);
        }
        return layouts;
    }
}

