/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListColumnConfig;
import kd.bos.list.ListFieldMeta;
import kd.bos.metadata.dao.EntityMetadataUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ListColumnEdit
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final String ITEMS = "Items";
    private static final String ITEM_ID = "itemId";
    private static String Key_btnOK = "btnok";
    private static String Key_btnCancel = "btncancel";
    private static String Key_TreeView = "fieldtree";
    private static String Key_FExpression = "fexpression";
    public static final String CustParamKey_ExpressionJson = "context";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{Key_btnOK, Key_btnCancel});
        TreeView tv = (TreeView)this.getView().getControl(Key_TreeView);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    private String getEntityId(String id, Map<String, Object> itemMap) {
        Map item = (Map)itemMap.get(id);
        if (item == null) {
            return null;
        }
        String parentId = (String)item.get("ParentId");
        if (parentId == null) {
            return null;
        }
        Map parentItem = (Map)itemMap.get(parentId);
        if (parentItem == null) {
            return null;
        }
        if ("BillListAp".equals(parentItem.get("_Type_"))) {
            return (String)parentItem.get("EntityId");
        }
        return this.getEntityId((String)parentItem.get("Id"), itemMap);
    }

    private List<Map<String, Object>> filterItems(List<Map<String, Object>> items, String notInFilterTypes) {
        ArrayList<Map<String, Object>> newItems = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> item : items) {
            if ("Entity".equalsIgnoreCase(item.get("Type").toString())) {
                item.put(ITEMS, this.filterItems((List)item.get(ITEMS), notInFilterTypes));
                newItems.add(item);
                continue;
            }
            String dataType = "";
            if (item.get("DataType") != null) {
                dataType = item.get("DataType").toString();
            }
            if (notInFilterTypes.contains(dataType.toLowerCase())) continue;
            newItems.add(item);
        }
        return newItems;
    }

    private String getEntityId() {
        List contextList = (List)this.getView().getFormShowParameter().getCustomParams().get(CustParamKey_ExpressionJson);
        if (contextList != null) {
            List items = (List)contextList.get(0);
            String itemId = (String)this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID);
            if (items != null && itemId != null) {
                HashMap<String, Object> itemMap = new HashMap<String, Object>(16);
                for (Map item : items) {
                    itemMap.put((String)item.get("Id"), item);
                }
                return this.getEntityId(itemId, itemMap);
            }
        }
        return null;
    }

    public void afterCreateNewData(EventObject e) {
        Object value;
        super.afterCreateNewData(e);
        String entityId = this.getEntityId();
        if (entityId != null) {
            Map fields = EntityMetadataUtil.getListFields((String)entityId, (boolean)false);
            List fieldItems = (List)fields.get(ITEMS);
            List<Map<String, Object>> newItems = this.filterItems(fieldItems, "basedataprop");
            fields.put(ITEMS, newItems);
            this.addFieldListToModel(fields);
        }
        if (!StringUtils.isBlank(value = this.getView().getFormShowParameter().getCustomParams().get("value"))) {
            ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
            dts.add(OrmUtils.getDataEntityType(ListColumnConfig.class));
            dts.add(OrmUtils.getDataEntityType(ListFieldMeta.class));
            DcJsonSerializer dcJsonSerializer = new DcJsonSerializer(dts);
            ListColumnConfig listColumnConfig = (ListColumnConfig)dcJsonSerializer.deserializeFromMap((Map)value, null);
            this.getModel().setValue(Key_FExpression, (Object)listColumnConfig.getFormatExpression());
        }
    }

    private Matcher getMatcher(String expression) {
        String regEx = "(?<=\\{)(.+?)(?=\\})";
        Pattern pattern = Pattern.compile(regEx);
        return pattern.matcher(expression.trim());
    }

    private ListColumnConfig getListColumnConfig(String expression) {
        ListColumnConfig listColumnConfig = new ListColumnConfig();
        Matcher matcher = this.getMatcher(expression);
        ArrayList<ListFieldMeta> listFieldMetas = new ArrayList<ListFieldMeta>();
        while (matcher.find()) {
            ListFieldMeta listFieldMeta = new ListFieldMeta(matcher.group());
            if (listFieldMetas.contains(listFieldMeta)) continue;
            listFieldMetas.add(listFieldMeta);
        }
        listColumnConfig.setListFieldMetas(listFieldMetas);
        listColumnConfig.setFormatExpression(expression);
        return listColumnConfig;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (Key_btnOK.equalsIgnoreCase(ctlSource.getKey())) {
            String expression = (String)this.getModel().getValue(Key_FExpression);
            if (!this.checkExpressionLength(expression)) {
                return;
            }
            ListColumnConfig listColumnConfig = this.getListColumnConfig(expression);
            ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
            dts.add(OrmUtils.getDataEntityType(ListColumnConfig.class));
            dts.add(OrmUtils.getDataEntityType(ListFieldMeta.class));
            DcJsonSerializer dcJsonSerializer = new DcJsonSerializer(dts);
            HashMap<String, Object> para = new HashMap<String, Object>();
            para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
            para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
            para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
            para.put("value", SerializationUtils.fromJsonString((String)dcJsonSerializer.serializeToString((Object)listColumnConfig, null), Map.class));
            para.put("alias", listColumnConfig.getFormatExpression());
            this.getView().returnDataToParent(para);
            this.getView().close();
        } else if (Key_btnCancel.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        }
    }

    private void addFieldListToModel(Map<String, Object> fields) {
        TreeNode root = TreeNode.Parse((String)"", fields, (String)"Id", (String)"Name", (String)ITEMS);
        root.setIsOpened(true);
        TreeView treeView = (TreeView)this.getControl("fieldtree");
        treeView.addNode(root);
        this.getPageCache().put("FieldTree", SerializationUtils.toJsonString((Object)root));
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
        MainEntityType dataEntityType;
        IDataEntityProperty findProperty;
        String expression = (String)this.getModel().getValue(Key_FExpression);
        String entityId = this.getEntityId();
        if (entityId == null) {
            return;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bos_formmeta", (String)"masterid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)entityId)});
        if (dynamicObject == null) {
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("masterid"))) {
            entityId = dynamicObject.getString("masterid");
        }
        if ((findProperty = (dataEntityType = EntityMetadataCache.getDataEntityTypeById((String)entityId)).findProperty(e.getNodeId().toString())) != null && findProperty instanceof EntryProp || dataEntityType.getName().equalsIgnoreCase(e.getNodeId().toString())) {
            return;
        }
        if (!this.checkExpressionLength(expression = expression + "{" + e.getNodeId().toString() + "}")) {
            return;
        }
        this.getModel().setValue(Key_FExpression, (Object)expression);
    }

    private boolean checkExpressionLength(String expression) {
        Matcher matcher = this.getMatcher(expression);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        if (count > 15) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u52a8\u6001\u6587\u672c\u5b57\u6bb5\u6700\u591a\u53ea\u652f\u630115\u4e2a\u5b57\u6bb5", (String)"ListColumnEdit_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

