/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.dao.FormMetadataUtil;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.metadata.dao.EntityMetadataUtil;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.QueryEntity;
import kd.bos.metadata.entity.businessfield.IBasedataField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.filter.FastSearchGridViewAp;
import kd.bos.metadata.filter.FilterColumnAp;
import kd.bos.metadata.filter.FilterGridViewAp;
import kd.bos.metadata.filter.SchemeFilterViewAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.mcontrol.MobAdvFilterPanelAp;
import kd.bos.metadata.form.mcontrol.MobCommonBaseDataFilterColumnAp;
import kd.bos.metadata.form.mcontrol.MobFilterPanelAp;
import kd.bos.metadata.form.mcontrol.MobSortColumnAp;
import kd.bos.metadata.form.mcontrol.MobSortPanelAp;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.Nullable;

public final class ListDesignerValidator {
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String TYPE = "_Type_";
    private static final String FORM_META = "formmeta";
    private Map<String, BillEntityType> basedataEntityTypeCacheMap = new HashMap<String, BillEntityType>();
    private Map<String, EntityMetadata> entityMetadataCacheMap = new HashMap<String, EntityMetadata>();

    @Nullable
    public String validate(Map<String, Object> content, String propName, List<Map<String, Object>> context) {
        Map map = (Map)content.get(FORM_META);
        List list = (List)map.get("Items");
        if ("MobListMeta".equals(propName)) {
            ((Map)list.get(0)).put(TYPE, "MobileListFormAp");
        }
        FormMetadata formMetadata = FormMetadataUtil.getFormMetadata(list);
        formMetadata.createIndex(true);
        ControlAp fastSearchGridAp = formMetadata.getItem("fastsearchgridview");
        ControlAp filterGridAp = formMetadata.getItem("filtergridview");
        ControlAp schemeGridAp = formMetadata.getItem("schemefilterview");
        String validate = this.checkRepeat(new ControlAp[]{fastSearchGridAp, filterGridAp, schemeGridAp}, context);
        if (!validate.equals("")) {
            return validate;
        }
        validate = this.checkMobFilterSortPanel(formMetadata.getItems(), context);
        if (StringUtils.isNotBlank((CharSequence)validate)) {
            return validate;
        }
        return null;
    }

    private boolean checkFilterColumnAp(ControlAp<?> ap, ControlAp<?> refprop, List<ControlAp<?>> parentList, List<String> list, Set<String> repeateList, Set<ControlAp<?>> baseDataRepeatList, EntityMetadata entityMetadata) {
        String fieldName = ((FilterColumnAp)refprop).getFieldName();
        if ((ap instanceof FilterGridViewAp || ap instanceof MobAdvFilterPanelAp || ap instanceof MobFilterPanelAp) && this.checkControlRepeat(parentList, fieldName, entityMetadata, baseDataRepeatList, refprop)) {
            return true;
        }
        if (!list.contains(fieldName)) {
            if (fieldName != null) {
                parentList.add(refprop);
            }
            list.add(fieldName);
        } else {
            repeateList.add(refprop.getName().getLocaleValue());
        }
        return false;
    }

    private String getParentKey(String fieldName) {
        int lastIndexOf = fieldName.lastIndexOf(46);
        String parentKey = "";
        if (lastIndexOf > -1) {
            parentKey = fieldName.substring(0, lastIndexOf);
        }
        return parentKey;
    }

    private boolean checkControlRepeat(List<ControlAp<?>> parentList, String fieldKey, EntityMetadata entityMetadata, Set<ControlAp<?>> baseDataRepeatList, ControlAp<?> refprop) {
        String parentKey = this.getParentKey(fieldKey);
        if ("".equals(parentKey)) {
            return false;
        }
        boolean notCombo = this.isNotCombo(fieldKey, entityMetadata);
        for (ControlAp<?> controlAp : parentList) {
            String fieldName = ((FilterColumnAp)controlAp).getFieldName();
            if (!parentKey.equals(this.getParentKey(fieldName)) || !notCombo || !this.isNotCombo(fieldName, entityMetadata)) continue;
            baseDataRepeatList.add(controlAp);
            baseDataRepeatList.add(refprop);
            return true;
        }
        return false;
    }

    private boolean isNotCombo(String fieldKey, EntityMetadata entityMetadata) {
        IBasedataField basedataField;
        String[] split = fieldKey.split("\\.");
        int length = split.length;
        Field preField = entityMetadata.getFieldByKey(split[0]);
        String number = null;
        if (preField == null && length > 1) {
            String entityName;
            EntityMetadata entityMetadata1;
            if (entityMetadata.getRootEntity() instanceof QueryEntity && (entityMetadata1 = this.getEntityMetadata(entityName = ((QueryEntity)entityMetadata.getRootEntity()).getEntityName())) != null) {
                preField = entityMetadata1.getFieldByKey(split[0]);
                if (preField instanceof IBasedataField) {
                    basedataField = (IBasedataField)preField;
                    number = MetadataDao.getEntityNumberById((String)basedataField.getBaseEntityId());
                } else {
                    List joinEntitys = ((QueryEntity)entityMetadata.getRootEntity()).getJoinEntitys();
                    for (JoinEntity joinEntity : joinEntitys) {
                        if (!split[0].equals(joinEntity.getEntityName())) continue;
                        number = joinEntity.getEntityName();
                        break;
                    }
                }
            }
            if (number == null) {
                return false;
            }
        }
        if (number == null && preField instanceof IBasedataField) {
            number = MetadataDao.getEntityNumberById((String)((IBasedataField)preField).getBaseEntityId());
        }
        IDataEntityProperty findProperty = null;
        if (number != null) {
            int index;
            BillEntityType dt = this.basedataEntityTypeCacheMap.get(number);
            if (dt == null) {
                if (preField instanceof IBasedataField) {
                    basedataField = (IBasedataField)preField;
                    dt = (BillEntityType)EntityMetadataCache.getSubDataEntityType((String)number, (Collection)basedataField.getRuntimeRefProps());
                    this.basedataEntityTypeCacheMap.put(number, dt);
                } else {
                    dt = (BillEntityType)EntityMetadataCache.getSubDataEntityType((String)number, Collections.singletonList(split[1]));
                }
            }
            int n = index = "fbasedataid".equals(fieldKey.split("\\.")[1]) && preField instanceof MulBasedataField && length > 2 ? 2 : 1;
            if (length > 1) {
                findProperty = dt.findProperty(fieldKey.split("\\.")[index]);
            }
            if (length > index + 1 && findProperty instanceof BasedataProp) {
                BasedataEntityType complexType = (BasedataEntityType)((BasedataProp)findProperty).getComplexType();
                findProperty = complexType.findProperty(fieldKey.split("\\.")[index + 1]);
            }
            if (findProperty != null) {
                return !(findProperty instanceof ComboProp) && !(findProperty instanceof BooleanProp) && !(findProperty instanceof DateTimeProp);
            }
        }
        return false;
    }

    @Nullable
    private EntityMetadata getEntityMetadata(String entityName) {
        String id;
        EntityMetadata entityMetadata = this.entityMetadataCacheMap.get(entityName);
        if (entityMetadata == null && !this.entityMetadataCacheMap.containsKey(entityName) && StringUtils.isNotBlank((CharSequence)(id = MetadataDao.getIdByNumber((String)entityName, (MetaCategory)MetaCategory.Entity)))) {
            entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Entity);
            this.entityMetadataCacheMap.put(entityName, entityMetadata);
        }
        return entityMetadata;
    }

    private void checkFilterViewAp(ControlAp<?> ap, List<ControlAp<?>> items, String format, List<String> repeateMessages, List<Map<String, Object>> context) {
        ControlAp<?> refprop;
        ArrayList<String> list = new ArrayList<String>();
        HashSet<String> repeateList = new HashSet<String>();
        HashSet baseDataRepeatList = new HashSet();
        ArrayList parentList = new ArrayList();
        EntityMetadata entityMetadata = EntityMetadataUtil.getEntityMetadata(context);
        Iterator<ControlAp<?>> iterator = items.iterator();
        while (!(!iterator.hasNext() || (refprop = iterator.next()) instanceof FilterColumnAp && this.checkFilterColumnAp(ap, refprop, parentList, list, repeateList, baseDataRepeatList, entityMetadata))) {
        }
        if (!baseDataRepeatList.isEmpty()) {
            ArrayList<String> baseDataRepeatNameList = new ArrayList<String>(10);
            for (ControlAp controlAp : baseDataRepeatList) {
                baseDataRepeatNameList.add(controlAp.getName().getLocaleValue());
            }
            repeateMessages.add(String.format(ResManager.loadKDString((String)"%1$s\u7684\u5e38\u7528\u4e0d\u652f\u6301\u653e\u4e24\u4e2a\u76f8\u540c\u7684\u57fa\u7840\u8d44\u6599\uff1a%2$s\u3002", (String)"BillListCDWDesignerPlugin_10", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), ap.getName(), String.join((CharSequence)",", baseDataRepeatNameList)));
        }
        if (!repeateList.isEmpty()) {
            repeateMessages.add(String.format(format, ap.getName(), String.join((CharSequence)",", repeateList)));
        }
    }

    private String checkRepeat(ControlAp<?>[] aps, List<Map<String, Object>> context) {
        ArrayList<String> repeateMessages = new ArrayList<String>();
        List items = null;
        String format = ResManager.loadKDString((String)"%1$s\u7684\u5b57\u6bb5\u201c%2$s\u201d\u91cd\u590d\u3002", (String)"BillListCDWDesignerPlugin_11", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
        for (ControlAp<?> ap : aps) {
            FastSearchGridViewAp sFilterViewAp;
            if (ap instanceof FastSearchGridViewAp) {
                sFilterViewAp = (FastSearchGridViewAp)ap;
                items = sFilterViewAp.getItems();
            } else if (ap instanceof SchemeFilterViewAp) {
                sFilterViewAp = (SchemeFilterViewAp)ap;
                items = sFilterViewAp.getItems();
            } else if (ap instanceof FilterGridViewAp) {
                sFilterViewAp = (FilterGridViewAp)ap;
                items = sFilterViewAp.getItems();
            }
            if (items == null || items.isEmpty()) continue;
            this.checkFilterViewAp(ap, items, format, repeateMessages, context);
        }
        return String.join((CharSequence)"\r\n", repeateMessages);
    }

    private String checkMobFilterSortPanel(List<ControlAp<?>> items, List<Map<String, Object>> context) {
        ArrayList mobAdvFilterPanelItems = new ArrayList(10);
        ArrayList mobFilterPanelApItems = new ArrayList(10);
        ArrayList mobSortPanelApItems = new ArrayList(10);
        MobAdvFilterPanelAp mobAdvFilterPanelAp = null;
        int count = 0;
        for (ControlAp<?> ap : items) {
            if (ap instanceof MobAdvFilterPanelAp) {
                mobAdvFilterPanelAp = (MobAdvFilterPanelAp)ap;
                mobAdvFilterPanelItems.addAll(mobAdvFilterPanelAp.getItems());
                ++count;
            }
            if (ap instanceof MobFilterPanelAp) {
                MobFilterPanelAp mobFilterPanelAp = (MobFilterPanelAp)ap;
                mobFilterPanelApItems.addAll(mobFilterPanelAp.getItems());
            }
            if (!(ap instanceof MobSortPanelAp)) continue;
            MobSortPanelAp mobSortPanelAp = (MobSortPanelAp)ap;
            mobSortPanelApItems.addAll(mobSortPanelAp.getItems());
        }
        ArrayList<String> repeatMessages = new ArrayList<String>();
        this.checkMobRepeatField(mobFilterPanelApItems, repeatMessages, ResManager.loadKDString((String)"\u8fc7\u6ee4\u5b57\u6bb5\u201c%s\u201d\u91cd\u590d\uff0c\u8bf7\u79fb\u9664\u91cd\u590d\u8fc7\u6ee4\u5b57\u6bb5\u3002", (String)"BillListCDWDesignerPlugin_15", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        this.checkMobRepeatField(mobSortPanelApItems, repeatMessages, ResManager.loadKDString((String)"\u6392\u5e8f\u5b57\u6bb5\u201c%s\u201d\u91cd\u590d\uff0c\u8bf7\u79fb\u9664\u91cd\u590d\u6392\u5e8f\u5b57\u6bb5\u3002", (String)"BillListCDWDesignerPlugin_16", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        this.checkMobAdvFilterPanel(count, mobAdvFilterPanelAp, mobAdvFilterPanelItems, mobFilterPanelApItems, repeatMessages, context);
        return String.join((CharSequence)"\r\n", repeatMessages);
    }

    private void checkMobRepeatField(List<ControlAp<?>> filterSortItems, List<String> repeatMessages, String message) {
        StringBuilder filterSortMessage = new StringBuilder();
        HashMap<String, String> filterItemsName = new HashMap<String, String>(16);
        for (ControlAp<?> filterSortAp : filterSortItems) {
            String fieldName;
            if (filterSortAp instanceof FilterColumnAp) {
                fieldName = ((FilterColumnAp)filterSortAp).getFieldName();
            } else {
                if (!(filterSortAp instanceof MobSortColumnAp)) continue;
                fieldName = ((MobSortColumnAp)filterSortAp).getFieldName();
            }
            if (filterItemsName.containsKey(fieldName)) {
                filterSortMessage.append(filterSortAp.getName().toString()).append(fieldName).append(' ');
                continue;
            }
            filterItemsName.put(fieldName, filterSortAp.getName().toString());
        }
        if (StringUtils.isNotBlank((CharSequence)filterSortMessage.toString())) {
            repeatMessages.add(String.format(message, filterSortMessage.toString()));
        }
    }

    private void checkMobAdvFilterPanel(int count, MobAdvFilterPanelAp mobAdvFilterPanelAp, List<ControlAp<?>> mobAdvFilterPanelItems, List<ControlAp<?>> mobFilterPanelApItems, List<String> repeatMessages, List<Map<String, Object>> context) {
        if (mobAdvFilterPanelAp == null || CollectionUtils.isEmpty(mobAdvFilterPanelItems)) {
            return;
        }
        if (count > 1) {
            repeatMessages.add(ResManager.loadKDString((String)"\u53ea\u80fd\u6dfb\u52a0\u4e00\u4e2a\u9ad8\u7ea7\u7b5b\u9009\u9762\u677f\u3002", (String)"BillListCDWDesignerPlugin_12", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String format = ResManager.loadKDString((String)"%1$s\u7684\u5b57\u6bb5\u201c%2$s\u201d\u91cd\u590d\u3002", (String)"BillListCDWDesignerPlugin_11", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
        this.checkFilterViewAp((ControlAp<?>)mobAdvFilterPanelAp, mobAdvFilterPanelItems, format, repeatMessages, context);
        EntityMetadata entityMetadata = EntityMetadataUtil.getEntityMetadata(context);
        Map filterItems = mobFilterPanelApItems.stream().collect(Collectors.toMap(item -> {
            String fieldKey = ((FilterColumnAp)item).getFieldName();
            if (item instanceof MobCommonBaseDataFilterColumnAp && this.isNotCombo(fieldKey, entityMetadata)) {
                fieldKey = this.getParentKey(fieldKey);
            }
            return fieldKey;
        }, Function.identity(), (key1, key2) -> key2));
        HashSet<String> repeatList = new HashSet<String>();
        for (ControlAp<?> mobAdvFilterPanelItem : mobAdvFilterPanelItems) {
            String fieldKey = ((FilterColumnAp)mobAdvFilterPanelItem).getFieldName();
            if (mobAdvFilterPanelItem instanceof MobCommonBaseDataFilterColumnAp && this.isNotCombo(fieldKey, entityMetadata)) {
                fieldKey = this.getParentKey(fieldKey);
            }
            if (!filterItems.containsKey(fieldKey)) continue;
            repeatList.add(mobAdvFilterPanelItem.getName().toString());
        }
        if (CollectionUtils.isNotEmpty(repeatList)) {
            format = ResManager.loadKDString((String)"%1$s\u7684\u5b57\u6bb5%2$s\u4e0e\u79fb\u52a8\u8fc7\u6ee4\u9879\u4e2d\u7684\u91cd\u590d\u3002", (String)"BillListCDWDesignerPlugin_14", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
            repeatMessages.add(String.format(format, mobAdvFilterPanelAp.getName(), String.join((CharSequence)",", repeatList)));
        }
    }
}

