/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.property.AbstractPropertyPlugin;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.metadata.dao.EntityMetadataUtil;

public class ListFieldIdPlugin
extends AbstractPropertyPlugin
implements TreeNodeClickListener {
    private static final String IS_NEED_ENTRY_ENTITY = "isNeedEntryEntity";
    private static final String IS_NEED_BASE_DATA = "isNeedBaseData";
    private static final String IS_NEED_SEQ = "isNeedSeq";
    private static final String CHECKED_FIELDS = "checkedFields";
    private static final String REGEX = ",";
    private static final String BILL_LIST_AP = "BillListAp";
    private static final String FILTER_CONTAINER_AP = "FilterContainerAp";
    private static final String ID = "id";
    private static final String ORG_VALUE = "orgValue";
    private static final String TYPE = "Type";
    private static final String CARD = "Card";
    private static final String SEQ_TYPE = "SeqType";
    private static final String FIELD_TYPES = "fieldTypes";
    private static final String FIELDTREE = "fieldtree";
    private static final String ITEMS2 = "Items";
    private static final String TYPE2 = "_Type_";
    private static final String ITEM_ID = "itemId";
    private static final String IS_MULTI = "isMulti";
    private static final String FIELD_TREE = "FieldTree";
    private static final String META_TYPE = "metaType";
    private static final String PROPERTY_NAME = "propertyName";
    private static final String VALUE = "value";
    private static final String SHOW_STYLE = "ShowStyle";
    private static final String ALIAS = "alias";
    private static final String NAME = "Name";
    private static final String K = "Key";

    @Override
    public void initialize() {
        super.initialize();
        TreeView treeView = (TreeView)this.getControl(FIELDTREE);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    private List<Map<String, Object>> filterItems(List<Map<String, Object>> items, List<String> fieldTypes, boolean isNeedBaseData, boolean isNeedEntryEntity) {
        ArrayList<Map<String, Object>> newItems = new ArrayList<Map<String, Object>>(10);
        for (Map<String, Object> item : items) {
            if (isNeedEntryEntity && item.get(TYPE) != null && "Entity".equalsIgnoreCase(item.get(TYPE).toString())) {
                newItems.addAll(this.filterItems((List)item.get(ITEMS2), fieldTypes, isNeedBaseData, isNeedEntryEntity));
                continue;
            }
            boolean isBaseData = false;
            if (item.get("IsBaseData") != null) {
                isBaseData = (Boolean)item.get("IsBaseData");
            }
            if (!isNeedBaseData && isBaseData) continue;
            String dataType = "";
            if (item.get("DataType") != null) {
                dataType = item.get("DataType").toString();
            }
            if (fieldTypes.isEmpty() || !fieldTypes.contains(dataType.toLowerCase())) continue;
            newItems.add(item);
        }
        return newItems;
    }

    private void filterFields(Map<String, Object> fields) {
        List items = (List)fields.get(ITEMS2);
        List fieldTypes = new ArrayList(10);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get(FIELD_TYPES) != null) {
            fieldTypes = (List)customParams.get(FIELD_TYPES);
        }
        ArrayList<String> lowerCaseFieldTypes = new ArrayList<String>(10);
        for (String fieldType : fieldTypes) {
            lowerCaseFieldTypes.add(fieldType.toLowerCase());
        }
        boolean isNeedBaseData = true;
        if (customParams.get(IS_NEED_BASE_DATA) != null) {
            isNeedBaseData = (Boolean)customParams.get(IS_NEED_BASE_DATA);
        }
        boolean isNeedEntryEntity = true;
        if (customParams.get(IS_NEED_ENTRY_ENTITY) != null) {
            isNeedEntryEntity = (Boolean)customParams.get(IS_NEED_ENTRY_ENTITY);
        }
        List<Map<String, Object>> newItems = this.filterItems(items, lowerCaseFieldTypes, isNeedBaseData, isNeedEntryEntity);
        if (!fieldTypes.isEmpty()) {
            fields.put(ITEMS2, newItems);
        }
    }

    public void afterCreateNewData(EventObject e) {
        List contextList = (List)this.getView().getFormShowParameter().getCustomParams().get("context");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        boolean isNeedSeq = true;
        if (customParams.get(IS_NEED_SEQ) != null && !((Boolean)customParams.get(IS_NEED_SEQ)).booleanValue()) {
            isNeedSeq = false;
        }
        if (contextList != null) {
            List items = (List)contextList.get(0);
            String type = (String)customParams.get("type");
            String fieldType = (String)((Map)((List)contextList.get(1)).get(0)).get(TYPE2);
            HashMap<String, Object> itemMap = new HashMap<String, Object>(items.size());
            for (Map item : items) {
                itemMap.put((String)item.get("Id"), item);
            }
            if (!StringUtils.isBlank((CharSequence)type)) {
                this.addFieldListToModel(EntityMetadataUtil.getFieldlist((List)items), fieldType);
                return;
            }
            String itemId = (String)customParams.get(ITEM_ID);
            if (itemId == null) {
                return;
            }
            String entityId = "CommonBaseDataFilterColumnAp".equals(fieldType) || "SchemeBaseDataFilterColumnAp".equals(fieldType) ? ((Map)((List)contextList.get(1)).get(0)).get("BaseEntityId").toString() : this.getEntityId(itemId, itemMap);
            if (entityId != null) {
                Map fields = EntityMetadataUtil.getListFields((String)entityId, (boolean)isNeedSeq);
                this.filterFields(fields);
                this.addFieldListToModel(fields, fieldType);
                this.setTreeNodeMultiSelect(customParams, entityId);
                return;
            }
        }
        this.doWithNullContextList(isNeedSeq, customParams);
    }

    private void doWithNullContextList(boolean isNeedSeq, Map<String, Object> customParams) {
        String entityId = (String)customParams.get("entityId");
        if (entityId != null) {
            Map fields = EntityMetadataUtil.getListFields((String)entityId, (boolean)isNeedSeq);
            this.filterFields(fields);
            this.addFieldListToModel(fields, null);
        }
        this.setTreeNodeMultiSelect(customParams, entityId);
    }

    private void setTreeNodeMultiSelect(Map<String, Object> customParams, String entityId) {
        if (customParams.get(IS_MULTI) != null && ((Boolean)customParams.get(IS_MULTI)).booleanValue()) {
            TreeView treeView = (TreeView)this.getControl(FIELDTREE);
            treeView.setMulti(true);
            if (customParams.get(CHECKED_FIELDS) == null) {
                return;
            }
            String checkFields = customParams.get(CHECKED_FIELDS).toString();
            for (String checkField : checkFields.split(REGEX)) {
                treeView.checkNode(new TreeNode(entityId, checkField, checkField));
            }
        }
    }

    private void addFieldListToModel(Map<String, Object> fields, String fieldType) {
        HashMap<String, Integer> existIds = new HashMap<String, Integer>(10);
        TreeNode root = this.Parse("", fields, "Id", NAME, ITEMS2, existIds);
        root.setIsOpened(true);
        TreeView treeView = (TreeView)this.getControl(FIELDTREE);
        treeView.addNode(root);
        this.getPageCache().put(FIELD_TREE, SerializationUtils.toJsonString((Object)root));
        this.getPageCache().put("FieldType", fieldType);
    }

    private TreeNode Parse(String rootParentId, Map<String, Object> map, String idKey, String textKey, String itemsKey, Map<String, Integer> existIds) {
        Object items = map.get(itemsKey);
        String id = (String)map.get(idKey);
        Integer repeat = existIds.get(id);
        if (repeat != null) {
            repeat = repeat + 1;
            existIds.put(id, repeat);
            id = String.format("%s$%s", id, repeat);
        } else {
            existIds.put(id, 0);
        }
        TreeNode root = new TreeNode(rootParentId, id, (String)map.get(textKey), items != null, map);
        if (items instanceof List) {
            List children = (List)items;
            for (Map item : children) {
                TreeNode node = this.Parse(root.getId(), item, idKey, textKey, itemsKey, existIds);
                root.addChild(node);
            }
        }
        return root;
    }

    private String getEntityId(String id, Map<String, Object> itemMap) {
        Map item = (Map)itemMap.get(id);
        if (item == null) {
            return null;
        }
        if (BILL_LIST_AP.equals(item.get(TYPE2)) || FILTER_CONTAINER_AP.equals(item.get(TYPE2))) {
            return (String)item.get("EntityId");
        }
        String parentId = (String)item.get("ParentId");
        if (parentId == null) {
            return null;
        }
        Map parentItem = (Map)itemMap.get(parentId);
        if (parentItem == null) {
            return null;
        }
        if (BILL_LIST_AP.equals(parentItem.get(TYPE2)) || FILTER_CONTAINER_AP.equals(item.get(TYPE2))) {
            return (String)parentItem.get("EntityId");
        }
        return this.getEntityId((String)parentItem.get("Id"), itemMap);
    }

    private Map<String, Object> getReturnPara() {
        HashMap<String, Object> para = new HashMap<String, Object>(4);
        para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
        para.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
        para.put(PROPERTY_NAME, this.getView().getFormShowParameter().getCustomParams().get(PROPERTY_NAME));
        return para;
    }

    @Override
    protected void returnData() {
        TreeView treeView = (TreeView)this.getControl(FIELDTREE);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        ArrayList<Map<String, Object>> paras = new ArrayList<Map<String, Object>>();
        if (this.getPageCache().get(FIELD_TREE) == null) {
            return;
        }
        if (customParams.get(IS_MULTI) != null && ((Boolean)customParams.get(IS_MULTI)).booleanValue()) {
            Map<String, Object> para;
            boolean isFormDesign;
            TreeView.TreeState treeState = treeView.getTreeState();
            TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(FIELD_TREE), TreeNode.class);
            boolean bl = isFormDesign = customParams.get("isFormDesign") != null && (Boolean)customParams.get("isFormDesign") != false;
            if (isFormDesign) {
                para = this.getReturnPara();
                HashMap<String, Object> valueMap = new HashMap<String, Object>(16);
                if ("SummaryFieldIds".equals(customParams.get(PROPERTY_NAME))) {
                    ListFieldIdPlugin.createSummaryFieldIds(treeState, root, valueMap, "SummaryFieldIds", "SummaryFieldId");
                }
                para.put(VALUE, valueMap);
            } else {
                ArrayList<String> selectedNodeIds = new ArrayList<String>(10);
                for (String selectedNodeId : treeState.getSelectedNodeId()) {
                    if (selectedNodeId.equalsIgnoreCase(root.getId())) continue;
                    selectedNodeIds.add(selectedNodeId.split("\\$")[0]);
                }
                para = this.getReturnPara();
                para.put(VALUE, String.join((CharSequence)REGEX, selectedNodeIds));
            }
            paras.add(para);
            this.getView().returnDataToParent(paras);
            this.getView().close();
            return;
        }
        Map focusNode = treeView.getTreeState().getFocusNode();
        if (focusNode != null && "".equals(focusNode.get("parentid"))) {
            return;
        }
        if (focusNode == null || !focusNode.containsKey(ID)) {
            this.getView().returnDataToParent(paras);
            this.getView().close();
            return;
        }
        this.postReturnData(customParams, paras, focusNode);
    }

    private static void createSummaryFieldIds(TreeView.TreeState treeState, TreeNode root, Map<String, Object> valueMap, String propertyName, String typeName) {
        valueMap.put(TYPE2, propertyName);
        ArrayList summaryFieldIdList = new ArrayList(10);
        for (String selectedNodeId : treeState.getSelectedNodeId()) {
            if (selectedNodeId.equalsIgnoreCase(root.getId())) continue;
            HashMap<String, String> subValueMap = new HashMap<String, String>(16);
            subValueMap.put(TYPE2, typeName);
            subValueMap.put("FieldName", selectedNodeId.split("\\$")[0]);
            summaryFieldIdList.add(subValueMap);
        }
        valueMap.put(propertyName, summaryFieldIdList);
    }

    private String getNewKey(String key) {
        List contextList = (List)this.getView().getFormShowParameter().getCustomParams().get("context");
        if (contextList != null) {
            List items = (List)contextList.get(0);
            HashSet<String> set = new HashSet<String>(16);
            for (Map item : items) {
                set.add((String)item.get(K));
            }
            if (!set.contains(key)) {
                return key;
            }
            for (int i = 1; i < 100; ++i) {
                if (set.contains(key + i)) continue;
                return key + i;
            }
            return "";
        }
        return key;
    }

    private void postReturnData(Map<String, Object> customParams, List<Map<String, Object>> paras, Map<String, Object> focusNode) {
        String focusNodeId = focusNode.get(ID).toString().split("\\$")[0];
        Map<String, Object> para = this.getReturnPara();
        para.put(VALUE, focusNodeId);
        paras.add(para);
        if (customParams.get(ORG_VALUE) != null && customParams.get(ORG_VALUE) instanceof Boolean && ((Boolean)customParams.get(ORG_VALUE)).booleanValue()) {
            this.getView().returnDataToParent(paras);
            this.getView().close();
            return;
        }
        String fieldType = this.getPageCache().get("FieldType");
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(FIELD_TREE), TreeNode.class);
        Map data = (Map)root.getTreeNode((String)focusNode.get(ID), 16).getData();
        if (data != null) {
            HashMap namePara = new HashMap(10);
            namePara.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
            namePara.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
            namePara.put(PROPERTY_NAME, NAME);
            namePara.put(VALUE, data.get(NAME));
            namePara.put(ALIAS, data.get("Id"));
            paras.add(namePara);
            String key = this.getNewKey(focusNodeId);
            if (!StringUtils.isBlank((CharSequence)key)) {
                HashMap keyPara = new HashMap(10);
                keyPara.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
                keyPara.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
                keyPara.put(PROPERTY_NAME, K);
                keyPara.put(VALUE, key);
                keyPara.put(ALIAS, data.get("Id"));
                paras.add(keyPara);
            }
        }
        if (data != null && data.containsKey(TYPE)) {
            para = new HashMap<String, Object>(4);
            para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
            para.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
            para.put(PROPERTY_NAME, TYPE2);
            fieldType = fieldType != null && fieldType.startsWith(CARD) ? CARD + data.get(TYPE) : (String)data.get(TYPE);
            para.put(VALUE, fieldType);
            paras.add(para);
        }
        if (data != null && data.containsKey(SHOW_STYLE)) {
            para = new HashMap<String, Object>(4);
            para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
            para.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
            para.put(PROPERTY_NAME, SHOW_STYLE);
            para.put(VALUE, data.get(SHOW_STYLE));
            paras.add(para);
        }
        if (data != null && data.containsKey(SEQ_TYPE)) {
            para = new HashMap<String, Object>(4);
            para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
            para.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
            para.put(PROPERTY_NAME, "SeqColumnType");
            para.put(VALUE, data.get(SEQ_TYPE));
            paras.add(para);
        }
        this.getView().returnDataToParent(paras);
        this.getView().close();
    }

    public void treeNodeClick(TreeNodeEvent arg0) {
    }

    public void treeNodeDoubleClick(TreeNodeEvent arg0) {
        this.returnData();
    }
}

