/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.EntityMetadataUtil;
import org.apache.commons.collections4.map.CaseInsensitiveMap;

public class ListFieldPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String ENTRY_SOURCE = "entry_source";
    private static final String ENTRY_TARGET = "entry_target";
    private static final String TXT_KEY_TARGET = "txtkeytarget";
    private static final String TXT_FIELD_TARGET = "txtfieldtarget";
    private static final String TXT_WIDTH = "txtWidth";
    private static final String CBF_IS_LOOKUP = "cbfIsLookup";
    private static final String CBF_SHOW_STYLE = "cbfShowStyle";
    private static final String STRING = "%s.%s";
    private static final String TXT_KEY = "txtkey";
    private static final String TXT_FIELD = "txtfield";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btncancel", "btnadd", "btnremove"});
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_SOURCE);
        grid.addRowClickListener((RowClickEventListener)this);
        AbstractGrid gridtarget = (AbstractGrid)this.getView().getControl(ENTRY_TARGET);
        gridtarget.addRowClickListener((RowClickEventListener)this);
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        if ("btnok".equalsIgnoreCase(c.getKey())) {
            this.reurnData();
        } else if ("btncancel".equalsIgnoreCase(c.getKey())) {
            this.getView().close();
        } else if ("btnadd".equals(c.getKey())) {
            this.addField();
        } else if ("btnremove".equals(c.getKey())) {
            this.delField();
        }
    }

    private void reurnData() {
        List<Map<String, Object>> row = this.getCurrentSelector();
        if (row != null) {
            HashMap para = new HashMap(16);
            para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
            para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
            para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
            para.put("value", row);
            this.getView().returnDataToParent(para);
            this.getView().close();
        }
    }

    private List<Map<String, Object>> getCurrentSelector() {
        ArrayList<Map<String, Object>> paras = new ArrayList<Map<String, Object>>();
        DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTRY_TARGET);
        if (collection != null) {
            int i = 1;
            for (DynamicObject dynamicObject : collection) {
                HashMap<String, Object> listField = new HashMap<String, Object>();
                String key = (String)dynamicObject.get(TXT_KEY_TARGET);
                String field = (String)dynamicObject.get(TXT_FIELD_TARGET);
                int width = dynamicObject.get(TXT_WIDTH) == null ? 100 : Integer.parseInt(dynamicObject.get(TXT_WIDTH).toString());
                boolean isLookup = dynamicObject.get(CBF_IS_LOOKUP) == null ? false : (Boolean)dynamicObject.get(CBF_IS_LOOKUP);
                int showStyle = dynamicObject.get(CBF_SHOW_STYLE) == null ? 0 : Integer.parseInt(dynamicObject.get(CBF_SHOW_STYLE).toString());
                String fontColor = (String)dynamicObject.get("txtFontColor");
                listField.put("_Type_", "ComboListField");
                listField.put("Key", key);
                listField.put("Header", field);
                listField.put("Seq", i);
                listField.put("Width", width);
                listField.put("Lookup", isLookup);
                listField.put("ShowStyle", showStyle);
                listField.put("FontColor", fontColor);
                ++i;
                paras.add(listField);
            }
        }
        return paras;
    }

    int addBaseProperty(BasedataEntityType dt, List<Map<String, Object>> fieldlist, String name, String key, Map<String, String> selectFields) {
        int i = 0;
        if (!selectFields.containsKey(String.format(STRING, key, dt.getNumberProperty()))) {
            HashMap<String, String> numProp = new HashMap<String, String>();
            numProp.put("Key", String.format(STRING, key, dt.getNumberProperty()));
            numProp.put("Name", name);
            fieldlist.add(numProp);
            ++i;
        }
        if (!selectFields.containsKey(String.format(STRING, key, dt.getNameProperty()))) {
            HashMap<String, String> nameProp = new HashMap<String, String>();
            nameProp.put("Key", String.format(STRING, key, dt.getNameProperty()));
            nameProp.put("Name", name);
            fieldlist.add(nameProp);
            ++i;
        }
        return i;
    }

    public void afterCreateNewData(EventObject e) {
        Object context;
        IDataModel model = this.getModel();
        Object value = this.getView().getFormShowParameter().getCustomParam("value");
        List item = value == null || StringUtils.isEmpty((CharSequence)value.toString()) ? new ArrayList() : (List)value;
        CaseInsensitiveMap selectFields = new CaseInsensitiveMap();
        if (item.size() > 0) {
            model.batchCreateNewEntryRow(ENTRY_TARGET, item.size());
            int i = 0;
            for (Map fieldName : item) {
                String key = (String)fieldName.get("Key");
                model.setValue(TXT_KEY_TARGET, (Object)key, i);
                model.setValue(TXT_FIELD_TARGET, fieldName.get("Header"), i);
                model.setValue(TXT_WIDTH, fieldName.get("Width"), i);
                model.setValue(CBF_IS_LOOKUP, fieldName.get("Lookup"), i);
                model.setValue(CBF_SHOW_STYLE, fieldName.get("ShowStyle"), i);
                model.setValue("txtFontColor", fieldName.get("FontColor"), i);
                selectFields.put(key, key);
                ++i;
            }
        }
        if ((context = this.getView().getFormShowParameter().getCustomParam("context")) instanceof List) {
            List items = (List)this.getView().getFormShowParameter().getCustomParams().get("context");
            Map fields = EntityMetadataUtil.getFieldlist((List)items);
            this.addFieldListToSourceModel(model, (Map<String, String>)selectFields, fields);
        }
    }

    private void addFieldListToSourceModel(IDataModel model, Map<String, String> selectFields, Map<String, Object> fields) {
        TreeNode root = TreeNode.Parse((String)"", fields, (String)"Id", (String)"Name", (String)"Items");
        root.iterate(16, node -> {
            if (!selectFields.containsKey(node.getId())) {
                int i = model.createNewEntryRow(ENTRY_SOURCE);
                model.setValue(TXT_KEY, (Object)node.getId(), i);
                model.setValue(TXT_FIELD, (Object)node.getText(), i);
            }
        });
    }

    private void addField() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_SOURCE);
        int[] rows = grid.getEntryState().getSelectedRows();
        IDataModel model = this.getModel();
        if (rows.length > 0) {
            DynamicObjectCollection coll = model.getEntryEntity(ENTRY_TARGET);
            if (coll != null) {
                int i = 0;
                for (DynamicObject obj : coll) {
                    Object key = obj.get(TXT_KEY_TARGET);
                    if (key == null) {
                        model.deleteEntryRow(ENTRY_TARGET, i);
                    }
                    ++i;
                }
            }
            int[] nArray = rows;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int rowKey;
                int row1;
                int row = row1 = nArray[i];
                String key = (String)model.getValue(TXT_KEY, row);
                String field = (String)model.getValue(TXT_FIELD, row);
                int row2 = rowKey = model.createNewEntryRow(ENTRY_TARGET);
                model.setValue(TXT_KEY_TARGET, (Object)key, row2);
                model.setValue(TXT_FIELD_TARGET, (Object)field, row2);
                model.deleteEntryRow(ENTRY_SOURCE, row);
            }
        }
        this.getView().updateView();
    }

    private void delField() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_TARGET);
        int[] rows = grid.getEntryState().getSelectedRows();
        IDataModel model = this.getModel();
        if (rows.length > 0) {
            DynamicObjectCollection coll = model.getEntryEntity(ENTRY_SOURCE);
            if (coll != null) {
                int i = 0;
                for (DynamicObject obj : coll) {
                    Object key = obj.get(TXT_KEY);
                    if (key == null) {
                        model.deleteEntryRow(ENTRY_SOURCE, i);
                    }
                    ++i;
                }
            }
            for (int row : rows) {
                if (!StringUtils.isNotBlank((Object)row)) continue;
                String key = (String)model.getValue(TXT_KEY_TARGET, row);
                String field = (String)model.getValue(TXT_FIELD_TARGET, row);
                int rowKey = model.createNewEntryRow(ENTRY_SOURCE);
                model.setValue(TXT_KEY, (Object)key, rowKey);
                model.setValue(TXT_FIELD, (Object)field, rowKey);
                model.deleteEntryRow(ENTRY_TARGET, row);
            }
            this.getView().updateView();
        }
    }

    public void entryRowClick(RowClickEvent evt) {
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
    }
}

