/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.entity.commonfield.LongPressItem;
import kd.bos.metadata.extensible.ExtensibleDao;

public class LongPressOpEditPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String Id_EntryEntity = "entryentity";
    private static final String Id_fID = "fid";
    private static final String Id_fKey = "fkey";
    private static final String Id_fName = "fname";
    private static final String Id_fOpKey = "foperationkey";
    private static final String Id_fVisible = "fvisible";
    private static final String Id_fLock = "flock";
    private static final String Id_Btnok = "btnok";
    private static final String FormId_Ope = "ide_operationselect";
    private static final String ActionId_SelectOpe = "operationselect";
    private static final String CONTEXT = "context";
    private static final String VALUE = "value";
    private static final String OpName = "opName";
    private static final String KEY_LOCK = "flock";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(Id_EntryEntity);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        entryGrid.addPackageDataListener(this::handlePackageDataEvent);
    }

    private void handlePackageDataEvent(PackageDataEvent packageDataEvent) {
        Object ctl = packageDataEvent.getSource();
        int rowIndex = packageDataEvent.getRowIndex();
        if (ctl instanceof Control && "flock".equals(((Control)ctl).getKey())) {
            String itemsCache = this.getPageCache().get("oriDropdownItems_cache");
            Map map = (Map)SerializationUtils.fromJsonString((String)itemsCache, Map.class);
            packageDataEvent.setComboList(this.getComboItemsForMultiCombo(rowIndex, map));
        }
    }

    private List<Object> getComboItemsForMultiCombo(int rowIndex, Map<String, List<String>> map) {
        String id = (String)this.getModel().getValue(Id_fID, rowIndex);
        boolean newDisable = false;
        boolean editDisable = false;
        boolean viewDisable = false;
        boolean submitDisable = false;
        boolean auditDisable = false;
        if (map.containsKey(id)) {
            List<String> locks = map.get(id);
            if (locks.contains("new")) {
                newDisable = true;
            }
            if (locks.contains("edit")) {
                editDisable = true;
            }
            if (locks.contains("view")) {
                viewDisable = true;
            }
            if (locks.contains("submit")) {
                submitDisable = true;
            }
            if (locks.contains("audit")) {
                auditDisable = true;
            }
        }
        return Arrays.asList(this.createComboItem(ResManager.loadKDString((String)"\u65b0\u589e\u9501\u5b9a", (String)"DropdownMenuEditPlugin_4", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "new", newDisable), this.createComboItem(ResManager.loadKDString((String)"\u4fee\u6539\u9501\u5b9a", (String)"DropdownMenuEditPlugin_5", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "edit", editDisable), this.createComboItem(ResManager.loadKDString((String)"\u67e5\u770b\u9501\u5b9a", (String)"DropdownMenuEditPlugin_6", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "view", viewDisable), this.createComboItem(ResManager.loadKDString((String)"\u63d0\u4ea4\u9501\u5b9a", (String)"DropdownMenuEditPlugin_7", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "submit", submitDisable), this.createComboItem(ResManager.loadKDString((String)"\u5ba1\u6838\u9501\u5b9a", (String)"DropdownMenuEditPlugin_8", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "audit", auditDisable));
    }

    private ComboItem createComboItem(String localeString, String value, boolean disable) {
        ComboItem item = new ComboItem(new LocaleString(localeString), value);
        item.setDisable(disable);
        return item;
    }

    public void afterBindData(EventObject e) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(Id_EntryEntity, "setColEditorProp", new Object[]{"flock", "isDynamicOption", true});
        EntryGrid grid = (EntryGrid)this.getView().getControl(Id_EntryEntity);
        grid.setColumnProperty("flock", "sort", (Object)false);
        grid.setColumnProperty("flock", "filter", (Object)false);
    }

    public void entryRowClick(RowClickEvent evt) {
        String id = (String)this.getModel().getValue(Id_fID, evt.getRow());
        String itemsCache = this.getPageCache().get("oriDropdownItems_cache");
        Map idSet = (Map)SerializationUtils.fromJsonString((String)itemsCache, Map.class);
        String isLock = "false";
        if (idSet.containsKey(id)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"baritemap"});
            isLock = "true";
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"baritemap"});
        }
        this.getPageCache().put("currentRowIsLock", isLock);
    }

    private void initLockRows(List<Map<String, Object>> items) {
        EntryGrid grid = (EntryGrid)this.getControl(Id_EntryEntity);
        Map<String, Set<String>> idSet = this.initBaseProps();
        if (!idSet.isEmpty()) {
            int i = 0;
            int k = 0;
            int[] lockIndexes = new int[idSet.size()];
            for (Map<String, Object> item : items) {
                if (idSet.containsKey((String)item.get("Id"))) {
                    lockIndexes[k++] = i;
                }
                ++i;
            }
            for (Object lockIndex : (Object)lockIndexes) {
                this.getView().setEnable(Boolean.FALSE, (int)lockIndex, new String[]{Id_fKey, Id_fName});
                this.setEntryFieldSX(Id_EntryEntity, Id_fOpKey);
            }
        }
    }

    private Map<String, Set<String>> initBaseProps() {
        String mainEntityId;
        Object listCustData;
        List context = (List)this.getView().getFormShowParameter().getCustomParam(CONTEXT);
        String itemId = (String)this.getView().getFormShowParameter().getCustomParam("itemId");
        if (context.get(0) instanceof List) {
            listCustData = (List)context.get(0);
            mainEntityId = (String)((Map)listCustData.get(0)).get("Id");
        } else if (context.get(0) instanceof Map) {
            listCustData = (Map)context.get(0);
            mainEntityId = (String)listCustData.get("Id");
        } else {
            return Collections.emptyMap();
        }
        Set oriDropdownItems = ExtensibleDao.getBasePropIds((IPageCache)this.getView().getPageCache(), (MetaCategory)MetaCategory.Form, (String)mainEntityId, (String)itemId, (String)"LongPressOperation", (boolean)false, o -> {
            HashSet<String> strings = new HashSet<String>(8);
            List dis = (List)o;
            for (LongPressItem di : dis) {
                strings.add(String.format("%1$s@_@%2$s", di.getId(), di.getLock()));
            }
            return strings;
        });
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(16);
        if (StringUtils.isNotBlank((Object)oriDropdownItems)) {
            for (String str : oriDropdownItems) {
                HashSet<Object> ss = new HashSet(10);
                String[] split = str.split("@_@");
                if (split.length > 1 && StringUtils.isNotBlank((CharSequence)split[1])) {
                    ss = new HashSet<String>(Arrays.asList(split[1].split(",")));
                }
                map.put(split[0], ss);
            }
        }
        this.getPageCache().put("oriDropdownItems_cache", SerializationUtils.toJsonString(map));
        return map;
    }

    private void setEntryFieldSX(String entryKey, String fldKey) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(entryKey, "setColEditorProp", new Object[]{fldKey, "sx", false});
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{Id_Btnok});
        TextEdit opeKey = (TextEdit)this.getControl(Id_fOpKey);
        opeKey.addButtonClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.loadLongPressConfigItems();
    }

    private void loadLongPressConfigItems() {
        Object value = this.getView().getFormShowParameter().getCustomParams().get(VALUE);
        List items = (List)value;
        if (items != null && !items.isEmpty()) {
            IDataModel model = this.getModel();
            int[] rowIndex = model.batchCreateNewEntryRow(Id_EntryEntity, items.size());
            int i = 0;
            for (Map item : items) {
                model.setValue(Id_fID, item.get("Id"), rowIndex[i]);
                model.setValue(Id_fKey, item.get("Key"), rowIndex[i]);
                model.setValue(Id_fName, item.get("Name"), rowIndex[i]);
                model.setValue(Id_fOpKey, item.get("OpKey"), rowIndex[i]);
                model.setValue(Id_fVisible, item.get("Visible"), rowIndex[i]);
                model.setValue("flock", item.get("Lock"), rowIndex[i]);
                ++i;
            }
        }
        this.initLockRows(items);
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.returnData();
                break;
            }
            case "foperationkey": {
                this.showOperationSelector();
                break;
            }
        }
    }

    private void showOperationSelector() {
        FormShowParameter parameter = new FormShowParameter();
        List context = (List)this.getView().getFormShowParameter().getCustomParam(CONTEXT);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId(FormId_Ope);
        parameter.setCustomParam("isLock", (Object)this.getPageCache().get("currentRowIsLock"));
        parameter.setCustomParam("bizext", this.getView().getFormShowParameter().getCustomParam("bizext"));
        parameter.setCustomParam(CONTEXT, (Object)context);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ActionId_SelectOpe));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (evt.getReturnData() == null) {
            return;
        }
        String actionId = evt.getActionId();
        IDataModel model = this.getModel();
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(Id_EntryEntity);
        int rowIndex = grid.getEntryState().getFocusRow();
        switch (actionId) {
            case "operationselect": {
                Object data = evt.getReturnData();
                if (data instanceof Map) {
                    model.setValue(Id_fOpKey, ((Map)data).get(VALUE), rowIndex);
                    model.setValue(Id_fKey, ((Map)data).get(VALUE), rowIndex);
                    model.setValue(Id_fName, ((Map)data).get(OpName), rowIndex);
                    break;
                }
                model.setValue(Id_fOpKey, ((Map)((List)data).get(0)).get(VALUE), rowIndex);
                model.setValue(Id_fKey, ((Map)((List)data).get(0)).get(VALUE), rowIndex);
                model.setValue(Id_fName, ((Map)((List)data).get(0)).get(OpName), rowIndex);
                break;
            }
        }
    }

    private void returnData() {
        HashSet<String> allKeys = new HashSet<String>(16);
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>(10);
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount(Id_EntryEntity);
        for (int i = 0; i < rowCount; ++i) {
            String id = (String)model.getValue(Id_fID, i);
            String key = (String)model.getValue(Id_fKey, i);
            String name = (String)model.getValue(Id_fName, i);
            String opKey = (String)model.getValue(Id_fOpKey, i);
            String visible = (String)model.getValue(Id_fVisible, i);
            String lock = (String)model.getValue("flock", i);
            if (StringUtils.isBlank((CharSequence)key)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b2c%d\u884c\uff1a\u201c\u6807\u8bc6\u201d\u3002", (String)"LongPressOpEditPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), i + 1));
                return;
            }
            if (StringUtils.isBlank((CharSequence)name)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b2c%d\u884c\uff1a\u201c\u540d\u79f0\u201d\u3002", (String)"LongPressOpEditPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), i + 1));
                return;
            }
            if (allKeys.contains(key)) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u201c\u6807\u8bc6\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"LongPressOpEditPlugin_2", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), i + 1));
                return;
            }
            allKeys.add(key);
            LongPressItem item = new LongPressItem(id, key, name, opKey, visible, lock, i + 1);
            DcJsonSerializer serializer = new DcJsonSerializer(new DcBinder(){

                public IDataEntityType tryBindToType(String paramString, Map<String, String> paramMap) {
                    return OrmUtils.getDataEntityType(LongPressItem.class);
                }
            });
            items.add(serializer.serializeToMap((Object)item, null));
        }
        HashMap retData = new HashMap();
        retData.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        retData.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        retData.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        retData.put(VALUE, items);
        retData.put("alias", this.getAlias(items));
        this.getView().returnDataToParent(retData);
        this.getView().close();
    }

    private String getAlias(List<Map<String, Object>> items) {
        if (items == null || items.isEmpty()) {
            return " ";
        }
        StringBuilder alias = new StringBuilder();
        for (Map<String, Object> item : items) {
            alias.append(alias.length() == 0 ? alias.toString() : "; ");
            alias.append(item.get("Name").toString());
        }
        return alias.toString();
    }
}

