/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.ListDcxmlBinder;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.metadata.form.MenuItem;

public class MenuItemsEditPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String F_OPERATION_KEY = "FOperationKey";
    private static final String VALUE = "value";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    String entryKey = "EntryEntity";

    public void initialize() {
        Button btncancel = (Button)this.getView().getControl("btncancel");
        Button btnok = (Button)this.getView().getControl("btnok");
        btncancel.addClickListener((ClickListener)this);
        btnok.addClickListener((ClickListener)this);
        TextEdit operationSelect = (TextEdit)this.getControl(F_OPERATION_KEY);
        operationSelect.addButtonClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Object value = this.getView().getFormShowParameter().getCustomParams().get(VALUE);
        List items = (List)(value instanceof List ? value : new ArrayList());
        if (items != null && items.size() > 0) {
            IDataModel model = this.getModel();
            int[] rowIndexs = model.batchCreateNewEntryRow(this.entryKey, items.size());
            int i = 0;
            if (items.size() > 0) {
                model.setValue("FMenuName", ((Map)items.get(0)).get("MenuName"));
            }
            for (Map item : items) {
                model.setValue(F_OPERATION_KEY, item.get("OperationKey"), rowIndexs[i]);
                model.setValue("FKey", item.get("Key"), rowIndexs[i]);
                model.setValue("FName", item.get("Name"), rowIndexs[i]);
                ++i;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase(Locale.ENGLISH)) {
            case "foperationkey": {
                this.showOperationSelector(evt);
                break;
            }
            case "btnok": {
                this.returnData();
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
        }
    }

    private void showOperationSelector(EventObject evt) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("ide_operationselect");
        parameter.setCustomParam("bizext", this.getView().getFormShowParameter().getCustomParam("bizext"));
        parameter.setCustomParam("context", this.getView().getFormShowParameter().getCustomParam("context"));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectOperation"));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (evt.getReturnData() == null) {
            return;
        }
        String actionId = evt.getActionId();
        if ("selectOperation".equalsIgnoreCase(actionId)) {
            AbstractGrid grid = (AbstractGrid)this.getView().getControl(this.entryKey);
            int rowKey = grid.getEntryState().getFocusRow();
            List retData = (List)evt.getReturnData();
            if (retData != null && !retData.isEmpty()) {
                this.getModel().setValue(F_OPERATION_KEY, (Object)((String)((Map)retData.get(0)).get(VALUE)), rowKey);
            }
        }
    }

    private void returnData() {
        if (!this.validate()) {
            return;
        }
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        para.put(VALUE, this.getMenuItems());
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    private boolean validate() {
        DynamicObjectCollection dyObjs = this.getModel().getEntryEntity("entryentity");
        ArrayList<String> keyList = new ArrayList<String>(dyObjs.size());
        for (DynamicObject obj : dyObjs) {
            keyList.add(obj.getString("fkey"));
        }
        if (keyList.size() != new HashSet(keyList).size()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u6807\u8bc6\uff0c\u8bf7\u4fee\u6539\u3002", (String)"MenuItemsEditPlugin_1", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private Object getMenuItems() {
        ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        IDataModel model = this.getModel();
        DynamicObjectCollection rowKeyobjs = model.getEntryEntity(this.entryKey);
        String menuName = (String)model.getValue("FMenuName");
        LocaleString menuN = new LocaleString();
        menuN.setItem(Lang.get().name(), (Object)menuName);
        if (rowKeyobjs != null) {
            int i = 0;
            LocaleString menuDetail = null;
            for (DynamicObject rowKeyObj : rowKeyobjs) {
                menuDetail = new LocaleString();
                menuDetail.setItem(Lang.get().name(), (Object)((String)model.getValue("FName", i)));
                items.add(new MenuItem(i, menuN, (String)model.getValue("FKey", i), menuDetail, (String)model.getValue(F_OPERATION_KEY, i)));
                ++i;
            }
        }
        MenuJsonSerializer menuJson = new MenuJsonSerializer();
        menuJson.setItems(items);
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(MenuJsonSerializer.class));
        DcJsonSerializer serializer = new DcJsonSerializer((DcBinder)new ListDcxmlBinder(false, dts));
        Map mapMenu = serializer.serializeToMap((Object)menuJson, null);
        return mapMenu.containsKey("Items") ? mapMenu.get("Items") : items;
    }

    public static class MenuJsonSerializer {
        private List<MenuItem> items = new ArrayList<MenuItem>();

        @CollectionPropertyAttribute(collectionItemPropertyType=MenuItem.class)
        public List<MenuItem> getItems() {
            return this.items;
        }

        public void setItems(List<MenuItem> items) {
            this.items = items;
        }
    }
}

