/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.filter.DefaultHiddenField;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.filter.CommonFilterColumnAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.mcontrol.MobAdvFilterPanelAp;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.orm.util.CollectionUtils;

public class MobAdvInitialFieldPlugin
extends AbstractFormPlugin {
    private static final String NAME = "name";
    private static final String CHECKED = "Checked";
    private static final String CONTEXT = "context";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String FIELD_NAME = "FieldName";
    private static final String VALUE = "value";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
        this.addClickListeners(new String[]{"btncancel"});
        super.registerListener(e);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "btnok": {
                this.returnDataToParentAndClose();
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        PropertyEditHelper helper = new PropertyEditHelper();
        Map<String, LocaleString> cansetFields = this.canSetFields(helper);
        if (CollectionUtils.isEmpty(cansetFields)) {
            return;
        }
        List defaultFields = (List)helper.getParamValue(this.getView(), VALUE);
        HashSet<String> defaultShowFields = new HashSet<String>();
        if (defaultFields != null) {
            for (Map defaultField : defaultFields) {
                defaultShowFields.add(defaultField.get(FIELD_NAME).toString());
            }
        }
        this.getModel().clearNoDataRow();
        this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, cansetFields.size());
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(ENTRY_ENTITY);
        int i = 0;
        for (Map.Entry<String, LocaleString> cansetField : cansetFields.entrySet()) {
            ((DynamicObject)dynamicObjectCollection.get(i)).set(FIELD_NAME, (Object)cansetField.getKey());
            ((DynamicObject)dynamicObjectCollection.get(i)).set(NAME, (Object)cansetField.getValue());
            if (defaultShowFields.contains(cansetField.getKey())) {
                ((DynamicObject)dynamicObjectCollection.get(i)).set(CHECKED, (Object)true);
            } else {
                ((DynamicObject)dynamicObjectCollection.get(i)).set(CHECKED, (Object)false);
            }
            ++i;
        }
        super.afterCreateNewData(e);
    }

    private Map<String, LocaleString> canSetFields(PropertyEditHelper helper) {
        List<ControlAp<?>> commonFilterColumnAps = this.getCommonFilterColumnAp(helper);
        HashMap<String, LocaleString> canSetField = new HashMap<String, LocaleString>();
        for (ControlAp<?> ap : commonFilterColumnAps) {
            if (!(ap instanceof CommonFilterColumnAp)) continue;
            CommonFilterColumnAp commonFilterColumnAp = (CommonFilterColumnAp)ap;
            canSetField.put(commonFilterColumnAp.getFieldName(), commonFilterColumnAp.getName());
        }
        return canSetField;
    }

    private List<ControlAp<?>> getCommonFilterColumnAp(PropertyEditHelper helper) {
        List context = (List)helper.getParamValue(this.getView(), CONTEXT);
        if (context != null) {
            FormMetadata listMetadata = FormTreeBuilder.deserialzeFormMetadata((List)context);
            listMetadata.createIndex();
            for (ControlAp item : listMetadata.getItems()) {
                if (!(item instanceof MobAdvFilterPanelAp)) continue;
                return ((MobAdvFilterPanelAp)item).getItems();
            }
        }
        return new ArrayList();
    }

    private void returnDataToParentAndClose() {
        HashMap<String, Object> para = new HashMap<String, Object>(16);
        StringBuilder sortAlias = new StringBuilder();
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(ENTRY_ENTITY);
        ArrayList value = new ArrayList();
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            boolean checked = dynamicObject.getBoolean(CHECKED);
            if (!checked || !StringUtils.isNotBlank((CharSequence)dynamicObject.getString(FIELD_NAME))) continue;
            String field = dynamicObject.getString(FIELD_NAME);
            HashMap<String, String> defaultShowFieldValue = new HashMap<String, String>();
            defaultShowFieldValue.put(FIELD_NAME, field);
            defaultShowFieldValue.put("_Type_", DefaultHiddenField.class.getSimpleName());
            value.add(defaultShowFieldValue);
            sortAlias.append(field);
            sortAlias.append(";");
        }
        para.put(VALUE, value);
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("mataType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        para.put("alias", sortAlias.toString());
        this.getView().returnDataToParent(para);
        this.getView().close();
    }
}

