/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.AbstractFormDesignerPlugin;
import kd.bos.designer.FormDesignerPlugin;
import kd.bos.designer.ISubDesginer;
import kd.bos.designer.dao.FormTemplateFactory;
import kd.bos.designer.dao.IFormTemplate;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.FormDesigner;
import kd.bos.form.control.events.AfterAddControlEvent;
import kd.bos.form.control.events.AfterAddControlListener;
import kd.bos.form.control.events.PropertyEvent;
import kd.bos.isv.ISVService;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;

public class MobBillDesignerPlugin
extends AbstractFormDesignerPlugin
implements ISubDesginer,
AfterAddControlListener {
    private static final String MOB_BILL_DESIGNER = "subformdesigner";
    private static final String ITEMS = "Items";
    private String id;
    private String key;

    @Override
    public void registerListener(EventObject e) {
        FormDesigner designer = (FormDesigner)this.getView().getControl("formdesigner");
        designer.addAfterAddControlListener((AfterAddControlListener)this);
    }

    @Override
    protected String getDesignerKey() {
        return MOB_BILL_DESIGNER;
    }

    public Map<String, Object> loadData(FormDesigner designer, Object context, String propertName, Object value, String lang) {
        Map<String, Object> tMap;
        if (context instanceof List) {
            HashMap<String, Object> entityMeta = new HashMap<String, Object>();
            entityMeta.put(ITEMS, ((List)context).get(1));
            entityMeta.put("_Type_", "EntityMetadata");
            Map formmeta = null;
            if (value instanceof Map) {
                formmeta = (Map)value;
            }
            Map item = (Map)((List)((List)context).get(0)).get(0);
            this.id = (String)item.get("Id");
            this.key = item.get("Key") + "_mob";
            designer.resetSideBar(new String[]{"entitytree", "outline", "toolbox"});
            tMap = this.createMobFormMetadata(this.id, this.key, formmeta, entityMeta, lang);
            designer.open("MobileBillFormModel", tMap);
            designer.sendMulLangProperty((Map)tMap.remove("localeItemProps"));
        } else {
            tMap = new HashMap<String, Object>();
        }
        return tMap;
    }

    private Map<String, Object> createMobFormMetadata(String id, String key, Map<String, Object> srcFormmeta, Map<String, Object> srcEntityMeta, String lang) {
        Map localeItemMap;
        Object formLocaleItems;
        Map item;
        List items;
        IFormTemplate template = FormTemplateFactory.createTemplate("MobileBillFormModel");
        FormMetadata formMeta = null;
        if (srcFormmeta == null) {
            formMeta = template.getFormMetadata();
            formMeta.setModelType("MobileBillFormModel");
            FormAp fm = formMeta.getRootAp();
            fm.setDirection("column");
        } else {
            formMeta = (FormMetadata)template.deserializeFromMap(srcFormmeta, null);
        }
        formMeta.setId(id);
        formMeta.setKey(key);
        formMeta.getRootAp().setLanguage(lang);
        if (null == formMeta.getRootAp().getName() && null != srcEntityMeta && null != (items = (List)srcEntityMeta.get(ITEMS)) && !items.isEmpty() && null != (item = (Map)items.get(0))) {
            Object name = item.get("Name");
            if (name instanceof String) {
                formMeta.getRootAp().setName(new LocaleString(lang, name));
            } else if (name instanceof LocaleString) {
                formMeta.getRootAp().setName((LocaleString)name);
            }
        }
        HashMap<String, Object> srcEntityMetaClone = new HashMap<String, Object>();
        if (srcEntityMeta != null) {
            srcEntityMetaClone.putAll(srcEntityMeta);
        }
        if (srcEntityMeta != null && srcEntityMeta.get(ITEMS) != null) {
            ArrayList entityItemsClone = new ArrayList();
            ArrayList entityItems = (ArrayList)srcEntityMeta.get(ITEMS);
            entityItemsClone.addAll(entityItems);
            this.removeNoSupportObject(entityItemsClone);
            srcEntityMetaClone.put(ITEMS, entityItemsClone);
        }
        EntityMetadata entityMeta = (EntityMetadata)template.deserializeFromMap(srcEntityMetaClone, null);
        entityMeta.setId(entityMeta.getRootEntity().getId());
        formMeta.setEntityId(entityMeta.getRootEntity().getId());
        formMeta.bindEntityMetadata(entityMeta);
        HashMap<String, Object> tMap = new HashMap<String, Object>(8);
        tMap.put("entityreadonly", true);
        tMap.put("entitytree", entityMeta.buildDesgnerTree());
        tMap.put("id", formMeta.getId());
        tMap.put("entitymeta", this.fillBackInheritPropertyEntity(srcEntityMetaClone, template.serializeToMap(entityMeta)));
        tMap.put("ui", formMeta.builderDesgnerControls());
        tMap.put("billentityid", formMeta.getId());
        Map formDesigner = ((FormDesigner)this.getView().getControl("formdesigner")).getContent();
        Map<String, Object> newFormMeta = this.fillBackInheritProperty(srcFormmeta, template.serializeToMap(formMeta));
        if (formDesigner != null && StringUtils.isNotBlank(formDesigner.get("devType"))) {
            newFormMeta.put("DevType", formDesigner.get("devType"));
        }
        if (formDesigner != null && ((Map)formDesigner.get("formmeta")).get("EnableGlobalExtLimits") instanceof Boolean) {
            newFormMeta.put("EnableGlobalExtLimits", ((Map)formDesigner.get("formmeta")).get("EnableGlobalExtLimits"));
        }
        String pageIsv = "";
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((Object)formMeta.getId(), (String)"bos_formmeta", (String)"isv");
        if (object != null) {
            pageIsv = object.getString("isv");
        }
        newFormMeta.put("Isv", pageIsv);
        tMap.put("formmeta", newFormMeta);
        tMap.put("islayout", true);
        tMap.put("isPC", false);
        tMap.put("isv", ISVService.getISVInfo().getId());
        String localeItemsStr = this.getPageCache().get("localeItems");
        if (StringUtils.isNotBlank((CharSequence)localeItemsStr) && (formLocaleItems = (localeItemMap = (Map)SerializationUtils.fromJsonString((String)localeItemsStr, Map.class)).get("form")) instanceof List) {
            this.restoreLang((AbstractMetadata)formMeta, (List)formLocaleItems, lang);
            Map<String, Map<String, Object>> localeItemProps = this.extractControlAttribute(ControlAp.class, formMeta.getItems(), Arrays.asList("Height", "Width"));
            tMap.put("localeItemProps", localeItemProps);
        }
        return tMap;
    }

    private Map<String, Object> fillBackInheritPropertyEntity(Map<String, Object> originMeta, Map<String, Object> needFillMeta) {
        Map<String, Object> r = super.fillBackInheritProperty(originMeta, needFillMeta);
        return this.fillBackInheritOperationProperty(originMeta, r);
    }

    private Map<String, Object> fillBackInheritOperationProperty(Map<String, Object> originMeta, Map<String, Object> needFillMeta) {
        if (null == originMeta || originMeta.isEmpty() || null == needFillMeta || needFillMeta.isEmpty()) {
            return needFillMeta;
        }
        if (null == originMeta || originMeta.isEmpty()) {
            return needFillMeta;
        }
        List originItems = (List)originMeta.get(ITEMS);
        List needFillItems = (List)needFillMeta.get(ITEMS);
        if (null == originItems || originItems.isEmpty() || null == needFillItems || needFillItems.isEmpty()) {
            return needFillMeta;
        }
        if (originItems.get(0) == null || needFillItems.get(0) == null) {
            return needFillMeta;
        }
        Map<String, Boolean> inheritMap = new HashMap<String, Boolean>(16);
        Map content = (Map)originItems.get(0);
        List operations = (List)content.get("Operations");
        if (operations != null && !operations.isEmpty()) {
            inheritMap = this.getOpInheritMap(operations);
        }
        this.fillOpInherit(needFillMeta, inheritMap);
        return needFillMeta;
    }

    private Map<String, Boolean> getOpInheritMap(List<Map<String, Object>> operations) {
        HashMap<String, Boolean> inheritMap = new HashMap<String, Boolean>();
        if (operations == null) {
            return inheritMap;
        }
        for (Map<String, Object> op : operations) {
            List validations = (List)op.get("Validations");
            if (validations == null) continue;
            for (Map validation : validations) {
                String id = (String)validation.get("Id");
                Boolean inherit = (Boolean)validation.get("Inherit");
                if (!StringUtils.isNotBlank((CharSequence)id) || null == inherit) continue;
                inheritMap.put(id, inherit);
            }
        }
        return inheritMap;
    }

    private void fillOpInherit(Map<String, Object> meta, Map<String, Boolean> inheritMap) {
        if (meta == null) {
            return;
        }
        List items = (List)meta.get(ITEMS);
        if (items == null) {
            return;
        }
        List operations = (List)((Map)items.get(0)).get("Operations");
        if (operations == null) {
            return;
        }
        for (Map op : operations) {
            List validations = (List)op.get("Validations");
            if (validations == null) continue;
            for (Map validation : validations) {
                String id = (String)validation.get("Id");
                if (!StringUtils.isNotBlank((CharSequence)id) || !inheritMap.containsKey(id)) continue;
                validation.put("Inherit", inheritMap.get(id));
            }
        }
    }

    private void removeNoSupportObject(ArrayList entityItems) {
        String type;
        if (CollectionUtils.isEmpty((Collection)entityItems)) {
            return;
        }
        ArrayList needRemoveObjectList = new ArrayList();
        HashSet<String> treeEntryKeySet = new HashSet<String>();
        HashSet<String> subEntryKeySet = new HashSet<String>();
        for (Object object : entityItems) {
            if (!(object instanceof Map)) continue;
            type = (String)((Map)object).get("_Type_");
            if ("TreeEntryEntity".equalsIgnoreCase(type)) {
                needRemoveObjectList.add(object);
                treeEntryKeySet.add((String)((Map)object).get("Id"));
            }
            if (!"JsonSubEntryEntity".equals(type)) continue;
            needRemoveObjectList.add(object);
        }
        if (CollectionUtils.isNotEmpty(treeEntryKeySet)) {
            for (Object object : entityItems) {
                if (!(object instanceof Map)) continue;
                type = (String)((Map)object).get("_Type_");
                if (!"SubEntryEntity".equalsIgnoreCase(type) && treeEntryKeySet.contains((String)((Map)object).get("ParentId"))) {
                    needRemoveObjectList.add(object);
                }
                if (!"SubEntryEntity".equalsIgnoreCase(type) || !treeEntryKeySet.contains((String)((Map)object).get("ParentEntryId"))) continue;
                needRemoveObjectList.add(object);
                subEntryKeySet.add((String)((Map)object).get("Id"));
            }
        }
        if (CollectionUtils.isNotEmpty(subEntryKeySet)) {
            for (Object object : entityItems) {
                if (!(object instanceof Map) || !subEntryKeySet.contains((String)((Map)object).get("ParentId"))) continue;
                needRemoveObjectList.add(object);
            }
        }
        entityItems.removeAll(needRemoveObjectList);
    }

    @Override
    protected Map<String, Object> fillBackInheritProperty(Map<String, Object> originMeta, Map<String, Object> needFillMeta) {
        Map<String, Object> r = super.fillBackInheritProperty(originMeta, needFillMeta);
        return this.fillBackFormPluginInherit(originMeta, r);
    }

    private Map<String, Object> fillBackFormPluginInherit(Map<String, Object> originMeta, Map<String, Object> needFillMeta) {
        if (null == originMeta || originMeta.isEmpty() || null == needFillMeta || needFillMeta.isEmpty()) {
            return needFillMeta;
        }
        HashMap<String, Boolean> inheritPlugins = new HashMap<String, Boolean>();
        if (null == originMeta || originMeta.isEmpty()) {
            return needFillMeta;
        }
        List originItems = (List)originMeta.get(ITEMS);
        List needFillItems = (List)needFillMeta.get(ITEMS);
        if (null == originItems || originItems.isEmpty() || null == needFillItems || needFillItems.isEmpty()) {
            return needFillMeta;
        }
        if (originItems.get(0) == null || needFillItems.get(0) == null) {
            return needFillMeta;
        }
        Map originAp = (Map)originItems.get(0);
        Map needFillAp = (Map)needFillItems.get(0);
        if (originAp.get("Plugins") == null || needFillAp.get("Plugins") == null) {
            return needFillMeta;
        }
        for (Map originPlugin : (List)originAp.get("Plugins")) {
            if (!Boolean.parseBoolean(String.valueOf(originPlugin.get("Inherit")))) continue;
            inheritPlugins.put(String.valueOf(originPlugin.get("ClassName")), true);
        }
        for (Map needfillPlugin : (List)needFillAp.get("Plugins")) {
            String className = String.valueOf(needfillPlugin.get("ClassName"));
            if (!inheritPlugins.containsKey(className) || !((Boolean)inheritPlugins.get(className)).booleanValue()) continue;
            needfillPlugin.put("Inherit", true);
        }
        return needFillMeta;
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        if ("btnok".equals(c.getKey())) {
            this.returnData();
        } else if ("btnpreview".equals(c.getKey())) {
            this.preview(this.key, "MobileBillFormModel");
        }
    }

    @Override
    public void click(PropertyEvent e) {
        if ("Language".equals(e.getPropertName())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5230PC\u8868\u5355\u9875\u9762\u4e0b\u8fdb\u884c\u8bed\u8a00\u8bbe\u7f6e\u3002", (String)"MobBillDesignerPlugin_1", (String)"bos-designer-plugin", (Object[])new Object[0]));
            return;
        }
        super.click(e);
    }

    @Override
    protected void beforeShowPropertyEdit(PropertyEvent e, FormShowParameter showParameter) {
        showParameter.setCustomParam("isPC", (Object)false);
    }

    private void returnData() {
        FormDesigner designer = (FormDesigner)this.getView().getControl(MOB_BILL_DESIGNER);
        Object v = this.getReturnData(designer, (Map<String, Object>)this.getView().getFormShowParameter().getCustomParams());
        if (v instanceof String) {
            this.getView().showTipNotification((String)v);
        } else {
            this.getView().returnDataToParent(v);
            this.getView().close();
        }
    }

    private String validateItem(Map<String, Object> map) {
        return "";
    }

    @Override
    public Object getReturnData(FormDesigner subdesigner, Map<String, Object> params) {
        if (subdesigner.getContent() == null) {
            return false;
        }
        Map map = (Map)subdesigner.getContent().get("formmeta");
        String metastr = SerializationUtils.toJsonString((Object)map);
        String validate = this.validateItem(map);
        if (!validate.equals("")) {
            return validate;
        }
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("itemId", params.get("itemId"));
        para.put("metaType", params.get("metaType"));
        para.put("propertyName", params.get("propertyName"));
        para.put("value", SerializationUtils.fromJsonString((String)metastr, Map.class));
        return para;
    }

    public void afterAddControl(AfterAddControlEvent event) {
        FormDesignerPlugin plugin = new FormDesignerPlugin();
        plugin.afterAddControl(event);
    }
}

