/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.property.AbstractPropertyPlugin;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.EntryGrid;

public class MobFieldIdPlugin
extends AbstractPropertyPlugin {
    private static final String ENTRY_KEY = "entryentity";
    private static final String ITEM_ID = "itemId";
    private static final String TYPE = "_Type_";
    private static final String PARENT_ID = "ParentId";
    private static final String META_TYPE = "metaType";
    private static final String PROPERTY_NAME = "propertyName";
    private static final String VALUE = "value";
    private static final String ALIAS = "alias";

    public void afterCreateNewData(EventObject e) {
        List<Map<String, Object>> fields;
        List data = (List)this.getView().getFormShowParameter().getCustomParams().get("context");
        String itemId = (String)this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID);
        String itemType = ((List)data.get(1)).stream().filter(m -> itemId.equals(m.get("Id"))).findFirst().map(m -> m.get(TYPE).toString()).get();
        List<Map<String, Object>> list = fields = "CardEntryFieldAp".equals(itemType) ? this.getBillEntryFields(data, itemId) : this.getBillHeadFields((List)data.get(0));
        if (!fields.isEmpty()) {
            IDataModel model = this.getModel();
            int count = model.getEntryRowCount(ENTRY_KEY);
            if (fields.size() > count) {
                model.batchCreateNewEntryRow(ENTRY_KEY, fields.size() - count);
            }
            int i = 0;
            for (Map<String, Object> field : fields) {
                model.setValue("fid", field.get("Id"), i);
                model.setValue("fkey", field.get("Key"), i);
                model.setValue("fname", field.get("Name"), i);
                ++i;
            }
        }
    }

    private List<Map<String, Object>> getBillEntryFields(List<List<Map<String, Object>>> context, String itemId) {
        List<Map<String, Object>> formMetas = context.get(1);
        Map<String, Map<String, Object>> formMetaMap = formMetas.stream().collect(Collectors.toMap(s -> s.get("Id").toString(), s -> s));
        String entryId = this.getEntryId(itemId, formMetaMap);
        if (StringUtils.isNotBlank((CharSequence)entryId)) {
            return context.get(0).stream().filter(m -> entryId.equals(m.get(PARENT_ID))).collect(Collectors.toList());
        }
        return context.get(0).stream().filter(m -> m.containsKey(PARENT_ID)).collect(Collectors.toList());
    }

    private String getEntryId(String itemId, Map<String, Map<String, Object>> formMetaMap) {
        if (formMetaMap == null) {
            return null;
        }
        Map<String, Object> item = formMetaMap.get(itemId);
        if (item == null) {
            return null;
        }
        if ("CardEntryAp".equals(item.get(TYPE))) {
            return (String)item.get("EntryId");
        }
        String parentId = (String)item.get(PARENT_ID);
        if (StringUtils.isBlank((CharSequence)parentId)) {
            return null;
        }
        return this.getEntryId(parentId, formMetaMap);
    }

    private List<Map<String, Object>> getBillHeadFields(List<Map<String, Object>> entityMetas) {
        String entityId = this.getRootEntityId(entityMetas);
        return entityMetas.stream().filter(s -> !s.containsKey(PARENT_ID) || entityId.equals(s.get(PARENT_ID))).filter(s -> s.get(TYPE).toString().endsWith("Field")).collect(Collectors.toList());
    }

    private String getRootEntityId(List<Map<String, Object>> entityMetas) {
        return entityMetas.stream().filter(s -> "BillEntity".equals(s.get(TYPE)) || "MainEntity".equals(s.get(TYPE))).findFirst().map(s -> s.get("Id").toString()).orElse("");
    }

    @Override
    protected void returnData() {
        Map<String, Object> row = this.getCurrentSelector();
        if (row != null) {
            ArrayList paras = new ArrayList(5);
            HashMap<String, Object> para = new HashMap<String, Object>(10);
            para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
            para.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
            para.put(PROPERTY_NAME, this.getView().getFormShowParameter().getCustomParams().get(PROPERTY_NAME));
            para.put(VALUE, row.get("id"));
            para.put(ALIAS, row.get("name"));
            paras.add(para);
            HashMap<String, Object> namePara = new HashMap<String, Object>(10);
            namePara.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
            namePara.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
            namePara.put(PROPERTY_NAME, "Name");
            namePara.put(VALUE, row.get("name"));
            namePara.put(ALIAS, row.get("key"));
            paras.add(namePara);
            HashMap<String, Object> keyPara = new HashMap<String, Object>(10);
            keyPara.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
            keyPara.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
            keyPara.put(PROPERTY_NAME, "Key");
            keyPara.put(VALUE, row.get("key"));
            keyPara.put(ALIAS, row.get("key"));
            paras.add(keyPara);
            this.getView().returnDataToParent(paras);
            this.getView().close();
        }
    }

    private Map<String, Object> getCurrentSelector() {
        HashMap<String, Object> ret = new HashMap<String, Object>(10);
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_KEY);
        int row = grid.getEntryState().getFocusRow();
        if (this.getModel().getEntryRowCount(ENTRY_KEY) <= 0 || row < 0) {
            return null;
        }
        ret.put("id", this.getModel().getValue("fid", row));
        ret.put("key", this.getModel().getValue("fkey", row));
        ret.put("name", this.getModel().getValue("fname", row));
        return ret;
    }
}

