/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.utils.CultureInfoUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;

public class MobFormSelectPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String ITEM_ID = "itemId";
    private static final String META_TYPE = "metaType";
    private static final String PROPERTY_NAME = "propertyName";
    private static final String NUMBER = "number";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btncancel", "reset"});
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("formlist");
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void click(EventObject arg0) {
        Control c = (Control)arg0.getSource();
        if ("btnok".equalsIgnoreCase(c.getKey())) {
            this.reurnData();
        } else if ("btncancel".equalsIgnoreCase(c.getKey())) {
            this.getView().close();
        } else if ("reset".equals(c.getKey())) {
            HashMap para = new HashMap();
            para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
            para.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
            para.put(PROPERTY_NAME, this.getView().getFormShowParameter().getCustomParams().get(PROPERTY_NAME));
            para.put("value", null);
            this.getView().returnDataToParent(para);
            this.getView().close();
        }
    }

    private void reurnData() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("formList");
        int row = grid.getEntryState().getFocusRow();
        if (StringUtils.isNotBlank((Object)row)) {
            IDataModel model = this.getModel();
            String key = (String)model.getValue("formid", row);
            String name = (String)model.getValue("name", row);
            HashMap<String, Object> para = new HashMap<String, Object>(16);
            para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
            para.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
            para.put(PROPERTY_NAME, this.getView().getFormShowParameter().getCustomParams().get(PROPERTY_NAME));
            para.put("value", model.getValue(NUMBER, row));
            this.getView().returnDataToParent(para);
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject arg0) {
        List formList;
        Object[] params = new SqlParameter[]{new SqlParameter(":FLOCALEID", 12, (Object)CultureInfoUtils.getDefaultLCId())};
        String sql = "select b.FID, b.FNumber,a.FNAME, b.FMODELTYPE from T_META_FORMDESIGN_L a inner join T_META_FORMDESIGN b on a.FID = b.FID where b.FMODELTYPE = 'MobileBillFormModel' and a.FLOCALEID = ?";
        try {
            formList = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

                public List<Map<String, Object>> handle(ResultSet rs) throws SQLException {
                    ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(10);
                    while (rs.next()) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("id", rs.getString(1));
                        map.put(MobFormSelectPlugin.NUMBER, rs.getString(2));
                        map.put("name", rs.getString(3));
                        String modelType = rs.getString(4);
                        map.put("modelType", modelType);
                        map.put("isPC", false);
                        list.add(map);
                    }
                    return list;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format("error:%s;  sql:%s", e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        if (formList.size() > 0) {
            IDataModel model = this.getModel();
            model.batchCreateNewEntryRow("formlist", formList.size());
            int i = 0;
            for (Map form : formList) {
                model.setValue(NUMBER, form.get(NUMBER), i);
                model.setValue("name", form.get("name"), i);
                model.setValue("formid", form.get("id"), i);
                ++i;
            }
        }
    }

    public void entryRowClick(RowClickEvent arg0) {
    }

    public void entryRowDoubleClick(RowClickEvent arg0) {
    }
}

