/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.designer.property.AbstractPropertyPlugin;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.EntityMetadataUtil;

public class MobListFieldIdPlugin
extends AbstractPropertyPlugin
implements RowClickEventListener {
    private static final Log log = LogFactory.getLog(MobListFieldIdPlugin.class);
    private static final String ITEM_ID = "itemId";
    private static final String META_TYPE = "metaType";
    private static final String PROPERTY_NAME = "propertyName";
    private static final String VALUE = "value";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String ITEMS = "Items";
    private static final String PARENT_SEQ = "parentSeq";
    private static final String MOB_LIST_FIELD_ID_PLUGIN_0 = "MobListFieldIdPlugin_0";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";
    private static final String TYPE = "Type";

    private static String getDESCRIPTION() {
        return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b57\u6bb5", (String)MOB_LIST_FIELD_ID_PLUGIN_0, (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
    }

    public void afterCreateNewData(EventObject e) {
        JSONArray designerContext;
        DynamicObjectCollection treeData = this.getModel().getEntryEntity(ENTRY_ENTITY);
        DynamicObjectType dynamicObjectType = treeData.getDynamicObjectType();
        JSONArray designerContextList = designerContext = (JSONArray)this.getView().getFormShowParameter().getCustomParams().get("designerContext");
        Map map = EntityMetadataUtil.getlistFieldTree((List)designerContextList);
        List items = (List)map.get(ITEMS);
        Map o = (Map)items.get(items.size() - 1);
        List fieldItems = (List)o.get(ITEMS);
        List<Map<String, Object>> flatFieldItems = new ArrayList<Map<String, Object>>();
        this.processFlat(fieldItems, flatFieldItems, 1, 0);
        JSONArray context = (JSONArray)this.getView().getFormShowParameter().getCustomParam("context");
        String currentItemType = context.getJSONArray(1).getJSONObject(0).getString("_Type_");
        boolean isCardPictureListColumnAp = "CardPictureListColumnAp".equals(currentItemType);
        flatFieldItems = isCardPictureListColumnAp ? this.filterCardPictureListColumnAp(flatFieldItems) : this.excludeCardPictureListColumnAp(flatFieldItems);
        this.getPageCache().put("sortedDesignerContext", SerializationUtils.toJsonString(flatFieldItems));
        this.getModel().beginInit();
        for (Map<String, Object> map1 : flatFieldItems) {
            DynamicObject d = new DynamicObject(dynamicObjectType);
            d.set("id", map1.get("seq"));
            d.set("fkey", map1.get("Id"));
            d.set("fname", map1.get("Name"));
            if (map1.containsKey(PARENT_SEQ) && !map1.get(PARENT_SEQ).equals(0)) {
                d.set("pid", map1.get(PARENT_SEQ));
            }
            treeData.add((Object)d);
        }
        this.getModel().endInit();
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(ENTRY_ENTITY);
        treeEntryGrid.setCollapse(false);
    }

    private List<Map<String, Object>> excludeCardPictureListColumnAp(List<Map<String, Object>> flatFieldItems) {
        return flatFieldItems.stream().filter(item -> !"PictureListColumnAp".equals(item.get(TYPE))).collect(Collectors.toList());
    }

    private List<Map<String, Object>> filterCardPictureListColumnAp(List<Map<String, Object>> flatFieldItems) {
        HashMap<Integer, Integer> entitySeqMap = new HashMap<Integer, Integer>(16);
        Iterator<Map<String, Object>> it = flatFieldItems.iterator();
        while (it.hasNext()) {
            Map<String, Object> item = it.next();
            String type = (String)item.get(TYPE);
            if (type.endsWith("Entity")) {
                entitySeqMap.put((Integer)item.get("seq"), ((List)item.get(ITEMS)).size());
                continue;
            }
            if ("PictureListColumnAp".equals(type)) continue;
            Integer parentSeq = (Integer)item.get("seq");
            if (entitySeqMap.containsKey(parentSeq)) {
                Integer remain = (Integer)entitySeqMap.get(parentSeq);
                entitySeqMap.put(parentSeq, remain - 1);
            }
            it.remove();
        }
        ArrayList shouldDeleteEntitySeq = new ArrayList(10);
        for (Map.Entry entry : entitySeqMap.entrySet()) {
            if (!((Integer)entry.getValue()).equals(0)) continue;
            shouldDeleteEntitySeq.add(entry.getKey());
        }
        return flatFieldItems.stream().filter(s -> !shouldDeleteEntitySeq.contains(s.get("seq"))).collect(Collectors.toList());
    }

    private int processFlat(List<Map<String, Object>> fieldItems, List<Map<String, Object>> flatFieldItems, int seq, int parentSeq) {
        for (Map<String, Object> f : fieldItems) {
            f.put("seq", seq++);
            f.put(PARENT_SEQ, parentSeq);
            flatFieldItems.add(f);
            if (!f.containsKey(ITEMS)) continue;
            seq = this.processFlat((List)f.get(ITEMS), flatFieldItems, seq, seq - 1);
        }
        return seq;
    }

    @Override
    public void click(EventObject e) {
        Control control = (Control)e.getSource();
        String key = control.getKey();
        if ("btnok".equals(key)) {
            this.returnData();
        }
    }

    private Map<String, Object> getReturnPara(String propertyName, String nodeValue) {
        HashMap<String, Object> para = new HashMap<String, Object>(4);
        para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
        para.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
        para.put(PROPERTY_NAME, propertyName);
        para.put(VALUE, nodeValue);
        return para;
    }

    @Override
    protected void returnData() {
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectedRows = treeEntryGrid.getEntryState().getSelectedRows();
        if (selectedRows.length != 1) {
            this.getView().showErrorNotification(MobListFieldIdPlugin.getDESCRIPTION());
            return;
        }
        int selectRow = selectedRows[0];
        String fid = this.getModel().getValue("fid", selectRow).toString();
        String fkey = this.getModel().getValue("fkey", selectRow).toString();
        String fname = this.getModel().getValue("fname", selectRow).toString();
        List designerContext = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get("sortedDesignerContext"), Map.class);
        Map map = (Map)designerContext.get(selectRow);
        if ("Entity".equals(map.get(TYPE))) {
            this.getView().showErrorNotification(MobListFieldIdPlugin.getDESCRIPTION());
            return;
        }
        ArrayList<Map<String, Object>> paras = new ArrayList<Map<String, Object>>();
        paras.add(this.getReturnPara("ListFieldId", fkey));
        paras.add(this.getReturnPara("Name", fname));
        paras.add(this.getReturnPara("_Type_", "Card" + map.get(TYPE).toString()));
        this.getView().returnDataToParent(paras);
        this.getView().close();
    }

    private String getSourceType() {
        JSONArray contextList = (JSONArray)this.getView().getFormShowParameter().getCustomParams().get("context");
        return contextList.getJSONArray(1).getJSONObject(0).getString("_Type_");
    }

    public void entryRowClick(RowClickEvent evt) {
        evt.getRow();
    }
}

