/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.designer.property.AbstractPropertyPlugin;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;

public class MobTableDataSourcePlugin
extends AbstractPropertyPlugin
implements RowClickEventListener {
    private static final String ENTRY_KEY = "entryentity";
    private static final String PARENT_ENTRY_ENTITY_KEY = "parententryentity";
    private static final String SUB_ENTRY_ENTITY_KEY = "subentryentity";
    private static final String ENTRY_ENTITY = "EntryEntity";
    private static final String SUB_ENTRY_ENTITY = "SubEntryEntity";
    private static final String PARENT_ID = "ParentId";
    private static final String MOB_TABLE_TYPE = "MobTableType";
    private static final String ENTRY_FLEX_PANEL_AP = "entryflexpanelap";
    private static final String SUB_ENTRY_FLEX_PANEL_AP = "subentryflexpanelap";
    private static final String CONTEXT = "context";
    private static final String TYPE = "_Type_";
    private static final String META_TYPE = "metaType";
    private static final String PROPERTY_NAME = "propertyName";
    private static final String VALUE = "value";
    private static final String F_ID = "fid";
    private static final String ID = "Id";
    private static final String F_KEY = "fkey";
    private static final String F_NAME = "fname";
    private static final String F_TYPE = "ftype";
    private static final String KEY = "Key";
    private static final String NAME = "Name";
    private static final String TYPE_1 = "type";
    private static final String ITEM_ID = "itemId";
    private static final String ENTITY_ID = "entityId";
    private static final String F_PARENT_ID = "fparentid";
    private static final String F_PARENT_KEY = "fparentkey";
    private static final String F_PARENT_NAME = "fparentname";
    private static final String F_SUB_ID = "fsubid";
    private static final String F_SUB_KEY = "fsubkey";
    private static final String F_SUB_NAME = "fsubname";
    private static final String SUB_KEY = "subKey";
    private static final String ENTRY_TABLE = "entryTable";
    private static final String SUB_ENTRY_TABLE = "subEntryTable";
    private static final String BTN_OK = "btnok";
    private static final String BILL_ENTITY = "BillEntity";
    private static final String MAIN_ENTITY = "MainEntity";
    private Map<String, String> ENTRY_MAP = new HashMap(){
        {
            this.put(MobTableDataSourcePlugin.ENTRY_ENTITY, ResManager.loadKDString((String)"\u5355\u636e\u4f53", (String)"MobTableDataSourcePlugin_0", (String)"bos-designer-plugin", (Object[])new Object[0]));
            this.put(MobTableDataSourcePlugin.SUB_ENTRY_ENTITY, ResManager.loadKDString((String)"\u5b50\u5355\u636e\u4f53", (String)"MobTableDataSourcePlugin_1", (String)"bos-designer-plugin", (Object[])new Object[0]));
        }
    };

    @Override
    public void initialize() {
        super.initialize();
        EntryGrid grid = (EntryGrid)this.getControl(ENTRY_KEY);
        grid.addRowClickListener((RowClickEventListener)this);
        EntryGrid parentGrid = (EntryGrid)this.getControl(PARENT_ENTRY_ENTITY_KEY);
        parentGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid subGrid = (EntryGrid)this.getControl(SUB_ENTRY_ENTITY_KEY);
        subGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        List contextList = (List)this.getView().getFormShowParameter().getCustomParams().get(CONTEXT);
        if (contextList != null && contextList.size() > 0) {
            String tableType = ((List)contextList.get(0)).isEmpty() ? ENTRY_TABLE : ((Map)((List)contextList.get(0)).get(0)).get(MOB_TABLE_TYPE);
            List data = (List)contextList.get(1);
            switch (tableType.toString()) {
                case "entryTable": {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{SUB_ENTRY_FLEX_PANEL_AP});
                    this.fillEntryTableData(data);
                    break;
                }
                case "subEntryTable": {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{ENTRY_FLEX_PANEL_AP});
                    this.fillSubEntryTableData(data);
                    break;
                }
            }
        }
    }

    private void fillEntryTableData(List<Map<String, Object>> contextList) {
        ArrayList<Map<String, Object>> ops = new ArrayList<Map<String, Object>>();
        IDataModel model = this.getModel();
        for (Map<String, Object> map : contextList) {
            if (!ENTRY_ENTITY.equals(map.get(TYPE))) continue;
            ops.add(map);
        }
        int size = ops.size();
        if (size < 1) {
            return;
        }
        model.batchCreateNewEntryRow(ENTRY_KEY, size);
        int i = 0;
        for (Map map : ops) {
            model.setValue(F_ID, map.get(ID), i);
            model.setValue(F_TYPE, (Object)this.ENTRY_MAP.get(map.get(TYPE).toString()), i);
            model.setValue(F_KEY, map.get(KEY), i);
            model.setValue(F_NAME, map.get(NAME), i);
            ++i;
        }
        this.getPageCache().put(VALUE, SerializationUtils.toJsonString(ops));
    }

    private void fillSubEntryTableData(List<Map<String, Object>> contextList) {
        ArrayList<Map<String, Object>> ops = new ArrayList<Map<String, Object>>();
        IDataModel model = this.getModel();
        for (Map<String, Object> map : contextList) {
            if (!ENTRY_ENTITY.equals(map.get(TYPE))) continue;
            ops.add(map);
        }
        int size = ops.size();
        if (size < 1) {
            return;
        }
        model.batchCreateNewEntryRow(PARENT_ENTRY_ENTITY_KEY, size);
        int i = 0;
        for (Map map : ops) {
            model.setValue(F_PARENT_ID, map.get(ID), i);
            model.setValue(F_PARENT_KEY, map.get(KEY), i);
            model.setValue(F_PARENT_NAME, map.get(NAME), i);
            ++i;
        }
        this.getPageCache().put(VALUE, SerializationUtils.toJsonString(ops));
    }

    public void entryRowClick(RowClickEvent evt) {
        Control source = (Control)evt.getSource();
        if (!PARENT_ENTRY_ENTITY_KEY.equals(source.getKey())) {
            return;
        }
        IDataModel model = this.getModel();
        if (!model.getEntryEntity(SUB_ENTRY_ENTITY_KEY).isEmpty()) {
            return;
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl(PARENT_ENTRY_ENTITY_KEY);
        int row = grid.getEntryState().getFocusRow();
        String itemId = model.getValue(F_PARENT_ID, row).toString();
        List contextList = (List)this.getView().getFormShowParameter().getCustomParams().get(CONTEXT);
        if (contextList != null && contextList.size() > 0) {
            List ops = ((List)contextList.get(1)).stream().filter(m -> m.get(PARENT_ID) != null && itemId.equals(m.get(PARENT_ID)) && SUB_ENTRY_ENTITY.equals(m.get(TYPE))).collect(Collectors.toList());
            if (ops.size() < 1) {
                return;
            }
            model.batchCreateNewEntryRow(SUB_ENTRY_ENTITY_KEY, ops.size());
            int i = 0;
            for (Map op : ops) {
                model.setValue(F_SUB_ID, op.get(ID), i);
                model.setValue(F_SUB_KEY, op.get(KEY), i);
                model.setValue(F_SUB_NAME, op.get(NAME), i);
                ++i;
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_OK.equals(key)) {
            this.returnData();
        }
    }

    @Override
    protected void returnData() {
        List contextList = (List)this.getView().getFormShowParameter().getCustomParams().get(CONTEXT);
        if (contextList != null && contextList.size() > 0) {
            int row;
            String tableType = ((List)contextList.get(0)).isEmpty() ? ENTRY_TABLE : ((Map)((List)contextList.get(0)).get(0)).get(MOB_TABLE_TYPE);
            Integer subRow = null;
            if (ENTRY_TABLE.equals(tableType)) {
                EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_KEY);
                row = grid.getEntryState().getFocusRow();
                if (this.getModel().getEntryRowCount(ENTRY_KEY) > 0 && row >= 0) {
                    this.returnDataToDesign(row, subRow, (List)contextList.get(1));
                }
            }
            if (SUB_ENTRY_TABLE.equals(tableType)) {
                EntryGrid parentGrid = (EntryGrid)this.getView().getControl(PARENT_ENTRY_ENTITY_KEY);
                EntryGrid subGrid = (EntryGrid)this.getView().getControl(SUB_ENTRY_ENTITY_KEY);
                row = parentGrid.getEntryState().getFocusRow();
                subRow = subGrid.getEntryState().getFocusRow();
                if (this.getModel().getEntryRowCount(PARENT_ENTRY_ENTITY_KEY) > 0 && row >= 0 && this.getModel().getEntryRowCount(SUB_ENTRY_ENTITY_KEY) > 0 && subRow >= 0) {
                    this.returnDataToDesign(row, subRow, (List)contextList.get(1));
                }
            }
        }
    }

    private void returnDataToDesign(int row, Integer subRow, List<Map<String, Object>> entityMetas) {
        IDataModel model = this.getModel();
        HashMap para = new HashMap(10);
        HashMap<String, Object> value = new HashMap<String, Object>(10);
        value.put(ENTITY_ID, this.getRootEntityId(entityMetas));
        if (subRow != null) {
            value.put(SUB_KEY, model.getValue(F_SUB_KEY, row));
            value.put(KEY, model.getValue(F_PARENT_KEY, row));
        } else {
            value.put(KEY, model.getValue(F_KEY, row));
        }
        para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
        para.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
        para.put(PROPERTY_NAME, this.getView().getFormShowParameter().getCustomParams().get(PROPERTY_NAME));
        para.put(VALUE, value);
        this.getView().returnDataToParent(para);
        this.getView().close();
    }

    private String getRootEntityId(List<Map<String, Object>> entityMetas) {
        return entityMetas.stream().filter(s -> BILL_ENTITY.equals(s.get(TYPE)) || MAIN_ENTITY.equals(s.get(TYPE))).findFirst().map(s -> s.get(ID).toString()).orElse("");
    }
}

