/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.designer.property.AbstractPropertyPlugin;
import kd.bos.designer.property.MobTableFieldTypeBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.PictureProp;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.metadata.dao.EntityMetadataUtil;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.SubEntryEntity;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.BasedataPropField;
import kd.bos.metadata.entity.businessfield.FlexField;
import kd.bos.metadata.entity.businessfield.ItemClassField;
import kd.bos.metadata.entity.businessfield.ItemClassTypeField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.mcontrol.mobtable.tablecolumn.PictureMobTableColumnAp;
import kd.bos.metadata.form.mcontrol.mobtable.tablecolumn.TextMobTableColumnAp;
import kd.bos.metadata.treebuilder.FormTreeBuilder;

public class MobTableFieldPlugin
extends AbstractPropertyPlugin {
    private static final String ENTRY_KEY = "entryentity";
    private static final String MOB_TABLE_DATA_SOURCE = "MobTableDataSource";
    private static final String MOB_TABLE_TYPE = "MobTableType";
    private static final String ENTRY_TABLE = "entryTable";
    private static final String SUB_ENTRY_ENTITY = "SubEntryEntity";
    private static final String ITEM_ID = "itemId";
    private static final String TYPE = "_Type_";
    private static final String PARENT_ID = "ParentId";
    private static final String META_TYPE = "metaType";
    private static final String PROPERTY_NAME = "propertyName";
    private static final String VALUE = "value";
    private static final String ALIAS = "alias";
    private static final String SUB_ID = "subId";
    private static final String SUB_KEY = "subKey";
    private static final String FID = "fid";
    private static final String ID = "Id";
    private static final String F_NAME = "fname";
    private static final String NAME = "Name";
    private static final String F_KEY = "fkey";
    private static final String KEY = "Key";
    private static final String CONTEXT = "context";
    private static final String BOS_DESIGNER_PLUGIN = "bos-designer-plugin";

    public void afterCreateNewData(EventObject e) {
        List data = (List)this.getView().getFormShowParameter().getCustomParams().get(CONTEXT);
        if (data == null || data.isEmpty() || ((List)data.get(0)).isEmpty() || !((Map)((List)data.get(0)).get(0)).containsKey(MOB_TABLE_DATA_SOURCE) || ((Map)((Map)((List)data.get(0)).get(0)).get(MOB_TABLE_DATA_SOURCE)).get(KEY) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u79fb\u52a8\u8868\u683c\u6570\u636e\u6e90\u3002", (String)"MobTableFieldPlugin_0", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
            return;
        }
        Object dataSource = ((Map)((Map)((List)data.get(0)).get(0)).get(MOB_TABLE_DATA_SOURCE)).get(KEY);
        Object subDataSource = ((Map)((Map)((List)data.get(0)).get(0)).get(MOB_TABLE_DATA_SOURCE)).get(SUB_KEY);
        String tableType = ((Map)((List)data.get(0)).get(0)).get(MOB_TABLE_TYPE) == null ? ENTRY_TABLE : ((Map)((List)data.get(0)).get(0)).get(MOB_TABLE_TYPE).toString();
        Object key = ((Map)((List)data.get(1)).get(0)).get(KEY);
        String itemId = ((List)data.get(2)).stream().filter(m -> dataSource.toString().equals(m.get(KEY))).findFirst().map(m -> m.get(ID).toString()).orElse("");
        List<Map<String, Object>> fields = this.getBillEntryFields(data, itemId, tableType, key);
        List<Map<String, Object>> subFields = null;
        if (subDataSource != null) {
            String subItemId = ((List)data.get(2)).stream().filter(m -> subDataSource.toString().equals(m.get(KEY))).findFirst().map(m -> m.get(ID).toString()).orElse("");
            subFields = this.getBillEntryFields(data, subItemId, tableType, key);
        }
        this.buildTreeNode(subFields, fields, null);
    }

    private List<Map<String, Object>> getBillEntryFields(List<List<Map<String, Object>>> data, String itemId, String type, Object key) {
        ArrayList<Map<String, Object>> entryFields = new ArrayList<Map<String, Object>>(10);
        if (StringUtils.isBlank((CharSequence)itemId)) {
            return entryFields;
        }
        EntityMetadata entityMetadata = EntityMetadataUtil.getEntityMetadata(data.get(2));
        Object fieldProp = this.getFieldProp(data.get(3), key);
        for (EntityItem entityItem : entityMetadata.getItems()) {
            if (entityItem.getParentId() == null || !itemId.equals(entityItem.getParentId()) || entityItem instanceof ItemClassField || entityItem instanceof ItemClassTypeField || ENTRY_TABLE.equals(type) && entityItem instanceof SubEntryEntity || (fieldProp == null || !fieldProp.getClass().getName().equals(MobTableFieldTypeBuilder.getFieldType(entityItem.getClass().getName()))) && (!(entityItem instanceof BasedataField) && !entityItem.getClass().isAssignableFrom(MulBasedataField.class) && !(entityItem instanceof FlexField) || !(fieldProp instanceof TextMobTableColumnAp)) && !this.isBasePropField(entityItem, fieldProp)) continue;
            HashMap<String, String> field = new HashMap<String, String>(16);
            field.put(ID, entityItem.getId());
            field.put(KEY, entityItem.getKey());
            field.put(NAME, entityItem.getName().toString());
            field.put(TYPE, entityItem.getClass().getSimpleName());
            entryFields.add(field);
        }
        return entryFields;
    }

    private boolean isBasePropField(EntityItem<?> entityItem, Object fieldProp) {
        if (entityItem instanceof BasedataPropField) {
            MainEntityType entityType;
            DynamicProperty property;
            String refBaseFieldId = ((BasedataPropField)entityItem).getRefBaseFieldId();
            String refDisplayProp = ((BasedataPropField)entityItem).getRefDisplayProp();
            if (StringUtils.isBlank((CharSequence)refBaseFieldId) || StringUtils.isBlank((CharSequence)refDisplayProp)) {
                return false;
            }
            List<Map<String, Object>> entityMeta = new PropertyEditHelper().getEntityMeta(this.getView());
            String baseEntityId = "";
            for (Map<String, Object> map : entityMeta) {
                if (!refBaseFieldId.equals(map.get(ID))) continue;
                baseEntityId = (String)map.get("BaseEntityId");
            }
            if (StringUtils.isNotBlank((CharSequence)baseEntityId) && ((property = (entityType = EntityMetadataCache.getDataEntityTypeById((String)baseEntityId)).getProperty(refDisplayProp)) instanceof PictureProp && fieldProp instanceof PictureMobTableColumnAp || !(property instanceof PictureProp) && fieldProp instanceof TextMobTableColumnAp)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void returnData() {
        Map<String, Object> row = this.getCurrentSelector();
        if (row != null) {
            ArrayList paras = new ArrayList(5);
            HashMap<String, Object> para = new HashMap<String, Object>(10);
            para.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
            para.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
            para.put(PROPERTY_NAME, this.getView().getFormShowParameter().getCustomParams().get(PROPERTY_NAME));
            para.put(VALUE, row.get(KEY));
            para.put(ALIAS, row.get(NAME));
            paras.add(para);
            HashMap<String, Object> namePara = new HashMap<String, Object>(10);
            namePara.put(ITEM_ID, this.getView().getFormShowParameter().getCustomParams().get(ITEM_ID));
            namePara.put(META_TYPE, this.getView().getFormShowParameter().getCustomParams().get(META_TYPE));
            namePara.put(PROPERTY_NAME, NAME);
            namePara.put(VALUE, row.get(NAME));
            namePara.put(ALIAS, row.get(KEY));
            paras.add(namePara);
            this.getView().returnDataToParent(paras);
            this.getView().close();
        }
    }

    private Map<String, Object> getCurrentSelector() {
        HashMap<String, Object> ret = new HashMap<String, Object>(10);
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_KEY);
        int row = grid.getEntryState().getFocusRow();
        if (this.getModel().getEntryRowCount(ENTRY_KEY) <= 0 || row < 0) {
            return null;
        }
        ret.put(ID, this.getModel().getValue(FID, row));
        ret.put(KEY, this.getModel().getValue(F_KEY, row));
        ret.put(NAME, this.getModel().getValue(F_NAME, row));
        return ret;
    }

    private void buildTreeNode(List<Map<String, Object>> fieldsIndex, List<Map<String, Object>> fieldsTree, Integer parentRow) {
        ArrayList<Integer> collapseRows = new ArrayList<Integer>();
        for (Map<String, Object> fieldTreeNode : fieldsTree) {
            int row = this.getModel().createNewEntryRow(ENTRY_KEY);
            DynamicObject newRow = this.getModel().getEntryRowEntity(ENTRY_KEY, row);
            if (parentRow != null) {
                DynamicObject parentObj = this.getModel().getEntryRowEntity(ENTRY_KEY, parentRow.intValue());
                Long pid = (Long)parentObj.getPkValue();
                newRow.set("pid", (Object)pid);
            }
            this.getModel().setValue(FID, fieldTreeNode.get(ID), row);
            this.getModel().setValue(F_KEY, fieldTreeNode.get(KEY) == null ? fieldTreeNode.get(ID) : fieldTreeNode.get(KEY), row);
            this.getModel().setValue(F_NAME, fieldTreeNode.get(NAME), row);
            if (fieldsIndex == null || !SUB_ENTRY_ENTITY.equals(fieldTreeNode.get(TYPE))) continue;
            collapseRows.add(row);
            this.buildTreeNode(null, fieldsIndex, row);
        }
        if (!collapseRows.isEmpty()) {
            TreeEntryGrid grid = (TreeEntryGrid)this.getControl(ENTRY_KEY);
            grid.collapse(collapseRows.stream().mapToInt(Integer::valueOf).toArray());
        }
    }

    private Object getFieldProp(List<Map<String, Object>> formContext, Object key) {
        FormMetadata formMetadata = FormTreeBuilder.deserialzeFormMetadata(formContext);
        for (ControlAp item : formMetadata.getItems()) {
            if (!key.equals(item.getKey())) continue;
            return item;
        }
        return null;
    }
}

